/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */
package org.netbeans.modules.maven.runjar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.configurations.ConfigurationProviderEnabler;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 * extending the default maven project lookup.
 * @author  Milos Kleint
 */
@LookupProvider.Registration(projectType="org-netbeans-modules-maven")
public class J2seLookupProvider implements LookupProvider {
    
    /** Creates a new instance of J2eeLookupProvider */
    public J2seLookupProvider() {
    }
    
    public Lookup createAdditionalLookup(Lookup baseLookup) {
        NbMavenProjectImpl project = baseLookup.lookup(NbMavenProjectImpl.class);
        ConfigurationProviderEnabler config = baseLookup.lookup(ConfigurationProviderEnabler.class);
        assert project != null;
        assert config != null;
//        // if there's more items later, just do a proxy..
        InstanceContent ic = new InstanceContent();
        //sort of hack.. the base lookup is static list, need instance content
        // from somewhere, why not here?
        config.setInstanceContent(ic);
        Provider prov = new Provider(project, ic);
        return prov;
    }
    
    public static class Provider extends AbstractLookup implements  PropertyChangeListener {
        private NbMavenProjectImpl project;
        private InstanceContent content;
        private RunJarPrereqChecker runJarChecker = new RunJarPrereqChecker();
        public Provider(NbMavenProjectImpl proj, InstanceContent cont) {
            super(cont);
            project = proj;
            content = cont;
            checkJ2se();
            NbMavenProject.addPropertyChangeListener(project, this);
        }
        
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (NbMavenProjectImpl.PROP_PROJECT.equals(propertyChangeEvent.getPropertyName())) {
                checkJ2se();
            }
        }
        
        private void checkJ2se() {
            NbMavenProject watcher = project.getLookup().lookup(NbMavenProject.class);
            String packaging = watcher.getPackagingType();
            doCheckJ2se(packaging);
        }
        
        
        private void doCheckJ2se(String packaging) {
            content.remove(runJarChecker);
            if (NbMavenProject.TYPE_JAR.equals(packaging)) {
                content.add(runJarChecker);
            } 
        }
    }
}
