/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xslt.model.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.resources.ResourceMarker;

/**
 *
 * @author ads
 */
public class Utils {
    
    public static File getTempDir(String path) throws Exception {
        File tempdir = new File(System.getProperty("java.io.tmpdir"), path);
        tempdir.mkdirs();
        return tempdir;
    }
    
    public static XslModel loadXslModel(String resourcePath) throws Exception {
        return  loadXslModel( resourcePath , false );
    }
    
    
    public static XslModel loadXslModel(String resourcePath, boolean reload) 
        throws Exception 
    {
        String location = resourcePath.substring(resourcePath.lastIndexOf('/')+1);
        URI locationURI = new URI(location);
        TestCatalogModel.getDefault().addURI(locationURI, 
                getResourceURI(resourcePath));
        return TestCatalogModel.getDefault().getXslModel(locationURI, reload);
    }
    
    public static XslModel loadXslModel(File schemaFile) throws Exception {
        URI locationURI = new URI(schemaFile.getName());
        TestCatalogModel.getDefault().addURI(locationURI, schemaFile.toURI());
        return TestCatalogModel.getDefault().getXslModel(locationURI);
    }
    
    public static URI getResourceURI(String path) throws RuntimeException {
        try {
            return ResourceMarker.class.getResource(path).toURI();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
    
    public static void setNewContent( XslModel model , String newContent ) 
        throws IOException 
    {
        Document doc = (Document) model.getModelSource().getLookup().
            lookup( Document.class );
        assert doc != null;
        try {
            doc.remove( 0 , doc.getLength());
            doc.insertString( 0 , newContent , null );
        }
        catch (BadLocationException e) {
            assert false;
        }
        model.sync();
    }
    
    public static void setNewContentFromFile( XslModel model , String fileName ) 
        throws IOException 
    {
        InputStream stream = ResourceMarker.class.getResourceAsStream( fileName );
        BufferedReader reader = new BufferedReader(new InputStreamReader( stream));
        StringBuilder builder = new StringBuilder();
        String nextLine = null;
        try {
            while( (nextLine = reader.readLine()) != null ) {
                builder.append( nextLine );
                builder.append(System.getProperty("line.separator"));
            }
        }
        finally {
            reader.close();
        }
        setNewContent(model, builder.toString() );
    }
}
