/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.core.actions;

import javax.swing.JComboBox;

import java.awt.Dialog;
import javax.swing.ComboBoxModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.loaders.DataObject;

import javax.swing.event.ListDataListener;
import org.netbeans.modules.xml.api.cookies.ScenarioCookie;
import org.openide.windows.TopComponent;
import org.netbeans.modules.xml.core.actions.CollectXMLAction;

/**
 * This is the action which is used to customize scenarios and select the active
 * scenario.  In a toolbar it is represented as ComboBox where the user can
 * select the active scenario.  The last item in the ComboBox will cause the
 * ScenarioAction to be performed.  Performing of this action will call
 * customizeScenarios() on the ScenarioCookie of the selected node and it
 * will display the Scenario customization dialog.
 *
 * @author asgeir@dimonsoftware.com
 */
public class ScenarioAction extends CookieAction implements CollectXMLAction.XMLAction {
    /** Serial Version UID */
    private static final long serialVersionUID = -640535981015880507L;
    
    /** @link dependency */
    /*# ScenarioCookie lnkScenarioCookie; */
    
    protected Class[] cookieClasses() {
        return new Class[] {ScenarioCookie.class};
    }
    
    protected int mode() {
        return MODE_EXACTLY_ONE;
    }
    
    protected void performAction(Node[] nodes) {
        if (nodes.length > 0) {
            ScenarioCookie scenarioCookie = nodes[0].getCookie(ScenarioCookie.class);
            if (scenarioCookie != null) {
                scenarioCookie.customizeScenarios();
            }
        }
    }
    
    public String getName() {
        return Util.THIS.getString("LBL_Scenario_Action");
    }
    
    protected String iconResource() {
        return "org/netbeans/modules/xml/core/resources/scenarioAction.gif"; // NOI18N
    }
    
    public java.awt.Component getToolbarPresenter() {
        return new ToolbarPresenter();
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx (ScenarioAction.class);
    }
    
    private class ToolbarPresenter extends JComboBox {
        private static final int FIXED_WIDTH = 150;
        
        
        public ToolbarPresenter() {
            super();
            addAncestorListener(new AncestorListener() {
                public void ancestorAdded(AncestorEvent event) {
                    java.awt.Component parent = event.getAncestor();
                    while (parent != null) {
                        if (parent instanceof TopComponent) {
                            Node[] nodes = ((TopComponent)parent).getActivatedNodes();
                            if (nodes != null && nodes.length > 0) {
                                DataObject dataObj = nodes[0].getCookie(DataObject.class);
                                if (dataObj != null) {
                                    ScenarioCookie scenarioCookie = dataObj.getCookie(ScenarioCookie.class);
                                    if (scenarioCookie != null) {
                                        ExScenarioModel model = new ExScenarioModel(scenarioCookie);
                                        setModel(model);
                                        setEnabled(true);
                                        if (model.getSize() == 1) {
                                            setSelectedIndex(-1);
                                        }
                                        model.setAllowCustomizing(true);
                                        return;
                                    }
                                }
                            }
                            setEnabled(false);
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
                public void ancestorMoved(AncestorEvent event) {}
                public void ancestorRemoved(AncestorEvent event) {}
            });
        }
        
        public java.awt.Dimension getMinimumSize() {
            // minimum width to prevent excessive horizontal shrinking
            return new java.awt.Dimension(FIXED_WIDTH, getPreferredSize().height);
        }
        
        public java.awt.Dimension getMaximumSize() {
            // minimum width to prevent moving of the remaining contents of the toolbar
            return new java.awt.Dimension(FIXED_WIDTH, getPreferredSize().height);
        }
    }
    
    
    /**
     * This class adds one item to the end of the ComboBoxModel which performs
     * the scenario action when selected.
     */
    private class ExScenarioModel implements ComboBoxModel {
        
        private ScenarioCookie scenarioCookie;
        
        private ComboBoxModel scenarioModel;
        
        private String customizeValue;
        
        private boolean allowCustomizing = false;
        
        public ExScenarioModel(ScenarioCookie scenarioCookie) {
            this.scenarioCookie = scenarioCookie;
            this.scenarioModel = scenarioCookie.getModel();
            this.customizeValue = "[ " + Util.THIS.getString("LBL_Scenario_Action") + "]";
        }
        
        /** Specifies whether scenario customizer should be started when the customizeValue
         * is selected.  The default value is false */
        public void setAllowCustomizing(boolean allow) {
            allowCustomizing = allow;
        }
        
        public Object getElementAt(int index) {
            if (index == scenarioModel.getSize()) {
                return customizeValue;
            } else {
                return scenarioModel.getElementAt(index);
            }
        }
        
        public void setSelectedItem(Object anObject) {
            if (anObject == customizeValue && allowCustomizing) {
                scenarioCookie.customizeScenarios();
            } else {
                scenarioModel.setSelectedItem(anObject);
            }
        }
        
        public int getSize() {
            return scenarioModel.getSize() + 1;
        }
        
        public void addListDataListener(ListDataListener l) {
            scenarioModel.addListDataListener(l);
        }
        
        public Object getSelectedItem() {
            return scenarioModel.getSelectedItem();
        }
        
        public void removeListDataListener(ListDataListener l) {
            scenarioModel.removeListDataListener(l);
        }
    }
}
