/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.*;
import javax.servlet.http.*;
import org.netbeans.modules.exceptions.bugs.issuezilla.IssuezillaReporter;
import org.netbeans.modules.exceptions.entity.Comment;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Line;
import org.netbeans.modules.exceptions.entity.Stacktrace;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.modules.exceptions.utils.Utils;

/**
 *
 * @author Jan Horvath
 * @version
 */
public class IssuezillaRedirect extends HttpServlet {
    
    public static final String ISSUEZILLA_ENTER_BUG = "http://www.netbeans.org/issues/enter_bug.cgi?";
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        
        Integer id = null;
        try {
            id = new Integer(request.getParameter("exceptionsid"));            
        } catch (NumberFormatException e) {
        }
        
        //notify updater
        if (id != null) {
            Object o = getServletContext().getAttribute("updater");
            if (o instanceof IssuezillaUpdater) {
                IssuezillaUpdater updater = (IssuezillaUpdater) o;
                updater.addIssue(id);
            }
        }
        
        //prepare url parameters
        StringBuffer params = new StringBuffer();
        Exceptions exceptions = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, id);
        exceptions.setIssuezillaTransfer(true);
        PersistenceUtils.getInstance().merge(exceptions);
        if (exceptions != null) {
                Integer issuezillaId = exceptions.getIssuezillaid();
                if ((issuezillaId == null) || (issuezillaId.intValue() == 0)) {
                    
                    // prepare first 10 lines of stacktrace
                    Stacktrace stacktraceEntity = exceptions.getStacktrace();
                    StringBuffer stacktrace = new StringBuffer();
                    if (exceptions.getStacktrace() != null) {
                        stacktrace.append(exceptions.getStacktrace().getMessage() + "\n");
                        List<Line> lines = new ArrayList(exceptions.getStacktrace().getLineCollection());
                        Collections.sort(lines, new LineComparator());
                        int i = 9;
                        for (Line line : lines) {
                            stacktrace.append(Utils.formatStacktraceLine(line) + "\n");
                            if (i-- < 1) break;
                        }
                    }

                    StringBuffer comments = new StringBuffer();
                    Iterator<Comment> it = exceptions.getCommentCollection().iterator();
                    while(it.hasNext()) {
                        Comment comment =  it.next();
                        comments.append(comment.getComment());
                        if (it.hasNext()) {
                            comments.append("\n");
                        }
                    }
                    
                    params.append("component=" + URLEncoder.encode(exceptions.getComponent()));
                    params.append("&subcomponent=" + URLEncoder.encode(exceptions.getSubcomponent()));
                    params.append("&comment=" + URLEncoder.encode("\n" +
                            "\nBuild: " + exceptions.getProductversion() +
                            "\nVM: " + exceptions.getVm() +
                            "\nOS: " + exceptions.getOperatingsystem() +
                            "\nUser comments: " + comments +
                            "\nSTACKTRACE: (first 10 lines)\n" + stacktrace));
                    params.append("&short_desc=" + URLEncoder.encode(exceptions.getSummary()));
                    if ((exceptions.getNbuserId() != null) && (!"GUEST".equals(exceptions.getNbuserId().getName()))) {
                        params.append("&cc=" + URLEncoder.encode(exceptions.getNbuserId().getName()));
                    }
                    params.append("&issue_file_loc=" + URLEncoder.encode(IssuezillaReporter.EXCEPTION_DETAIL + exceptions.getId()));
                    params.append("&version=6.0");
                    params.append("status_whiteboard=EXCEPTIONS_REPORT");
                    params.append("&exceptionsid=" + exceptions.getId());
                } 
            }
        
        
        
        response.sendRedirect(ISSUEZILLA_ENTER_BUG + params);        
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
