/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */
package org.netbeans.modules.changelog.settings;

import java.beans.*;
import java.util.*;

import org.openide.util.*;

import org.netbeans.modules.changelog.html.*;

    /** Property editor for Default Server Info prop. of the ChangeLog settings
     *
     * @author Ralph Krueger
     */
public class DefaultServerInfoPE extends PropertyEditorSupport {

    private static final java.util.ResourceBundle bundle = NbBundle.getBundle(DefaultServerInfoPE.class);

    /** localized string*/
    private final static String DEFAULTS = bundle.getString("DefaultServerInfoPE.noDefault.text"); // NOI18N

    /** array of display names */
    private String[] texts;
    /** array of internal Ids */
    private String[] ids;

    /** @return names of the supported LookAndFeels */
    public String[] getTags() {
        if (texts == null ) {
            initValues();
        }
        return texts;
    }
    
    private void initValues() {
        Lookup.Template template = new Lookup.Template(ChangeLogHTMLService.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection col = result.allItems();
        texts = new String[col.size() + 1];
        ids = new String[col.size() + 1];
        texts[0] = DEFAULTS;
        ids[0] = "";
        Iterator it = col.iterator();
        int index = 1;
        while (it.hasNext()) {
            Lookup.Item item = (Lookup.Item)it.next();
            ChangeLogHTMLService serv = (ChangeLogHTMLService)item.getInstance();
            texts[index] = serv.getName();
            ids[index] = item.getId();
            index = index + 1;
        }
    }


    private int findIndexInArray(String[] arr, String value) {
        for (int i = 0; i < arr.length; i++) {
            if (value.equals(arr[i])) {
                return i;
            }
        }
        return -1;
    }
    
    /** Gets the property value as a string suitable for presentation
     * to a human to edit.
     *
     * @return The property value as a string suitable for presentation
     *       to a human to edit.
     * <p>   Returns "null" is the value can't be expressed as a string.
     * <p>   If a non-null value is returned, then the PropertyEditor should
     * 	     be prepared to parse that string back in setAsText().
     */
    public String getAsText() {
        if (texts == null ) {
            initValues();
        }
        String value = (String)getValue();
        if (value == null) {
            value = "";
        }
        int i = findIndexInArray(ids, value);
        if (i != -1) {
            return texts[i];
        }
        setValue("");
        return DEFAULTS;
    }    

    /** Sets the property value by parsing a given String.  May raise
     * java.lang.IllegalArgumentException if either the String is
     * badly formatted or if this kind of property can't be expressed
     * as text.
     *
     * @param text  The string to be parsed.
     */
    public void setAsText(String text) throws java.lang.IllegalArgumentException {
        if (texts == null ) {
            initValues();
        }
        int i = findIndexInArray(texts, text);
        if (i != -1) {
            setValue(ids[i]);
            return;
        }
        setValue("");
    }
    
}

