/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: st_sql_postgres.c,v 1.89 2009-08-01 09:23:55 anton Exp $ */

#ifdef USE_POSTGRES

#include "netams.h"
#include "st_any.h"
#include <libpq-fe.h>

//////////////////////////////////////////////////////////////////////////
void *pg_stOpenSql(struct sql_config *cfg,st_conn_type type);
void *pg_stCheckSql(void *fd);
unsigned pg_stSaveSql(void *fd, char *filename, st_conn_type type);
void pg_stCloseSql(void *fd);
u_char pg_stObtainDbData(void *fd, char *query,
	void (*FillData)(void*, void* ,char* (*getRowData)(void*, void* , u_char)));
//////////////////////////////////////////////////////////////////////////
struct sql_data pg_sql_data = {
	5432,
	&pg_stOpenSql,
	&pg_stCheckSql,
	&pg_stSaveSql,
	&pg_stCloseSql,
	&pg_stObtainDbData
};
//////////////////////////////////////////////////////////////////////////
char* pg_getRowData(void *res, void *row, u_char num) {
        return PQgetvalue((PGresult*)res,*(int*)row,num);
}
//////////////////////////////////////////////////////////////////////////
extern const char *tr_func[ST_CONN_TYPES_NUM];
//////////////////////////////////////////////////////////////////////////
void *pg_stOpenSql(struct sql_config *cfg, st_conn_type type){
	PGresult  *res;
	PGconn *conn;

	char *pg_host, *pg_user, *pg_pass, *pg_dbname;
	char buffer[1024]; 
        
	pg_host=cfg->hostname;
        pg_user=cfg->username;
        pg_pass=cfg->password;
        pg_dbname=cfg->dbname;
	
	conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,pg_dbname,pg_user,pg_pass);
	if (PQstatus(conn) == CONNECTION_BAD) {
		PQfinish(conn);
		conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,"template1",pg_user,pg_pass);
		if (PQstatus(conn) == CONNECTION_BAD) {	
             		aLog(D_ERR, "postgres connect failed: %s, continuing closed\n",  PQerrorMessage(conn));
			PQfinish(conn);
			return NULL;
		}
		res = PQexec(conn,"SET autocommit TO 'on'"); 
		PQclear(res);

		sprintf(buffer,"SELECT * FROM pg_database WHERE datname='%s'",pg_dbname);
		res = PQexec(conn, buffer);
        	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
			aLog(D_ERR, "postgres list dbs failed: %s\n", PQerrorMessage(conn));
			PQfinish(conn);
			return NULL;
		}
		if(!PQntuples(res)) { //hmmm, there are no netams database there... creating it...
			PQclear(res);
			snprintf(buffer, 254, "CREATE DATABASE %s TEMPLATE template0", pg_dbname);
			res = PQexec(conn, buffer);
			if (PQresultStatus(res) != PGRES_COMMAND_OK) {
				aLog(D_ERR, "postgres create db failed: %s\n",PQerrorMessage(conn));
				PQfinish(conn);
				return NULL;
			} else 
				aLog(D_INFO, "postgres database [%s] created\n", pg_dbname);

			PQclear(res);
			PQfinish(conn);
			
			conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,pg_dbname,pg_user,pg_pass);
			if (PQstatus(conn) == CONNECTION_BAD) {
                        	aLog(D_ERR, "postgres connect failed: %s, continuing closed\n",  PQerrorMessage(conn));
                        	PQfinish(conn);
				return NULL;
                	}
			
			const char *query;
			//create function && load language ignore errors
			query="CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler 	\
				AS '$libdir/plpgsql', 'plpgsql_call_handler' LANGUAGE c ";
			res=PQexec(conn, query); PQclear(res);

			//create language
			query="CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler";
			res=PQexec(conn, query); PQclear(res);
		}
	}
	
//	FILE *debug = fopen("/tmp/trace.out","a");
//	PQtrace(conn, debug);

	res=PQexec(conn,"BEGIN");PQclear(res);
	
	const char *table=st_table_name[type];
	sprintf(buffer, "SELECT * FROM pg_tables WHERE tablename='%s'", table);
	res = PQexec(conn, buffer);
	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
		aLog(D_ERR, "postgres list table failed: %s\n", PQerrorMessage(conn));
		PQfinish(conn);
		return NULL;
	}
	int num=PQntuples(res);
	PQclear(res);

	if(!num) {
		const char *query=NULL;
		switch(type) {
			case ST_CONN_RAW:
				query="CREATE TABLE raw (unit_oid INT NOT NULL, policy_oid INT NOT NULL, t_from INT , t_to INT , bytes_in BIGINT , bytes_out BIGINT );\
					CREATE INDEX raw_unit_oid_idx ON raw(unit_oid);\
					CREATE INDEX raw_policy_oid_idx ON raw(policy_oid);\
					CREATE INDEX raw_t_from_idx ON raw(t_from);\
					CREATE INDEX raw_t_to_idx ON raw(t_to)\
				";
				break;
			case ST_CONN_SUMMARY:
				query="CREATE TABLE summary (prefix CHAR(1) NOT NULL, unit_oid INT NOT NULL, policy_oid INT NOT NULL, t_from INT NOT NULL, bytes_in BIGINT, bytes_out BIGINT, PRIMARY KEY(prefix, unit_oid, policy_oid, t_from));\
                        		CREATE INDEX summary_unit_oid_idx ON summary(unit_oid);\
                        		CREATE INDEX summary_policy_oid_idx ON summary(policy_oid);\
                        		CREATE INDEX summary_t_from_idx ON summary(t_from)\
				";
				break;
			case ST_CONN_MONITOR:
				query="CREATE TABLE monitor (time INT NOT NULL, flowt INT , unit_oid INT , proto SMALLINT , src BIGINT NOT NULL, srcport INT , dst BIGINT NOT NULL, dstport INT ,if_in INT, if_out INT, as_src INT, as_dst INT, dpkts BIGINT , len BIGINT, layer7 VARCHAR(80) );\
					CREATE INDEX monitor_time_idx ON monitor(time);\
					CREATE INDEX monitor_unit_oid_idx ON monitor(unit_oid)\
				";
				break;
			case ST_CONN_LOGIN:
				query="CREATE TABLE login (unit_oid INT PRIMARY KEY NOT NULL, password VARCHAR(32), inact INT, abs INT , last_changed INT , last_opened_time INT , ip BIGINT NULL, mac VARCHAR(18), flags INT NULL)\
				";
				break;
			case ST_CONN_QUOTA:
				query="CREATE TABLE quota (unit_oid INT NOT NULL,policy_oid INT NOT NULL, syspolicy_oid INT , soft_treshold INT , flags INT , last_blocked_time INT , notify_soft_oid INT , notify_hard_oid INT , notify_return_oid INT , h_in BIGINT NULL, h_out BIGINT NULL, h_sum BIGINT NULL, d_in BIGINT NULL, d_out BIGINT NULL, d_sum BIGINT NULL, w_in BIGINT NULL, w_out BIGINT NULL, w_sum BIGINT NULL, m_in BIGINT NULL, m_out BIGINT NULL, m_sum BIGINT NULL, block_policy INT, block_policy_flags INT, PRIMARY KEY (unit_oid,policy_oid));\
                                CREATE INDEX quota_unit_oid_idx ON quota(unit_oid);\
                                CREATE INDEX quota_policy_oid_idx ON quota(policy_oid)\
				";
				break;
			case ST_CONN_OIDS:
				query="CREATE TABLE oids (object_oid INT PRIMARY KEY NOT NULL, name VARCHAR(32))\
				";
				break;
			case ST_CONN_EVENTS:
				query="CREATE TABLE events (time INT , type VARCHAR(8), unit_oid INT, user_oid INT, account_oid INT, param VARCHAR(254))\
				";
				break;
			case ST_CONN_BILLING:
				query="CREATE TABLE billing (account_oid INT PRIMARY KEY NOT NULL, name VARCHAR(32), description VARCHAR(254), balance DOUBLE PRECISION, units TEXT, plan INT, plan_ch INT, nextplan INT, nextplan_ch INT, blocked INT, created INT, changed INT, last_fee_ch INT, email VARCHAR(32), passwd VARCHAR(32), status INT NULL, credit_limit DOUBLE PRECISION)\
				";
				break;
			case ST_CONN_BDATA:
				query="CREATE TABLE bdata (prefix CHAR(1) NOT NULL, account_oid INT NOT NULL, subplan_oid INT NOT NULL, t_from INT NOT NULL, bytes_in BIGINT NULL, bytes_out BIGINT NULL, pay_in DOUBLE PRECISION NULL, pay_out DOUBLE PRECISION NULL, PRIMARY KEY(prefix, account_oid, subplan_oid, t_from));\
					CREATE INDEX bdata_account__oid_idx ON bdata(account_oid);\
					CREATE INDEX bdata_subplan_oid_idx ON bdata(subplan_oid);\
					CREATE INDEX bdata_t_from_idx ON bdata(t_from)\
				";
				break;
			default:
				break;
		}
		res = PQexec(conn, query);
		if (PQresultStatus(res) != PGRES_COMMAND_OK) {
			aLog(D_ERR, "postgres create table '%s' failed: %s\n", table, PQerrorMessage(conn));
			PQfinish(conn);
			return NULL;
		} else 
			aLog(D_INFO, "postgres table '%s' created\n", table);
		PQclear(res);
		
		//create triggers
		if(tr_func[type]) {
			res = PQexec(conn, tr_func[type]);
			if (PQresultStatus(res) != PGRES_COMMAND_OK) {
				aLog(D_ERR, "postgres create function 'netams_tr_%s' failed: %s\n",
						table, PQerrorMessage(conn));
			} else 
				aLog(D_INFO, "postgres function 'netams_tr_%s' created\n", table);
			PQclear(res);

			sprintf(buffer, "CREATE TRIGGER netams_tr_%s		\
						BEFORE INSERT ON \"%s\"		\
						FOR EACH ROW			\
						EXECUTE PROCEDURE netams_tr_%s()\
			", table, table, table);

			res = PQexec(conn, buffer);
			if (PQresultStatus(res) != PGRES_COMMAND_OK) {
				aLog(D_ERR, "postgres create trigger 'netams_tr_%s' failed: %s\n", 
						table, PQerrorMessage(conn));
			} else 
				aLog(D_INFO, "postgres trigger 'netams_tr_%s' created\n", table);
			PQclear(res);
		}
	}

	res=PQexec(conn,"COMMIT");PQclear(res);
	
	return (void*)conn;
}
//////////////////////////////////////////////////////////////////////////
void *pg_stCheckSql(void *fd){
	PGconn *conn=(PGconn*)fd;
	
	//check for reconnect
	if(PQstatus(conn) != CONNECTION_BAD)
		return (void*)conn;
	else
		pg_stCloseSql(conn);
	
	return NULL;
}

//////////////////////////////////////////////////////////////////////////
void pg_stCloseSql(void *fd){
	PGconn *conn=(PGconn*)fd;
	PQfinish((PGconn*)conn);
}

//////////////////////////////////////////////////////////////////////////
unsigned pg_stSaveSql(void *fd, char *filename, st_conn_type type){
	
	char buf[255];
	PGconn *conn=(PGconn*)fd;
	PGresult *res;
	int i, j=0;
	// this is not working. see also
	// http://groups.google.com/groups?q=PGRES_COPY_IN+PQputCopyData&hl=ru&lr=&selm=272e4be7.0404300512.49592ecb%40posting.google.com&rnum=1
	
	res=PQexec(conn,"BEGIN");PQclear(res);

	sprintf(buf, "COPY %s FROM STDIN DELIMITER AS ',';", st_table_name[type]);
	res = PQexec(conn, buf );
	if (PQresultStatus (res) != PGRES_COPY_IN) {
		aLog(D_ERR, "SQL Load data: postgres: COPY failed: %s\n", PQerrorMessage(conn)); 
		PQclear(res);
		return 0;
	}
	PQclear(res);
			
	FILE *f = fopen(filename, "r");
	if (!f) { 
		aLog(D_ERR, "SQL Load data: postgres: file %s: %s \n", filename, strerror(errno));
		goto COPY_END;
	}

	while (fgets(buf, 255, f) != NULL) {
		i=PQputCopyData(conn, buf, strlen(buf));
		j++;
		if (i==-1) aLog(D_ERR, "SQL/pg copy data: (size=%d) %s\n", strlen(buf), PQerrorMessage(conn) );
	}
	fclose(f);

COPY_END:
	i=PQputCopyEnd(conn, NULL);
	if (i==-1) aLog(D_ERR, "SQL/pg copy end: %s\n", PQerrorMessage(conn) );
	
	//clear results
	while((res=PQgetResult(conn))) {
		PQclear(res);
	}
	
	res=PQexec(conn,"COMMIT");PQclear(res);

	return j;	
}
//////////////////////////////////////////////////////////////////////////
u_char pg_stObtainDbData(void *fd, char *query,
	void (*FillData)(void*, void* ,char* (*)(void*, void* , u_char)) ){

	PGresult  *res;
	PGconn *conn=(PGconn*)fd;
	u_char ret=1;

	res=PQexec(conn,query);
	if(PQresultStatus(res) != PGRES_TUPLES_OK) {
                aLog(D_ERR, "postgres select failed: %s\n", PQerrorMessage(conn));
                return 0;
        }

	if(PQntuples(res)) {
		for(int row=0;row < PQntuples(res); row++)
			FillData(res, &row, &pg_getRowData);
    	} else 
		ret=0;

	PQclear(res);
	return ret;
}
//////////////////////////////////////////////////////////////////////////
const char *tr_func[ST_CONN_TYPES_NUM]={
NULL,
NULL,
"								\
CREATE FUNCTION netams_tr_summary() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM summary WHERE prefix=NEW.prefix	\
	AND unit_oid=NEW.unit_oid AND policy_oid=NEW.policy_oid	\
	AND t_from=NEW.t_from);					\
	if cnt <> 0 then					\
		DELETE FROM summary WHERE prefix=NEW.prefix 	\
		AND unit_oid=NEW.unit_oid 			\
		AND policy_oid=NEW.policy_oid 			\
		AND t_from=NEW.t_from;				\
	end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",			
NULL,
"								\
CREATE FUNCTION netams_tr_login() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM login WHERE unit_oid=NEW.unit_oid);\
        if cnt <> 0 then					\
            DELETE FROM login WHERE unit_oid=NEW.unit_oid;	\
        end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",		
"								\
CREATE FUNCTION netams_tr_quota() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM quota WHERE unit_oid=NEW.unit_oid 	\
	AND policy_oid=NEW.policy_oid);				\
        if cnt <> 0 then					\
            DELETE FROM quota WHERE unit_oid=NEW.unit_oid 	\
		AND policy_oid=NEW.policy_oid;			\
        end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",
NULL,
"								\
CREATE FUNCTION netams_tr_oids() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM oids WHERE object_oid=NEW.object_oid);\
        if cnt <> 0 then					\
            UPDATE oids SET 					\
		object_oid=NEW.object_oid, name=NEW.name	\
	    WHERE object_oid=NEW.object_oid;			\
	RETURN NULL;						\
        end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",
"								\
CREATE FUNCTION netams_tr_billing() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM billing WHERE account_oid=NEW.account_oid);\
        if cnt <> 0 then					\
            DELETE FROM billing WHERE account_oid=NEW.account_oid;\
        end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",
"								\
CREATE FUNCTION netams_tr_bdata() RETURNS \"trigger\"		\
    AS '							\
DECLARE								\
cnt int;							\
BEGIN								\
								\
cnt := (SELECT COUNT(*) FROM bdata WHERE 			\
	prefix=NEW.prefix AND account_oid=NEW.account_oid 	\
	AND subplan_oid=NEW.subplan_oid AND t_from=NEW.t_from);	\
        if cnt <> 0 then					\
            DELETE FROM bdata WHERE 				\
		prefix=NEW.prefix AND account_oid=NEW.account_oid \
		AND subplan_oid=NEW.subplan_oid AND t_from=NEW.t_from;\
        end if;							\
								\
RETURN NEW;							\
END;								\
'								\
    LANGUAGE plpgsql;						\
",
NULL
};
#endif // postgres
