/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: services.h,v 1.101 2009-08-01 09:23:55 anton Exp $ */

#define SERVICE_TYPES_NUM	24

enum service_type { SERVICE_UNDEF=0, SERVICE_STORAGE=1, SERVICE_PROCESSOR=2, SERVICE_DATASOURCE=3, SERVICE_MONITOR=4, SERVICE_HTML=5, SERVICE_QUOTA=6, SERVICE_QUOTACTL=7, SERVICE_LOGIN=8, SERVICE_ALERTER=9, SERVICE_SCHEDULER=10, SERVICE_BILLING=11, SERVICE_WEBLOGIN=12, SERVICE_EMPTY=13, SERVICE_SERVER=14, SERVICE_MAIN=15, SERVICE_DS_IPQ=16, SERVICE_DS_IPFW=17, SERVICE_DS_LIBPCAP=18, SERVICE_DS_ULOG=19, SERVICE_DS_NETGRAPH=20, SERVICE_DS_NETFLOW=21, SERVICE_ACL_SERVER=22, SERVICE_DS_RAW=23 };

//////////////////////////////////////////////////////////////////////////
//cancellation points stuff
#define SET_CANCEL()		pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
#define TEST_CANCEL(arg)	{ int cancel_state;pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, &cancel_state);arg;pthread_setcancelstate(cancel_state, NULL); }

#define DISABLE_CANCEL	int cancel_state;pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, &cancel_state);
#define RESTORE_CANCEL	pthread_setcancelstate(cancel_state, NULL);
//////////////////////////////////////////////////////////////////////////
typedef u_char service_flags;
#define SERVICE_FLAG_NONE	0
#define SERVICE_FLAG_VISIBLE	0x01
#define SERVICE_FLAG_SINGLE	0x02
#define SERVICE_FLAG_FAULTY	0x04
#define SERVICE_FLAG_DOWN	0x08
//////////////////////////////////////////////////////////////////////////
class Service: public Object {
	private:
		pthread_mutex_t sleep_mutex;
		pthread_cond_t sleep_cond;
		u_char sleep_state;
	public:
		const char *getName();
		
		Service(service_type s_type, u_char i=0);
		virtual ~Service();
		
		void Start();
		void Stop();
		pthread_t t_id;
		service_flags serv_flags;
		service_type serv_type;
		u_char cli_mode;

		u_char instance;
		u_char Wakeup();
		u_char Sleep(unsigned sec=0);
		void setSleep() { sleep_state=1; }
		int isSleep() { return sleep_state; }
		void showPerf(FILE *f, u_char isheader=0);
		
		virtual void ShowCfg(struct cli_def *cli, u_char flags=0) {};
		virtual int ProcessCfg(struct cli_def *cli, char **argv, int argc, u_char no_flag) { return CLI_OK; };
		virtual void ShowInfo(struct cli_def *cli) {};
		virtual void ShowPerf(struct cli_def *cli, u_char isheader) {};
		virtual void Worker() {};
		virtual void Cancel() {};
		virtual int ProcessMessage(void *msg) {return 0;};
};
//////////////////////////////////////////////////////////////////////////
//Service interfaces
//DATASOURCE
class Service_Datasource_Interface : public Service {
	public:
		Service_Datasource_Interface():Service(SERVICE_DATASOURCE) {};
		virtual ~Service_Datasource_Interface() {};
		
		virtual int unit2ds(unsigned addr,u_char mask,NetUnit *u,u_char flag) = 0;
};
//////////////////////////////////////////////////////////////////////////
//MONITOR
class Service_Monitor_Interface : public Service {
	public:
		Service_Monitor_Interface():Service(SERVICE_MONITOR) {};
		virtual ~Service_Monitor_Interface() {};
		
		virtual int aMonitor(NetUnit *u, Flow *flow) = 0;
};
//////////////////////////////////////////////////////////////////////////
// STORAGE
#define ST_CONN_TYPES_NUM	11
//Types of connections to storage
enum st_conn_type { ST_CONN_UNDEF=0, ST_CONN_RAW=1, ST_CONN_SUMMARY=2, ST_CONN_MONITOR=3, ST_CONN_LOGIN=4, ST_CONN_QUOTA=5, ST_CONN_EVENTS=6, ST_CONN_OIDS=7, ST_CONN_BILLING=8 , ST_CONN_BDATA=9, ST_CONN_CONFIG=10 };

Service* aStorageGetAccepted(st_conn_type type);
Service** aStorageGetAcceptedAll(st_conn_type type, Service ***list=NULL);

class Service_Storage_Interface : public Service {
	public:
		Service_Storage_Interface():Service(SERVICE_STORAGE) {};
		virtual ~Service_Storage_Interface() {};
		
		virtual int stLoad(st_conn_type type,
			void (*FillData)(void *res, void *row, char* (*getRowData)(void*, void* , u_char))=NULL) = 0;
		virtual int SaveFile(char *filename, st_conn_type type) = 0;
		virtual int isAccepted(st_conn_type type) = 0;
		virtual void Close(st_conn_type type) = 0;
};
//////////////////////////////////////////////////////////////////////////
//BILLING
extern Service *Billing;

class Service_Billing_Interface : public Service {
	public:
		Service_Billing_Interface():Service(SERVICE_BILLING) {};
		virtual ~Service_Billing_Interface() {};
		
};
/////////////////////////////////////////////////////////////////////////
//Scheduler
extern Service *sSched;

//////////////////////////////////////////////////////////////////////////
void* ServiceWorker(void *s);
void  ServiceCancel(void *s);
//////////////////////////////////////////////////////////////////////////
class ServicesList: public List {
	public:
		ServicesList();
		~ServicesList() {};
		Service *getService(service_type type, u_char i);
		Service *getServiceNextByType(service_type type, Service *s=NULL);
		Service *getServiceByThr(pthread_t t);
		void StartAll();
		void ShutdownAll();
		
		void ShowCfg(struct cli_def *cli, u_char flags);
		void ShowPerf(struct cli_def *cli, u_char isheader=0);
		void ShowInfo(struct cli_def *cli);
};

//////////////////////////////////////////////////////////////////////////
Service* InitAclServerService();
Service* InitDatasourceService();
//////////////////////////////////////////////////////////////////////////
class Service_Html: public Service {
	public:
		char *path;
		char *run_period;
		u_char is_distributed;
		cpages_type cpages;
		apages_type apages;
		char *url;
		char *servlet_url;
		u_char is_htaccess;
		u_char is_graphs;
		u_char display_top;
		u_char display_health;
		Html_grouplist_item *grouproot;
		
		Service_Html();
		~Service_Html();
		
		void ShowCfg(struct cli_def *cli, u_char flags);
		int ProcessCfg(struct cli_def *cli, char **argv, int argc, u_char no_flag);
		void Worker();
		void Cancel();

		void HtmlAction();
};
//////////////////////////////////////////////////////////////////////////
Service* InitLoginService();
Service* InitMonitorService();
//////////////////////////////////////////////////////////////////////////
class Service_Processor: public Service {
	public:
		NetUnit *def;
		unsigned delay; // in seconds
		unsigned lifetime; // in seconds
		restrict_type restrict_local, restrict_all;
		char *access_script;
		FIFO *fifo;  //this is for billing
		AutoAssignEntry *auto_assign;
		AutoUnitsEntry *auto_units;

		unsigned long long mac_control_units_checked;
		unsigned long long mac_control_units_violated;

		Service_Processor();
		~Service_Processor();

		void ShowCfg(struct cli_def *cli, u_char flags);
		int ProcessCfg(struct cli_def *cli, char **argv, int argc, u_char no_flag);
		void Worker();
		void Cancel();

		void MessagesGenerator();
		void MessagesMultiplexer();
};
//////////////////////////////////////////////////////////////////////////
Service* InitQuotaService();
Service* InitQuotactlService();
Service* InitSchedulerService();
Service* InitServerService();
Service* InitStorageService();
Service* InitAlerterService();
Service* InitBillingService();
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
