/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: mutex.h,v 1.9 2009-08-01 09:23:55 anton Exp $ */

/////////////////////////////////////////////////////////////////////////////////////////
void aMutexDebugInit();
void aMutexDebugRelease();
/////////////////////////////////////////////////////////////////////////////////////////
#if defined(DEBUG) && defined(MUTEX_DEBUG)

#define LOCK_MUTEX		0x01
#define LOCK_RWLOCK		0x02

#define LOCK_LOCK		0x10
#define LOCK_RWLOCK_RDLOCK	0x20
#define LOCK_RWLOCK_WRLOCK	0x30

//mutexes
#define netams_mutex_init(mutex, attr)          netams_lock_init(__FILE__, __LINE__, LOCK_MUTEX, mutex, attr)
#define netams_mutex_destroy(mutex)             netams_lock_destroy(__FILE__, __LINE__, LOCK_MUTEX, mutex)
#define netams_mutex_lock(mutex)                netams_lock_lock(__FILE__, __LINE__, LOCK_MUTEX|LOCK_LOCK, mutex)
#define netams_mutex_unlock(mutex)              netams_lock_unlock(__FILE__, __LINE__, LOCK_MUTEX, mutex)
#define netams_mutex_trylock(mutex)             netams_lock_trylock(__FILE__, __LINE__, LOCK_MUTEX|LOCK_LOCK, mutex)

//rwlocks
#define netams_rwlock_init(rwlock, attr)        netams_lock_init(__FILE__, __LINE__, LOCK_RWLOCK, rwlock, attr)
#define netams_rwlock_destroy(rwlock)           netams_lock_destroy(__FILE__, __LINE__, LOCK_RWLOCK, rwlock)
#define netams_rwlock_rdlock(rwlock)            netams_lock_lock(__FILE__, __LINE__, LOCK_RWLOCK|LOCK_RWLOCK_RDLOCK, rwlock)
#define netams_rwlock_wrlock(rwlock)            netams_lock_lock(__FILE__, __LINE__, LOCK_RWLOCK|LOCK_RWLOCK_WRLOCK, rwlock)
#define netams_rwlock_unlock(rwlock)            netams_lock_unlock(__FILE__, __LINE__, LOCK_RWLOCK, rwlock)
#define netams_rwlock_tryrdlock(rwlock)         netams_lock_trylock(__FILE__, __LINE__, LOCK_RWLOCK|LOCK_RWLOCK_RDLOCK, rwlock)
#define netams_rwlock_trywrlock(rwlock)         netams_lock_trylock(__FILE__, __LINE__, LOCK_RWLOCK|LOCK_RWLOCK_WRLOCK, rwlock)

//functions
int	netams_lock_destroy(const char *, unsigned, u_char type, void *);
int	netams_lock_init(const char *, unsigned, u_char type, void *, void *);
int	netams_lock_lock(const char *, unsigned, u_char type, void *);
int	netams_lock_trylock(const char *, unsigned, u_char type, void *);
int	netams_lock_unlock(const char *, unsigned, u_char type, void *);

#else

//mutexes
#define netams_mutex_init(mutex, attr)		pthread_mutex_init(mutex, attr)
#define netams_mutex_destroy(mutex)		pthread_mutex_destroy(mutex)
#define netams_mutex_lock(mutex)		pthread_mutex_lock(mutex)
#define netams_mutex_unlock(mutex)		pthread_mutex_unlock(mutex)
#define netams_mutex_trylock(mutex)		pthread_mutex_trylock(mutex)

//rwlocks
#define netams_rwlock_init(rwlock, attr)	pthread_rwlock_init(rwlock, attr)
#define netams_rwlock_destroy(rwlock)		pthread_rwlock_destroy(rwlock)
#define netams_rwlock_rdlock(rwlock)		pthread_rwlock_rdlock(rwlock)
#define netams_rwlock_wrlock(rwlock)		pthread_rwlock_wrlock(rwlock)
#define netams_rwlock_unlock(rwlock)		pthread_rwlock_unlock(rwlock)
#define netams_rwlock_tryrdlock(rwlock)		pthread_rwlock_tryrdlock(rwlock)
#define netams_rwlock_trywrlock(rwlock)		pthread_rwlock_trywrlock(rwlock)

#endif
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
