#!/bin/sh
# Configuration script for NeTAMS project
# $Id: configure.sh,v 1.67 2009-09-06 16:44:54 anton Exp $
##########################################################

PATH="/usr/local/sbin:/bin:/usr/bin:/usr/sbin:/sbin:/usr/local/bin"
export PATH
makefile="Rules.make"
 
##########################################################
paths="/usr/lib /usr/local/lib /usr/lib/mysql /usr/local/lib/mysql /usr/local/mysql4/lib/mysql \
 /usr/local/include/mysql /usr/local/include /usr/include /usr/include/mysql /usr/local/mysql4/include/mysql \
 /opt/csw/include /usr/pkg/include/mysql /usr/pkg/lib/mysql $ORACLE_HOME/lib32 $ORACLE_HOME/lib /usr/include/libipq \
 /usr/pkg/include /usr/pkg/lib /usr/lib64/mysql /usr/lib64 /usr/include/postgresql /usr/include/libnetfilter_queue \
 /usr/include/glib-2.0 /usr/lib/glib-2.0/include"

locate_file() {
	for val in $paths
	do
		to_test="$val/$1"
		#echo " try: $to_test"
		if [ -f $to_test ]
		then
			var=$val
			return
		fi
	done
	var=""
}

##########################################################
warn_on_mysql3xx(){
if [ -f "$v1/libmysqlclient.so.10" ]; then
	echo "!!! Looks like you have MYSQL=3.xx which is NOT supported !!!"
	echo "!!! I will continue making but ensure you have 4.XX or above  !!!"
fi
}

##########################################################
llu_to_qu_patch(){
	cp src/st_sql_mysql.c src/st_sql_mysql.c.orig
	sed -e "s/llu/qu/g" src/st_sql_mysql.c.orig > src/st_sql_mysql.c
	cp src/st_sql_postgres.c src/st_sql_postgres.c.orig
	sed -e "s/llu/qu/g" src/st_sql_postgres.c.orig > src/st_sql_postgres.c
	cp src/st_hash.c src/st_hash.c.orig
	sed -e "s/llu/qu/g" src/st_hash.c.orig > src/st_hash.c
}

##########################################################
prepare_for_freebsd() {
echo "FreeBSD operating system..."
echo "DEFINE += -DFREEBSD" >> $makefile
echo "LIB += -lpcap -pthread -lnetgraph" >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "STARTUP_SCRIPT=netams-startup-freebsd6.sh" >> $makefile
echo "PATH_TO_ETC=/usr/local/etc" >> $makefile
echo "PATH_TO_WWW=/usr/local/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/usr/local/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/local/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/local/libexec"  >> $makefile
echo "SBINDIR=/usr/local/sbin"	>> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

#check for FreeBSD-4.xx and patch
var=`uname -r | cut -b 1`
if [ $var -lt 5 ]; then
	echo "With FreeBSD 4 patch the sources..."
	llu_to_qu_patch
else
	echo "With FreeBSD 5 and above will have netgraph module..."
	echo "FREEBSD_KMOD = ng_netams.ko" >> $makefile
	echo "FREEBSD_KMOD_CLEAN = clean_ng_netams.ko" >> $makefile
fi

echo "PROG += flowprobe ipfw2netflow"	 >> $makefile
}

##########################################################
prepare_for_macos() {
echo "MAC OS X (darwin) operating system..."
echo "DEFINE += -DFREEBSD -DMACOS" >> $makefile
echo "LIB += -lpcap -lz -pthread" >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "STARTUP_SCRIPT=netams-startup-freebsd6.sh" >> $makefile
echo "PATH_TO_ETC=/etc" >> $makefile
echo "PATH_TO_WWW=/usr/local/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/local/sbin"  >> $makefile
echo "SBINDIR=/usr/local/sbin"  >> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

llu_to_qu_patch

echo "PROG += flowprobe ipfw2netflow"    >> $makefile
}

##########################################################
prepare_for_netbsd() {

echo "NetBSD operating system..."
echo "DEFINE += -DNETBSD" >> $makefile
echo "LIB += -lpcap -pthread " >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "STARTUP_SCRIPT=netams-startup-failover.sh" >> $makefile
echo "PATH_TO_ETC=/usr/pkg/etc" >> $makefile
echo "PATH_TO_WWW=/usr/local/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/usr/pkg/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/pkg/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/pkg/libexec"  >> $makefile
echo "SBINDIR=/usr/pkg/sbin"  >> $makefile
echo "MANDIR=/usr/pkg/man"  >> $makefile

llu_to_qu_patch

echo "PROG += flowprobe"    >> $makefile
}

##########################################################
prepare_for_openbsd() {
echo "OpenBSD operating system..."
echo "DEFINE += -DOPENBSD" >> $makefile
echo "LIB += -lpcap -pthread" >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

# paths
echo "STARTUP_SCRIPT=netams-startup-failover.sh" >> $makefile
echo "PATH_TO_ETC=/usr/local/etc" >> $makefile
echo "PATH_TO_WWW=/usr/local/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/usr/local/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/usr/local/etc/rc.d" >> $makefile
echo "DAEMONDIR=/usr/local/libexec"  >> $makefile
echo "SBINDIR=/usr/local/sbin"	>> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

echo "PROG += flowprobe"    >> $makefile
}

##########################################################
prepare_for_linux() {
echo "Linux operating system..."
echo "DEFINE += -DLINUX -D_BSD_SOURCE -I/usr/include/pcap -I/usr/libipq -I../lib/libipulog/include" >> $makefile
echo "LIB += -pthread -lpcap" >> $makefile
echo "INSTALL = /usr/bin/install" >> $makefile

#paths
echo "STARTUP_SCRIPT=netams.init.d" >> $makefile
echo "PATH_TO_ETC=/etc" >> $makefile
echo "PATH_TO_WWW=/var/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/etc/init.d" >> $makefile
echo "DAEMONDIR=/usr/local/sbin"  >> $makefile
echo "SBINDIR=/usr/local/sbin"	>> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

#ipq
locate_file "libipq.a" && v1=$var && locate_file "libnetfilter_queue_libipq.a" && v3=$var && locate_file "libipq.h" && v2=$var
if [ "X$v1$v3" != "X" -a "X$v2" != "X" ]; then
	echo "Will have LIBIPQ support"
	if [ -e /sbin/iptables ]; then
		ipv=`/sbin/iptables -V`
		ipvn=`echo $ipv | sed -e "s/iptables v1\.2\.//g" -e "s/iptables v1\.3\./3/g" -e "s/iptables v1\.4\./4/g" -e 's/\..*//' -e "s/[a-z]//g "`
		if [ -n "$ipvn" ] && [ $ipvn -lt 5 ]; then
			echo "		LIBIPQ is <=1.2.4 (yours is .$ipvn)"
			echo "DEFINE += -DIPTBL_OLD" >> $makefile
		fi
	fi
	if [ "X$v1" != "X" ]; then
		echo "LIB += -lipq -L$v1 -lipulog" >> $makefile
	else
		echo "LIB += -lnetfilter_queue_libipq -L$v3 -lipulog" >> $makefile
	fi
	echo "DEFINE += -I$v2" >> $makefile
	echo "NLIB += libipulog" >> $makefile
	echo "PROG += ulog2netflow"    >> $makefile
else
	echo "No LIBIPQ support - install \"iptables-devel\" if needed"
	echo "DEFINE += -DIPTBL_NONE" >> $makefile
fi

echo "PROG += flowprobe"    >> $makefile
}
##########################################################
prepare_for_solaris() {
echo "Solaris operating system..."
#paths
echo "PATH_TO_ETC=/etc" >> $makefile
echo "PATH_TO_WWW=/opt/www/netams" >> $makefile
echo "PATH_TO_CONFIG=/etc" >> $makefile
echo "PATH_TO_LOG=/var/log/netams.log" >> $makefile
echo "PATH_TO_SCRIPTS=/etc/init.d" >> $makefile
echo "DAEMONDIR=/usr/local/sbin"  >> $makefile
echo "SBINDIR=/usr/local/sbin"	>> $makefile
echo "MANDIR=/usr/local/man"  >> $makefile

echo "INSTALL = /usr/sbin/install" >> $makefile
echo "DEFINE += -DSOLARIS" >>$makefile
echo "LIB += -R/usr/local/lib -lnsl -lsocket -lresolv -lpthread" >> $makefile
echo "SYSLIB += -lnsl -lsocket -lresolv" >> $makefile

	#LIBPCAP support
	if [ -f /usr/local/lib/libpcap.so -a -f /opt/csw/include/pcap.h ]; then
		echo "LIB += -L/opt/csw/lib -lpcap" >> $makefile
		echo "DEFINE += -I/opt/csw/include" >> $makefile
		echo "PROG += flowprobe"    >> $makefile
	else
		echo "NO libPCAP"
		echo "DEFINE += -DNOPCAP" >> $makefile
	fi

}
##########################################################
add_common() {

# mysql
locate_file "libmysqlclient.so" && v1=$var && locate_file "mysql.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
        echo "Will have MYSQL support"
        echo "  [ $v1   $v2 ]"
        warn_on_mysql3xx
        echo "DEFINE += -DUSE_MYSQL -I$v2" >> $makefile
        echo "LIB += -lmysqlclient -L$v1" >> $makefile
fi


# mysql-static
locate_file "libmysqlclient.a" && v1=$var && locate_file "mysql.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have MYSQL (static) support"
	echo "	[ $v1	$v2 ]"
	echo "DEFINE += -DUSE_MYSQL -I$v2" >> $makefile
	echo "LIB += -lmysqlclient -L$v1" >> $makefile
fi


#postgres
locate_file "libpq.so" && v1=$var && locate_file "libpq-fe.h" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have POSTGRESQL support"
	echo "	[ $v1	$v2 ]"
	echo "DEFINE += -DUSE_POSTGRES -I$v2" >> $makefile
	echo "LIB += -lpq -L$v1" >> $makefile
fi

#glib2.0
locate_file "libglib-2.0.so" && v1=$var && locate_file "glib.h" && v2=$var && locate_file "glibconfig.h" && v3=$var
if [ "X$v1" != "X" -a "X$v2" != "X" -a "X$v3" != "X" ]; then
	echo "GLib 2.0 found disabling OpenSSL"
	echo "  [ $v1   $v2   $v3 ]"
	echo "DEFINE += -DWIPE_OPENSSL -I$v2 -I$v3" >> $makefile
	echo "LIB += -lglib-2.0 -L$v1" >> $makefile
else
	echo "LibC - enabling OpenSSL"
	echo "LIB += -lcrypt" >> $makefile
fi

# oracle
# XXX Should check for oci.h presence.
# Oracle moves oci.h around the world, this
# is include paths for 8i/9i. YMMV.
locate_file "libclntsh.so" && v1=$var
if [ "X$v1" != "X" ]; then
	use_oracle=`echo $CONFIGURE_ARGS | awk " /--no-oracle/ { print $1 } " | wc -l`
	if [ $use_oracle -eq 0 ]; then
		echo "Will have ORACLE support"
		echo "	[ $v1 ]"
		echo "DEFINE += -DUSE_ORACLE -I$ORACLE_HOME/rdbms/demo -I$ORACLE_HOME/rdbms/public" >> $makefile
		echo "LIB += -L$v1 -R$v1 -lclntsh" >> $makefile
		echo "( if you are building MySQL or PostgreSQL version on the "
		echo "	same computer where Oracle is installed, clean and "
		echo "	invoke this with \"CONFIGURE_ARGS=--no-oracle\" option ) "
	fi
fi

#service billing
if [ -f src/billing.c -o -f src/billing.o ]; then
	echo "Will have BILLING service"
	echo "DEFINE += -DHAVE_BILLING" >> $makefile
	echo "SRC += billing.c s_billing.c" >> $makefile
	echo "HEADERFILES += billing.h" >> $makefile
fi

#debug (on by default)
if [ ! "x$1" = "x-nodebug" ]; then
	echo "Will have DEBUG flag set"
	echo "DEFINE += -DDEBUG" >> $makefile
	echo "FLAGS += -g -Wall" >> $makefile
fi

#memory debug (off by default)
if [ "x$1" = "x-memory" ]; then
	echo "Will have MEMORY DEBUGGING"
	echo "DEFINE += -DMEMORY_DEBUG" >> $makefile
fi

#radius
locate_file "openssl/md5.h" && v1=$var
if [ "X$v1" != "X" ]; then
	echo "Will have RADIUS support"
	echo "DEFINE += -DUSE_LIBRADIUS" >> $makefile
	echo "NLIB += libradius" >> $makefile
	echo "LIB += -lradius" >> $makefile
else
	echo "No RADIUS support - install \"openssl-devel\" (md5.h)"
fi

#PAM
locate_file "security/pam_appl.h" && v1=$var && locate_file "libpam.so" && v2=$var
if [ "X$v1" != "X" -a "X$v2" != "X" ]; then
	echo "Will have PAM support (experimental)"
	echo "DEFINE += -DHAVE_PAM" >> $makefile
	echo "LIB += -lpam -L$v2" >> $makefile
	echo "PROG += pam_netams.so"	>> $makefile
fi

echo "## Configuration file was built.			      ##"
echo "##########################################################"
}

#check if file exist
if [ -s $makefile ] ; then exit; fi

##########################################################
echo "##########################################################"
echo "## Configuring NeTAMS for build targets...	      ##"

#header
rm -f $makefile
echo "#/*************************************************************************"	>  $makefile
echo "#***	Authentication, authorization, accounting + firewalling package"	>> $makefile
echo "#***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>"			>> $makefile
echo "#***	Copyright 2002-2008 NeTAMS Development Team"					>> $makefile
echo "#***	This code is GPL v3"	>> $makefile
echo "#***	For latest version and more info, visit this project web page"		>> $makefile
echo "#***	located at http://www.netams.com"					>> $makefile
echo "#***							"			>> $makefile
echo "#*************************************************************************/"	>> $makefile
echo "# This is automatically generated Makefile for NeTAMS"				>> $makefile
echo "# Created `date`"									>> $makefile
echo											>> $makefile

echo "PROG += netamsctl ascii2netflow"		>> $makefile
echo "CONFIG_FILE_NAME = netams.conf" >>$makefile

system=`uname`
if [ $system = "FreeBSD" ]; then
        prepare_for_freebsd
fi
if [ $system = "Darwin" ]; then
	prepare_for_macos
fi
if [ $system = "OpenBSD" ]; then
	prepare_for_openbsd
fi
if [ $system = "NetBSD" ]; then
	prepare_for_netbsd
fi
if [ $system = "Linux" ]; then
	prepare_for_linux
fi
if [ $system = "Solaris" -o $system = "SunOS" ]; then
	prepare_for_solaris
fi

echo "#Optional params - uncomment if needed"	>> $makefile
echo -n "Optional features: "
echo -n "Use_cli_enable " && echo "#DEFINE += -DUSE_CLI_ENABLE" >> $makefile
echo -n "BW_limit " && echo "DEFINE += -DHAVE_BW"				>> $makefile
#echo -n "Memory_debug " && echo "DEFINE += -DMEMORY_DEBUG"		>> $makefile
#echo -n "Mutex_debug " && echo "DEFINE += -DMUTEX_DEBUG"		>> $makefile
#echo -n "Timer_ticks " && echo "DEFINE += -DUSE_TICKS"			>> $makefile
echo -n "Fast_FW_checks " && echo "DEFINE += -DFAST_FW_CHECK"	>> $makefile
echo -n "Layer7_filter " && echo "DEFINE += -DLAYER7_FILTER"	>> $makefile
echo -n "Hash_database " && echo "#DEFINE += -DUSE_HASH"		>> $makefile

echo " "

add_common $1 $2

