#!/usr/bin/perl -w
#
# $Id: monitor.cgi,v 1.9 2008-01-02 13:29:36 anton Exp $
# Contributed to NeTAMS project by A.Rudenko aka RAV (2006/09/14)
#
use DBI;
use CGI;
use Socket;
require "config.cgi";
require "russian.res";

$version="3.4";			# 3.4  3.3
$connect_netams="yes";		#        tmp-
$file="/tmp/monitor.data";	# tmp-       (   ) .
$default_oid_group="yes";	#    (   OID-unit)
$default_unit_ip="dst";		#   IP unita (src,dst,both) 
$default_period="hour";		#   -   
$default_detail="yes";		#    
$default_topN="10";		#    
$default_debug="on";		# (on off)     

$url="monitor.cgi";
@s_oid=();			#  UNIT OID Net,Host,User,Cluster, .   
@s_oid_group=();		#  UNIT OID Group, .   
@s_conf_ip=();			#  UNIT  IP, .    
@s_ip=();			#  IP-, .   
@s_port=();			#  , .   
@s_proto=();			#  , .   
@s_conf_all=();			#   UNIT
#@netams_config();		#   "unit host name ...."  NeTAMS (  ),    tmp- @netams_config=('','',''...);

$cgi = new CGI;
print $cgi->header(-type=>'text/html',-expires=>'now', -charset=>'windows-1251');
my $action=$cgi->param("action");
$access=CheckAccess_m("MONITOR");
if($access<1 or ($access<2  and $action ne "")) {print "<html><font color=red><b>$L_access_noaccess<b></font></html>";exit;}
$netams=$cgi->param("netams");
$netams=$connect_netams if $netams eq "";

if ($netams eq "yes" and $action !~ "Report" and $action ne "Help") {
    require "netams.cgi";
}else{
    $p1="<html><head><title> NeTAMS Admintool Monitor </title></head><form name=admintool action=$url method=post>";
}

open(F,"< $file") || `echo 1 > $file`;
close(F);
require $file;

my(@ip_s,@oid_s,$t_from,$t_to,$i,$period,$period_from,$period_to,$ip,$oid,$oid_string,$src,$src_string,$dst,$dst_string,$proto,$proto_string,$sport,$sport_string,$dport,$dport_string,$layer7);
$sum_pak=$sum_rec=$sum_len=$sum_len7=0;$where=$param=$debug=$oid=$ip="";$help="yes";

    $period_from=$cgi->param("period_from");
    $period_to=$cgi->param("period_to");
    $period = $cgi->param("period");

if ( $action eq "" or $action eq "Clear string" ) {					#  
    {$det="rep12";$det7="rep71";$det_line=$default_topN;$ip_src_dst=$default_unit_ip;}
    $debug_b=$default_debug eq "on"?"on":"";
    $roid=($default_oid_group eq "yes")?"group":"unit";
    $det_more=($default_detail eq "yes")?1:0;
    $period=$default_period if $action eq "";
    @s_conf_ip=parse_config($netams) if scalar(@s_conf_ip)==0;
    $action=$L_monitor_roid if scalar(@s_oid)+scalar(@s_oid_group)==0;
}else {
    if ($action !~ "Report" and $action ne "Form" ) {					#    
	$help="yes" if $cgi->param("net") eq "off";
	$debug_b=$cgi->param("debug");
	$rip=$cgi->param("rip");
	if ($rip eq "No") {$rip=0;} elsif ($rip eq "Yes") {$rip=1;} else {$rip=2;}
	$rproto=$cgi->param("rproto");
	if ($rproto eq "No") {$rproto=0;} elsif ($rproto eq "Yes") {$rproto=1;} else {$rproto=2;}
	$rport=$cgi->param("rport");
	if ($rport eq "Name_All"){$rport=-1;} elsif ($rport eq "No") {$rport=0;} elsif ($rport eq "Yes") {$rport=-2} else {$rport=~tr/0-9//cd;};
    }
    $roid=$cgi->param("roid");
    $ip_src_dst=$cgi->param("ipsrcdst");
    $ip_unit=$cgi->param("ip_unit");
    $oid_string=$cgi->param("oid_string");
    if ($oid_string ne "") {$oid_string=~s/^,+(\S+)/$1/;$oid_string=~tr/0-9A-Za-z\,\!//cd;}
    $src_string=$cgi->param("src_string");
    if ($src_string ne "") {$src_string=~s/^,+(\S+)/$1/;$src_string=~tr/0-9\,\!\.\/\\//cd;}
    $dst_string=$cgi->param("dst_string");
    if ($dst_string ne "") {$dst_string=~s/^,+(\S+)/$1/;$dst_string=~tr/0-9\,\!\.\/\\//cd;}
    $proto_string=$cgi->param("proto_string");
    if ($proto_string ne "") {$proto_string=~s/^,+(\S+)/$1/;$proto_string=~tr/0-9\,\!\<\>//cd;}
    $sport_string=$cgi->param("sport_string");
    if ($sport_string ne "") {$sport_string=~s/^,+(\S+)/$1/;$sport_string=~tr/0-9\,\!\<\>//cd;}
    $dport_string=$cgi->param("dport_string");
    if ($dport_string ne "") {$dport_string=~s/^,+(\S+)/$1/;$dport_string=~tr/0-9\,\!\<\>//cd;}
    $det7=$cgi->param("det7");
    $det=$cgi->param("det");
    $det_line=$cgi->param("det_line");
    $det_more=$cgi->param("det_more");
    if ($ip_unit ne "") {$ip_unit=~s/^,+(\S+)/$1/;$ip_unit=~tr/sdb0-9\.\,\/\\//cd;}
    if ($action ne "Form") {
    @ip_s=$cgi->param("ip");
	for $i (@ip_s) {
	    $i=(split(/ip=/,$i))[1];
	    $i=(split(/\s+/,$i))[0];
	    next if $i eq "";
	    if (index($i,",")>=0) {
		@v=split(/,/,$i);
		for $i (@v) {
		    next if $i eq "";
		    $ip.=",";
		    if ($ip_src_dst eq "src") {$ip.="s".$i;}elsif($ip_src_dst eq "dst") {$ip.="d".$i;}else{$ip.="b".$i;}
		}
		next;
	    }
	    $ip.=",";
	    if ($ip_src_dst eq "src") {$ip.="s".$i;}elsif($ip_src_dst eq "dst") {$ip.="d".$i;}else{$ip.="b".$i;}
	}
    @oid_s=$cgi->param("oid");
	for $str (@oid_s) {
	    next if $str eq "" or $str eq "All";
	    if ($str =~ "All Groups" and $roid eq "group") {
		for ($i=scalar(@s_oid_group)-1;$i>=0;$i--) {
		    $str=(split(/oid=/,$s_oid_group[$i]))[1];
		    $str=(split(/\s+/,$str))[0];
		    $oid.=$str."," if $str ne "";
		}
		next;
	    }elsif ($str =~ "All Units" and $roid eq "unit"){
		for ($i=scalar(@s_oid_group)-1;$i>=0;$i--) {
		    $str=(split(/oid=/,$s_oid_group[$i]))[1];
		    $str=(split(/\s+/,$str))[0];
		    $oid.="!".$str."," if $str ne "";
		}
		next;
	    }
	    $str=(split(/oid=/,$str))[1];
	    $str=(split(/\s+/,$str))[0];
	    $oid.=$str."," if $str ne "";
	}
    $oid=~tr/0-9A-Za-z\,\!//cd;
	$oid.=$oid_string;
	$ip.=",".$ip_unit;
    $src=$cgi->param("src");
    if ($src ne "") {$src=(split(/ /,$src))[0];$src=~tr/0-9\!\.//cd;}
    $dst=$cgi->param("dst");
    if ($dst ne "") {$dst=(split(/ /,$dst))[0];$dst=~tr/0-9\!\.//cd;}
    $proto=$cgi->param("proto");
    if ($proto ne "") {$proto=(split(/ /,$proto))[0];$proto=~tr/0-9//cd;}
    $sport=$cgi->param("sport");
    if ($sport ne "") {$sport=(split(/ /,$sport))[0];$sport=~tr/0-9//cd;}
    $dport=$cgi->param("dport");
    if ($dport ne "") {$dport=(split(/ /,$dport))[0];$dport=~tr/0-9//cd;}
    }else{
	{$det7="rep71";$ip_src_dst=$default_unit_ip;$debug_b=$default_debug eq "on"?"on":"";$roid=($default_oid_group eq "yes")?"group":"unit";}
	$period_from=~s/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/$1-$2-$3_$4:$5:$6/;
	$period_to=~s/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/$1-$2-$3_$4:$5:$6/;
	@v=split(/\,/,$ip_unit);
	for $str (@v) {
	    if ($str=~"s"){$src_string.=",".substr($str,1);}elsif($str=~"d"){$dst_string.=",".substr($str,1);}else{$str=~tr/0-9.\/\\//cd;$src_string.=",".$str;$dst_string.="'".$str;}
	}
	if ($cgi->param("rep_swap")==1) {
	    {$str=$src_string; $src_string=$dst_string; $dst_string=$str; $str=$sport_string; $sport_string=$dport_string; $dport_string=$str;}
	}
    }	
    $layer7=$cgi->param("layer7");
    if ($layer7 ne "") {$layer7=~tr/A-Za-z0-9_\-\.\,\!\/\\://cd;}
    $layer7_and=$cgi->param("layer7_and");
    if ($layer7_and ne "") {$layer7_and=~tr/A-Za-z0-9_\-\.\,\!\/\\://cd;}
}
if  ( $period ne "exact" or $period_from eq "" ) {
    ($d,$m,$y,$h,$mi)=split(/\./,`date +%d.%m.%G.%H.%M`);
    if ($period eq "month") {$period_from=$y."-".$m."-01_00:00";}
    elsif ($period eq "day") {$period_from=$y."-".$m."-".$d."_00:00";}
    elsif ($period eq "week") {$period_from=n_week($y,$m,$d)."_00:00";}
    elsif ($period eq "hour") {$period_from=$y."-".$m."-".$d."_".$h.":00";}
    else {$period_from=$y."-".$m."-".$d."_".$h.":".$mi;}
}
{$period_from=~tr/0-9\:\-_//cd;$t_from=$period_from;$t_from=~tr/0-9//cd;$t_from.="00" if $t_from < 1000000000000;}
if ($period_to ne "") {$period_to=~tr/0-9\:\-_//cd;$t_to=$period_to;$t_to=~tr/0-9//cd;$t_to.="00" if $t_to < 1000000000000;}
if ( $action eq $L_monitor_roid ) {
    main_db("Refresh_oid",$t_from,$t_to);
    @s_oid=parse_config($netams,@s_oid) if scalar(@s_oid)>0;
    @s_oid_group=parse_config($netams,@s_oid_group) if scalar(@s_oid_group)>0;
    write_to_file();
}elsif ($action eq $L_monitor_rconfig) {
    @s_conf_ip=parse_config($netams);
    write_to_file();
}elsif ($action eq $L_monitor_rdb) {
    main_db("Refresh_db",$t_from,$t_to,$ip,$oid,$src.",".$src_string,$dst.",".$dst_string,$proto.",".$proto_string,$sport.",".$sport_string,$dport.",".$dport_string,$layer7."@".$layer7_and,$rip,$roid,$rproto,$rport);
    @s_proto=parse_file("/etc/protocols","",@s_proto) if $rproto > 1;
    @s_port=parse_file("/etc/services","/tcp",@s_port) if $rport > 0 or $rport==-1;
    @s_ip=parse_ip($rip,@s_ip) if $rip > 0;
    write_to_file();
}elsif ($action eq $L_monitor_refresh or $action eq "Refresh") {
    main_db("Refresh",$t_from,$t_to,$ip,$oid,$src.",".$src_string,$dst.",".$dst_string,$proto.",".$proto_string,$sport.",".$sport_string,$dport.",".$dport_string,$layer7."@".$layer7_and,"","","","");
}elsif ($action =~ "Report" or $action eq "Help") {
    $query = new CGI;
    print "<html><head><title> NeTAMS Admintool Monitor Report </title></head>";
    if ($action ne "Help" ) {
	if ($action eq "Report_IP"){$p2="Report_IP,".$cgi->param("det");}else{$p2="Report_Layer7,".$cgi->param("det7");}
	print main_db($p2,$t_from,$t_to,$ip,$oid,$src.",".$src_string,$dst.",".$dst_string,$proto.",".$proto_string,$sport.",".$sport_string,$dport.",".$dport_string,$layer7."@".$layer7_and,"","","","");
    }else{print $L_monitor_help;}
    print "</html>";
    exit;
}

($p1,$p2,$p3,$p4)=cgi_text($p1);
    	
if ($netams eq "yes") {$rightdata="$p1 $p2 $p3 $p4"; netams_print();}
else{print $p1.$p2.$p3.$p4; print "</form>";}
exit;

#-------------------------------------------------------
sub main_db {
    my ($action,$t_from,$t_to,$v_unit_ip,$v_unit_oid,$v_src,$v_dst,$v_proto,$v_srcport,$v_dstport,$v_layer7,$v_parse_ip,$v_parse_oid,$v_parse_proto,$v_parse_port)=@_;
    my ($t_ip,$t_proto,$val_ip,$val_port,$group,@v,$where1,$z,$debug1,$o,$a1);
    $param="&period=exact";
    $where=$debug="";
    $group=1;						# 1- GROUP BY  ,  SORT BY
    $val_ip="dst";					#  IP-  src
    $val_port="dstport";				#    srcport
    if ($t_from ne "" and $t_from >0 ){
	$where.=" time >= UNIX_TIMESTAMP('".$t_from."') "; 
	$param.="&period_from=".$t_from;
	$t_from=~s/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/$1-$2-$3 $4:$5:$6/;
	$debug=" TIME >= ".$t_from." ";
    }
    if ($t_to ne "" and $t_to >0 ){
	if ($where ne ""){$where.=" AND ";$debug.=" AND ";}    
	$param.="&period_to=".$t_to;
	$where.="time <= UNIX_TIMESTAMP('".$t_to."') ";
	$t_to=~s/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/$1-$2-$3 $4:$5:$6/;
	$debug.="TIME <= ".$t_to." ";
    }
    if ($v_unit_oid ne "" and $v_unit_oid ne ",") {	#   unit_oid
	$v_unit_oid=~s/(\S+),+$/$1/;
	$param.="&oid_string=".$v_unit_oid;
	@v=split(/\,/,$v_unit_oid);
	$where1=$debug1=" AND (";
	$z=$a1="";
	for $v_unit_oid (@v) { 
	    next if $v_unit_oid eq "";
	    if ($v_unit_oid =~ "!") {$a1.=substr($v_unit_oid,1).","; next}
	    if ($where1 ne " AND (") {$where1.=" OR ";$debug1.=" OR ";}
	    $where1.="unit_oid=".hex($v_unit_oid);
	    $debug1.="unit_oid=".$v_unit_oid;
    	}
	$where.=$where1.") " if $where1 ne " AND (";
	$debug.=$debug1.") " if $where1 ne " AND (";
	@v=split(/\,/,$a1);
	for $v_unit_oid (@v) { 
	    next if $v_unit_oid eq "";
	    $where.=" AND unit_oid!=".hex($v_unit_oid);
	    $debug.=" AND unit_oid!=".$v_unit_oid;
    	}
    }
    if ($v_unit_ip ne "" and $v_unit_ip ne ",") {	#   ip-  (src,dst  both) 
	$param.="&ip_unit=".$v_unit_ip;
	@v=split(/\,/,$v_unit_ip);
	$s=$d=$b="";
	for $str (@v) {
	    if ($str=~"s"){$s.=substr($str,1).",";}elsif($str=~"d"){$d.=substr($str,1).",";}else{$str=~tr/0-9.\/\\//cd;$b.=$str.",";}
	}
	($where1,$debug1)=parse_addr($b,"");
	$where.=$where1;
	$debug.=$debug1;
	($where1,$debug1)=parse_addr($s,"src");
	$where.=$where1;
	$debug.=$debug1;
	($where1,$debug1)=parse_addr($d,"dst");
	$where.=$where1;
	$debug.=$debug1;
	$val_ip="src" if $ip_src_dst eq "dst";
	$val_ip="dst" if $ip_src_dst eq "src";
    }
    if ($v_src ne "" and $v_src ne ",") {		#   ip-src -     a.b.c.d/z !-  - 
	$v_src=~s/(\S+),+$/$1/;
	$param.="&src_string=".$v_src;
	($where1,$debug1)=parse_addr($v_src,"src");
	$where.=$where1;
	$debug.=$debug1;
	$val_ip="dst";
    }
    if ($v_dst ne "" and $v_dst ne ",") {		#   ip-dst -     a.b.c.d/z !-  - 
	$v_dst=~s/(\S+),+$/$1/;
	$param.="&dst_string=".$v_dst;
	($where1,$debug1)=parse_addr($v_dst,"dst");
	$where.=$where1;
	$debug.=$debug1;
	$val_ip="src";
    }
    if ($v_proto ne "" and $v_proto ne ",") {		#    -   ,      ! > <  
	$v_proto=~s/(\S+),+$/$1/;
	$param.="&proto_string=".$v_proto;
	$where1=bmr($v_proto,"proto");
	$where.=$where1;
	$debug.=$where1;
    }
    if ($v_srcport ne "" and $v_srcport ne ",") {	#   src  -   ,      ! > <
	$v_srcport=~s/(\S+),+$/$1/;
	$param.="&sport_string=".$v_srcport;
	$where1=bmr($v_srcport,"srcport");
	$where.=$where1;
	$debug.=$where1;
	$val_port="dstport";
	$group=0;					#    
    }
    if ($v_dstport ne "" and $v_dstport ne ",") {	#   dst  -   ,      ! > <
	$v_dstport=~s/(\S+),+$/$1/;
	$param.="&dport_string=".$v_dstport;
	$where1=bmr($v_dstport,"dstport");
	$where.=$where1;
	$debug.=$where1;
	$val_port="srcport";
	$group=0;					#    
    }
    if ($v_layer7 ne "") {				#      layer7 -   ,  !
	($o,$a1)=split(/\@/,$v_layer7);
	$param.="&layer7=".$o if $o ne "";
	$param.="&layer7_and=".$a1 if $a1 ne "";
	@v=split(/\,/,$o);
	$where1=" AND (";
	for $v_layer7 (@v) {
	    $where1.=" OR " if $where1 ne " AND (";
	    $where1.=" INSTR(layer7,'$v_layer7') > 0";
    	}
    	if ($where1 ne " AND (") {$where.=$where1.") ";$debug.=$where1.") ";}
	$where1="";
	@v=split(/\,/,$a1);
	for $v_layer7 (@v) {if ($v_layer7 =~ "!") {$z="=";$v_layer7=substr($v_layer7,1);}else{$z=">";}
	    $where1.=" AND INSTR(layer7,'$v_layer7') ".$z." 0";
    	}
	$where.=$where1;
	$debug.=$where1;
    }
    $db = DBI->connect("DBI:$sql_type:database=".$sql_dbname.";host=".$sql_host, $sql_login, $sql_password);
    if($db eq "") { die "Error database connecting."; }

###### 	monitoring enabled??
	$r = $db->prepare("SELECT count(1) FROM monitor;");
	$r->execute();
	$retcode=$db->err;
	if ($retcode != 0) {
		$p1 .= "<b>$L_monitor_isenabled</b><br><br>";
		return;
	}
######

	if ($action eq "Refresh" or $action eq "Refresh_db") {
	$v_parse_proto=0 if $v_parse_proto eq "";
	$v_parse_port=0 if $v_parse_port eq "";
	$v_parse_oid="unit" if $v_parse_oid eq "";
	$v_parse_ip=0 if $v_parse_ip eq "";
	$group=0 if $v_parse_proto > 0;			#     
	$group=0 if $v_parse_port > 0;			#     
        $sum_pak=$sum_len=$sum_len7=$t_ip=0;
	$t_proto=-1;
	@s_ip=@s_port=@s_proto=() if $action eq "Refresh_db";
	
	if ($group==1) {
	    $r = $db->prepare("SELECT 
		".$val_ip.",sum(dpkts),sum(len),sum(STRCMP(layer7,'')),COUNT(*) 
		FROM monitor where ".$where." group by 1 ;");
	    $r->execute() or die;
	    while ( ($ip,$dpkts,$len,$len7,$count) = $r->fetchrow_array) {
		push(@s_ip,$ip) if ($v_parse_ip);
		{$sum_pak+=$dpkts;$sum_len+=$len;$sum_len7+=$len7;$sum_rec+=$count;}
	    }
	}else{
	    $r = $db->prepare("SELECT 
		".$val_ip.",".$val_port.",proto,dpkts,len,STRCMP(layer7,''),1 
		FROM monitor where ".$where." order by 1,2;");
	    $r->execute() or die;
	    while ( ($ip,$port,$proto,$dpkts,$len,$len7,$count) = $r->fetchrow_array) {
		if ($v_parse_ip and $ip != $t_ip) {push(@s_ip,$ip); $t_ip=$ip;}
		if ($v_parse_proto and $t_proto!=$proto){@s_proto=unic($proto,@s_proto);$t_proto=$proto;}
		@s_port=unic($port,@s_port) if $v_parse_port and $port <= $v_parse_port;
		{$sum_pak+=$dpkts;$sum_len+=$len;$sum_len7+=$len7;$sum_rec+=$count;}
	    }
	    @s_proto=sort {$a <=> $b} @s_proto;
	    @s_port=sort {$a <=> $b} @s_port;
	}
	if ($v_parse_port < 0) {		#   ....
	    $r = $db->prepare("SELECT DISTINCT ".$val_port." FROM monitor WHERE ".$where." order by 1;");
	    $r->execute() or die;
	    while (($port)=$r->fetchrow_array) {
    		push(@s_port,$port);
	    }
	}
    }elsif ($action eq "Refresh_oid") {		#    
	$group="";
	@s_oid_group=@s_oid=();
	@v=grep(/type=group/,@s_conf_all);
	for $str (@v) {
	    $str=(split(/oid=/,$str))[1];
	    $str=(split(/ /,$str))[0];
	    $group.=hex($str).",";
	}
	$r = $db->prepare("SELECT DISTINCT
	    unit_oid 
	    FROM monitor where ".$where." order by 1;");
	$r->execute() or die;
	while ( ($unit_oid) = $r->fetchrow_array) {
    	    if (index($group,$unit_oid)>=0) {push(@s_oid_group,$unit_oid);}else{push(@s_oid,$unit_oid);}
	}
    }else{
	return reports($action.",".$cgi->param("det_name").",".$det_line.",".$det_more.",".$cgi->param("rep_swap").",".$cgi->param("pfilter"),$where,$debug,$param);
    }
}

#-------------------------------------------------------
sub reports {
    my ($action,$where,$debug,$param)=@_;
    my ($group,$val_ip,$z,$det_name,$det_str,$ns,$report,$param1,$param2);
    ($action,$group,$det_name,$det_str,$det_more,$rep_swap,$pfilter)=split(/\,/,$action);
    $det_name=0 if $det_name ne "1";
    $det_str=0 if $det_str eq "";
    $det_more=0 if $det_more ne "1";
    $rep_swap=0 if $rep_swap ne "1";
    $pfilter=0 if $pfilter ne "1";
    $param.="&det_line=".$det_str if $det_str > 0;    
    $param.="&det_more=1" if $det_more > 0;    
    $param2=$param;	
    $param.="&det_name=1" if $det_name > 0;
    $param="&action=".$action.$param;
    $param1=$param;	
    $param.="&det".(($action eq "Report_Layer7")?"7":"")."=".$group;
    $param2.="&det".(($action eq "Report_Layer7")?"7":"")."=".$group;
    $ns=0;
    $z=" < <A HREF=$url?$param".($rep_swap?"&rep_swap=1":"").">$L_monitor_permanentref</A> > ";
    $z.=" < <A HREF=$url?$param&det_name=1>$L_monitor_det_name </A> > " if ($group =~ "rep1" or $group =~ "rep2");
    $z.=" < <A HREF=$url?action=Form$param2&rep_swap=$rep_swap>$L_monitor_permanentform</A> >" if $group !~ "rep7";
    $z.=" < <A HREF=$url?action=> $url </A> > <br>";
    if ($action eq "Report_IP") {
	if ($rep_swap==0) {
	    $z.=" < <A HREF=$url?$param&rep_swap=1>$L_monitor_permanentswap</A> > ";
	    $z.=" < <A HREF=$url?$param1&det=".substr($group,0,4).(substr($group,4) eq "1"?"2":"1").">$L_monitor_permanentgrp</A> > " if $group !~ "rep3";
	    $z.="<br>$L_monitor_report ".$debug;
	}else{
	    $z.=" < <A HREF=$url?$param>$L_monitor_permanentswap</A> > ";
	    $z.=" < <A HREF=$url?$param1&rep_swap=1&det=".substr($group,0,4).(substr($group,4) eq "1"?"2":"1").">$L_monitor_permanentgrp</A> > " if $group !~ "rep3";
	    $param.="&rep_swap=1";
	    {$where=~s/src/SRC/g;$where=~s/dst/src/g;$where=~s/SRC/dst/g;$debug=~s/src/SRC/g;$debug=~s/dst/src/g;$debug=~s/SRC/dst/g;}
	    $z.="<br>$L_monitor_det_line4: ".$debug;
	}
    }	
    $z.="<br>".$L_monitor_det_line2.$det_str.$L_monitor_det_line3."<br>" if $det_str > 0;
    if ($action eq "Report_Layer7") {
	if ($group eq "rep70") {
	    if ( $det_more==1 ) {
		@v=split(/&/,$param);
		$param="";
		for $str (@v) {
		    next if $str eq "";
		    if ($str =~ "ip_unit=") { $filter_ip="&".$str; next; }
		    if ($str =~ "det7=") { next; }
		    if ($str =~ "action=") { next; }
		    $param.="&".$str;
		}
		$filter_ip="&ip_unit=" if $filter_ip eq ""; 
	    }    
    	    my (%dst_urls,%count_urls,@str,@data,$st,$s,$where1,$s_dst,$j,$all);
	    if ( $det_str>0 ) {
    		$r = $db->prepare("SELECT 
		    COUNT(*),SUBSTRING_INDEX(layer7,'/',1)
		    FROM monitor where ".$where." AND 
		    layer7 REGEXP '^[a-z0-9-]+[.]*[a-z0-9-]+[.]...*' group by 2 order by 1 desc;");
		$r->execute() or die;							# order by Count if TopN
		$ns=$all=0;$st=",";
		while ( ($count,$layer7) = $r->fetchrow_array) {
		    next if $layer7 eq "";
		    $all += $count;
		    $ns++;
		    next if $ns > $det_str;
		    $st.=$layer7.",";
		    $count_urls{$layer7}=$count;
		}
	    }
    	    $r = $db->prepare("SELECT 
		COUNT(*),SUBSTRING_INDEX(layer7,'/',1),dst 
		FROM monitor where ".$where." AND 
		layer7 REGEXP '^[a-z0-9-]+[.]*[a-z0-9-]+[.]...*' group by 2,3;");
	    $r->execute() or die;							# group by urls and dst, no order
	    while ( ($count,$layer7,$dst) = $r->fetchrow_array) {
		next if $layer7 eq "";
		if ($det_str>0) {
		    next if index($st,",".$layer7.",") < 0;				# not necessary urls
		}else{
		    $count_urls{$layer7}+=$count;
		}
		$dst_urls{$layer7}{$dst}=$count;
	    }
	    $s=index($where,"layer7");
	    if ( $s > 0 ) {$s=rindex(substr($where,0,$s)," AND ");$where=substr($where,0,$s);}
	    $where1=$where;$where1=~s/src/SRC/g;$where1=~s/dst/src/g;$where1=~s/SRC/dst/g;
	    @str=sort {$count_urls{$b} <=> $count_urls{$a}} keys(%count_urls);
    	    $z.="<br><b>$L_monitor_ds_urls_dst</b><br>";
	    $z.="<table width=100% cellpadding=2 cellspacing=2 border=2>";
	    $z.="<tr><td><b>Count</b></td><td><b>URLs</b></td><td><b>Dst in Layer7 flow".($det_more?" (more)":"")."</b></td><td><b>Count for dst</b></td><td><b>In Bytes</b></td><td><b>Out Bytes</b></td></tr>";
	    $len_all_out=$count_all=$len_all_in=0;
	    $s_dst="";
	    for $s (@str) {
		$ns=0;									# the first line urls
		@data=sort {$dst_urls{$s}{$b} <=> $dst_urls{$s}{$a}} keys(%{$dst_urls{$s}});
		for $st (@data) {
		    $len_in=$len_out=0;
		    if (index($s_dst,$st)<0 and $det_more) {				# not exists dst, we consider the in-out ( skip if ! det_more )
    			$r = $db->prepare("SELECT dst,sum(len) FROM monitor where ".$where." AND dst=$st group by 1;");
			$r->execute() or die;
			($dst,$len_out) = $r->fetchrow_array;
    			$r = $db->prepare("SELECT src,sum(len) FROM monitor where ".$where1." AND src=$st group by 1;");
			$r->execute() or die;
			($dst,$len_in) = $r->fetchrow_array;
			$len_all_in+=$len_in;
			$len_all_out+=$len_out;
			$s_dst.=$st.",";
			$j=1;
		    }else{								# already considered
		    	$j=0;
		    }	
		    $z.="<tr><td>".kmg_p($count_urls{$s})."</td><td><A HREF='http://$s'>$s</A></td>" if !$ns;
		    $z.="<tr><td>                          </td><td>                          </td>" if  $ns; 
		    $z.="<td>";
		    $z.="<A HREF=$url?action=Report_IP$param$filter_ip,d".dec2ip($st)."&det=rep12>" if $det_more;
		    $z.=dec2ip($st);
		    $z.="</A> " if $det_more;
		    $z.=host_name(dec2ip($st)) if ($det_name);
		    $z.=($j?"":($det_more?" Already exists!!!":" Skip count Bytes"))."</td><td>".kmg_p($dst_urls{$s}{$st})."</td><td>".($j?kmg($len_in,2):"-")."</td><td>".($j?kmg($len_out,2):"-")."</td></tr>";
		    $ns=1;
		}
		$count_all+=$count_urls{$s};
	    }
	    $z.="<tr><td><b>Sum: ".kmg_p($count_all);
	    $z.=" ( ".int($count_all*100/$all)."% ) " if $det_str > 0 and $all > 0;
	    $z.="</b></td><td></td><td></td><td></td><td><b>".kmg($len_all_in,2)."</b></td><td><b>".kmg($len_all_out,2)."</b></td></tr>";
	} elsif ($group eq "rep71") {
    	    $r = $db->prepare("SELECT 
		COUNT(*),SUBSTRING_INDEX(layer7,'/',1) 
		FROM monitor where ".$where." AND 
		layer7 REGEXP '^[a-z0-9-]+[.]*[a-z0-9-]+[.]...*' group by 2 order by 1 desc;");
	    $r->execute() or die;
    	    $z.="<br><b>$L_monitor_ds_urls</b><br>";
	    $z.="<table width=100% cellpadding=2 cellspacing=2 border=2>";
	    $z.="<tr><b><td><b>Count</b></td><td><b>URLs</b></td></tr>";
    	    $sum_count=$all=0;
	    while ( ($count,$layer7) = $r->fetchrow_array) {
		next if $layer7 eq "";
		++$ns;
		$all += $count;
		next if $det_str>0 and $ns>$det_str;
		$sum_count+=$count;
		$z.="<tr><td>$count</td><td><A HREF='http://$layer7'>$layer7</A></td></tr>";
	    }
	    $z.="<tr><td><b>Counts=".kmg_p($sum_count);
	    $z.=" ( ".int($sum_count*100/$all)."% ) " if $det_str > 0 and $all > 0;
	    $z.="</b></td><td></td></tr></table>";
	} elsif ($group eq "rep72" or $group eq "rep73") {
	    $val_ip="unit_oid" if $group eq "rep73";
	    $val_ip="src" if $group eq "rep72";
    	    $r = $db->prepare("SELECT 
		".$val_ip.",COUNT(*),SUBSTRING_INDEX(layer7,'/',1) 
		FROM monitor where ".$where." AND 
		layer7 REGEXP '^[a-z0-9-]+[.]*[a-z0-9-]+[.]...*' group by 1,3 order by 1,2 desc;");
	    $r->execute() or die;
    	    $z.="<br><b>$L_monitor_ds_ip</b><br>" if $group eq "rep72";
    	    $z.="<br><b>$L_monitor_ds_oid</b><br>" if $group eq "rep73";
	    $z.="<table width=100% cellpadding=2 cellspacing=2 border=2>";
	    $z.="<tr><td><b>Source</b></td><td><b>Count</b></td><td><b>URLs</b></td></tr>";
	    $count_all=$sum_pak=$sum_count=$src_ip=$all=0;
	    while ( ($src,$count,$layer7) = $r->fetchrow_array) {
		next if $layer7 eq "";
		if ($src_ip!=$src) {
		    $z.="<tr><td align=right><b>Sum:</b></td><td>$sum_count</td><td></td></tr>" if $src_ip>0;
		    $z.="<tr><td>";
		    $z.=name_rep(dec2ip($src),"ip") if $val_ip eq "src";
		    $z.=name_rep(sprintf("%6.6X",$src),"oid") if $val_ip eq "unit_oid";
		    $z.="</td><td>$count</td><td><A HREF='http://$layer7'>$layer7</A></td></tr>";
		    $src_ip=$src;
		    $count_all+=$sum_count;
		    $all+=$sum_count=$count;
		    $ns=1;
		}else{
		    ++$ns; $all+=$count;
		    next if $det_str>0 and $ns>$det_str;
		    $z.="<tr><td></td><td>$count</td><td><A HREF='http://$layer7'>$layer7</A></td></tr>";
		    $sum_count+=$count;
		}
	    }
	    $count_all+=$sum_count;
	    $z.="<tr><td align=right><b>Sum:</b></td><td>$sum_count</td><td></td></tr>" if $src_ip>0;
	    $z.="<tr><td align=right><b>All<b></td><td><b>Count=".kmg_p($count_all);
	    $z.=" ( ".int($count_all*100/$all)."% ) " if $det_str > 0 and $all > 0;
	    $z.="</b></td><td></td></table>";
	}
    }elsif ($action eq "Report_IP") {
	if ( $det_more==1 ) {
	    @v=split(/&/,$param);
	    $param="";
	    for $str (@v) {
		next if $str eq "";
		if ($str =~ "ip_unit=") { $filter_ip="&".$str; next; }
		if ($str =~ "det=") { $filter_det="&".$str; next; }
		if ( $group =~ "rep2") {
		    if ($str =~ "proto_string=") { $filter_proto="&".$str; next; }
		    if ($str =~ "sport_string=") { $filter_sp="&".$str; next; }
		    if ($str =~ "dport_string=") { $filter_dp="&".$str; next; }
		}
		$param.="&".$str;
	    }
	    $filter_ip="&ip_unit=" if $filter_ip eq ""; 
	    $filter_det="&det=" if $filter_det eq ""; 
	    if ( $group =~ "rep2") {
		$filter_proto="&proto_string=" if $filter_proto eq ""; 
		$filter_sp="&sport_string=" if $filter_sp eq ""; 
		$filter_dp="&dport_string=" if $filter_dp eq ""; 
	    }
	    $rep_next="&det=rep".(substr($group,3)+10);
	    $rep_next="&det=rep31" if $rep_next eq "&det=rep32";
	}    
	if ($group =~ "rep1") {
	    $val_ip=$rep_swap?"dst,src":"src,dst" if $group eq "rep11";
	    $val_ip=$rep_swap?"src,dst":"dst,src" if $group eq "rep12";
	    $sd=$val_ip eq "src,dst"?1:0;
	    $sd=!$sd if $rep_swap==1;
    	    $r = $db->prepare("SELECT 
		".$val_ip.",sum(dpkts),sum(len) 
		FROM monitor where ".$where." group by 1,2 ".($det_str>0?"order by 4 desc;":";"));
	    $r->execute() or die;
	    $z.="<table width=100% cellpadding=1 cellspacing=1 border=1>";
	    if ( $val_ip eq "src,dst" ) {$z.="<tr><td><b>Source</b></td><td><b>Destination</b></td><td><b>Packets</b></td><td><b>Bytes</b></td></tr>";}
	    else {$z.="<tr><td><b>Destination</b></td><td><b>Source</b></td><td><b>Packets</b></td><td><b>Bytes</b></td></tr>";}
	    $len_all=$count_all=$len_src=$count_src=$src_ip=0;
	    while ( ($src,$dst,$count,$len) = $r->fetchrow_array) {
		if ($src_ip!=$src) {
		    $z.="<tr><td><td align=right>Sum:</td><td>$count_src</td><td>".kmg($len_src,2)."</td></tr>" if $src_ip>0;
		    $ip=dec2ip($src);
		    $z.="<tr><td>";
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ip).$filter_det.">filter</A> ";
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ip).$rep_next.">more</A> ";
		    }
		    $z.=$ip;
		    $z.=host_name($ip) if $det_name;
		    $z.="</td><td>";
		    $ip=dec2ip($dst);
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ip).$filter_det.">filter</A>";
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ip).$rep_next.">more</A> ";
		    }
		    $z.=$ip;
		    $z.=host_name($ip) if $det_name;
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td><td>";
		    $src_ip=$src;
		    $count_all+=$count_src;
		    $len_all+=$len_src;
		    $len_src=$count_src=$dst_ip=0;
    		    $proto_n=-1;
		}else{
		    $ip=dec2ip($dst);
		    $z.="<tr><td></td><td>";
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ip).$filter_det.">filter</A>";
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ip).$rep_next.">more</A> ";
		    }
		    $z.=$ip;
		    $z.=host_name($ip) if $det_name;
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td></tr>";
		}
		$count_src+=$count;
		$len_src+=$len;
		++$ns;
		last if $det_str>0 and $ns>=$det_str;
	    }
	    $count_all+=$count_src;
	    $len_all+=$len_src;
	    $z.="<tr><td></td><td align=right>Sum:</td><td>$count_src</td><td>".kmg($len_src,2)."</td></tr>" if $src_ip>0;
	    $z.="<td></td><td align=right><b>All</b></td><td><b>Packets=".kmg_p($count_all)."</b></td><td><b>Bytes=".kmg($len_all,2)."</b></td><tr></table>";
	}elsif ($group =~ "rep2") {
	    $val_ip=$rep_swap?"dst,src,proto,srcport":"src,dst,proto,dstport" if $group eq "rep21";
	    $val_ip=$rep_swap?"src,dst,proto,dstport":"dst,src,proto,srcport" if $group eq "rep22";
	    $sd=$val_ip eq "src,dst,proto,dstport"?1:0;
	    $sd=!$sd if $rep_swap==1;
    	    $r = $db->prepare("SELECT 
		".$val_ip.",sum(dpkts),sum(len) 
		FROM monitor where ".$where." group by 1,2,3,4 ".($det_str>0?"order by 6 desc;":";"));
	    $r->execute() or die;
	    $z.="<table width=100% cellpadding=1 cellspacing=1 border=1>";
	    if ($val_ip eq "src,dst,proto,dstport"){$z.="<tr><td><b>Source</b></td><td><b>Destination</b></td><td><b>Proto</b>".($det_more?" (filter)":"")."</td><td><b>DST_Port</b>".($det_more?($pfilter?" (more)":" (filter)"):"")."</td><td><b>Packets</b></td><td><b>Bytes</b></td></tr>";}
	    else {$z.="<tr><td><b>Destination</b></td><td><b>Source</b></td><td><b>Proto</b>".($det_more?" (filter)":"")."</td><td><b>SRC_Port</b>".($det_more?($pfilter?" (more)":" (filter)"):"")."</td><td><b>Packets</b></td><td><b>Bytes</b></td></tr>";}
	    $len_all=$count_all=$len_src=$count_src=$src_ip=$dst_ip=0;
	    $proto_n=-1;
	    while ( ($src,$dst,$proto,$port,$count,$len) = $r->fetchrow_array) {
		if ($src_ip!=$src) {
		    $z.="<tr><td></td><td></td><td><td align=right>Sum:</td><td>$count_src</td><td>".kmg($len_src,2)."</td></tr>" if $src_ip>0;
		    $z.="<tr><td>";
		    $ips=dec2ip($src);
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).$filter_proto.$filter_sp.$filter_dp.$filter_det.">filter</A>";
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).$filter_proto.$filter_sp.$filter_dp.$rep_next.">more</A> ";
		    }
		    $z.=$ips;
		    $z.=host_name($ips) if $det_name;
		    $z.="</td><td>";
		    $ipd=dec2ip($dst);
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ipd).$filter_proto.$filter_sp.$filter_dp.$filter_det.">filter</A>";
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ipd).$filter_proto.$filter_sp.$filter_dp.$rep_next.">more</A> ";
		    }
		    $z.=$ipd;
		    $z.=host_name($ipd) if $det_name;
		    $z.="</td><td>";
		    if ($det_more) {
			$z.=" <A HREF=$url?$param$filter_ip".filter($filter_proto,$proto).$filter_sp.$filter_dp.$filter_det.">";
		    }
		    $z.=$proto;
		    $z.="</A> " if $det_more;
		    $z.="</td><td>";
		    if ($det_more) {if ($pfilter) {
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).filter($filter_ip,($sd?"d":"s").$ipd,1).filter($filter_proto,$proto).filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$rep_next.">";
		    }else{
			$z.=" <A HREF=$url?$param$filter_ip$filter_proto".filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$filter_det."&pfilter=1>";}
		    }
		    $z.=$port;
		    $z.="</A> " if $det_more;
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td><td>";
		    $src_ip=$src;
		    $count_all+=$count_src;
		    $len_all+=$len_src;
		    $len_src=$count_src=$dst_ip=0;
    		    $proto_n=-1;
		}elsif ($dst==$dst_ip and $proto==$proto_n){
		    $z.="<tr><td></td><td></td><td></td><td>";
		    if ($det_more) {if ($pfilter) {
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).filter($filter_ip,($sd?"d":"s").$ipd,1).filter($filter_proto,$proto).filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$rep_next.">";
		    }else{
			$z.=" <A HREF=$url?$param$filter_ip$filter_proto".filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$filter_det."&pfilter=1>";}
		    }
		    $z.=$port;
		    $z.="</A> " if $det_more;
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td><td>";
		}elsif ($dst==$dst_ip) {
		    $z.="<tr><td></td><td></td><td>";
		    if ($det_more) {
			$z.=" <A HREF=$url?$param$filter_ip".filter($filter_proto,$proto).$filter_sp.$filter_dp.$filter_det.">";
		    }
		    $z.=$proto;
		    $z.="</A> " if $det_more;
		    $z.="</td><td>";
		    if ($det_more) {if ($pfilter) {
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).filter($filter_ip,($sd?"d":"s").$ipd,1).filter($filter_proto,$proto).filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$rep_next.">";
		    }else{
			$z.=" <A HREF=$url?$param$filter_ip$filter_proto".filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$filter_det."&pfilter=1>";}
		    }
		    $z.=$port;
		    $z.="</A> " if $det_more;
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td></tr>";
		    $proto_n=$proto;
		}else{
		    $z.="<tr><td></td><td>";
		    $ipd=dec2ip($dst);
		    if ($det_more) {
			$z.="<A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ipd).$filter_proto.$filter_sp.$filter_dp.$filter_det.">filter</A>";
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"d":"s").$ipd).$filter_proto.$filter_sp.$filter_dp.$rep_next.">more</A> ";
		    }
		    $z.=$ipd;
		    $z.=host_name($ipd) if $det_name;
		    $z.="</td><td>";
		    if ($det_more) {
			$z.=" <A HREF=$url?$param$filter_ip".filter($filter_proto,$proto).$filter_sp.$filter_dp.$filter_det.">";
		    }
		    $z.=$proto;
		    $z.="</A> " if ($det_more);
		    $z.="</td><td>";
		    if ($det_more) {if ($pfilter) {
			$z.=" <A HREF=$url?$param".filter($filter_ip,($sd?"s":"d").$ips).filter($filter_ip,($sd?"d":"s").$ipd,1).filter($filter_proto,$proto).filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$rep_next.">";
		    }else{
			$z.=" <A HREF=$url?$param$filter_ip$filter_proto".filter($sd?$filter_dp:$filter_sp,$port).($sd?$filter_sp:$filter_dp).$filter_det."&pfilter=1>";}
		    }
		    $z.=$port;
		    $z.="</A> " if ($det_more);
		    $z.="</td><td>$count</td><td>".kmg($len,2)."</td></tr>";
		    $dst_ip=$dst;
		    $proto_n=$proto;
		}
		$count_src+=$count;
		$len_src+=$len;
		++$ns;
		last if $det_str>0 and $ns>=$det_str;
	    }
	    $count_all+=$count_src;
	    $len_all+=$len_src;
	    $z.="<tr><td></td><td></td><td><td align=right>Sum:</td><td>$count_src</td><td>".kmg($len_src,2)."</td></tr>" if $src_ip>0;
	    $z.="<td></td><td></td><td></td><td align=right><b>All</b></td><td><b>Packets=".kmg_p($count_all)."</b></td><td><b>Bytes=".kmg($len_all,2)."</b></td><tr></table>";
	}elsif ($group eq "rep32") {
    	    $r = $db->prepare("SELECT 
	    from_unixtime(time),unit_oid,src,dst,dpkts,len,layer7 
	    FROM monitor where ".$where." AND NOT layer7 Like '' order by time;");
	    $r->execute() or die;
	    $z.="<table width=100% cellpadding=1 cellspacing=1 border=1>";
	    $z.="<tr><td><b>Time<b></td><td><b>Unit Name (OID)</b></td><td><b>Source</b></td><td><b>Destination</b></td><td><b>Packets</b></td><td><b>Bytes</b></td><td><b>Layer7 string</b><td></tr>";
	    $len_all=$count_all=0;
	    while ( ($time,$unit,$src,$dst,$count,$len,$layer7) = $r->fetchrow_array) {
		$z.="<tr><td>".$time."</td><td>".name_rep(sprintf("%6.6X",$unit),"oid")."</td><td>".dec2ip($src)."</td><td>".dec2ip($dst)."</td><td>$count</td><td>$len</td><td>$layer7</td></tr>";
		$count_all+=$count;
		$len_all+=$len;
		++$ns;
		last if $det_str>0 and $ns>=$det_str;
	    }
	    $z.="<td></td><td></td><td></td><td align=right><b>All</b></td><td><b>Packets=".kmg_p($count_all)."</b></td><td><b>Bytes=".kmg($len_all,2)."</b></td><tr></table>";
	}elsif ($group eq "rep31") {
    	    $r = $db->prepare("SELECT 
	    from_unixtime(time),unit_oid,src,srcport,dst,dstport,proto,dpkts,len 
	    FROM monitor where ".$where." order by time;");
	    $r->execute() or die;
	    $z.="<table width=100% cellpadding=1 cellspacing=1 border=1>";
	    $z.="<tr><td><b>Time</b></td><td><b>Unit Name (OID)</b></td><td><b>Source</b></td><td><b>src_port</b></td><td><b>Destination</b></td><td><b>dst_port</b></td><td><b>Proto</b></td><td><b>Packets</b></td><td><b>Bytes</b	></td></tr>";
	    $len_all=$count_all=0;
	    while ( ($time,$unit,$src,$sport,$dst,$dport,$proto,$count,$len) = $r->fetchrow_array) {
		$z.="<tr><td>".$time."</td><td>".name_rep(sprintf("%6.6X",$unit),"oid")."</td><td>".dec2ip($src)."</td><td>$sport</td><td>".dec2ip($dst)."</td><td>$dport</td><td>$proto</td><td>$count</td><td>$len</td></tr>";
		$count_all+=$count;
		$len_all+=$len;
		++$ns;
		last if $det_str>0 and $ns>=$det_str;
	    }
	    $z.="<td></td><td></td><td></td><td></td><td></td><td></td><td align=right><b>All</b></td><td><b>Packets=".kmg_p($count_all)."</b></td><td><b>Bytes=".kmg($len_all,2)."</b></td><tr></table>";
	}
    }	
return $z;
}

#-------------------------------------------------------
sub filter {						#      ,   
    my ($filter,$str,$f)=@_;
    my ($st,@v);
    $f=0 if $f eq "";
    if (index($filter,$str)<0) {
	    return $f?(",".$str):($filter.",".$str);
    }else{
	@v=split(/,/,$filter);
	for $st (@v) {if ($st eq $str){return $f?"":$filter;}
	}
	return $f?(",".$str):($filter.",".$str);
    }
}

#-------------------------------------------------------
sub parse_config {					#    (@oid) -   NAME(OID),    unit   NAME(IP/mask,....)
    my ($netams,@oid)=@_;
    my (@result,$name,$ip,@s_ip,$s_oid,$i,$type,$str,$oi);
    if ($netams eq "yes" or defined @netams_config) {
	if ( scalar(@oid)==0 ) {
	    if ($netams eq "yes") {
    		netams_send("show config");
		if ( $version =~ "3.4" ) {
		    $str=netams_read();
		}else{
		    $str=netams_readline();
		}
		@result=split(/\n/,$str);
		@result=grep(/^unit\s+[host]*[group]*[cluster]*[net]*[user]*\s+oid\s+/,@result);
#		@netams_config=@result;
	    }else{
		@result=@netams_config;
	    }
	    @s_conf_all=();
	    for $name (@result) {
		($type,$name)=split(/ name\s+/,$name);
		($str,$type,$str,$oi)=split(/\s+/,$type);
		($name,$str)=split(/ parent\s+/,$name);
		$name=(split(/ description /,$name))[0];
		$ip="";
		if (index($name," ip ") > 0 ) {
		    ($name,@s_ip)=split(/ ip\s+/,$name);
		    while (@s_ip) {
			$ip.="," if $ip ne "";
    			$ip.=(split(/\s+/,shift(@s_ip)))[0];
		    }
		}
		$name=(split(/\s+/,$name))[0];
		$str=(split(/\s+/,$str))[0];
		$oi.=" parent=".$str if $str ne ""; 
		if ($name ne "" and $oi ne "") {
		    $str=" ip=".$ip." type=".$type." oid=".$oi;
		    push(@s_conf_all,$name.$str);
		    push(@oid,$name." (".$str." )") if $ip ne "" and $ip ne "0.0.0.0";
		}
	    }    
	} else {    
	    for ($i=scalar(@oid)-1;$i>=0;$i--) {
		$s_oid=sprintf("%6.6X",$oid[$i]);
	    	($name,$ip,$type,$oi,$str)=split(/ /,(grep(/oid=$s_oid/,@s_conf_all))[0]);
		    $type=(split(/=/,$type))[1];
		    $oid[$i]=$name." ( ".$type." oid=".$s_oid." ".(($ip eq "ip=")?"":$ip." ").$str." ) ";
		}
	    }
    }else{
	open(F,"< $file");
	for $str (<F>) {
	    if ($str =~ "\@s_conf_all") {
		$name=(split(/s_conf_all=\(\'/,$str))[1];
		$name=(split(/\'\)\;/,$name))[0];
		@s_conf_all=split(/\'\,\'/,$name);
	    }
	    if ($str =~ "\@s_conf_ip"){
		$name=(split(/s_conf_ip=\(\'/,$str))[1];
		$name=(split(/\'\)\;/,$name))[0];
    		@result=split(/\'\,\'/,$name);
	    }
	}
	close(F);
	if (scalar(@oid)==0){@oid=@result;} elsif ( scalar(@s_conf_all) > 0){
	    for ($i=scalar(@oid)-1;$i>=0;$i--) {
		$s_oid=sprintf("%6.6X",$oid[$i]);
	    	($name,$ip,$type,$oi,$str)=split(/ /,(grep(/oid=$s_oid/,@s_conf_all))[0]);
		    $type=(split(/=/,$type))[1];
		    $oid[$i]=$name." ( ".$type." oid=".$s_oid." ".(($ip eq "ip=")?"":$ip." ").$str." ) ";
		}
	}else{
	    for ($i=scalar(@oid)-1;$i>=0;$i--) {
		$oid[$i]="oid=".sprintf("%6.6X",$oid[$i]);
	    }
	}    
    }	
    return sort @oid;
}

#-------------------------------------------------------
sub parse_addr {					#   IP/mask,IP....      WHERE
    my ($v_unit_ip,$column)=@_;
    my (@buff,$ip,$mask,$where,$ip_max,$ip_min,$debug,$z);
    $where=$debug=" AND (";	
    @buff=split(/\,/,$v_unit_ip);
    while (@buff) {
	($ip,$mask)=split(/[\/\\]/,shift(@buff));
	next if $ip eq "";
	if ($mask eq "" or $mask>=32) {if ($ip =~ "!") {$z="!=";$ip=substr($ip,1);}else{$z="=";}
	    if ($where ne " AND (") {$where.=" OR " ;$debug.=" OR " ;}
	    if ($column eq "") {
    		$where.="(src".$z.ip2dec($ip)." OR dst".$z.ip2dec($ip).")";
    		$debug.="(src".$z.$ip." OR dst".$z.$ip.")";
	    }else{
    		$where.=$column.$z.ip2dec($ip);
    		$debug.=$column.$z.$ip;
	    }
	}else{
	    if ($ip =~ "!") {$z=" NOT ";$ip=substr($ip,1);}else{$z=" ";}
	    $ip_min=ip2dec($ip)>>(32-$mask);
	    $ip_min=$ip_min<<(32-$mask);
	    $ip_max=$ip_min | hex("FFFFFFFF")>>$mask;
	    if ($ip_min+$ip_max>0) {
		if ($where ne " AND (") {$where.=" OR ";$debug.=" OR ";}
		if ($column eq "") {
		    $where.=$z."((src>=".$ip_min." AND src<=".$ip_max.") OR (dst>=".$ip_min." AND dst<=".$ip_max."))";
		    $debug.=$z."((src>=".dec2ip($ip_min)." AND src<=".dec2ip($ip_max).") OR (dst>=".dec2ip($ip_min)." AND dst<=".dec2ip($ip_max)."))";
		}else{
		    $where.=$z."(".$column.">=".$ip_min." AND ".$column."<=".$ip_max.")";
		    $debug.=$z."(".$column.">=".dec2ip($ip_min)." AND ".$column."<=".dec2ip($ip_max).")";
		}
	    }
	}
    }
    if ($where ne " AND (") {
        $where.=") " ;
        $debug.=") " ;
	return ($where,$debug);
    }
    return ("","");
}

#-------------------------------------------------------
sub cgi_text {
    my $p1=shift;
    my($p2,$p3,$p4);
		$p1.="<b>$L_monitor_periodselect:</b><br>\n";
		$p1.="<table width=100% cellpadding=1 cellspacing=1 border=0>";
		$p1.="<tr><td><input type=radio name=period value=month> $L_monitor_ps_mon</td>";
		$p1.="<td><input type=radio name=period value=week> $L_monitor_ps_week</td>";
		$p1.="<td><input type=radio name=period value=day> $L_monitor_ps_day</td>";
		$p1.="<td><input type=radio name=period value=hour> $L_monitor_ps_hour</td>";
		$p1.="<td><input type=radio name=period value=exact checked > $L_monitor_ps_exact</td>";
		$p1.= "<td><input type='submit' name='action' value='$L_monitor_refresh'></td>";
		$p1.="<td><input type='submit' name='action' value=Help></td>";
		$p1.="</table><table width=100% cellpadding=4 cellspacing=4 border=0>";
		$p1.="<tr><td>&nbsp;(yyyy-mm-dd_hh:mm)&nbsp; $L_monitor_periodselect_from: <input type=text name=period_from size=40 value=".$period_from."></td>\n";
		$p1.="<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$L_monitor_periodselect_to: <input type=text name=period_to size=40 value=".$period_to."></td>";
		$p1.="<td>NeTAMS <input type=radio name=netams value=yes ".checked("yes",$netams).">Yes";
		$p1.="<td><input type=radio name=netams value=no ".checked("no",$netams).">No</td><td>";
		$p1.= "</tr></table>";
		$p1.="<table width=100% cellpadding=1 cellspacing=1 border=1><tr><td>";
		$p1.="<td><input type='submit' name='action' value='$L_monitor_rconfig'>";
		$p1.=" $L_monitor_src_dst <input type=radio name=ipsrcdst value=src ".checked("src",$ip_src_dst)."> <b>src</b> ";
		$p1.="<input type=radio name=ipsrcdst value=dst ".checked("dst",$ip_src_dst)."> <b>dst</b> ";
		$p1.="<input type=radio name=ipsrcdst value=both ".checked("both",$ip_src_dst)."> <b>both</b> <br>";
		$p1.=$cgi->scrolling_list(
					-name=>'ip',
					-Values=>[('All',@s_conf_ip)],
					-size=>11,
					-multiple=>'true',
					);
		$p1.= "</td><td>";
		if ( $help eq "yes" or $netams eq "no" ) {
		    $p1.="<td><input type='submit' name='action' value='$L_monitor_roid'>";
		    $p1.=" $L_monitor_group <input type=radio name=roid value=group ".checked("group",$roid)."> <b>All Group</b> ";
		    $p1.="<input type=radio name=roid value=unit ".checked("unit",$roid)."> <b>All Units</b> <br>";
		    $p1.=$cgi->scrolling_list(
					-name=>'oid',
					-Values=>['All',checked($roid),@s_oid_group,@s_oid],
					-size=>10,
					-multiple=>'true',
					);
		} else {
		    $p1.="<input type=text name=command size=55 value='$command'>";
		    $p1.="<input type='submit' name='action' value='NeTAMS_Command'>";
		    $p1.=" hide<input type=checkbox name=net value=off><br>";
		    $p1.=$cgi->scrolling_list(
					-name=>'n_c',
					-Values=>[n_cmd($cgi->param("command"))],
					-size=>10,
					) if $cgi->param("action") eq "NeTAMS_Command";
		}
		$p1.="<br> OR <input type=text name=oid_string size=45 value='$oid_string'>";
		$p1.="</td></tr></table><br>";
		$p2="<input type='submit' name='action' value='$L_monitor_rdb'> $L_monitor_rdb_help ";
		$p2.=" <input type='submit' name='action' value='Clear string'>";
		$p2.="<table width=100% cellpadding=2 cellspacing=2 border=2>";
		$p2.="<tr><td>IP  SRC</td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'rip',
					-Values=>['No','Yes','Name'],
					);
		$p2.="</td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'src',
					-Values=>[('All',@s_ip)],
					);
		$p2.="</td><td> OR <input type=text name=src_string size=15 value='$src_string'> </td><td> srcport ";
		$p2.=$cgi->popup_menu(
					-name=>'rport',
					-Values=>['No','Yes','Name=<1024','Name=<2048','Name_All'],
					);
		$p2.="</td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'sport',
					-Values=>[('All',@s_port)],
					);
		$p2.="</td><td> OR <input type=text name=sport_string size=5 value='$sport_string'> </td></tr>";
		$p2.="<tr><td> IP  DST</td><td></td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'dst',
					-Values=>[('All',@s_ip)],
					);
		$p2.="</td><td> OR  <input type=text name=dst_string size=15 value='$dst_string'> </td>";
		$p2.="<td>dstport </td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'dport',
					-Values=>[('All',@s_port)],
					);
		$p2.="</td><td> OR <input type=num name=dport_string size=5 value='$dport_string'> </td></tr>";
		$p2.="<tr><td> Layer7 </td><td align=right> AND </td>";
		$p2.="<td><input type=text name=layer7_and size=15 value='$layer7_and'> </td>";
		$p2.="<td> OR <input type=text name=layer7 size=15 value='$layer7'> </td>";
		$p2.="<td> protocol ";
		$p2.=$cgi->popup_menu(
					-name=>'rproto',
					-Values=>['No','Yes','Name'],
					);
		$p2.="</td><td>";
		$p2.=$cgi->popup_menu(
					-name=>'proto',
					-Values=>[('All',@s_proto)],
					);
		$p2.="</td><td> OR  <input type=text name=proto_string size=5 value='$proto_string'> </td></tr>";
		$p2.= "</td></tr></table>";
		$p3="<br><table width=100% cellpadding=2 cellspacing=2 border=2>";
		$p3.="<tr><td><input type='submit' name='action' value='$L_monitor_refresh'></td>\n";
		$p3.="<td> Records in DB = ".kmg_p($sum_rec)."</td><td>  Packets = ".kmg_p($sum_pak)."</td><td> Bytes = ".kmg($sum_len,2)."</td><td> Flow with layer7 = ".kmg_p($sum_len7)."</td>\<td></td>\n";
		$p3.="<td><input type=checkbox name=debug value=on ".checked("on",$debug_b).">Debug</td></tr>";
		$p3.= "</table>";
		if ($debug_b ne ""){
		    $p3.="<br><table width=100% cellpadding=1 cellspacing=1 border=1>";
		    $p3.= "<tr><td>WHERE:".$debug."</td><tr>\n";
		    $p3.= "<tr><td>SQL WHERE: ".$where."</td><tr>\n";
		    $p3.= "<tr><td>URLS: ".$url."?action=Refresh".$param."</td><tr>\n";
		    $p3.= "</tr></table>";
		}
		$p4="<br><b>$L_monitor_detailselect:</b><br>";
		$p4.=" $L_monitor_det_line <input type=text name=det_line size=2 value=".$det_line."> $L_monitor_det_line3 <br><br>";
		$p4.="<table width=100% cellpadding=1 cellspacing=1 border=0>";
		$p4.="<tr><td><input type=checkbox name=det_more value=1 ".checked("1",$det_more)."></td><td> $L_monitor_det_more </td>";
		$p4.="<td><input type=checkbox name=det_name value=1 ".checked("1",$cgi->param("det_name"))."></td><td> $L_monitor_det_name </td>";
		$p4.="<td><input type=radio name=det7 value=rep70 ".checked("rep70",$det7)."></td><td> $L_monitor_ds_urls_dst</td></tr>";
		$p4.="<tr><td><input type=radio name=det value=rep12 ".checked("rep12",$det)."></td><td> $L_monitor_det_grp Dst,Src</td>";
		$p4.="<td><input type=radio name=det value=rep11 ".checked("rep11",$det)."></td><td> $L_monitor_det_grp Src,Dst</td>";
		$p4.="<td><input type=radio name=det7 value=rep71 ".checked("rep71",$det7)."></td><td> $L_monitor_ds_urls</td></tr>";
		$p4.="<tr><td><input type=radio name=det value=rep22 ".checked("rep22",$det)."></td><td> $L_monitor_det_grp Dst,Src,Proto,SrcPort</td>";
		$p4.="<td><input type=radio name=det value=rep21 ".checked("rep21",$det)."></td><td> $L_monitor_det_grp Src,Dst,Proto,DstPort</td>";
		$p4.="<td><input type=radio name=det7 value=rep72 ".checked("rep72",$det7)."></td><td> $L_monitor_ds_ip</td></tr>";
		$p4.="<tr><td><input type=radio name=det value=rep31 ".checked("rep31",$det)."></td><td> $L_monitor_det_flow </td>";
		$p4.="<td><input type=radio name=det value=rep32 ".checked("rep32",$det)."></td><td> $L_monitor_det_flow7 </td>";
		$p4.="<td><input type=radio name=det7 value=rep73 ".checked("rep73",$det7)."></td><td> $L_monitor_ds_oid</td></tr>";
    		$p4.= "<tr><td></td><td align=right><input type='submit' name='action' value=Report_IP></td>";
		$p4.="<td><input type=checkbox name=rep_swap value=1 ".checked("1",$cgi->param("rep_swap"))."></td><td> $L_monitor_det_swap </td>";
		$p4.= "<td></td><td><input type='submit' name='action' value=Report_Layer7></td></tr>";
		$p4.= "</table>";
return ($p1,$p2,$p3,$p4);
}

#-------------------------------------------------------
sub write_to_file {					#    
    open(F,"> $file");
	print F "\@netams_config=('".join("','",@netams_config)."');\n" if (defined @netams_config);
	print F "\@s_conf_all=('".join("','",@s_conf_all)."');\n" if scalar @s_conf_all>0;
	print F "\@s_conf_ip=('".join("','",@s_conf_ip)."');\n" if scalar @s_conf_ip>0;
	print F "\@s_oid_group=('".join("','",@s_oid_group)."');\n" if scalar @s_oid_group>0;
	print F "\@s_oid=('".join("','",@s_oid)."');\n" if scalar @s_oid>0;
	print F "\@s_proto=('".join("','",@s_proto)."');\n" if scalar @s_proto>0;
	print F "\@s_port=('".join("','",@s_port)."');\n" if scalar @s_port>0;
	print F "\@s_ip=('".join("','",@s_ip)."');\n" if scalar @s_ip>0;
	print F "1";
    close(F);
}    

#-------------------------------------------------------
sub checked {
    my($p,$v)=@_;
    return "checked" if ($v eq $p);
    return "All Groups" if ($p eq "group");
    return "All Units (no Groups)" if ($p eq "unit");
    return ""; 
}

#-------------------------------------------------------
sub kmg {						#   K M G byte
    my ($val,$t)=@_;
    if ($val>1024*1024*1024) { return sprintf("%0.".$t."fG",$val/1024/1024/1024);}
    elsif ($val>1024*1024)   { return sprintf("%0.".$t."fM",$val/1024/1024);}
    elsif ($val>1024)        { return sprintf("%0.".$t."fK",$val/1024);}
    else 		     { return sprintf("%dB",$val);}
}

#-------------------------------------------------------
sub kmg_p {						#   
    my $val=shift;
    my ($i,$j,$s);
    $s="";$j=3;$i=length($val);
    while ($i > 0) {$i-=3;if ($i < 0) {$j+=$i;$i=0;}$s=" ".substr($val,$i,$j).$s;}
    return $s;
}

sub n_cmd {
    my @n_send=split(/\;/,shift);
    return "" if scalar(@n_send)==0;
    my ($cmd,$n_read,$z);
    for $cmd (@n_send){
	if ($cmd=~"!") {$cmd=substr($cmd,1);$z=0} else {$z=1;}
	{netams_send($cmd);$cmd=netams_read();$n_read.=$cmd if $z;}
    }
    return split(/\n/,$n_read);
    
}

#-------------------------------------------------------
sub bmr {						#   WHERE   
    my ($val,$name)=@_;
    my ($where,@v,$z,$a1);
    @v=split(/\,/,$val);
    $a1="";
    $where=" AND (";
    for $val (@v) { 
	next if $val eq "";
	if ($val =~ "!") {$a1.=substr($val,1).","; next;} elsif ($val =~ "<") {$z="<";} elsif ($val =~ ">") {$z=">";} else {$z="=";}
	$val=~tr/0-9//cd;
	$where.=" OR " if ($where ne " AND (");
	$where.=$name.$z.$val;
    }
    if ($where ne " AND (") {$where.=") ";}else{$where="";}
    @v=split(/\,/,$a1);
    for $val (@v) { 
	next if $val eq "";
	if ($val =~ "<") {$z=">=";} elsif ($val =~ ">") {$z="<=";} else {$z="!=";}
	$val=~tr/0-9//cd;
	$where.=" AND ".$name.$z.$val;
    }
    return $where;
}

#-------------------------------------------------------
sub unic {						#     ,   -  (    )
    my ($k,@m)=@_;
    my $i;
    for ($i=scalar(@m)-1;$i>=0;$i--) {last if $m[$i] == $k;}
    push(@m,$k) if $i<0;
    return @m;
}

#-------------------------------------------------------
sub parse_ip {						#  IP     a.b.c.d  ,  $v > 1
    my ($v,@str)=@_;
    my $i;
    for ($i=scalar(@str)-1;$i>=0;$i--) {
	$str[$i]=dec2ip($str[$i]);
	$str[$i].=host_name($str[$i]) if $v > 1;
    }
    return @str;
}

#-------------------------------------------------------
sub host_name {						# gethostbyaddr
    my $ip=shift;
    my $name=gethostbyaddr(pack("C4", split(/\./,$ip) ),2);
    $name = " ( ".$name." )" if $name ne "";
    return $name;
}

#-------------------------------------------------------
sub ip2dec {						#  IP a.b.c.d  HEX AABBCCDD,  
    my $ip=shift;
    $ip=~s/(\d+).(\d+).(\d+).(\d+)/sprintf("%2.2X",$1).sprintf("%2.2X",$2).sprintf("%2.2X",$3).sprintf("%2.2X",$4)/e;
    return hex $ip;
}

#-------------------------------------------------------
sub dec2ip {						#    IP a.b.c.d
    my $dec=shift;
    my $ip=sprintf("%8.8X",$dec);
    $ip=~s/(\w\w)(\w\w)(\w\w)(\w\w)/hex($1).".".hex($2).".".hex($3).".".hex($4)/e;
    return $ip;
}

#-------------------------------------------------------
sub parse_file {					#     (port, protocol)
    my ($file,$r,@str)=@_;
    my ($i,@f,$st);
    open(F,"< $file"); @f=<F>; close(F);
    for ($i=0;$i<scalar(@str);$i++) {
	last if $str[$i]>50000;
	$st=$str[$i].$r;
	$st=(grep(/\s+$st\s+/,@f))[0];
	$st=(split(/\s+/,$st))[0];
	$str[$i].=" (".$st.")" if $st ne "";
    }
    return @str;
}

#-------------------------------------------------------
sub name_rep {						#   
    my ($str,$s)=@_;
    $s.="=".$str;
    $str=(grep(/$s/,@s_conf_all))[0];
    $str=(split(/\s+/,$str))[0];
    return $str." ( ".$s." )";
}

#-------------------------------------------------------
sub n_week {						#  
    my ($y,$m,$d)=@_; 
    my $w=`date +%u`;
    $d-=($w-1);
    return $y."-".$m.sprintf("-%02d",$d) if $d > 0 ;
    my @d_m=(31,$y%4==0?29:28,31,30,31,30,31,31,30,31,30);
    return $y.sprintf("-%02d-%02d",$m-1,$d_m[$m-2]+$d) if $m > 1;
    return sprintf("%04d-12-%2d",$y-1,31+$d);
}

################################################
sub CheckAccess_m {
	if ($have_access ne "yes") {
	    return 9;
	}
	$what = shift;
	$user = $ENV{REMOTE_USER};
	$dbh = DBI->connect("DBI:$sql:database=$sql_dbname;host=$sql_host", $sql_login, $sql_password);
	$sth = $dbh->prepare("SELECT rights FROM $accessdb WHERE login='$user'");
        $sth->execute();
        @rights=split //,$sth->fetchrow_array;
	if(@rights eq "") { return "0"; }  #shouldnt
	elsif($rights[0] eq "2") { return "2"; } 
	elsif ($rights[0] eq "1") {
		if($rights[$access{$what}] eq "2") { return "2"; }
		else { return "1"; }
	}
	return $rights[$access{$what}];
}
1;

