/* $Id: prefs_scope_tree.h,v 1.3.2.1 2006/11/04 23:22:37 renaud Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#ifndef PREFS_SCOPE_TREE_H
#  define PREFS_SCOPE_TREE_H

struct arglist *prefs_dialog_scope_tree(struct context *);

struct context *scopetree_new_with_parent(struct context *, context_type,
    const char *, const char *);
struct context *scopetree_new(context_type, const char *, const char *);
void scopetreeview_counters_update(struct context *, int, char*);
void scopetreeview_connected_update(struct context *);

void scope_move_menuitem_enable(struct context *, gboolean);

void task_menu_rename(GtkMenuItem *, gpointer);
void scope_menu_rename(GtkMenuItem *, gpointer);
void report_menu_rename(GtkMenuItem *, gpointer);

void task_menu_new(GtkMenuItem *, gpointer);
void scope_menu_new(GtkMenuItem *, gpointer);

void task_menu_delete(GtkMenuItem *, gpointer);
void scope_menu_delete(GtkMenuItem *, gpointer);
void report_menu_delete(GtkMenuItem *, gpointer);

void scope_menu_open(GtkMenuItem *, gpointer);
void scope_menu_save(GtkMenuItem *, gpointer);

void scopetree_context_new(GtkWidget *, gpointer);
void scopetree_context_delete(GtkWidget *, gpointer);

#endif /* ifndef PREFS_SCOPE_TREE_H */

