/* $Id: prefs_dialog_prefs.c,v 1.1.1.1 2005/09/10 17:36:45 renaud Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Jan-Oliver Wagner <jan@intevation.de>
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#include <includes.h>
#include <gtk/gtk.h>

#include "nessus_i18n.h"
#include "context.h"
#include "preferences.h"

/* Build and run the preferences Dialog. In case of finishing the
 * dialog with OK, store the changed preferences data. */
void
prefs_dialog_prefs(menuitem, ctrls)
  GtkMenuItem * menuitem; /* not required here, but mandatory since
                             function is connected via GTK_SIGNAL_CONNECT */
  gpointer ctrls;
{
  GtkWindow * window = GTK_WINDOW(arg_get_value(ctrls, "WINDOW"));
  GtkWidget * dialog;
  GtkWidget * vbox;
  GtkWidget * hbox;
  GtkWidget * frame;
  GtkWidget * table;
  GtkWidget * label;
  GtkWidget * check_autoexpand;
  GtkWidget * check_autoconnect;
  GtkWidget * entry_url_nessus;
  GtkWidget * entry_url_cve;
  GtkWidget * entry_url_bid;
  /*
  GtkTooltips * tooltips = GTK_TOOLTIPS(arg_get_value(ctrls, "TOOLTIPS"));
  */

  dialog = gtk_dialog_new_with_buttons(_("Preferences"), window,
             GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
             GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
             GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
  gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);
  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
  gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);

  vbox = gtk_vbox_new(FALSE, 4);
  gtk_widget_show(vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), vbox);

  hbox = gtk_hbox_new(FALSE, 4);
  gtk_widget_show(hbox);
  gtk_box_pack_start_defaults(GTK_BOX(vbox), hbox);

  /*
   * User interface
   */
  frame = gtk_frame_new(_("User interface"));
  gtk_widget_show(frame);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), frame);

  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_container_set_border_width(GTK_CONTAINER(table), 4);
  gtk_table_set_row_spacings(GTK_TABLE(table), 8);
  gtk_table_set_col_spacings(GTK_TABLE(table), 8);

  check_autoexpand = gtk_check_button_new_with_mnemonic(
      _("Auto expand tree elements"));
  gtk_widget_show(check_autoexpand);
  gtk_table_attach_defaults(GTK_TABLE(table), check_autoexpand, 0, 1, 0, 1);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_autoexpand),
      prefs_get_int(Global, "tree_autoexpand"));


  /*
   * Connection
   */
  frame = gtk_frame_new(_("Connection to Nessus Server"));
  gtk_widget_show(frame);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), frame);

  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_container_set_border_width(GTK_CONTAINER(table), 4);
  gtk_table_set_row_spacings(GTK_TABLE(table), 8);
  gtk_table_set_col_spacings(GTK_TABLE(table), 8);

  check_autoconnect = gtk_check_button_new_with_mnemonic(
      _("Automatically connect"));
  gtk_widget_show(check_autoconnect);
  gtk_table_attach_defaults(GTK_TABLE(table), check_autoconnect, 0, 1, 0, 1);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_autoconnect),
      prefs_get_int(Global, "nessusd_autoconnect"));


  /*
  frame = gtk_frame_new(_("External programs"));
  gtk_widget_show(frame);
  gtk_box_pack_start_defaults(GTK_BOX(vbox), frame);
  */

  /* TODO: pdfviewer, maybe htmldoc? */

  frame = gtk_frame_new(_("External Links in HTML/PDF"));
  gtk_widget_show(frame);
  gtk_box_pack_start_defaults(GTK_BOX(vbox), frame);

  table = gtk_table_new(3, 2, FALSE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_container_set_border_width(GTK_CONTAINER(table), 4);
  gtk_table_set_row_spacings(GTK_TABLE(table), 8);
  gtk_table_set_col_spacings(GTK_TABLE(table), 8);

  label = gtk_label_new(_("Nessus IDs:"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
      GTK_FILL, GTK_FILL, 0, 0);

  entry_url_nessus = gtk_entry_new();
  gtk_widget_show(entry_url_nessus);
  gtk_entry_set_text(GTK_ENTRY(entry_url_nessus),
      prefs_get_string(Global, "url_nessus"));
  gtk_table_attach_defaults(GTK_TABLE(table), entry_url_nessus, 1, 2, 0, 1);

  label = gtk_label_new(_("CVE IDs:"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
      GTK_FILL, GTK_FILL, 0, 0);

  entry_url_cve = gtk_entry_new();
  gtk_widget_show(entry_url_cve);
  gtk_entry_set_text(GTK_ENTRY(entry_url_cve),
      prefs_get_string(Global, "url_cve"));
  gtk_table_attach_defaults(GTK_TABLE(table), entry_url_cve, 1, 2, 1, 2);

  label = gtk_label_new(_("BugTraq IDs:"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
      GTK_FILL, GTK_FILL, 0, 0);

  entry_url_bid = gtk_entry_new();
  gtk_widget_show(entry_url_bid);
  gtk_entry_set_text(GTK_ENTRY(entry_url_bid),
      prefs_get_string(Global, "url_bid"));
  gtk_table_attach_defaults(GTK_TABLE(table), entry_url_bid, 1, 2, 2, 3);


  /*
  frame = gtk_frame_new(_("Debug"));
  gtk_widget_show(frame);
  gtk_box_pack_start_defaults(GTK_BOX(vbox), frame);
  */

  switch (gtk_dialog_run(GTK_DIALOG(dialog)))
  {
    case GTK_RESPONSE_OK:
      prefs_set_int(Global, "tree_autoexpand",
	  gtk_toggle_button_get_active(
	    GTK_TOGGLE_BUTTON(check_autoexpand))?1:0);
      prefs_set_int(Global, "nessusd_autoconnect",
	  gtk_toggle_button_get_active(
	    GTK_TOGGLE_BUTTON(check_autoconnect))?1:0);
      prefs_set_string(Global, "url_nessus",
	  gtk_entry_get_text(GTK_ENTRY(entry_url_nessus)));
      prefs_set_string(Global, "url_cve",
	  gtk_entry_get_text(GTK_ENTRY(entry_url_cve)));
      prefs_set_string(Global, "url_bid",
	  gtk_entry_get_text(GTK_ENTRY(entry_url_bid)));
      break;
  }

  gtk_widget_destroy(dialog);
}
