#TRUSTED 21872abad08a3084dbce10a5d3d04d9bec2c05cc1d041782ea9573f837f1ad62705b93cd8ecf1e6278391bb11b04521dd6a156fd2593bf3db3582ed7964c4f7d23b256e955246ef467eb76f520e1a3833391f9efd8c6ca29315dea2b066f93e11e0e5710ffc6cc714dc6cb129be352efa499f79b43e07aa905d0f7567c54a8d105f21ac0042781b2a1a26e7ab9688efbbaf2d2ff597a17eedebe683d693b440e2fb72308e33dbe1c579e8b56fea64c0d00ea4af48a68783afe3c07b6a853ac19f03c46c34ac0193569c93dd9ab8b92c0279e02dcf6aea7aa29fcddf4c00bfc8de80432682d150775dce288bcef0314ae43cb84b28c2abbb825eef770b7efd677fb21f76a6a277257ba44a1d31077496b5c770e4959e146613e3dd21e158c60bcb5323654d9eef51ea4566600ec73726851e88b4b13380b33d7ecbe63beb4d92378161b684830a0aaec60742ea584394c3111d4bec20bf5837646607b918dada97df2a42cb5b8e7a2a7f39dbc2588841d6167e09e0a38b978121e86a194b5480ea86f63e6772cdc50878fbf8c365034bd877546d454c7732af4756da94cab780ad13b8d8d17a44414796ea66214baf1d5c9ec4d0f391ec23fe9cf44b83728bf7f1f9a75530f5488d46bae9fe10a54aa586b4e4d6e403c41bdecfb9372fdee7bb7f4fb762833294f0a04b06cf009ce27425b920fc9c835dfd2f1be4ec4ae7c4730
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15878);
 script_version ("1.3");
 name["english"] = "Hydra: MS SQL";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find MS SQL passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force MS SQL authentication with Hydra";
 script_summary(english:summary["english"]);
 script_timeout(0);
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/mssql", 1433);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "mssqlserver_detect.nasl", "mssql_blank_password.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/mssql");
if (! port) exit(0);	# port = 1433;
if (! get_port_state(port)) exit(0);
if (get_kb_item('MSSQL/blank_password/'+port)) exit(0);

# We should check that the server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "mssql";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/mssql/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following MS SQL accounts:\n' + report);
