#TRUSTED 58f2d45308b4dabdeb6d7e4e9bc8a1223544c065fd1c4de8b5f91b57ce087a7bb0664421d85b7075a119f4041c8214c799eded2b5b129bb6bf94ef0e0861345e428cc26b74bdcc538ecc91efb5e3ff16c89fa802026d8c92cae8fa6ee48e0ac7ac102f03907076ab157459cec25e462729dc6b40b922b58b5154e3b3321afb7fc9f5a54b10515a10e6ee91d78424b67a8bb88fa4cf8e7f0395aff2997c76fce72440e8a651731e6473d8988c49cd153dce86ad97c2412bccb3673991d837fb3e904ca8bae4018c6287ed86337a80dd515789b5e2379ee01d5e678bbc0790fb6945f10a92f4cd2e58941a43da1188e23063d3811da0f3e15cbda25c03927ed9009916d9101d954bc5fd1260408623de2ee649e2a80d58ea277992c9143563a3eecebf13a435aaf393bd2529306d65c4d5494137a8163e80d473088eb3a8536f5591e3d8be93307a4ddff406ca1fc51a00c8409781f3332c3debe7d285bf529ff1c1eae9c31a471abb3fd14445d9da04e1b4c2349f4d64e84ab92082502d11bf3bc95c7c05f50db81182c6be468d3b7bc994cd9be8385befdc35c7fc555a58a269cb6db607617e8eaf7901c71afaf5b228ee10992a6a9deac2ddd23ddb5b0f63ab1732b1cc75986c83d46271095ca82fd42b6ccd8a916433fd67392f63af4a116a06eedcb063612491fb401ea18a0f7c3bbcc7a2caddfb9e94153ccdb455398ff8
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15871);
 script_version ("1.3");
 name["english"] = "Hydra: CVS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find CVS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force CVS authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_timeout(0);
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/cvspserver", 2401);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "cvs_detect.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/cvspserver");
if (! port) exit(0);	# port = 2401;
if (! get_port_state(port)) exit(0);

# We should check that the server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cvs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/cvs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following CVS accounts:\n' + report);
