# This file is part of the nesC compiler.
#    Copyright (C) 2002 Intel Corporation
# 
# The attached "nesC" software is provided to you under the terms and
# conditions of the GNU General Public License Version 2 as published by the
# Free Software Foundation.
# 
# nesC is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with nesC; see the file COPYING.  If not, write to
# the Free Software Foundation, 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

#
# Modified by Geoffrey Mainland <mainland@eecs.harvard.edu>
# Written by Victor Shnayder <shnayder@eecs.harvard.edu> [11/23/2005]
#

true;

sub gen() {
    my ($classname, %csts) = @_;

    &usage("no classname name specified") if !defined($python_classname);

    print " #\n";
    print " # This class is automatically generated by ncg. DO NOT EDIT THIS FILE.\n";
    print " # This class includes values of some nesC constants from\n";
    print " # $cfile.\n";
    print " #/\n\n";
    
    if (defined($python_extends)) {
	if ($python_extends =~ /(.*)\.([^.]*)$/) {
	    $package = $1;
	    print "import $package\n\n";
	}

	print "class $python_classname($python_extends):\n";
    } else {
	print "class $python_classname:\n";
    }

    foreach $name (keys %csts) {
        $val = $csts{$name};
        print "    $name = $val\n";
    }

    print "\n";
}
