// REFERENCE: Nemerle.Compiler

using Nemerle.Compiler;
using Nemerle.Collections;

namespace DesignPatterns
{
  [Nemerle.MacroUsage (Nemerle.MacroPhase.WithTypedMembers,
                       Nemerle.MacroTargets.Field)]
  macro Proxy (t : TypeBuilder, f : FieldBuilder, iface)
  {
    // find out the real type specified as [iface] parameter
    def interfc = match (Nemerle.Macros.ImplicitCTX().BindType (iface))
    {
      | MType.Class (typeinfo, _) when typeinfo.IsInterface => typeinfo
      | _ => Message.FatalError ("expected interface type")
    }
    foreach (meth :> IMethod in interfc.GetMembers ())
    {
          // prepare interface method invocation parameters
          def parms = List.Map (meth.GetParameters (), fun (p) {
            <[ $(t.ParsedName.NewName (p.name) : name) : $(p.ty : typed) ]>
          });
          // prepare created method function parameters
          def fparms = List.Map (parms, Parsetree.Fun_parm);

          // create Name object for name of created object
          def method_name = t.ParsedName.NewName (meth.Name);

          // define the wrapper method
          t.Define (<[ decl:
            public virtual $(method_name : name) (..$fparms) : $(meth.ReturnType : typed) {
              this.$(f.Name : dyn).$(method_name : name) (..$parms)
            }
          ]>)
    } 
  }
}
