using Nemerle.IO;

class A {}
class B : A {}

class M {
  static g (b : B) : A { (b : A) }        // OK
  static f () : int { ("foo" : int) }    // E: expected int.*, got string in type-enforced expression
}

enum Fruit { | Apple | Orange };

module M1 {
  f () : void {
    def f1 (x) { printf ("%s\n", x) };
    printf ("%d", f1 ("foo")); // E: expected int.*, got void in type-enforced expression
    f1 (3); // E: in argument #1 \(x\).*, needed a string.*, got int

    _ = null : System.Int32; // E: expected int.*, got .* in type-enforced expression.*null

    _ = if (true) Fruit.Apple else null; // E: the `null' literal is not a valid value of type Fruit
    _ = if (true) null else Fruit.Apple; // E: the `null' literal is not a valid value of type Fruit

    _ = $ "$(foo"; // E: runaway .* in format string
    _ = $ "$(foo +)"; // E: parse error near operator
    _ = $ "$()"; // E: expression without content
    _ = $ ""; // OK
  }
}
