// Copyright (c) 2003-2005 The University of Wroclaw.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//    1. Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//    2. Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//    3. The name of the University may not be used to endorse or promote
//       products derived from this software without specific prior
//       written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

namespace Nemerle.CSharp
{
    /**
     *  Definition of ExtendedToken
     *  Holds informations about whitespaces and comments that exists before token
     */
    public class ExtendedToken : antlr.CommonToken
    {
        /* -- CONSTRUCTORS -------------------------------------------------- */

        /**
         *  Constructs token holding information about whitespaces that exists before token
         */
        public this ()
        {
            whitespaces_before_token = global_whitespaces_before_token ;
            ClearWhitespaces () 
        }

        /**
         *  Constructs token holding information about whitespaces that exists before token
         *  Token text is set to s, and token type to i
         */
        public this (i : int, s : string )
        {            
            base(i, s);            
            whitespaces_before_token = global_whitespaces_before_token ;
            ClearWhitespaces () 
        }

        /**
         *  Constructs token holding information about whitespaces that exists before token
         *  Token text is set to s
         */        
        public this ( s : string )
        {
            base(s);            
            ClearWhitespaces () 
        }

        /**
         *  Constructs token holding information about whitespaces that exists before token
         *  Token text is set to s, whitespaces are set to 'whitespaces'
         */          
        public this (whitespaces : string,s : string)
        {
            base(s);
            whitespaces_before_token = whitespaces;
        }
        
        /* -- PUBLIC METHODS -------------------------------------------------- */

        /**
         *  Clears whitespaces buffer
         */
        public static ClearWhitespaces () : void
        {
            global_whitespaces_before_token = ""
        }

        /**
         *  Add string to whitespaces buffer
         */
        public static AddToWhitespaces (s : string) : void
        {            
            global_whitespaces_before_token += s;
        }

        /**
         *  Returns whitespaces that exists before token t
         */
        public static getWhitespaces (t : antlr.Token) : string
        {
            def et = (t :> ExtendedToken);
            et.whitespaces_before_token
        }

        /**
         *  Returns text of whitespaces that exists before token + token
         */
        override public getText () : string
        {
             whitespaces_before_token + base.getText()
        }

        /**
         *  Returns text of token only
         */
        public static getTextOnly (t : antlr.Token) : string
        {
            def et = (t :> ExtendedToken);
            et.getTextOnly ()
        }

	/**
         *  prefixes token text (but not whitespaces) with s
	 */
	public static prefix_text (s : string,t : antlr.Token) : void
	{
	    (t :> ExtendedToken).prefix_text(s);
	}

        /* -- PRIVATE METHODS _------------------------------------------------ */

        /**
         *  Returns text of token only
         */
        private getTextOnly () : string
        {
            base.getText()
        }
	
	private prefix_text (s : string) : void
	{
	    base.setText( s + base.getText ());
	}

	public override ToString() : string
	{
	     base.getText ()
	}

        /* -- PRIVATE FIELDS -------------------------------------------------- */
        
        private mutable static global_whitespaces_before_token : string;
        private whitespaces_before_token : string;
    }
}
