// $ANTLR 2.7.4: "csharpgrammar.g" -> "CSharpLexer.cs"$

    using System.Collections;
    using Nemerle.Collections;

namespace Nemerle.CSharp
{
	// Generate header specific to lexer CSharp file
	using System;
	using Stream                          = System.IO.Stream;
	using TextReader                      = System.IO.TextReader;
	using Hashtable                       = System.Collections.Hashtable;
	using Comparer                        = System.Collections.Comparer;
	
	using TokenStreamException            = antlr.TokenStreamException;
	using TokenStreamIOException          = antlr.TokenStreamIOException;
	using TokenStreamRecognitionException = antlr.TokenStreamRecognitionException;
	using CharStreamException             = antlr.CharStreamException;
	using CharStreamIOException           = antlr.CharStreamIOException;
	using ANTLRException                  = antlr.ANTLRException;
	using CharScanner                     = antlr.CharScanner;
	using InputBuffer                     = antlr.InputBuffer;
	using ByteBuffer                      = antlr.ByteBuffer;
	using CharBuffer                      = antlr.CharBuffer;
	using Token                           = antlr.Token;
	using CommonToken                     = antlr.CommonToken;
	using SemanticException               = antlr.SemanticException;
	using RecognitionException            = antlr.RecognitionException;
	using NoViableAltForCharException     = antlr.NoViableAltForCharException;
	using MismatchedCharException         = antlr.MismatchedCharException;
	using TokenStream                     = antlr.TokenStream;
	using LexerSharedInputState           = antlr.LexerSharedInputState;
	using BitSet                          = antlr.collections.impl.BitSet;
	
	public 	class CSharpLexer : antlr.CharScanner	, TokenStream
	 {
		public const int EOF = 1;
		public const int NULL_TREE_LOOKAHEAD = 3;
		public const int INTEGER_LITERAL = 4;
		public const int HEXADECIMAL_INTEGER_LITERAL = 5;
		public const int REAL_LITERAL = 6;
		public const int CHARACTER_LITERAL = 7;
		public const int NULL = 8;
		public const int TRUE = 9;
		public const int FALSE = 10;
		public const int REGULAR_STRING_LITERAL = 11;
		public const int VERBATIM_STRING_LITERAL = 12;
		public const int IDENTIFIER = 13;
		public const int DOT = 14;
		public const int OBJECT = 15;
		public const int STRING = 16;
		public const int BOOL = 17;
		public const int DECIMAL = 18;
		public const int CHAR = 19;
		public const int INT = 20;
		public const int LONG = 21;
		public const int SBYTE = 22;
		public const int BYTE = 23;
		public const int SHORT = 24;
		public const int UINT = 25;
		public const int ULONG = 26;
		public const int USHORT = 27;
		public const int FLOAT = 28;
		public const int DOUBLE = 29;
		public const int LTHAN = 30;
		public const int COMMA = 31;
		public const int GTHAN = 32;
		public const int SR = 33;
		public const int LBRACK = 34;
		public const int RBRACK = 35;
		public const int REF = 36;
		public const int OUT = 37;
		public const int DEC = 38;
		public const int INC = 39;
		public const int DELEGATE = 40;
		public const int LPAREN = 41;
		public const int RPAREN = 42;
		public const int NEW = 43;
		public const int THIS = 44;
		public const int BASE = 45;
		public const int TYPEOF = 46;
		public const int VOID = 47;
		public const int CHECKED = 48;
		public const int UNCHECKED = 49;
		public const int PLUS = 50;
		public const int MINUS = 51;
		public const int LNOT = 52;
		public const int BNOT = 53;
		public const int STAR = 54;
		public const int DIV = 55;
		public const int MOD = 56;
		public const int SL = 57;
		public const int IS = 58;
		public const int AS = 59;
		public const int LE = 60;
		public const int GE = 61;
		public const int EQUAL = 62;
		public const int NOT_EQUAL = 63;
		public const int BAND = 64;
		public const int BXOR = 65;
		public const int BOR = 66;
		public const int LAND = 67;
		public const int LOR = 68;
		public const int QUESTION = 69;
		public const int COLON = 70;
		public const int ASSIGN = 71;
		public const int PLUS_ASN = 72;
		public const int MINUS_ASN = 73;
		public const int STAR_ASN = 74;
		public const int DIV_ASN = 75;
		public const int MOD_ASN = 76;
		public const int BAND_ASN = 77;
		public const int BOR_ASN = 78;
		public const int BXOR_ASN = 79;
		public const int SL_ASN = 80;
		public const int SR_ASN = 81;
		public const int CONST = 82;
		public const int YIELD = 83;
		public const int SEMI = 84;
		public const int DEFAULT = 85;
		public const int LBRACE = 86;
		public const int RBRACE = 87;
		public const int IF = 88;
		public const int ELSE = 89;
		public const int SWITCH = 90;
		public const int CASE = 91;
		public const int WHILE = 92;
		public const int DO = 93;
		public const int FOR = 94;
		public const int FOREACH = 95;
		public const int IN = 96;
		public const int BREAK = 97;
		public const int CONTINUE = 98;
		public const int GOTO = 99;
		public const int RETURN = 100;
		public const int THROW = 101;
		public const int TRY = 102;
		public const int CATCH = 103;
		public const int FINALLY = 104;
		public const int LOCK = 105;
		public const int USING = 106;
		public const int NAMESPACE = 107;
		public const int ENUM = 108;
		public const int STRUCT = 109;
		public const int INTERFACE = 110;
		public const int CLASS = 111;
		public const int PUBLIC = 112;
		public const int PROTECTED = 113;
		public const int INTERNAL = 114;
		public const int PRIVATE = 115;
		public const int SEALED = 116;
		public const int ABSTRACT = 117;
		public const int STATIC = 118;
		public const int PARTIAL = 119;
		public const int READONLY = 120;
		public const int VOLATILE = 121;
		public const int WHERE = 122;
		public const int VIRTUAL = 123;
		public const int OVERRIDE = 124;
		public const int EXTERN = 125;
		public const int PARAMS = 126;
		public const int EVENT = 127;
		public const int OPERATOR = 128;
		public const int IMPLICIT = 129;
		public const int EXPLICIT = 130;
		public const int SIZEOF = 131;
		public const int STACKALLOC = 132;
		public const int FIXED = 133;
		public const int UNSAFE = 134;
		public const int NEW_LINE = 135;
		public const int WHITESPACE = 136;
		public const int NEW_LINE_CHARACTER = 137;
		public const int NOT_NEW_LINE = 138;
		public const int SINGLE_LINE_COMMENT = 139;
		public const int DELIMITED_COMMENT = 140;
		public const int UNICODE_ESCAPE_SEQUENCE = 141;
		public const int IDENTIFIER_START_CHARACTER = 142;
		public const int IDENTIFIER_PART_CHARACTER = 143;
		public const int DECIMAL_DIGIT = 144;
		public const int HEX_DIGIT = 145;
		public const int INTEGER_TYPE_SUFFIX = 146;
		public const int NUMERIC_LITERAL = 147;
		public const int EXPONENT_PART = 148;
		public const int SIGN = 149;
		public const int CHARACTER = 150;
		public const int SIMPLE_CHARACTER = 151;
		public const int SIMPLE_ESCAPE_SEQUENCE = 152;
		public const int HEXADECIMAL_ESCAPE_SEQUENCE = 153;
		public const int REGULAR_STRING_LITERAL_CHARACTER = 154;
		public const int SINGLE_REGULAR_STRING_LITERAL_CHARCACTER = 155;
		public const int HASH = 156;
		public const int QUOTE = 157;
		public const int PP_DIRECTIVE = 158;
		public const int PP_WHITESPACE = 159;
		public const int PP_NEW_LINE = 160;
		public const int PP_EXPRESSION = 161;
		public const int PP_OR_EXPRESSION = 162;
		public const int PP_AND_EXPRESSION = 163;
		public const int PP_EQUALITY_EXPRESSION = 164;
		public const int EQUALITY_OP = 165;
		public const int PP_UNARY_EXPRESSION = 166;
		public const int PP_PRIMARY_EXPRESSION = 167;
		public const int PP_CONDITIONAL = 168;
		public const int PP_IF_SECTION = 169;
		public const int PP_ELIF_SECTION = 170;
		public const int PP_ELSE_SECTION = 171;
		public const int PP_ENDIF = 172;
		public const int PP_DECLARATION = 173;
		public const int CONDITIONAL_SYMBOL = 174;
		public const int PP_LINE = 175;
		public const int LINE_INDICATOR = 176;
		public const int FILE_NAME = 177;
		public const int FILE_NAME_CHARACTER = 178;
		public const int PP_DIAGNOSTIC = 179;
		public const int PP_START_REGION = 180;
		public const int PP_END_REGION = 181;
		public const int PP_MESSAGE = 182;
		
		public CSharpLexer(Stream ins) : this(new ByteBuffer(ins))
		{
		}
		
		public CSharpLexer(TextReader r) : this(new CharBuffer(r))
		{
		}
		
		public CSharpLexer(InputBuffer ib)		 : this(new LexerSharedInputState(ib))
		{
		}
		
		public CSharpLexer(LexerSharedInputState state) : base(state)
		{
			initialize();
		}
		private void initialize()
		{
			caseSensitiveLiterals = true;
			setCaseSensitive(true);
			literals = new Hashtable(100, (float) 0.4, null, Comparer.Default);
			literals.Add("namespace", 107);
			literals.Add("public", 112);
			literals.Add("byte", 23);
			literals.Add("extern", 125);
			literals.Add("uint", 25);
			literals.Add("case", 91);
			literals.Add("new", 43);
			literals.Add("sealed", 116);
			literals.Add("object", 15);
			literals.Add("readonly", 120);
			literals.Add("checked", 48);
			literals.Add("finally", 104);
			literals.Add("lock", 105);
			literals.Add("unchecked", 49);
			literals.Add("partial", 119);
			literals.Add("return", 100);
			literals.Add("abstract", 117);
			literals.Add("null", 8);
			literals.Add("sizeof", 131);
			literals.Add("false", 10);
			literals.Add("protected", 113);
			literals.Add("ref", 36);
			literals.Add("base", 45);
			literals.Add("default", 85);
			literals.Add("do", 93);
			literals.Add("out", 37);
			literals.Add("params", 126);
			literals.Add("catch", 103);
			literals.Add("interface", 110);
			literals.Add("volatile", 121);
			literals.Add("is", 58);
			literals.Add("ulong", 26);
			literals.Add("explicit", 130);
			literals.Add("yield", 83);
			literals.Add("internal", 114);
			literals.Add("if", 88);
			literals.Add("double", 29);
			literals.Add("override", 124);
			literals.Add("as", 59);
			literals.Add("delegate", 40);
			literals.Add("implicit", 129);
			literals.Add("try", 102);
			literals.Add("ushort", 27);
			literals.Add("goto", 99);
			literals.Add("enum", 108);
			literals.Add("int", 20);
			literals.Add("for", 94);
			literals.Add("event", 127);
			literals.Add("char", 19);
			literals.Add("private", 115);
			literals.Add("string", 16);
			literals.Add("class", 111);
			literals.Add("unsafe", 134);
			literals.Add("this", 44);
			literals.Add("static", 118);
			literals.Add("fixed", 133);
			literals.Add("operator", 128);
			literals.Add("using", 106);
			literals.Add("throw", 101);
			literals.Add("foreach", 95);
			literals.Add("float", 28);
			literals.Add("const", 82);
			literals.Add("continue", 98);
			literals.Add("bool", 17);
			literals.Add("struct", 109);
			literals.Add("typeof", 46);
			literals.Add("decimal", 18);
			literals.Add("stackalloc", 132);
			literals.Add("else", 89);
			literals.Add("in", 96);
			literals.Add("where", 122);
			literals.Add("void", 47);
			literals.Add("switch", 90);
			literals.Add("sbyte", 22);
			literals.Add("true", 9);
			literals.Add("long", 21);
			literals.Add("virtual", 123);
			literals.Add("while", 92);
			literals.Add("break", 97);
			literals.Add("short", 24);
		}
		
		override public Token nextToken()			//throws TokenStreamException
		{
			Token theRetToken = null;
tryAgain:
			for (;;)
			{
				Token _token = null;
				int _ttype = Token.INVALID_TYPE;
				resetText();
				try     // for char stream error handling
				{
					try     // for lexical error handling
					{
						switch ( LA(1) )
						{
						case '\t':  case '\n':  case '\u000b':  case '\u000c':
						case '\r':  case ' ':  case '\u2028':  case '\u2029':
						{
							mWHITESPACE(true);
							theRetToken = returnToken_;
							break;
						}
						case '\\':
						{
							mUNICODE_ESCAPE_SEQUENCE(true);
							theRetToken = returnToken_;
							break;
						}
						case '\'':
						{
							mCHARACTER_LITERAL(true);
							theRetToken = returnToken_;
							break;
						}
						case '{':
						{
							mLBRACE(true);
							theRetToken = returnToken_;
							break;
						}
						case '}':
						{
							mRBRACE(true);
							theRetToken = returnToken_;
							break;
						}
						case '[':
						{
							mLBRACK(true);
							theRetToken = returnToken_;
							break;
						}
						case ']':
						{
							mRBRACK(true);
							theRetToken = returnToken_;
							break;
						}
						case '(':
						{
							mLPAREN(true);
							theRetToken = returnToken_;
							break;
						}
						case ')':
						{
							mRPAREN(true);
							theRetToken = returnToken_;
							break;
						}
						case '~':
						{
							mBNOT(true);
							theRetToken = returnToken_;
							break;
						}
						case ',':
						{
							mCOMMA(true);
							theRetToken = returnToken_;
							break;
						}
						case ':':
						{
							mCOLON(true);
							theRetToken = returnToken_;
							break;
						}
						case ';':
						{
							mSEMI(true);
							theRetToken = returnToken_;
							break;
						}
						case '?':
						{
							mQUESTION(true);
							theRetToken = returnToken_;
							break;
						}
						default:
							if ((LA(1)=='<') && (LA(2)=='<') && (LA(3)=='='))
							{
								mSL_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='>') && (LA(2)=='>') && (LA(3)=='=')) {
								mSR_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='/') && (LA(2)=='/')) {
								mSINGLE_LINE_COMMENT(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='/') && (LA(2)=='*')) {
								mDELIMITED_COMMENT(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='0') && (LA(2)=='X'||LA(2)=='x')) {
								mHEXADECIMAL_INTEGER_LITERAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='"') && (tokenSet_0_.member(LA(2)))) {
								mREGULAR_STRING_LITERAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='@') && (LA(2)=='"')) {
								mVERBATIM_STRING_LITERAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='+') && (LA(2)=='=')) {
								mPLUS_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='-') && (LA(2)=='=')) {
								mMINUS_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='*') && (LA(2)=='=')) {
								mSTAR_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='/') && (LA(2)=='=')) {
								mDIV_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='%') && (LA(2)=='=')) {
								mMOD_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='+') && (LA(2)=='+')) {
								mINC(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='-') && (LA(2)=='-')) {
								mDEC(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='<') && (LA(2)=='<') && (true)) {
								mSL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='>') && (LA(2)=='>') && (true)) {
								mSR(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='&') && (LA(2)=='=')) {
								mBAND_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='|') && (LA(2)=='=')) {
								mBOR_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='^') && (LA(2)=='=')) {
								mBXOR_ASN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='=') && (LA(2)=='=')) {
								mEQUAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='<') && (LA(2)=='=')) {
								mLE(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='>') && (LA(2)=='=')) {
								mGE(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='!') && (LA(2)=='=')) {
								mNOT_EQUAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='|') && (LA(2)=='|')) {
								mLOR(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='&') && (LA(2)=='&')) {
								mLAND(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='#') && (tokenSet_1_.member(LA(2)))) {
								mPP_DIRECTIVE(true);
								theRetToken = returnToken_;
							}
							else if ((tokenSet_2_.member(LA(1))) && (true)) {
								mIDENTIFIER(true);
								theRetToken = returnToken_;
							}
							else if ((tokenSet_3_.member(LA(1))) && (true)) {
								mNUMERIC_LITERAL(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='+') && (true)) {
								mPLUS(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='-') && (true)) {
								mMINUS(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='*') && (true)) {
								mSTAR(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='/') && (true)) {
								mDIV(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='%') && (true)) {
								mMOD(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='&') && (true)) {
								mBAND(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='|') && (true)) {
								mBOR(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='^') && (true)) {
								mBXOR(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='=') && (true)) {
								mASSIGN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='<') && (true)) {
								mLTHAN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='>') && (true)) {
								mGTHAN(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='!') && (true)) {
								mLNOT(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='#') && (true)) {
								mHASH(true);
								theRetToken = returnToken_;
							}
							else if ((LA(1)=='"') && (true)) {
								mQUOTE(true);
								theRetToken = returnToken_;
							}
						else
						{
							if (LA(1)==EOF_CHAR) { uponEOF(); returnToken_ = makeToken(Token.EOF_TYPE); }
				else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());}
						}
						break; }
						if ( null==returnToken_ ) goto tryAgain; // found SKIP token
						_ttype = returnToken_.Type;
						_ttype = testLiteralsTable(_ttype);
						returnToken_.Type = _ttype;
						return returnToken_;
					}
					catch (RecognitionException e) {
							throw new TokenStreamRecognitionException(e);
					}
				}
				catch (CharStreamException cse) {
					if ( cse is CharStreamIOException ) {
						throw new TokenStreamIOException(((CharStreamIOException)cse).io);
					}
					else {
						throw new TokenStreamException(cse.Message);
					}
				}
			}
		}
		
	protected void mNEW_LINE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = NEW_LINE;
		
		switch ( LA(1) )
		{
		case '\n':
		{
			match('\u000A');
			if (0==inputState.guessing)
			{
				newline();
			}
			break;
		}
		case '\u2028':
		{
			match('\u2028');
			if (0==inputState.guessing)
			{
				newline();
			}
			break;
		}
		case '\u2029':
		{
			match('\u2029');
			if (0==inputState.guessing)
			{
				newline();
			}
			break;
		}
		default:
			bool synPredMatched622 = false;
			if (((LA(1)=='\r') && (LA(2)=='\n') && (true) && (true)))
			{
				int _m622 = mark();
				synPredMatched622 = true;
				inputState.guessing++;
				try {
					{
						match('\u000D');
						match('\u000A');
					}
				}
				catch (RecognitionException)
				{
					synPredMatched622 = false;
				}
				rewind(_m622);
				inputState.guessing--;
			}
			if ( synPredMatched622 )
			{
				match('\u000D');
				match('\u000A');
				if (0==inputState.guessing)
				{
					newline();
				}
			}
			else if ((LA(1)=='\r') && (true) && (true) && (true)) {
				match('\u000D');
				if (0==inputState.guessing)
				{
					newline();
				}
			}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		break; }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mWHITESPACE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = WHITESPACE;
		
		{ // ( ... )+
		int _cnt625=0;
		for (;;)
		{
			switch ( LA(1) )
			{
			case ' ':
			{
				match(' ');
				break;
			}
			case '\t':
			{
				match('\u0009');
				break;
			}
			case '\u000b':
			{
				match('\u000B');
				break;
			}
			case '\u000c':
			{
				match('\u000C');
				break;
			}
			case '\n':  case '\r':  case '\u2028':  case '\u2029':
			{
				mNEW_LINE(false);
				break;
			}
			default:
			{
				if (_cnt625 >= 1) { goto _loop625_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
			}
			break; }
			_cnt625++;
		}
_loop625_breakloop:		;
		}    // ( ... )+
		if (0==inputState.guessing)
		{
			
			_ttype = Token.SKIP;
			ExtendedToken.AddToWhitespaces (text.ToString(_begin, text.Length-_begin)) ;            
			
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mNEW_LINE_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = NEW_LINE_CHARACTER;
		
		{
			switch ( LA(1) )
			{
			case '\r':
			{
				match('\u000D');
				break;
			}
			case '\n':
			{
				match('\u000A');
				break;
			}
			case '\u2028':
			{
				match('\u2028');
				break;
			}
			case '\u2029':
			{
				match('\u2029');
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mNOT_NEW_LINE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = NOT_NEW_LINE;
		
		{
			match(tokenSet_0_);
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSINGLE_LINE_COMMENT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SINGLE_LINE_COMMENT;
		
		match("//");
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_0_.member(LA(1))) && (tokenSet_4_.member(LA(2))) && (true) && (true))
				{
					mNOT_NEW_LINE(false);
				}
				else if ((LA(1)=='`') && (tokenSet_4_.member(LA(2))) && (true) && (true)) {
					match('`');
				}
				else
				{
					goto _loop632_breakloop;
				}
				
			}
_loop632_breakloop:			;
		}    // ( ... )*
		{
			mNEW_LINE(false);
		}
		if (0==inputState.guessing)
		{
			
			_ttype = Token.SKIP;
			ExtendedToken.AddToWhitespaces (text.ToString(_begin, text.Length-_begin));
			
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mDELIMITED_COMMENT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = DELIMITED_COMMENT;
		
		match("/*");
		{    // ( ... )*
			for (;;)
			{
				if (((LA(1)=='*') && (tokenSet_4_.member(LA(2))) && (tokenSet_4_.member(LA(3))))&&( LA(2)!='/' ))
				{
					match('*');
				}
				else if ((LA(1)=='`') && (tokenSet_4_.member(LA(2))) && (tokenSet_4_.member(LA(3))) && (true)) {
					match('`');
				}
				else if ((tokenSet_5_.member(LA(1))) && (tokenSet_4_.member(LA(2))) && (tokenSet_4_.member(LA(3))) && (true)) {
					{
						match(tokenSet_5_);
					}
				}
				else if ((tokenSet_6_.member(LA(1)))) {
					mNEW_LINE(false);
				}
				else
				{
					goto _loop637_breakloop;
				}
				
			}
_loop637_breakloop:			;
		}    // ( ... )*
		match("*/");
		if (0==inputState.guessing)
		{
			
			_ttype = Token.SKIP;
			ExtendedToken.AddToWhitespaces (text.ToString(_begin, text.Length-_begin));
			
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mUNICODE_ESCAPE_SEQUENCE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = UNICODE_ESCAPE_SEQUENCE;
		
		if ((LA(1)=='\\') && (LA(2)=='u'))
		{
			{
				match('\\');
				match('u');
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
			}
		}
		else if ((LA(1)=='\\') && (LA(2)=='U')) {
			{
				match('\\');
				match('U');
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
				mHEX_DIGIT(false);
			}
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mHEX_DIGIT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = HEX_DIGIT;
		
		switch ( LA(1) )
		{
		case '0':
		{
			match('0');
			break;
		}
		case '1':
		{
			match('1');
			break;
		}
		case '2':
		{
			match('2');
			break;
		}
		case '3':
		{
			match('3');
			break;
		}
		case '4':
		{
			match('4');
			break;
		}
		case '5':
		{
			match('5');
			break;
		}
		case '6':
		{
			match('6');
			break;
		}
		case '7':
		{
			match('7');
			break;
		}
		case '8':
		{
			match('8');
			break;
		}
		case '9':
		{
			match('9');
			break;
		}
		case 'A':
		{
			match('A');
			break;
		}
		case 'B':
		{
			match('B');
			break;
		}
		case 'C':
		{
			match('C');
			break;
		}
		case 'D':
		{
			match('D');
			break;
		}
		case 'E':
		{
			match('E');
			break;
		}
		case 'F':
		{
			match('F');
			break;
		}
		case 'a':
		{
			match('a');
			break;
		}
		case 'b':
		{
			match('b');
			break;
		}
		case 'c':
		{
			match('c');
			break;
		}
		case 'd':
		{
			match('d');
			break;
		}
		case 'e':
		{
			match('e');
			break;
		}
		case 'f':
		{
			match('f');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mIDENTIFIER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = IDENTIFIER;
		
		switch ( LA(1) )
		{
		case '$':  case 'A':  case 'B':  case 'C':
		case 'D':  case 'E':  case 'F':  case 'G':
		case 'H':  case 'I':  case 'J':  case 'K':
		case 'L':  case 'M':  case 'N':  case 'O':
		case 'P':  case 'Q':  case 'R':  case 'S':
		case 'T':  case 'U':  case 'V':  case 'W':
		case 'X':  case 'Y':  case 'Z':  case '_':
		case 'a':  case 'b':  case 'c':  case 'd':
		case 'e':  case 'f':  case 'g':  case 'h':
		case 'i':  case 'j':  case 'k':  case 'l':
		case 'm':  case 'n':  case 'o':  case 'p':
		case 'q':  case 'r':  case 's':  case 't':
		case 'u':  case 'v':  case 'w':  case 'x':
		case 'y':  case 'z':
		{
			mIDENTIFIER_START_CHARACTER(false);
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_7_.member(LA(1))))
					{
						mIDENTIFIER_PART_CHARACTER(false);
					}
					else
					{
						goto _loop643_breakloop;
					}
					
				}
_loop643_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				
					if(text.ToString(_begin, text.Length-_begin) == "list")	
					   setText("list_");
					if(text.ToString(_begin, text.Length-_begin) == "array")	
					   setText("array_");   
					if(text.ToString(_begin, text.Length-_begin) == "type")	
					   setText("type_");   
					
			}
			break;
		}
		case '@':
		{
			match('@');
			mIDENTIFIER_START_CHARACTER(false);
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_7_.member(LA(1))))
					{
						mIDENTIFIER_PART_CHARACTER(false);
					}
					else
					{
						goto _loop645_breakloop;
					}
					
				}
_loop645_breakloop:				;
			}    // ( ... )*
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mIDENTIFIER_START_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = IDENTIFIER_START_CHARACTER;
		
		{
			switch ( LA(1) )
			{
			case 'a':  case 'b':  case 'c':  case 'd':
			case 'e':  case 'f':  case 'g':  case 'h':
			case 'i':  case 'j':  case 'k':  case 'l':
			case 'm':  case 'n':  case 'o':  case 'p':
			case 'q':  case 'r':  case 's':  case 't':
			case 'u':  case 'v':  case 'w':  case 'x':
			case 'y':  case 'z':
			{
				matchRange('a','z');
				break;
			}
			case 'A':  case 'B':  case 'C':  case 'D':
			case 'E':  case 'F':  case 'G':  case 'H':
			case 'I':  case 'J':  case 'K':  case 'L':
			case 'M':  case 'N':  case 'O':  case 'P':
			case 'Q':  case 'R':  case 'S':  case 'T':
			case 'U':  case 'V':  case 'W':  case 'X':
			case 'Y':  case 'Z':
			{
				matchRange('A','Z');
				break;
			}
			case '_':
			{
				match('_');
				break;
			}
			case '$':
			{
				match('$');
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mIDENTIFIER_PART_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = IDENTIFIER_PART_CHARACTER;
		
		{
			switch ( LA(1) )
			{
			case 'a':  case 'b':  case 'c':  case 'd':
			case 'e':  case 'f':  case 'g':  case 'h':
			case 'i':  case 'j':  case 'k':  case 'l':
			case 'm':  case 'n':  case 'o':  case 'p':
			case 'q':  case 'r':  case 's':  case 't':
			case 'u':  case 'v':  case 'w':  case 'x':
			case 'y':  case 'z':
			{
				matchRange('a','z');
				break;
			}
			case 'A':  case 'B':  case 'C':  case 'D':
			case 'E':  case 'F':  case 'G':  case 'H':
			case 'I':  case 'J':  case 'K':  case 'L':
			case 'M':  case 'N':  case 'O':  case 'P':
			case 'Q':  case 'R':  case 'S':  case 'T':
			case 'U':  case 'V':  case 'W':  case 'X':
			case 'Y':  case 'Z':
			{
				matchRange('A','Z');
				break;
			}
			case '_':
			{
				match('_');
				break;
			}
			case '0':  case '1':  case '2':  case '3':
			case '4':  case '5':  case '6':  case '7':
			case '8':  case '9':
			{
				matchRange('0','9');
				break;
			}
			case '$':
			{
				match('$');
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mDECIMAL_DIGIT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = DECIMAL_DIGIT;
		
		switch ( LA(1) )
		{
		case '0':
		{
			match('0');
			break;
		}
		case '1':
		{
			match('1');
			break;
		}
		case '2':
		{
			match('2');
			break;
		}
		case '3':
		{
			match('3');
			break;
		}
		case '4':
		{
			match('4');
			break;
		}
		case '5':
		{
			match('5');
			break;
		}
		case '6':
		{
			match('6');
			break;
		}
		case '7':
		{
			match('7');
			break;
		}
		case '8':
		{
			match('8');
			break;
		}
		case '9':
		{
			match('9');
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mHEXADECIMAL_INTEGER_LITERAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = HEXADECIMAL_INTEGER_LITERAL;
		
		if ((LA(1)=='0') && (LA(2)=='x'))
		{
			match("0x");
			{ // ( ... )+
			int _cnt653=0;
			for (;;)
			{
				if ((tokenSet_8_.member(LA(1))))
				{
					mHEX_DIGIT(false);
				}
				else
				{
					if (_cnt653 >= 1) { goto _loop653_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt653++;
			}
_loop653_breakloop:			;
			}    // ( ... )+
			{
				if ((tokenSet_9_.member(LA(1))))
				{
					mINTEGER_TYPE_SUFFIX(false);
				}
				else {
				}
				
			}
		}
		else if ((LA(1)=='0') && (LA(2)=='X')) {
			match("0X");
			{ // ( ... )+
			int _cnt656=0;
			for (;;)
			{
				if ((tokenSet_8_.member(LA(1))))
				{
					mHEX_DIGIT(false);
				}
				else
				{
					if (_cnt656 >= 1) { goto _loop656_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt656++;
			}
_loop656_breakloop:			;
			}    // ( ... )+
			{
				if ((tokenSet_9_.member(LA(1))))
				{
					mINTEGER_TYPE_SUFFIX(false);
				}
				else {
				}
				
			}
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mINTEGER_TYPE_SUFFIX(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = INTEGER_TYPE_SUFFIX;
		
		if ((LA(1)=='U') && (LA(2)=='L'))
		{
			match("UL");
		}
		else if ((LA(1)=='U') && (LA(2)=='l')) {
			match("Ul");
		}
		else if ((LA(1)=='u') && (LA(2)=='L')) {
			match("uL");
		}
		else if ((LA(1)=='u') && (LA(2)=='l')) {
			match("ul");
		}
		else if ((LA(1)=='L') && (LA(2)=='U')) {
			match("LU");
		}
		else if ((LA(1)=='L') && (LA(2)=='u')) {
			match("Lu");
		}
		else if ((LA(1)=='l') && (LA(2)=='U')) {
			match("lU");
		}
		else if ((LA(1)=='l') && (LA(2)=='u')) {
			match("lu");
		}
		else if ((LA(1)=='U') && (true)) {
			match('U');
		}
		else if ((LA(1)=='u') && (true)) {
			match('u');
		}
		else if ((LA(1)=='L') && (true)) {
			match('L');
		}
		else if ((LA(1)=='l') && (true)) {
			match('l');
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mNUMERIC_LITERAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = NUMERIC_LITERAL;
		
		bool synPredMatched671 = false;
		if ((((LA(1) >= '0' && LA(1) <= '9')) && (tokenSet_3_.member(LA(2))) && (tokenSet_3_.member(LA(3))) && (true)))
		{
			int _m671 = mark();
			synPredMatched671 = true;
			inputState.guessing++;
			try {
				{
					{ // ( ... )+
					int _cnt670=0;
					for (;;)
					{
						if (((LA(1) >= '0' && LA(1) <= '9')))
						{
							mDECIMAL_DIGIT(false);
						}
						else
						{
							if (_cnt670 >= 1) { goto _loop670_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
						}
						
						_cnt670++;
					}
_loop670_breakloop:					;
					}    // ( ... )+
					match(".");
				}
			}
			catch (RecognitionException)
			{
				synPredMatched671 = false;
			}
			rewind(_m671);
			inputState.guessing--;
		}
		if ( synPredMatched671 )
		{
			{ // ( ... )+
			int _cnt673=0;
			for (;;)
			{
				if (((LA(1) >= '0' && LA(1) <= '9')))
				{
					mDECIMAL_DIGIT(false);
				}
				else
				{
					if (_cnt673 >= 1) { goto _loop673_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt673++;
			}
_loop673_breakloop:			;
			}    // ( ... )+
			match(".");
			{ // ( ... )+
			int _cnt675=0;
			for (;;)
			{
				if (((LA(1) >= '0' && LA(1) <= '9')))
				{
					mDECIMAL_DIGIT(false);
				}
				else
				{
					if (_cnt675 >= 1) { goto _loop675_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt675++;
			}
_loop675_breakloop:			;
			}    // ( ... )+
			{
				if ((LA(1)=='E'||LA(1)=='e'))
				{
					mEXPONENT_PART(false);
				}
				else {
				}
				
			}
			{
				if ((tokenSet_10_.member(LA(1))))
				{
					{
						switch ( LA(1) )
						{
						case 'F':
						{
							match("F");
							break;
						}
						case 'f':
						{
							match("f");
							break;
						}
						case 'D':
						{
							match("D");
							break;
						}
						case 'd':
						{
							match("d");
							break;
						}
						case 'M':
						{
							match("M");
							break;
						}
						case 'm':
						{
							match("m");
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
				}
				else {
				}
				
			}
			if (0==inputState.guessing)
			{
				_ttype = REAL_LITERAL;
			}
		}
		else {
			bool synPredMatched682 = false;
			if ((((LA(1) >= '0' && LA(1) <= '9')) && (tokenSet_11_.member(LA(2))) && (tokenSet_12_.member(LA(3))) && (true)))
			{
				int _m682 = mark();
				synPredMatched682 = true;
				inputState.guessing++;
				try {
					{
						{ // ( ... )+
						int _cnt681=0;
						for (;;)
						{
							if (((LA(1) >= '0' && LA(1) <= '9')))
							{
								mDECIMAL_DIGIT(false);
							}
							else
							{
								if (_cnt681 >= 1) { goto _loop681_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
							}
							
							_cnt681++;
						}
_loop681_breakloop:						;
						}    // ( ... )+
						mEXPONENT_PART(false);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched682 = false;
				}
				rewind(_m682);
				inputState.guessing--;
			}
			if ( synPredMatched682 )
			{
				{ // ( ... )+
				int _cnt684=0;
				for (;;)
				{
					if (((LA(1) >= '0' && LA(1) <= '9')))
					{
						mDECIMAL_DIGIT(false);
					}
					else
					{
						if (_cnt684 >= 1) { goto _loop684_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
					}
					
					_cnt684++;
				}
_loop684_breakloop:				;
				}    // ( ... )+
				mEXPONENT_PART(false);
				{
					if ((tokenSet_10_.member(LA(1))))
					{
						{
							switch ( LA(1) )
							{
							case 'F':
							{
								match("F");
								break;
							}
							case 'f':
							{
								match("f");
								break;
							}
							case 'D':
							{
								match("D");
								break;
							}
							case 'd':
							{
								match("d");
								break;
							}
							case 'M':
							{
								match("M");
								break;
							}
							case 'm':
							{
								match("m");
								break;
							}
							default:
							{
								throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
							}
							 }
						}
					}
					else {
					}
					
				}
				if (0==inputState.guessing)
				{
					_ttype = REAL_LITERAL;
				}
			}
			else {
				bool synPredMatched662 = false;
				if (((LA(1)=='.') && ((LA(2) >= '0' && LA(2) <= '9'))))
				{
					int _m662 = mark();
					synPredMatched662 = true;
					inputState.guessing++;
					try {
						{
							match(".");
						}
					}
					catch (RecognitionException)
					{
						synPredMatched662 = false;
					}
					rewind(_m662);
					inputState.guessing--;
				}
				if ( synPredMatched662 )
				{
					match(".");
					{ // ( ... )+
					int _cnt664=0;
					for (;;)
					{
						if (((LA(1) >= '0' && LA(1) <= '9')))
						{
							mDECIMAL_DIGIT(false);
						}
						else
						{
							if (_cnt664 >= 1) { goto _loop664_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
						}
						
						_cnt664++;
					}
_loop664_breakloop:					;
					}    // ( ... )+
					{
						if ((LA(1)=='E'||LA(1)=='e'))
						{
							mEXPONENT_PART(false);
						}
						else {
						}
						
					}
					{
						if ((tokenSet_10_.member(LA(1))))
						{
							{
								switch ( LA(1) )
								{
								case 'F':
								{
									match("F");
									break;
								}
								case 'f':
								{
									match("f");
									break;
								}
								case 'D':
								{
									match("D");
									break;
								}
								case 'd':
								{
									match("d");
									break;
								}
								case 'M':
								{
									match("M");
									break;
								}
								case 'm':
								{
									match("m");
									break;
								}
								default:
								{
									throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
								}
								 }
							}
						}
						else {
						}
						
					}
					if (0==inputState.guessing)
					{
						_ttype = REAL_LITERAL;
					}
				}
				else {
					bool synPredMatched691 = false;
					if ((((LA(1) >= '0' && LA(1) <= '9')) && (tokenSet_13_.member(LA(2))) && (true) && (true)))
					{
						int _m691 = mark();
						synPredMatched691 = true;
						inputState.guessing++;
						try {
							{
								{ // ( ... )+
								int _cnt689=0;
								for (;;)
								{
									if (((LA(1) >= '0' && LA(1) <= '9')))
									{
										mDECIMAL_DIGIT(false);
									}
									else
									{
										if (_cnt689 >= 1) { goto _loop689_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
									}
									
									_cnt689++;
								}
_loop689_breakloop:								;
								}    // ( ... )+
								{
									switch ( LA(1) )
									{
									case 'F':
									{
										match("F");
										break;
									}
									case 'f':
									{
										match("f");
										break;
									}
									case 'D':
									{
										match("D");
										break;
									}
									case 'd':
									{
										match("d");
										break;
									}
									case 'M':
									{
										match("M");
										break;
									}
									case 'm':
									{
										match("m");
										break;
									}
									default:
									{
										throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
									}
									 }
								}
							}
						}
						catch (RecognitionException)
						{
							synPredMatched691 = false;
						}
						rewind(_m691);
						inputState.guessing--;
					}
					if ( synPredMatched691 )
					{
						{ // ( ... )+
						int _cnt693=0;
						for (;;)
						{
							if (((LA(1) >= '0' && LA(1) <= '9')))
							{
								mDECIMAL_DIGIT(false);
							}
							else
							{
								if (_cnt693 >= 1) { goto _loop693_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
							}
							
							_cnt693++;
						}
_loop693_breakloop:						;
						}    // ( ... )+
						{
							switch ( LA(1) )
							{
							case 'F':
							{
								match("F");
								break;
							}
							case 'f':
							{
								match("f");
								break;
							}
							case 'D':
							{
								match("D");
								break;
							}
							case 'd':
							{
								match("d");
								break;
							}
							case 'M':
							{
								match("M");
								break;
							}
							case 'm':
							{
								match("m");
								break;
							}
							default:
							{
								throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
							}
							 }
						}
						if (0==inputState.guessing)
						{
							_ttype = REAL_LITERAL;
						}
					}
					else if (((LA(1) >= '0' && LA(1) <= '9')) && (true) && (true) && (true)) {
						{ // ( ... )+
						int _cnt696=0;
						for (;;)
						{
							if (((LA(1) >= '0' && LA(1) <= '9')))
							{
								mDECIMAL_DIGIT(false);
							}
							else
							{
								if (_cnt696 >= 1) { goto _loop696_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
							}
							
							_cnt696++;
						}
_loop696_breakloop:						;
						}    // ( ... )+
						{
							if ((tokenSet_9_.member(LA(1))))
							{
								mINTEGER_TYPE_SUFFIX(false);
							}
							else {
							}
							
						}
						if (0==inputState.guessing)
						{
							_ttype = INTEGER_LITERAL;
						}
					}
					else if ((LA(1)=='.') && (true)) {
						match('.');
						if (0==inputState.guessing)
						{
							_ttype = DOT;
						}
					}
					else
					{
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					}}}
					if (_createToken && (null == _token) && (_ttype != Token.SKIP))
					{
						_token = makeToken(_ttype);
						_token.setText(text.ToString(_begin, text.Length-_begin));
					}
					returnToken_ = _token;
				}
				
	protected void mEXPONENT_PART(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = EXPONENT_PART;
		
		switch ( LA(1) )
		{
		case 'e':
		{
			match("e");
			{
				switch ( LA(1) )
				{
				case '+':  case '-':
				{
					mSIGN(false);
					break;
				}
				case '0':  case '1':  case '2':  case '3':
				case '4':  case '5':  case '6':  case '7':
				case '8':  case '9':
				{
					break;
				}
				default:
				{
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				 }
			}
			{ // ( ... )+
			int _cnt706=0;
			for (;;)
			{
				if (((LA(1) >= '0' && LA(1) <= '9')))
				{
					mDECIMAL_DIGIT(false);
				}
				else
				{
					if (_cnt706 >= 1) { goto _loop706_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt706++;
			}
_loop706_breakloop:			;
			}    // ( ... )+
			break;
		}
		case 'E':
		{
			match("E");
			{
				switch ( LA(1) )
				{
				case '+':  case '-':
				{
					mSIGN(false);
					break;
				}
				case '0':  case '1':  case '2':  case '3':
				case '4':  case '5':  case '6':  case '7':
				case '8':  case '9':
				{
					break;
				}
				default:
				{
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				 }
			}
			{ // ( ... )+
			int _cnt709=0;
			for (;;)
			{
				if (((LA(1) >= '0' && LA(1) <= '9')))
				{
					mDECIMAL_DIGIT(false);
				}
				else
				{
					if (_cnt709 >= 1) { goto _loop709_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt709++;
			}
_loop709_breakloop:			;
			}    // ( ... )+
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mSIGN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SIGN;
		
		switch ( LA(1) )
		{
		case '+':
		{
			mPLUS(false);
			break;
		}
		case '-':
		{
			mMINUS(false);
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mPLUS(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PLUS;
		
		match('+');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mMINUS(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = MINUS;
		
		match('-');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mCHARACTER_LITERAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = CHARACTER_LITERAL;
		
		match("'");
		mCHARACTER(false);
		match("'");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mCHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = CHARACTER;
		
		if ((LA(1)=='\\') && (tokenSet_14_.member(LA(2))))
		{
			mSIMPLE_ESCAPE_SEQUENCE(false);
		}
		else if ((LA(1)=='\\') && (LA(2)=='x')) {
			mHEXADECIMAL_ESCAPE_SEQUENCE(false);
		}
		else if ((LA(1)=='\\') && (LA(2)=='U'||LA(2)=='u')) {
			mUNICODE_ESCAPE_SEQUENCE(false);
		}
		else if ((tokenSet_15_.member(LA(1)))) {
			mSIMPLE_CHARACTER(false);
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mSIMPLE_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SIMPLE_CHARACTER;
		
		{
			match(tokenSet_15_);
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mSIMPLE_ESCAPE_SEQUENCE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SIMPLE_ESCAPE_SEQUENCE;
		
		if ((LA(1)=='\\') && (LA(2)=='\''))
		{
			match("\\'");
		}
		else if ((LA(1)=='\\') && (LA(2)=='"')) {
			match("\\\"");
		}
		else if ((LA(1)=='\\') && (LA(2)=='\\')) {
			match("\\\\");
		}
		else if ((LA(1)=='\\') && (LA(2)=='0')) {
			match("\\0");
		}
		else if ((LA(1)=='\\') && (LA(2)=='a')) {
			match("\\a");
		}
		else if ((LA(1)=='\\') && (LA(2)=='b')) {
			match("\\b");
		}
		else if ((LA(1)=='\\') && (LA(2)=='f')) {
			match("\\f");
		}
		else if ((LA(1)=='\\') && (LA(2)=='n')) {
			match("\\n");
		}
		else if ((LA(1)=='\\') && (LA(2)=='r')) {
			match("\\r");
		}
		else if ((LA(1)=='\\') && (LA(2)=='t')) {
			match("\\t");
		}
		else if ((LA(1)=='\\') && (LA(2)=='v')) {
			match("\\v");
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mHEXADECIMAL_ESCAPE_SEQUENCE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = HEXADECIMAL_ESCAPE_SEQUENCE;
		
		{
			match('\\');
			match('x');
			mHEX_DIGIT(false);
		}
		{
			if ((tokenSet_8_.member(LA(1))) && (tokenSet_0_.member(LA(2))) && (true) && (true))
			{
				mHEX_DIGIT(false);
				{
					if ((tokenSet_8_.member(LA(1))) && (tokenSet_0_.member(LA(2))) && (true) && (true))
					{
						mHEX_DIGIT(false);
						{
							if ((tokenSet_8_.member(LA(1))) && (tokenSet_0_.member(LA(2))) && (true) && (true))
							{
								mHEX_DIGIT(false);
							}
							else if ((tokenSet_0_.member(LA(1))) && (true) && (true) && (true)) {
							}
							else
							{
								throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
							}
							
						}
					}
					else if ((tokenSet_0_.member(LA(1))) && (true) && (true) && (true)) {
					}
					else
					{
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					
				}
			}
			else if ((tokenSet_0_.member(LA(1))) && (true) && (true) && (true)) {
			}
			else
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mREGULAR_STRING_LITERAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = REGULAR_STRING_LITERAL;
		
		match('\"');
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_16_.member(LA(1))))
				{
					mREGULAR_STRING_LITERAL_CHARACTER(false);
				}
				else
				{
					goto _loop723_breakloop;
				}
				
			}
_loop723_breakloop:			;
		}    // ( ... )*
		match('\"');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mREGULAR_STRING_LITERAL_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = REGULAR_STRING_LITERAL_CHARACTER;
		
		if ((LA(1)=='\\') && (tokenSet_14_.member(LA(2))))
		{
			mSIMPLE_ESCAPE_SEQUENCE(false);
		}
		else if ((LA(1)=='\\') && (LA(2)=='x')) {
			mHEXADECIMAL_ESCAPE_SEQUENCE(false);
		}
		else if ((LA(1)=='\\') && (LA(2)=='U'||LA(2)=='u')) {
			mUNICODE_ESCAPE_SEQUENCE(false);
		}
		else if ((tokenSet_17_.member(LA(1)))) {
			mSINGLE_REGULAR_STRING_LITERAL_CHARCACTER(false);
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mSINGLE_REGULAR_STRING_LITERAL_CHARCACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SINGLE_REGULAR_STRING_LITERAL_CHARCACTER;
		
		{
			match(tokenSet_17_);
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mVERBATIM_STRING_LITERAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = VERBATIM_STRING_LITERAL;
		char  ch = '\0';
		string s="";
		
		match('@');
		match("\"");
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)=='"') && (LA(2)=='"'))
				{
					match("\"\"");
					if (0==inputState.guessing)
					{
						s+=("\"");
					}
				}
				else if ((LA(1)=='\\')) {
					match("\\");
					if (0==inputState.guessing)
					{
						s+=("\\\\");
					}
				}
				else if ((tokenSet_18_.member(LA(1)))) {
					{
						ch = LA(1);
						match(tokenSet_18_);
					}
					if (0==inputState.guessing)
					{
						s+=(ch);
					}
				}
				else
				{
					goto _loop730_breakloop;
				}
				
			}
_loop730_breakloop:			;
		}    // ( ... )*
		match("\"");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLBRACE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LBRACE;
		
		match('{');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mRBRACE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = RBRACE;
		
		match('}');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLBRACK(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LBRACK;
		
		match('[');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mRBRACK(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = RBRACK;
		
		match(']');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLPAREN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LPAREN;
		
		match('(');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mRPAREN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = RPAREN;
		
		match(')');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mPLUS_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PLUS_ASN;
		
		match("+=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mMINUS_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = MINUS_ASN;
		
		match("-=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSTAR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = STAR;
		
		match('*');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSTAR_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = STAR_ASN;
		
		match("*=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mDIV(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = DIV;
		
		match('/');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mDIV_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = DIV_ASN;
		
		match("/=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mMOD(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = MOD;
		
		match('%');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mMOD_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = MOD_ASN;
		
		match("%=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mINC(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = INC;
		
		match("++");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mDEC(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = DEC;
		
		match("--");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SL;
		
		match("<<");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSL_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SL_ASN;
		
		match("<<=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SR;
		
		match(">>");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSR_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SR_ASN;
		
		match(">>=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBAND(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BAND;
		
		match('&');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBAND_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BAND_ASN;
		
		match("&=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBOR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BOR;
		
		match('|');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBOR_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BOR_ASN;
		
		match("|=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBXOR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BXOR;
		
		match('^');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBXOR_ASN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BXOR_ASN;
		
		match("^=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mBNOT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = BNOT;
		
		match('~');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mASSIGN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = ASSIGN;
		
		match('=');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mEQUAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = EQUAL;
		
		match("==");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLTHAN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LTHAN;
		
		match('<');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LE;
		
		match("<=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mGTHAN(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = GTHAN;
		
		match(">");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mGE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = GE;
		
		match(">=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLNOT(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LNOT;
		
		match('!');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mNOT_EQUAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = NOT_EQUAL;
		
		match("!=");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLOR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LOR;
		
		match("||");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mLAND(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LAND;
		
		match("&&");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mCOMMA(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = COMMA;
		
		match(',');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mCOLON(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = COLON;
		
		match(':');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mSEMI(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = SEMI;
		
		match(';');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mHASH(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = HASH;
		
		match('#');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mQUOTE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = QUOTE;
		
		match("\"");
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mQUESTION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = QUESTION;
		
		match('?');
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	public void mPP_DIRECTIVE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_DIRECTIVE;
		Token h = null;
		
		mHASH(true);
		h = returnToken_;
		if (0==inputState.guessing)
		{
			Emit.EmitToken (h);
		}
		{
			switch ( LA(1) )
			{
			case '\t':  case '\u000b':  case '\u000c':  case ' ':
			{
				mPP_WHITESPACE(false);
				break;
			}
			case 'd':  case 'e':  case 'i':  case 'l':
			case 'r':  case 'u':  case 'w':
			{
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		{
			switch ( LA(1) )
			{
			case 'd':  case 'u':
			{
				mPP_DECLARATION(false);
				break;
			}
			case 'l':
			{
				mPP_LINE(false);
				break;
			}
			case 'r':
			{
				mPP_START_REGION(false);
				break;
			}
			default:
				bool synPredMatched780 = false;
				if (((LA(1)=='e') && (LA(2)=='n') && (LA(3)=='d') && (LA(4)=='r')))
				{
					int _m780 = mark();
					synPredMatched780 = true;
					inputState.guessing++;
					try {
						{
							mPP_END_REGION(false);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched780 = false;
					}
					rewind(_m780);
					inputState.guessing--;
				}
				if ( synPredMatched780 )
				{
					mPP_END_REGION(false);
				}
				else if ((LA(1)=='e'||LA(1)=='i') && (LA(2)=='f'||LA(2)=='l'||LA(2)=='n') && (tokenSet_19_.member(LA(3))) && (tokenSet_20_.member(LA(4)))) {
					mPP_CONDITIONAL(false);
				}
				else if ((LA(1)=='e'||LA(1)=='w') && (LA(2)=='a'||LA(2)=='r')) {
					mPP_DIAGNOSTIC(false);
				}
			else
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			break; }
		}
		if (0==inputState.guessing)
		{
			_ttype = Token.SKIP;
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_WHITESPACE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_WHITESPACE;
		
		{ // ( ... )+
		int _cnt783=0;
		for (;;)
		{
			switch ( LA(1) )
			{
			case ' ':
			{
				match(' ');
				if (0==inputState.guessing)
				{
					Emit.EmitChar (' ');
				}
				break;
			}
			case '\t':
			{
				match('\u0009');
				if (0==inputState.guessing)
				{
					Emit.EmitChar ('\u0009');
				}
				break;
			}
			case '\u000b':
			{
				match('\u000B');
				if (0==inputState.guessing)
				{
					Emit.EmitChar ('\u000B');
				}
				break;
			}
			case '\u000c':
			{
				match('\u000C');
				if (0==inputState.guessing)
				{
					Emit.EmitChar ('\u000C');
				}
				break;
			}
			default:
			{
				if (_cnt783 >= 1) { goto _loop783_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
			}
			break; }
			_cnt783++;
		}
_loop783_breakloop:		;
		}    // ( ... )+
		if (0==inputState.guessing)
		{
			_ttype = Token.SKIP;
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_DECLARATION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_DECLARATION;
		
		switch ( LA(1) )
		{
		case 'd':
		{
			match("define");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("define");
			}
			mPP_WHITESPACE(false);
			mCONDITIONAL_SYMBOL(false);
			mPP_NEW_LINE(false);
			if (0==inputState.guessing)
			{
				Emit.EmitChar ('\n');
			}
			break;
		}
		case 'u':
		{
			match("undef");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("undef");
			}
			mPP_WHITESPACE(false);
			mCONDITIONAL_SYMBOL(false);
			mPP_NEW_LINE(false);
			if (0==inputState.guessing)
			{
				Emit.EmitChar ('\n');
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_END_REGION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_END_REGION;
		
		match("endregion");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("endregion");
		}
		mPP_MESSAGE(false);
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_CONDITIONAL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_CONDITIONAL;
		
		if ((LA(1)=='e') && (LA(2)=='l') && (LA(3)=='i'))
		{
			mPP_ELIF_SECTION(false);
		}
		else if ((LA(1)=='e') && (LA(2)=='l') && (LA(3)=='s')) {
			mPP_ELSE_SECTION(false);
		}
		else if ((LA(1)=='e') && (LA(2)=='n')) {
			mPP_ENDIF(false);
		}
		else if ((LA(1)=='i')) {
			mPP_IF_SECTION(false);
		}
		else
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_LINE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_LINE;
		
		match("line");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("line");
		}
		mPP_WHITESPACE(false);
		mLINE_INDICATOR(false);
		mPP_NEW_LINE(false);
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_DIAGNOSTIC(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_DIAGNOSTIC;
		
		switch ( LA(1) )
		{
		case 'e':
		{
			match("error");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("error");
			}
			mPP_MESSAGE(false);
			break;
		}
		case 'w':
		{
			match("warning");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("warning");
			}
			mPP_MESSAGE(false);
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_START_REGION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_START_REGION;
		
		match("region");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("region");
		}
		mPP_MESSAGE(false);
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_NEW_LINE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_NEW_LINE;
		
		{
			switch ( LA(1) )
			{
			case '/':
			{
				mSINGLE_LINE_COMMENT(false);
				break;
			}
			case '\n':  case '\r':  case '\u2028':  case '\u2029':
			{
				mNEW_LINE(false);
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_EXPRESSION;
		
		mPP_OR_EXPRESSION(false);
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_OR_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_OR_EXPRESSION;
		Token x = null;
		
		mPP_AND_EXPRESSION(false);
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_21_.member(LA(1))) && (tokenSet_21_.member(LA(2))) && (tokenSet_22_.member(LA(3))) && (tokenSet_23_.member(LA(4))))
				{
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '|':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mLOR(true);
					x = returnToken_;
					if (0==inputState.guessing)
					{
						Emit.EmitToken (x);
					}
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '!':  case '$':  case '(':  case '@':
						case 'A':  case 'B':  case 'C':  case 'D':
						case 'E':  case 'F':  case 'G':  case 'H':
						case 'I':  case 'J':  case 'K':  case 'L':
						case 'M':  case 'N':  case 'O':  case 'P':
						case 'Q':  case 'R':  case 'S':  case 'T':
						case 'U':  case 'V':  case 'W':  case 'X':
						case 'Y':  case 'Z':  case '_':  case 'a':
						case 'b':  case 'c':  case 'd':  case 'e':
						case 'f':  case 'g':  case 'h':  case 'i':
						case 'j':  case 'k':  case 'l':  case 'm':
						case 'n':  case 'o':  case 'p':  case 'q':
						case 'r':  case 's':  case 't':  case 'u':
						case 'v':  case 'w':  case 'x':  case 'y':
						case 'z':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mPP_AND_EXPRESSION(false);
				}
				else
				{
					goto _loop791_breakloop;
				}
				
			}
_loop791_breakloop:			;
		}    // ( ... )*
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_AND_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_AND_EXPRESSION;
		Token x = null;
		
		mPP_EQUALITY_EXPRESSION(false);
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_24_.member(LA(1))) && (tokenSet_24_.member(LA(2))) && (tokenSet_25_.member(LA(3))) && (tokenSet_23_.member(LA(4))))
				{
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '&':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mLAND(true);
					x = returnToken_;
					if (0==inputState.guessing)
					{
						Emit.EmitToken (x);
					}
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '!':  case '$':  case '(':  case '@':
						case 'A':  case 'B':  case 'C':  case 'D':
						case 'E':  case 'F':  case 'G':  case 'H':
						case 'I':  case 'J':  case 'K':  case 'L':
						case 'M':  case 'N':  case 'O':  case 'P':
						case 'Q':  case 'R':  case 'S':  case 'T':
						case 'U':  case 'V':  case 'W':  case 'X':
						case 'Y':  case 'Z':  case '_':  case 'a':
						case 'b':  case 'c':  case 'd':  case 'e':
						case 'f':  case 'g':  case 'h':  case 'i':
						case 'j':  case 'k':  case 'l':  case 'm':
						case 'n':  case 'o':  case 'p':  case 'q':
						case 'r':  case 's':  case 't':  case 'u':
						case 'v':  case 'w':  case 'x':  case 'y':
						case 'z':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mPP_EQUALITY_EXPRESSION(false);
				}
				else
				{
					goto _loop796_breakloop;
				}
				
			}
_loop796_breakloop:			;
		}    // ( ... )*
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_EQUALITY_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_EQUALITY_EXPRESSION;
		Token x = null;
		
		mPP_UNARY_EXPRESSION(false);
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_26_.member(LA(1))) && (tokenSet_26_.member(LA(2))) && (tokenSet_27_.member(LA(3))) && (tokenSet_23_.member(LA(4))))
				{
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '!':  case '=':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mEQUALITY_OP(true);
					x = returnToken_;
					if (0==inputState.guessing)
					{
						Emit.EmitToken (x);
					}
					{
						switch ( LA(1) )
						{
						case '\t':  case '\u000b':  case '\u000c':  case ' ':
						{
							mPP_WHITESPACE(false);
							break;
						}
						case '!':  case '$':  case '(':  case '@':
						case 'A':  case 'B':  case 'C':  case 'D':
						case 'E':  case 'F':  case 'G':  case 'H':
						case 'I':  case 'J':  case 'K':  case 'L':
						case 'M':  case 'N':  case 'O':  case 'P':
						case 'Q':  case 'R':  case 'S':  case 'T':
						case 'U':  case 'V':  case 'W':  case 'X':
						case 'Y':  case 'Z':  case '_':  case 'a':
						case 'b':  case 'c':  case 'd':  case 'e':
						case 'f':  case 'g':  case 'h':  case 'i':
						case 'j':  case 'k':  case 'l':  case 'm':
						case 'n':  case 'o':  case 'p':  case 'q':
						case 'r':  case 's':  case 't':  case 'u':
						case 'v':  case 'w':  case 'x':  case 'y':
						case 'z':
						{
							break;
						}
						default:
						{
							throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
						}
						 }
					}
					mPP_UNARY_EXPRESSION(false);
				}
				else
				{
					goto _loop801_breakloop;
				}
				
			}
_loop801_breakloop:			;
		}    // ( ... )*
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_UNARY_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_UNARY_EXPRESSION;
		Token n = null;
		
		switch ( LA(1) )
		{
		case '$':  case '(':  case '@':  case 'A':
		case 'B':  case 'C':  case 'D':  case 'E':
		case 'F':  case 'G':  case 'H':  case 'I':
		case 'J':  case 'K':  case 'L':  case 'M':
		case 'N':  case 'O':  case 'P':  case 'Q':
		case 'R':  case 'S':  case 'T':  case 'U':
		case 'V':  case 'W':  case 'X':  case 'Y':
		case 'Z':  case '_':  case 'a':  case 'b':
		case 'c':  case 'd':  case 'e':  case 'f':
		case 'g':  case 'h':  case 'i':  case 'j':
		case 'k':  case 'l':  case 'm':  case 'n':
		case 'o':  case 'p':  case 'q':  case 'r':
		case 's':  case 't':  case 'u':  case 'v':
		case 'w':  case 'x':  case 'y':  case 'z':
		{
			mPP_PRIMARY_EXPRESSION(false);
			break;
		}
		case '!':
		{
			mLNOT(true);
			n = returnToken_;
			if (0==inputState.guessing)
			{
				Emit.EmitToken (n);
			}
			{
				switch ( LA(1) )
				{
				case '\t':  case '\u000b':  case '\u000c':  case ' ':
				{
					mPP_WHITESPACE(false);
					break;
				}
				case '!':  case '$':  case '(':  case '@':
				case 'A':  case 'B':  case 'C':  case 'D':
				case 'E':  case 'F':  case 'G':  case 'H':
				case 'I':  case 'J':  case 'K':  case 'L':
				case 'M':  case 'N':  case 'O':  case 'P':
				case 'Q':  case 'R':  case 'S':  case 'T':
				case 'U':  case 'V':  case 'W':  case 'X':
				case 'Y':  case 'Z':  case '_':  case 'a':
				case 'b':  case 'c':  case 'd':  case 'e':
				case 'f':  case 'g':  case 'h':  case 'i':
				case 'j':  case 'k':  case 'l':  case 'm':
				case 'n':  case 'o':  case 'p':  case 'q':
				case 'r':  case 's':  case 't':  case 'u':
				case 'v':  case 'w':  case 'x':  case 'y':
				case 'z':
				{
					break;
				}
				default:
				{
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				 }
			}
			mPP_UNARY_EXPRESSION(false);
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mEQUALITY_OP(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = EQUALITY_OP;
		Token e = null;
		Token ne = null;
		
		switch ( LA(1) )
		{
		case '=':
		{
			mEQUAL(true);
			e = returnToken_;
			if (0==inputState.guessing)
			{
				Emit.EmitToken (e);
			}
			break;
		}
		case '!':
		{
			mNOT_EQUAL(true);
			ne = returnToken_;
			if (0==inputState.guessing)
			{
				Emit.EmitToken (ne);
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_PRIMARY_EXPRESSION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_PRIMARY_EXPRESSION;
		Token lp = null;
		Token rp = null;
		
		bool synPredMatched807 = false;
		if (((LA(1)=='t') && (LA(2)=='r') && (LA(3)=='u') && (LA(4)=='e')))
		{
			int _m807 = mark();
			synPredMatched807 = true;
			inputState.guessing++;
			try {
				{
					match("true");
				}
			}
			catch (RecognitionException)
			{
				synPredMatched807 = false;
			}
			rewind(_m807);
			inputState.guessing--;
		}
		if ( synPredMatched807 )
		{
			match("true");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("true");
			}
		}
		else {
			bool synPredMatched809 = false;
			if (((LA(1)=='f') && (LA(2)=='a') && (LA(3)=='l') && (LA(4)=='s')))
			{
				int _m809 = mark();
				synPredMatched809 = true;
				inputState.guessing++;
				try {
					{
						match("false");
					}
				}
				catch (RecognitionException)
				{
					synPredMatched809 = false;
				}
				rewind(_m809);
				inputState.guessing--;
			}
			if ( synPredMatched809 )
			{
				match("false");
				if (0==inputState.guessing)
				{
					Emit.EmitString ("false");
				}
			}
			else if ((tokenSet_2_.member(LA(1))) && (tokenSet_28_.member(LA(2))) && (true) && (true)) {
				mCONDITIONAL_SYMBOL(false);
			}
			else if ((LA(1)=='(')) {
				mLPAREN(true);
				lp = returnToken_;
				if (0==inputState.guessing)
				{
					Emit.EmitToken (lp);
				}
				{
					switch ( LA(1) )
					{
					case '\t':  case '\u000b':  case '\u000c':  case ' ':
					{
						mPP_WHITESPACE(false);
						break;
					}
					case '!':  case '$':  case '(':  case '@':
					case 'A':  case 'B':  case 'C':  case 'D':
					case 'E':  case 'F':  case 'G':  case 'H':
					case 'I':  case 'J':  case 'K':  case 'L':
					case 'M':  case 'N':  case 'O':  case 'P':
					case 'Q':  case 'R':  case 'S':  case 'T':
					case 'U':  case 'V':  case 'W':  case 'X':
					case 'Y':  case 'Z':  case '_':  case 'a':
					case 'b':  case 'c':  case 'd':  case 'e':
					case 'f':  case 'g':  case 'h':  case 'i':
					case 'j':  case 'k':  case 'l':  case 'm':
					case 'n':  case 'o':  case 'p':  case 'q':
					case 'r':  case 's':  case 't':  case 'u':
					case 'v':  case 'w':  case 'x':  case 'y':
					case 'z':
					{
						break;
					}
					default:
					{
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					 }
				}
				mPP_EXPRESSION(false);
				{
					switch ( LA(1) )
					{
					case '\t':  case '\u000b':  case '\u000c':  case ' ':
					{
						mPP_WHITESPACE(false);
						break;
					}
					case ')':
					{
						break;
					}
					default:
					{
						throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
					}
					 }
				}
				mRPAREN(true);
				rp = returnToken_;
				if (0==inputState.guessing)
				{
					Emit.EmitToken (rp);
				}
			}
			else
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			}
			if (_createToken && (null == _token) && (_ttype != Token.SKIP))
			{
				_token = makeToken(_ttype);
				_token.setText(text.ToString(_begin, text.Length-_begin));
			}
			returnToken_ = _token;
		}
		
	protected void mCONDITIONAL_SYMBOL(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = CONDITIONAL_SYMBOL;
		Token i = null;
		
		mIDENTIFIER(true);
		i = returnToken_;
		if (0==inputState.guessing)
		{
			Emit.EmitToken (i);
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_IF_SECTION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_IF_SECTION;
		
		match("if");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("if");
		}
		mPP_WHITESPACE(false);
		mPP_EXPRESSION(false);
		{
			switch ( LA(1) )
			{
			case '\t':  case '\u000b':  case '\u000c':  case ' ':
			{
				mPP_WHITESPACE(false);
				break;
			}
			case '\n':  case '\r':  case '/':  case '\u2028':
			case '\u2029':
			{
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		mPP_NEW_LINE(false);
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\n');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_ELIF_SECTION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_ELIF_SECTION;
		
		match("elif");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("elif");
		}
		mPP_WHITESPACE(false);
		mPP_EXPRESSION(false);
		{
			switch ( LA(1) )
			{
			case '\t':  case '\u000b':  case '\u000c':  case ' ':
			{
				mPP_WHITESPACE(false);
				break;
			}
			case '\n':  case '\r':  case '/':  case '\u2028':
			case '\u2029':
			{
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
			}
			 }
		}
		mPP_NEW_LINE(false);
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\n');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_ELSE_SECTION(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_ELSE_SECTION;
		
		match("else");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("else");
		}
		mPP_NEW_LINE(false);
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\n');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_ENDIF(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_ENDIF;
		
		match("endif");
		if (0==inputState.guessing)
		{
			Emit.EmitString ("endif");
		}
		mPP_NEW_LINE(false);
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\n');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mLINE_INDICATOR(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = LINE_INDICATOR;
		Token x = null;
		
		switch ( LA(1) )
		{
		case '0':  case '1':  case '2':  case '3':
		case '4':  case '5':  case '6':  case '7':
		case '8':  case '9':
		{
			{ // ( ... )+
			int _cnt824=0;
			for (;;)
			{
				if (((LA(1) >= '0' && LA(1) <= '9')))
				{
					mDECIMAL_DIGIT(true);
					x = returnToken_;
					if (0==inputState.guessing)
					{
						Emit.EmitToken (x);
					}
				}
				else
				{
					if (_cnt824 >= 1) { goto _loop824_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
				}
				
				_cnt824++;
			}
_loop824_breakloop:			;
			}    // ( ... )+
			{
				switch ( LA(1) )
				{
				case '\t':  case '\u000b':  case '\u000c':  case ' ':
				{
					mPP_WHITESPACE(false);
					mFILE_NAME(false);
					break;
				}
				case '\n':  case '\r':  case '/':  case '\u2028':
				case '\u2029':
				{
					break;
				}
				default:
				{
					throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
				}
				 }
			}
			break;
		}
		case 'd':
		{
			match("default");
			if (0==inputState.guessing)
			{
				Emit.EmitString ("default");
			}
			break;
		}
		default:
		{
			throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());
		}
		 }
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mFILE_NAME(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = FILE_NAME;
		
		match("\"");
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\"');
		}
		{ // ( ... )+
		int _cnt828=0;
		for (;;)
		{
			if ((tokenSet_29_.member(LA(1))))
			{
				mFILE_NAME_CHARACTER(false);
			}
			else
			{
				if (_cnt828 >= 1) { goto _loop828_breakloop; } else { throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());; }
			}
			
			_cnt828++;
		}
_loop828_breakloop:		;
		}    // ( ... )+
		match("\"");
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\"');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mFILE_NAME_CHARACTER(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = FILE_NAME_CHARACTER;
		char  x = '\0';
		
		{
			x = LA(1);
			match(tokenSet_29_);
		}
		if (0==inputState.guessing)
		{
			Emit.EmitChar (x);
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	protected void mPP_MESSAGE(bool _createToken) //throws RecognitionException, CharStreamException, TokenStreamException
{
		int _ttype; Token _token=null; int _begin=text.Length;
		_ttype = PP_MESSAGE;
		
		{    // ( ... )*
			for (;;)
			{
				if ((tokenSet_0_.member(LA(1))))
				{
					mNOT_NEW_LINE(false);
				}
				else
				{
					goto _loop836_breakloop;
				}
				
			}
_loop836_breakloop:			;
		}    // ( ... )*
		mNEW_LINE(false);
		if (0==inputState.guessing)
		{
			Emit.EmitChar ('\n');
		}
		if (_createToken && (null == _token) && (_ttype != Token.SKIP))
		{
			_token = makeToken(_ttype);
			_token.setText(text.ToString(_begin, text.Length-_begin));
		}
		returnToken_ = _token;
	}
	
	
	private static long[] mk_tokenSet_0_()
	{
		long[] data = new long[258];
		data[0]=-9224L;
		for (int i = 1; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_0_ = new BitSet(mk_tokenSet_0_());
	private static long[] mk_tokenSet_1_()
	{
		long[] data = new long[130];
		data[0]=4294973952L;
		data[1]=46181893548277760L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_1_ = new BitSet(mk_tokenSet_1_());
	private static long[] mk_tokenSet_2_()
	{
		long[] data = new long[130];
		data[0]=68719476736L;
		data[1]=576460745995190271L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_2_ = new BitSet(mk_tokenSet_2_());
	private static long[] mk_tokenSet_3_()
	{
		long[] data = new long[130];
		data[0]=288019269919178752L;
		for (int i = 1; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_3_ = new BitSet(mk_tokenSet_3_());
	private static long[] mk_tokenSet_4_()
	{
		long[] data = new long[258];
		data[0]=-8L;
		for (int i = 1; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_4_ = new BitSet(mk_tokenSet_4_());
	private static long[] mk_tokenSet_5_()
	{
		long[] data = new long[258];
		data[0]=-4398046520328L;
		for (int i = 1; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_5_ = new BitSet(mk_tokenSet_5_());
	private static long[] mk_tokenSet_6_()
	{
		long[] data = new long[258];
		data[0]=9216L;
		for (int i = 1; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_6_ = new BitSet(mk_tokenSet_6_());
	private static long[] mk_tokenSet_7_()
	{
		long[] data = new long[130];
		data[0]=287948969894477824L;
		data[1]=576460745995190270L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_7_ = new BitSet(mk_tokenSet_7_());
	private static long[] mk_tokenSet_8_()
	{
		long[] data = new long[130];
		data[0]=287948901175001088L;
		data[1]=541165879422L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_8_ = new BitSet(mk_tokenSet_8_());
	private static long[] mk_tokenSet_9_()
	{
		long[] data = new long[130];
		data[0]=0L;
		data[1]=9024791442886656L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_9_ = new BitSet(mk_tokenSet_9_());
	private static long[] mk_tokenSet_10_()
	{
		long[] data = new long[130];
		data[0]=0L;
		data[1]=35527969480784L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_10_ = new BitSet(mk_tokenSet_10_());
	private static long[] mk_tokenSet_11_()
	{
		long[] data = new long[130];
		data[0]=287948901175001088L;
		data[1]=137438953504L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_11_ = new BitSet(mk_tokenSet_11_());
	private static long[] mk_tokenSet_12_()
	{
		long[] data = new long[130];
		data[0]=287992881640112128L;
		data[1]=137438953504L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_12_ = new BitSet(mk_tokenSet_12_());
	private static long[] mk_tokenSet_13_()
	{
		long[] data = new long[130];
		data[0]=287948901175001088L;
		data[1]=35527969480784L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_13_ = new BitSet(mk_tokenSet_13_());
	private static long[] mk_tokenSet_14_()
	{
		long[] data = new long[130];
		data[0]=282041912393728L;
		data[1]=23714567704018944L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_14_ = new BitSet(mk_tokenSet_14_());
	private static long[] mk_tokenSet_15_()
	{
		long[] data = new long[258];
		data[0]=-549755823112L;
		data[1]=-268435457L;
		for (int i = 2; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_15_ = new BitSet(mk_tokenSet_15_());
	private static long[] mk_tokenSet_16_()
	{
		long[] data = new long[258];
		data[0]=-17179878408L;
		for (int i = 1; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_16_ = new BitSet(mk_tokenSet_16_());
	private static long[] mk_tokenSet_17_()
	{
		long[] data = new long[258];
		data[0]=-17179878408L;
		data[1]=-268435457L;
		for (int i = 2; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_17_ = new BitSet(mk_tokenSet_17_());
	private static long[] mk_tokenSet_18_()
	{
		long[] data = new long[258];
		data[0]=-17179869192L;
		data[1]=-268435457L;
		for (int i = 2; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_18_ = new BitSet(mk_tokenSet_18_());
	private static long[] mk_tokenSet_19_()
	{
		long[] data = new long[130];
		data[0]=4294973952L;
		data[1]=2254067556417536L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_19_ = new BitSet(mk_tokenSet_19_());
	private static long[] mk_tokenSet_20_()
	{
		long[] data = new long[130];
		data[0]=1181116013056L;
		data[1]=576460745995190271L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_20_ = new BitSet(mk_tokenSet_20_());
	private static long[] mk_tokenSet_21_()
	{
		long[] data = new long[130];
		data[0]=4294973952L;
		data[1]=1152921504606846976L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_21_ = new BitSet(mk_tokenSet_21_());
	private static long[] mk_tokenSet_22_()
	{
		long[] data = new long[130];
		data[0]=1181116013056L;
		data[1]=1729382250602037247L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_22_ = new BitSet(mk_tokenSet_22_());
	private static long[] mk_tokenSet_23_()
	{
		long[] data = new long[258];
		data[0]=2593936302894235136L;
		data[1]=1729382250602037247L;
		for (int i = 2; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_23_ = new BitSet(mk_tokenSet_23_());
	private static long[] mk_tokenSet_24_()
	{
		long[] data = new long[130];
		data[0]=279172880896L;
		for (int i = 1; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_24_ = new BitSet(mk_tokenSet_24_());
	private static long[] mk_tokenSet_25_()
	{
		long[] data = new long[130];
		data[0]=1455993920000L;
		data[1]=576460745995190271L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_25_ = new BitSet(mk_tokenSet_25_());
	private static long[] mk_tokenSet_26_()
	{
		long[] data = new long[130];
		data[0]=2305843022098602496L;
		for (int i = 1; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_26_ = new BitSet(mk_tokenSet_26_());
	private static long[] mk_tokenSet_27_()
	{
		long[] data = new long[130];
		data[0]=2305844190329707008L;
		data[1]=576460745995190271L;
		for (int i = 2; i<=129; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_27_ = new BitSet(mk_tokenSet_27_());
	private static long[] mk_tokenSet_28_()
	{
		long[] data = new long[258];
		data[0]=2593935203382607360L;
		data[1]=1729382250602037246L;
		for (int i = 2; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_28_ = new BitSet(mk_tokenSet_28_());
	private static long[] mk_tokenSet_29_()
	{
		long[] data = new long[258];
		data[0]=-17179869192L;
		for (int i = 1; i<=3; i++) { data[i]=-1L; }
		for (int i = 4; i<=127; i++) { data[i]=0L; }
		data[128]=3298534883328L;
		for (int i = 129; i<=257; i++) { data[i]=0L; }
		return data;
	}
	public static readonly BitSet tokenSet_29_ = new BitSet(mk_tokenSet_29_());
	
}
}
