using Nemerle.Compiler;

namespace NSokoban.Macros
{
    macro NextMove(x,y,move)
    {
	<[
	    match($move)
	    {
		| "L" => ($x-1,$y)
		| "R" => ($x+1,$y)
		| "U" => ($x,$y-1)
		| "D" => ($x,$y+1)
		| _ => assert(false)
	    }
	]>
    }

    macro UseTunnelMacro(y,x,macros,map,move)
    {
	<[	    
	//System.Console.WriteLine("-" + Nemerle.Utility.Pair.First ($macros [$y,$x]).ToString () + "- -" + $move.ToString () + "-");
	if($move == "U" || $move == "D")		    
	    if(Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'B')
	    {		
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move($move);
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else
	    if(Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'U' && $move=="D" 
		|| Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'D' && $move=="U" )
	    {	
		//System.Console.Write($move[0].ToString () + " + ");
		//System.Console.WriteLine(Nemerle.Utility.Pair.Second ($macros [$y,$x]).ToString ());
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move(Nemerle.Utility.Pair.Second ($macros [$y,$x]).ToString ());
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else		
		[$map]	    
	else
	    if(Nemerle.Utility.Pair.Second ($macros [$y,$x]) == 'B')
	    {
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move($move);
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else
	    if(Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'R' && $move=="L" 
		|| Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'L' && $move=="R" )
	    //if(Nemerle.Utility.Pair.Second ($macros [$y,$x]) == $move[0])
	    {	
		//System.Console.WriteLine($move[0]);
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move(Nemerle.Utility.Pair.First ($macros [$y,$x]).ToString ());
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else
		[$map]
	]>
    }

    macro UseTunnelMacro2(y,x,ny,nx,macros,map,move)
    {
	<[
	if($move == "U" || $move == "D")		    
	    if(Nemerle.Utility.Pair.First ($macros [$y,$x]) == 'B' && Nemerle.Utility.Pair.First ($macros [$ny,$nx]) == 'B')
	    {		
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move($move);
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else
		[$map]	    
	else
	    if(Nemerle.Utility.Pair.Second ($macros [$y,$x]) == 'B' && Nemerle.Utility.Pair.Second ($macros [$ny,$nx]) == 'B')
	    {
		if($map.error == 0)
		    [$map]
		else
		{
		    def n = $map.next_move($move);
		    if(n matches [])
			[$map]
		    else
			n
		}
	    }
	    else
		[$map]
	]>
    }
}
