 using Nemerle.IO;
 using Nemerle.Collections;
 using Nemerle;

 public class BalanceViolation : System.Exception { public this () {} }

  public class IntCmp : IComparable [IntCmp]
  {
    public val : int;

    public this (val : int)
    {
      this.val = val
    }

    public CompareTo (x : IntCmp) : int implements IComparable.CompareTo
    {
      this.val-x.val
    }
  }

  public module RBTester
  {

    public Main () : void 
    {
      def op_count = 1000;
      def key_range = 50;
      def rand = System.Random ();
      def op_range = 5;
      def check_array = (System.Array.CreateInstance (typeof (System.Boolean), key_range) :> array [bool]);
  
      mutable j = key_range - 1;
      while (j >= 0) 
      {
        check_array[j] = false;
        --j
      };
      
      def BoolFunc1 (elem : IntCmp ) : bool
          {
            (elem.CompareTo (IntCmp (25)) >= 0)
          };
      def BoolFunc2 (elem : IntCmp ) : bool
          {
            (elem.CompareTo (IntCmp (45)) >= 0)
          };
      def ArrayForAll (func : IntCmp -> bool) : bool 
          {
            mutable i = 0;
            mutable bl = true;
            
            while (i < key_range) 
            {
              unless (!check_array [i] || func (IntCmp (i))) {
                i = key_range;
                bl = false 
              };
              i = i + 1
            };
            bl
          };
      def ArrayExists (func : IntCmp -> bool) : bool 
          {
            mutable i = 0;
            mutable bl = false;
            
            while (i < key_range) 
            {
              when (check_array [i] && func (IntCmp (i))) {
                i = key_range;
                bl = true
              };
              i = i + 1
            };
            bl
          };
      def PrintNode (tree : Tree.Node [IntCmp]) : void 
          {
            match (tree) {
              | Tree.Node.Leaf => printf (" \n")
              | Tree.Node.Red (key, ltree, rtree) => 
                  printf (" Red : %d", key.val);
                  PrintNode (ltree);
                  PrintNode (rtree)
              | Tree.Node.Black (key, ltree, rtree) => 
                  printf (" Black : %d", key.val);
                  PrintNode (ltree);
                  PrintNode (rtree)
            }
          };
      def PrintList (op_list : list [string]) : void
          {
            match (op_list) {
              | [] => ()
              | h :: tl => printf ("%s|", h);
                  PrintList (tl)
            }
          }; 
      def TestRB (tree : Tree.Node [IntCmp]) : bool 
          {
            def testrb (tree : Tree.Node [IntCmp], red : bool) : int
                {
                  match ( (tree, red)) {
                    | (Tree.Node.Red, true) =>
                        printf ("Red conflict\n");
                        throw BalanceViolation ()
                    | (Tree.Node.Red (_, ltree, rtree), false) =>
                        match ( (ltree, rtree)) {
                          | (Tree.Node.Leaf, Tree.Node.Leaf) => 
                              0
                          | (Tree.Node.Leaf, _) =>
                              testrb (rtree, true)
                          | (_, Tree.Node.Leaf) =>
                              testrb (ltree, true)
                          | _ =>  def count = testrb (ltree, true);
                                  when (count != testrb (rtree, true))
                                  {
                                    printf ("No black balance\n");
                                    throw BalanceViolation ()  
                                  };
                                  count    
                        }
                    | (Tree.Node.Black (_, ltree, rtree), _) =>
                        match ( (ltree, rtree)){
                          | (Tree.Node.Leaf, Tree.Node.Leaf) => 
                              0
                          | (Tree.Node.Leaf, _) =>
                              testrb (rtree, false)
                          | (_, Tree.Node.Leaf) =>
                              testrb (ltree, false)
                          | _ =>  def count = testrb (ltree, false);
                                  when (count != testrb (rtree, false))
                                  {
                                    printf ("No black balance\n");
                                    throw BalanceViolation ()  
                                  };
                                  count+1    
                        }
                    | _ => throw BalanceViolation ()
                  }
                };
            try 
              {
                match (tree){
                  | Tree.Node.Leaf => true
                  | _ => def _= testrb (tree, false);
                     true
                }
              } catch 
                { 
                  _ is BalanceViolation => false
                }
          };

      def IterOps (tree : Tree.Node [IntCmp], op_list : list [string], counter : int) : void
          { 
            unless (TestRB (tree))
            {
              PrintList (op_list);
              throw BalanceViolation ()
            };
            when (counter >= 0)
              match (rand.Next (op_range)){
                | 0 => 
                    def i = rand.Next (key_range);
                    check_array[i] = true;
//                    IterOps (Tree.Insert (tree, IntCmp (i), false), 
//                               ("I (" + i.ToString () + ")") :: op_list, counter - 1)
                    IterOps (Tree.Insert (tree, IntCmp (i), true), op_list, counter - 1)  
                | 1 => 
                    def i = rand.Next (key_range);
                    def (treee, bl) =
                      match (Tree.Get (tree, IntCmp(i))) {
                        | Some =>
                          (Tree.Delete (tree, IntCmp(i)), true)
                        | None =>
                          (tree, false)
                      };
                    when (bl != check_array[i]) 
                    {
                      printf ("Wrong deletion acknowledge\n");
                      PrintList (("D (" + i.ToString () + ")") :: op_list);
                      throw BalanceViolation ()
                    };  
                    check_array[i] = false;
                    IterOps (treee, op_list, counter - 1)
                | 2 => 
                    def i = rand.Next (key_range);
                    match (Tree.Get (tree, IntCmp (i))){
                      | Some (key) => 
                          if (key.val == i && check_array[i])
                            IterOps (tree, op_list, counter-1)
                          else 
                          {
                            printf ("Wrong Get is %d %d\n", i, key.val);
                            PrintList (op_list);
                            printf ("tree : \n");
                            PrintNode (tree);
                            throw BalanceViolation ()
                          }
                      | None =>
                          if (!check_array[i])
                            IterOps (tree, op_list, counter-1)
                          else 
                          {
                            printf ("Wrong Get not %d\n", i);
                            PrintList (op_list);
                            printf ("tree : \n");
                            PrintNode (tree);
                            throw BalanceViolation ()
                          }  
                    }
                | 3 => 
                    def bl = Tree.ForAll (tree, BoolFunc1); 
                    when (ArrayForAll (BoolFunc1) != bl)
                    {
                      if (bl)
                        printf ("Wrong ForAll answer (true)\n")
                      else
                        printf ("Wrong ForAll answer (false)\n");
                      PrintList (op_list);
                      printf ("tree : \n");
                      PrintNode (tree);
                      throw BalanceViolation ()
                    };
                    IterOps (tree, ("ForAll") :: op_list, counter - 1)
               | 4 => 
                    def bl = Tree.Exists (tree, BoolFunc2); 
                    when (ArrayExists (BoolFunc2) != bl)
                    {
                      if (bl)
                        printf ("Wrong Exists answer (true)\n")
                      else
                        printf ("Wrong Exists answer (false)\n");
                      PrintList (op_list);
                      printf ("tree : \n");
                      PrintNode (tree);
                      throw BalanceViolation ()
                    };
                    IterOps (tree, ("Exists") :: op_list, counter - 1)
                | _ => ()
              }
        };

      try {
        IterOps (Tree.Node.Leaf (), [], op_count)
      } catch 
        {
          _ is BalanceViolation => printf ("\nError occurred\n")
        }
    }
  } 

/*
BEGIN-OUTPUT
END-OUTPUT
*/
