
using Nemerle.IO;
using Nemerle.Collections;

public class DerivedIndexers : TestIndexers
{
  public this () { }

  public override Item [index : int] : int
  {
    get
    {
      base [index] + 1
    }
    set
    {
      base [index] = value
    }
  }

  public override Foox [index : int] : int
  {
    get
    {
      base.Foox [index] + 1
    }
    set
    {
      base.Foox [index] = value
    }
  }

  public override Foox [index : int, i2 : int] : int
  {
    get
    {
      base.Foox [index, i2] + 1
    }
    set
    {
      base.Foox [index, i2] = value
    }
  }
  
}

public class TestIndexers
{
  public this () { }

  private mutable x : int;
  
  public virtual Item [index : int] : int
  {
    get
    {
      index * 2 + x
    }
    set
    {
      x = index * value
    }
  }

  public virtual Foox [index : int] : int
  {
    get
    {
      index * 3 + x
    }
    set
    {
      x = index * value + 42
    }
  }

  public virtual Foox [index : int, i2 : int] : int
  {
    get
    {
      index * 3 + x + i2 + this [index]
    }
    set
    {
      this [index + i2] = value
    }
  }

  static string_indexer () : void {
    def a = "Ala ma ";
    def b = "kota.";
    def x = a + b;

    def f (index : int) : void {
      System.Console.Write ("{0}", x [index])
    };
    System.Console.Write (a);
    List.Iter ([0, 1, 7, 8, 4, 5, 9], f);
  }

  public static Main () : void
  {
    def s = TestIndexers ();

    s [5] = 5;
    printf ("Hello world: %i!\n", s [20]);

    s.Item [6] = 6;
    printf ("Hello world: %i!\n", s [3]);

    s.Foox [3] += 7;
    printf ("Hello world: %i!\n", s.Foox [12]);

    s.Foox [3, 2] += 7;
    printf ("Hello world: %i!\n", s.Foox [12, 3]);

    def s = DerivedIndexers ();

    s [5] = 5;
    printf ("Hello world: %i!\n", s [20]);

    s.Item [6] = 6;
    printf ("Hello world: %i!\n", s [3]);

    s.Foox [3] += 7;
    printf ("Hello world: %i!\n", s.Foox [12]);

    s.Foox [3, 2] += 7;
    printf ("Hello world: %i!\n", s.Foox [12, 3]);

    string_indexer ();
  }
}

/*
BEGIN-OUTPUT
Hello world: 65!
Hello world: 42!
Hello world: 234!
Hello world: 4263!
Hello world: 66!
Hello world: 43!
Hello world: 238!
Hello world: 4345!
Ala ma Alkomat
END-OUTPUT
*/
