using Nemerle.IO;

module M {

  runner (f : void -> void) : void
  {
    f ()
  }

  xx : long; // W: field `M.xx' is never assigned to
  
  Main () : void {

    mutable x = (42 : object);
    printf ("%d\n", (x :> int));
    x = 6 * 9;
    printf ("%d\n", (x :> int));
    x = "foo";
    printf ("%s\n", (x :> string));

    mutable y = (420 : object);
    printf ("%d\n", (y :> int));
    
    def f () {
      y = 6 * 9 + 1;
      printf ("%d\n", (y :> int));
      y = "bar";
      printf ("%s\n", (y :> string));
    };

    runner (f);

   def x1 = (1 : object);
   def tab = array [("ala" : object), "kot", x1];
   printf ("%d\n", tab.Length);

   printf ("%s %s %s\n", 1.GetType ().FullName, 42.ToString (), xx.GetType().Name);

  }
}

/*
BEGIN-OUTPUT
42
54
foo
420
55
bar
3
System.Int32 42 Int64
END-OUTPUT
*/
