class C {
  OnlySet : int
  {
    set { _ = value; }
  }

  static gg () : void
  {
    System.Console.WriteLine (try { 1 } finally {}); // E: try block is not allowed inside expressions
  }

  static g () : int { try { 1 } finally { "foo" } } // W: ignored computed value of type string

  static t1 () : void
  {

    assert (! (true == null)); // E: comparing a value type
    assert (! (false == null)); // E: comparing a value type
    assert (! (() == null)); // E: comparing a value type
    assert (! (null == ())); // E: comparing a value type

    def val = 0;
    assert (val != null); // E: comparing a value type
    assert (null != val); // E: comparing a value type

    assert (C () == null); // OK
    assert (null == C ()); // OK
    assert (C () == C ()); // E: comparing values of types C and C with reference equality

    assert (1 == 0L); // OK
    assert (false == 0L); // E: comparing values.* with reference equality
    assert (false == 1); // E: comparing values.* with reference equality
    assert (0L == true); // E: comparing values.* with reference equality
    assert (1 == false); // E: comparing values.* with reference equality
  }
  
  static Main () : void {
    def x = System.Text.StringBuilder ();
    def _ = x.Chars;            // E: property `System.Text.StringBuilder.Chars' was used as a first class value

    3; // W: ignored computed value of type int

    def _ = (null : C).OnlySet; // E: the get accessor is unavailable
  }
}
