using Nemerle.Diagnostics;

interface I { }
class A : I { public virtual GetId () : int { 1 } }
class B : A { }
class C : B { public override GetId () : int { 3 } }


module Test {
  mutable ar : array[object];
  mutable ar1 : array[A];  
  mutable res : int;

  is_noop (times : int) : void
  {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j)
        when (ar[j] != null)
          ++cnt;
    res += cnt;
  }

  is_interface (times : int) : void
  {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j)
        when (ar[j] is I)
          ++cnt;
    res += cnt;
  }

  is_type_A (times : int) : void {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j)
        when (ar[j] is A)
          ++cnt;
    res += cnt;
  }

  
  is_type_C (times : int) : void {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j)
        when (ar[j] is C)
          ++cnt;
    res += cnt;
  }

  get_id (times : int) : void {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j) {
        def x = ar1[j];
        cnt += x.GetId ();
      }

    res += cnt;
  }

  get_id1 (times : int) : void {
    mutable cnt = 0;
    for (mutable i = 0; i < times; ++i)
      for (mutable j = 0; j < 1000; ++j) {
        def x = ar1[j];
        when (x != null) cnt += x.GetId ();
      }

    res += cnt;
  }
  
  Main () : void {
    ar = array (1000);
    def obj = object();
    def c = C();
    def a = A();
    for (mutable i = 0; i < 1000; ++i) {
      if (i % 3 == 0)
        ar[i] = c;
      else if (i % 3 == 1)
        ar[i] = null;
      else
        ar[i] = obj;
    }

    ar1 = array (1000);
    for (mutable i = 0; i < 1000; ++i) {
      if (i % 3 == 0)
        ar1[i] = c;
      else 
        ar1[i] = a;
    }

    
    time is_interface (100000);
    time is_type_A (100000);
    time is_type_C (100000);
    time is_noop (100000);
    time get_id (100000);
    time get_id1 (100000);    
  }
}

