/*
 * Copyright (c) 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


namespace Nemerle.Collections 
{
  /**
   * Dictionary entry.
   */
  public class DictionaryEntry ['a,'b]
  {    
    /* -- PUBLIC CONSTRUCTORS ----------------------------------------------- */
    
    /**
     * Creates a new dictionary entry
     */
    public this (key : 'a, value : 'b)
    {
      m_key = key;
      m_value = value;
    }


    /* -- PUBLIC PROPERTIES ------------------------------------------------- */

    /**
     * Returns the key of this entry.
     */
    public Key : 'a
    {
      get { m_key }
      set { m_key = value }
    }


    /**
     * Returns the value of this entry.
     */
    public Value : 'b
    {
      get { m_value }
      set { m_value = value }
    }


    /**
     * Returns the key/value pair for this entry.
     */
    public KeyValue : 'a * 'b
    {
      get { (m_key, m_value) }
      set
      {
        def (key, value) = value;
        
        m_key = key;
        m_value = value
      }
    }

    
    /* -- PRIVATE FIELDS ---------------------------------------------------- */

    private mutable m_key   : 'a;
    private mutable m_value : 'b;
  }
}
