/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * This namespace is always opened
 */
namespace Nemerle.Core 
{
  public class AssertionException : System.Exception 
  {
    public this (file : string, line : int, cond : string, msg : string) 
    { 
      def cond = if (cond != "") " ``" + cond + "''" else "";
      def m = "assertion" + cond + " failed in file " + file + ", line " 
              + line.ToString ();
      if (msg != "")
        base (m + ":\n" + msg)
      else
        base (m)
    }
  }

  public class MatchFailureException : System.Exception 
  {
    public this () {}
  }

  public class NullMatchException : MatchFailureException
  {
    public this () {}

    public static raise_self () : bool 
    { 
      throw NullMatchException ()
    }
  }

  public class AssemblyFindException : System.Exception 
  {
    public this () {}
  }

  public type byte = System.Byte;
  public type sbyte = System.SByte;  
  public type short = System.Int16;
  public type ushort = System.UInt16;  
  public type int = System.Int32;
  public type uint = System.UInt32;  
  public type long = System.Int64;
  public type ulong = System.UInt64;  
  public type float = System.Single;
  public type double = System.Double;
  public type decimal = System.Decimal; 
  public type string = System.String;
  public type object = System.Object;
  public type bool = System.Boolean;
  public type char = System.Char;
}

