/* Help strings.

	Copyright (C) 1993-1998 Sebastiano Vigna 
	Copyright (C) 1999-2005 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2, or (at your option) any
	later version.
	
	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.
	
	You should have received a copy of the GNU General Public License along
	with this program; see the file COPYING.  If not, write to the Free
	Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.  */

const char * const ABOUT_HELP[5] = {
  "Syntax: About",
  "Abbreviation: About",
  "",
  "displays a simple information line about `ne' on the status bar.",
};

const char * const ADJUSTVIEW_HELP[20] = {
  "Syntax: AdjustView [T|C|B|L|M|R]",
  "Abbreviation: AV",
  "",
  "shifts the view (text visible in the terminal window) horizontally or",
  "vertically without changing the cursor's position in the document. View",
  "adjustments are constrained by the current TAB size and the length and",
  "width of the current document. If called with no arguments `T' is",
  "assumed.",
  "",
  "   `T', `C', and `B' cause vertical shifts so that the current line",
  "becomes the top, center, or bottom-most visible line respectively.",
  "",
  "   `L', `M', and `R' cause horizontal shifts, making the current column",
  "the left-most, middle, or right-most visible positions.",
  "",
  "   Horizontal and vertical adjustment specifications may be combined,",
  "so that for example `AdjustView TL' shifts the view so that the current",
  "position becomes the top left-most character on screen (within the",
  "limits of the current TAB size).",
};

const char * const AUTOINDENT_HELP[22] = {
  "Syntax: AutoIndent [0|1]",
  "Abbreviation: AI",
  "",
  "sets the auto indent flag. When this flag is true, `ne' will",
  "automatically insert TABs and spaces on a new line (created by an",
  "`InsertLine' command, or by automatic word wrapping) in such a way to",
  "replicate the initial spaces of the previous line. Most useful for",
  "indenting programs.",
  "",
  "   If you invoke `AutoIndent' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `a' will appear on the status bar if the",
  "flag is true.",
  "",
  "   `AutoIndent' features a nice interaction with `Undo'. Whenever a new",
  "line is created, the insertion of spaces is recorded as a separate",
  "action in the undo buffer (with respect to the line creation). If you",
  "are not satisfied with the indentation, just give the `Undo' command and",
  "the indentation will disappear (but the new line will remain in place,",
  "since its creation has been recorded as a separate action). See ",
  "`Undo'.",
};

const char * const AUTOPREFS_HELP[14] = {
  "Syntax: AutoPrefs [0|1]",
  "Abbreviation: AP",
  "",
  "sets the automatic preferences flag. If this flag is true, each time an",
  "`Open' command is executed and a file is loaded, `ne' will look for an",
  "automatic preferences file in your `~/.ne' directory.  The preferences",
  "file name is given by the extension of the file loaded, postfixed with",
  "`#ap'. Thus, for instance, C sources have an associated `c#ap' file.",
  "",
  "   If you invoke `AutoPrefs' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `p' will appear on the status bar if the",
  "flag is true.",
};

const char * const BACKSPACE_HELP[6] = {
  "Syntax: Backspace [N]",
  "Abbreviation: BS",
  "",
  "acts like `DeleteChar', but moves the cursor to the left before",
  "deleting each character.",
};

const char * const BEEP_HELP[6] = {
  "Syntax: Beep",
  "Abbreviation: BE",
  "",
  "beeps. If your terminal cannot beep, it flashes. If it cannot flash,",
  "nothing happens (but you have a very bad terminal).",
};

const char * const BINARY_HELP[22] = {
  "Syntax: Binary [0|1]",
  "Abbreviation: B",
  "",
  "sets the binary flag. When this flag is true, loading and saving a",
  "document is performed in a different way. On loading, only nulls are",
  "considered newlines; on saving, nulls are saved instead of newlines.",
  "This allows you to edit a binary file, fix some text in it, and save it",
  "without modifying anything else. Normally, linefeeds, carriage returns",
  "and nulls are considered newlines, so that what you load will have all",
  "nulls and carriage returns substituted by newlines when saved.",
  "",
  "   Note that since usually binary files contain a great number of",
  "nulls, and every null will be considered a line terminator, the memory",
  "necessary for loading a binary file can be several times bigger than",
  "the length of the file itself. Thus, binary editing within `ne' should",
  "be considered not a normal activity, but rather an exceptional one.",
  "",
  "   If you invoke `Binary' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An upper case `B' will appear on the status bar if the",
  "flag is true.",
};

const char * const CAPITALIZE_HELP[6] = {
  "Syntax: Capitalize [N]",
  "Abbreviation: CA",
  "",
  "acts exactly like `ToUpper', but capitalizes, that is, makes the first",
  "letter upper case and the other ones lower case. See `ToUpper'.",
};

const char * const CASESEARCH_HELP[12] = {
  "Syntax: CaseSearch [0|1]",
  "Abbreviation: CS",
  "",
  "sets the case sensitivity flag. When this flag is true, the search",
  "commands distinguish between the upper and lower case letters. By",
  "default the flag is false.",
  "",
  "   If you invoke `CaseSearch' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `c' will appear on the status bar if the",
  "flag is true.",
};

const char * const CENTER_HELP[8] = {
  "Syntax: Center [N]",
  "Abbreviation: CE",
  "",
  "centers N lines from the cursor position onwards. If N is not",
  "specified, it is assumed to be one. The lines are centered with spaces,",
  "relatively to the value of the right margin as set by the `RightMargin'",
  "command. See `RightMargin'.",
};

const char * const CLEAR_HELP[7] = {
  "Syntax: Clear",
  "Abbreviation: CL",
  "",
  "destroys the contents of the current document and of its undo buffer.",
  "Moreover, the document becomes unnamed. If your current document is",
  "marked as modified, you have to confirm the action.",
};

const char * const CLIPNUMBER_HELP[11] = {
  "Syntax: ClipNumber [N]",
  "Abbreviation: CN",
  "",
  "sets the current clip number. This number is used by `OpenClip' and",
  "`SaveClip', and by `Copy', `Cut' and `Paste' if they are called without",
  "any argument. Its default value is zero. N is limited only by the",
  "integer size of the machine `ne' is running on.",
  "",
  "   If the optional argument N is not specified, you can enter it on the",
  "input line, the default being the current clip number.",
};

const char * const CLOSEDOC_HELP[7] = {
  "Syntax: CloseDoc",
  "Abbreviation: CD",
  "",
  "closes the current document. The document is removed from `ne''s list",
  "and, if it is the only existing document, `ne' exits. If the document",
  "was modified since it was last saved, you have to confirm the action.",
};

const char * const COPY_HELP[10] = {
  "Syntax: Copy [N]",
  "Abbreviation: C",
  "",
  "copies the contents of the characters lying between the cursor and the",
  "mark into the clip specified by the optional numeric argument, the",
  "default clip being the current clip, which can be set with the",
  "`ClipNumber' command; see `ClipNumber'. If the current mark was",
  "vertical, the rectangle of characters defined by the cursor and the",
  "mark is copied instead.",
};

const char * const CRLF_HELP[16] = {
  "Syntax: CRLF [0|1]",
  "Abbreviation: CRLF",
  "",
  "sets the CR/LF flag. When a file is saved from a buffer for which this",
  "flag is true, both a CR (carriage return) and a NL (new line) character",
  "are output as line terminators.  This flag has no effect except when",
  "saving a file.",
  "",
  "   This flag is automatically set if you load a file that has at least",
  "one CR/LF sequence into it.",
  "",
  "   If you invoke `CRLF' with no arguments, it will toggle the flag.  If",
  "you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An upper case `C' will appear on the status bar if the",
  "flag is true.",
};

const char * const CUT_HELP[5] = {
  "Syntax: Cut [N]",
  "Abbreviation: CU",
  "",
  "acts just like `Copy', but also deletes the block being copied.",
};

const char * const DELETECHAR_HELP[10] = {
  "Syntax: DeleteChar [N]",
  "Abbreviation: DC",
  "",
  "deletes N characters from the text. If the optional N argument is not",
  "specified, it is assumed to be one. Deleting a character when the",
  "cursor is just after the last char on a line will join a line with the",
  "following one; in other words, the carriage return between the two lines",
  "will be deleted. Note that if the cursor is past the end of the current",
  "line, no action will be performed.",
};

const char * const DELETEEOL_HELP[10] = {
  "Syntax: DeleteEOL",
  "Abbreviation: DE",
  "",
  "deletes all characters from the current cursor position to the end of",
  "the line.",
  "",
  "   `DeleteEOL' could be easily implemented with a macro, but it is such",
  "a common, basic editing feature that it seemed worth a separate",
  "implementation.",
};

const char * const DELETELINE_HELP[9] = {
  "Syntax: DeleteLine [N]",
  "Abbreviation: DL",
  "",
  "deletes N lines starting from the current cursor position, putting the",
  "last one in the temporary buffer, from which it can be undeleted. See",
  "`UndelLine'. If the optional N argument is not specified, it is",
  "assumed to be one. Note that this action is in no way inverse with",
  "respect to `InsertLine'.",
};

const char * const DOUNDO_HELP[20] = {
  "Syntax: DoUndo [0|1]",
  "Abbreviation: DU",
  "",
  "sets the flag that enables or disables the undo system. When you turn",
  "the undo system off, all the recorded actions are discarded, and the",
  "undo buffers are reset.",
  "",
  "   If you invoke `DoUndo' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `u' will appear on the status bar if the",
  "flag is true.",
  "",
  "   The usefulness of this option relies in the fact that the undo",
  "system is a major memory eater. If you plan to do massive editing (say,",
  "cutting and pasting megabytes of text) it is a good idea to disable the",
  "undo system, both for improving (doubling) performance and for using",
  "less (half) memory. Except for this, on a virtual memory system we see",
  "no reason to not keep the undo flag always true, and this is indeed the",
  "default.",
};

const char * const ERASE_HELP[6] = {
  "Syntax: Erase",
  "Abbreviation: E",
  "",
  "acts like `Cut', but the block is just deleted and not copied into any",
  "clip.",
};

const char * const ESCAPE_HELP[7] = {
  "Syntax: Escape",
  "Abbreviation: ESC",
  "",
  "toggles the menus on and off, or escapes from the input line. This",
  "command is mainly useful for reprogramming the menu activator, and it is",
  "never registered while recording a macro. `Record'.",
};

const char * const ESCAPETIME_HELP[16] = {
  "Syntax: EscapeTime [N]",
  "Abbreviation: ET",
  "",
  "sets the escape time. The <Escape> key is recognized as such after N",
  "tenths of second.  Along slow connections, it can happen that the",
  "default value of 10 is too low: in this case, escape sequences (e.g.,",
  "those of the arrow keys) could be erroneously broken into an escape and",
  "some spurious characters.  Rising the escape time usually solves this",
  "problem. Allowed values range from 0 to 255. Note that you can",
  "accelerate the recognition of the <Escape> key by hitting it twice in a",
  "row.",
  "",
  "   Note that the escape time is global to `ne', and it is not saved.",
  "However, you can add an `EscapeTime' command manually to a preferences",
  "file.",
};

const char * const EXEC_HELP[13] = {
  "Syntax: Exec",
  "Abbreviation: EX",
  "",
  "prompts the user on the input line, asking for a command, and executes",
  "it. It is never registered while recording a macro (though the command",
  "you type is).",
  "",
  "   `Exec' is mainly useful for key bindings, menu configurations, and in",
  "manually programmed macros.",
  "",
  "   Note that if the command you specify does not appear in `ne''s",
  "internal tables, it is considered to be a macro name. See `Macro'.",
};

const char * const EXIT_HELP[6] = {
  "Syntax: Exit",
  "Abbreviation: X",
  "",
  "saves all modified documents, closes them and exits. If any documents",
  "cannot be saved, the action is suspended and an error message is issued.",
};

const char * const FASTGUI_HELP[15] = {
  "Syntax: FastGUI [0|1]",
  "Abbreviation: FG",
  "",
  "sets the fast graphical user interface flag. When this flag is true,",
  "`ne' tries to print as little as possible while displaying menus and",
  "the status bar. In particular, menu items are highlighted by the cursor",
  "only, the status bar is not highlighted (which allows printing it with",
  "fewer characters) and the hexadecimal code is not displayed. This",
  "option is only (but very) useful if you are using `ne' through a slow",
  "connection.",
  "",
  "   If you invoke `FastGUI' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively.",
};

const char * const FIND_HELP[12] = {
  "Syntax: Find [PATTERN]",
  "Abbreviation: F",
  "",
  "searches for the given pattern. The cursor is positioned on the first",
  "occurrence of the pattern, or an error message is given. The direction",
  "and the case sensitivity of the search are established by the value of",
  "the back search and case sensitive search flags. See ",
  "`SearchBack', and `CaseSearch'.",
  "",
  "   If the optional argument PATTERN is not specified, you can enter it",
  "on the input line, the default being the last pattern used.",
};

const char * const FINDREGEXP_HELP[12] = {
  "Syntax: FindRegExp [PATTERN]",
  "Abbreviation: FX",
  "",
  "searches the current document for the given extended regular expression",
  ". The cursor is positioned on the first string matching the expression.",
  "The direction and the kind of search are established by the value of",
  "the back search and case sensitive search flags. See ",
  "`SearchBack', and `CaseSearch'.",
  "",
  "   If the optional argument PATTERN is not specified, you can enter it",
  "on the input line, the default being the last pattern used.",
};

const char * const FLAGS_HELP[27] = {
  "Syntax: Flags",
  "Abbreviation: FLAG",
  "",
  "displays a list of all the status flags for ne and their associated",
  "commands. It is not recorded when recording a macro.",
  "",
  "     FLAG COMMAND      ABBR  DESCRIPTION",
  "       i   Insert        I    inserts new characters (vs. replacing)",
  "       a   AutoIndent    AI   aligns cursor under previous line after <Return>",
  "       b   BackSearch    BS   searches search backward rather than forward",
  "       c   CaseSearch    CS   searches are case sensitive",
  "       w   WordWrap      WW   breaks long lines as you type",
  "       f   FreeForm      FF   allows cursor to move beyond the end of lines",
  "       p   AutoPrefs     AP   use automatic preferences based on file extension",
  "       v   VerboseMacros VM   record macros using use long command names",
  "       u   DoUndo        DU   record edits for later undoing",
  "       r   ReadOnly      RO   changes are not allowed",
  "       B   Binary        B    affects file loading/saving",
  "       M   Mark          M    mark set for line-oriented block operations",
  "       V   MarkVert      MV   like mark, but block is rectangle",
  "       R   Record        REC  actions are being recorded in a macro",
  "       P   PreserveCR    PCR  affects how <CR> chars are loaded from files",
  "       C   CRLF          CRLF use CR/LF as line terminator",
  "       *   Modified      MOD  document has been modified since last saved",
  "       @   UTF8IO        U8IO I/O (keyboard and terminal) are UTF-8 encoded",
  "     A/8/U UTF8          U8   the document encoding (ASCII, 8-bit or UTF-8)",
};

const char * const FLASH_HELP[6] = {
  "Syntax: Flash",
  "Abbreviation: FL",
  "",
  "acts as `Beep', but interchanging the words \"beep\" and \"flash\".  Same",
  "comments apply. See `Beep'.",
};

const char * const FREEFORM_HELP[18] = {
  "Syntax: FreeForm [0|1]",
  "Abbreviation: FF",
  "",
  "sets the free form flag. When this flag is true, you can move with the",
  "cursor anywhere on the screen, even where there is no text present",
  "(however, you cannot move inside the space expansion of a TAB",
  "character).",
  "",
  "   If you invoke `FreeForm' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `f' will appear on the status bar if the",
  "flag is true.",
  "",
  "   The issue free-form-versus-non-free-form is a major religious war",
  "that has engaged users from day one. The due of the implementor is to",
  "allow both choices, and to set as default the correct one (in his humble",
  "opinion). In this case, non-free-form.",
};

const char * const GOTOBOOKMARK_HELP[13] = {
  "Syntax: GotoBookmark [N|-]",
  "Abbreviation: GBM",
  "",
  "moves the cursor to the Nth or - automatic bookmark, assuming that",
  "bookmark has been set; see `SetBookmark'. If the optional N",
  "argument is not specified, it is assumed to be zero. When successful,",
  "the `-' automatic bookmark is set to the position in the document from",
  "which the command was issued, so that `GotoBookmark -' returns you to",
  "the location from which you last issued a `GotoBookmark' command.",
  "Subsequent repeated `GotoBookmark -' commands toggle you between the",
  "two locations. Each document's valid bookmark designations are 0 to 9,",
  "and the `-' automatic bookmark.",
};

const char * const GOTOCOLUMN_HELP[8] = {
  "Syntax: GotoColumn [COLUMN]",
  "Abbreviation: GC",
  "",
  "moves the cursor to the COLUMNth column of the file.",
  "",
  "   If the optional argument LINE is not specified, you can enter it on",
  "the input line; the default input response is the current column number.",
};

const char * const GOTOLINE_HELP[10] = {
  "Syntax: GotoLine [LINE]",
  "Abbreviation: GL",
  "",
  "moves the cursor to the LINEth line of the file. If LINE is zero or",
  "greater than the number of lines in the file, the cursor is moved to",
  "the last line.",
  "",
  "   If the optional argument LINE is not specified, you can enter it on",
  "the input line; the default input response is the current line number.",
};

const char * const GOTOMARK_HELP[9] = {
  "Syntax: GotoMark",
  "Abbreviation: GM",
  "",
  "moves the cursor to the current mark, if it exists. See `Mark'.",
  "",
  "   `GotoMark' is mainly useful if you forgot where you started marking.",
  "If you want to record a position in a file and jump to it later, you",
  "may want to use a bookmark. See `SetBookmark'.",
};

const char * const HELP_HELP[15] = {
  "Syntax: Help [NAME]",
  "Abbreviation: H",
  "",
  "displays some help about the command NAME (both the short and the long",
  "versions of the command names are accepted). If no argument is given, a",
  "list of all existing commands in long form is displayed, allowing you",
  "to choose one. You can browse the help text with the standard",
  "navigation keys. If you press <Return>, the command list will be",
  "displayed again. If you press <f1> or <Escape>, you will return to",
  "normal editing.",
  "",
  "   Invocations of the `Help' command are never registered while",
  "recording macros so that you can safely access the help system while",
  "recording. See `Record'.",
};

const char * const HEXCODE_HELP[7] = {
  "Syntax: HexCode [0|1]",
  "Abbreviation: HC",
  "",
  "sets the hex code flag. When this flag is true, the hexadecimal code of",
  "the character currently under the cursor is displayed on the status",
  "line.",
};

const char * const INSERT_HELP[12] = {
  "Syntax: Insert [0|1]",
  "Abbreviation: I",
  "",
  "sets the insert flag. If this flag is true, the text you type is",
  "inserted, otherwise it overwrites the existing characters. This also",
  "governs the behaviour of the `InsertChar' and `InsertString' commands.",
  "",
  "   If you invoke `Insert' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `i' will appear on the status bar if the",
  "flag is true.",
};

const char * const INSERTCHAR_HELP[20] = {
  "Syntax: InsertChar [CODE]",
  "Abbreviation: IC",
  "",
  "inserts a character whose ASCII code is CODE at the current cursor",
  "position.  CODE must always be different from 0. All the currently",
  "active preferences options (insert, word wrapping, auto indent, et",
  "cetera) are applied.",
  "",
  "   If the optional argument CODE is not specified, you can enter it on",
  "the input line, the default being the last inserted character.",
  "",
  "   Note that inserting a line feed (10) is completely different from",
  "inserting a line with `InsertLine'. `InsertChar 10' puts the control",
  "char `<Control>-J' in the text at the current cursor position.  See",
  "`InsertLine'.",
  "",
  "   Note also that `SaveMacro' converts `InsertChar' commands into a",
  "possibly smaller number of `InsertString' commands.  This makes macros",
  "easier to read and edit. See `SaveMacro'.",
};

const char * const INSERTLINE_HELP[7] = {
  "Syntax: InsertLine [N]",
  "Abbreviation: IL",
  "",
  "inserts N lines at the current cursor position, breaking the current",
  "line. If the optional N argument is not specified, it is assumed to be",
  "one.",
};

const char * const INSERTSTRING_HELP[12] = {
  "Syntax: InsertString [TEXT]",
  "Abbreviation: IS",
  "",
  "inserts TEXT at the current cursor position. If the optional argument",
  "TEXT is omitted, you will be prompted for it on the command line.  All",
  "the currently active preferences options (insert, word wrapping, auto",
  "indent, et cetera) are applied.",
  "",
  "   Note that `SaveMacro' converts `InsertChar' commands into a possibly",
  "smaller number of `InsertString' commands.  This makes macros easier to",
  "read and edit. See `SaveMacro'.",
};

const char * const LINEDOWN_HELP[6] = {
  "Syntax: LineDown [N]",
  "Abbreviation: LD",
  "",
  "moves the cursor down by one line N times. If the optional N argument",
  "is not specified, it is assumed to be one.",
};

const char * const LINEUP_HELP[6] = {
  "Syntax: LineUp [N]",
  "Abbreviation: LU",
  "",
  "moves the cursor up by one line N times. If the optional N argument is",
  "not specified, it is assumed to be one.",
};

const char * const LOADAUTOPREFS_HELP[7] = {
  "Syntax: LoadAutoPrefs",
  "Abbreviation: LAP",
  "",
  "loads the preferences file in `~/.ne' associated with the current",
  "document's file name extension. If the current file name has no",
  "extension, the default preferences are loaded.  See `AutoPrefs'.",
};

const char * const LOADPREFS_HELP[16] = {
  "Syntax: LoadPrefs [FILENAME]",
  "Abbreviation: LP",
  "",
  "loads the given preference file, and sets the current preferences",
  "accordingly.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.) If you escape from the file requester, you can",
  "input the file name on the command line.",
  "",
  "   Note that a preferences file is just a macro containing only option",
  "modifiers. You can manually edit a preferences file for special",
  "purposes, such as filtering out specific settings.",
};

const char * const MACRO_HELP[31] = {
  "Syntax: Macro [FILENAME]",
  "Abbreviation: MA",
  "",
  "executes the given file name as a macro.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can input the file name",
  "on the command line.",
  "",
  "   Note that macros whose name does not conflict with a command can be",
  "called without using `Macro'. Whenever `ne' is required to perform a",
  "command it cannot find in its internal tables, it will look for a macro",
  "by that name in the current directory. If this search also fails, `ne'",
  "looks in `~/.ne' and finally in the global ne directory (`/usr/lib/ne'",
  "by default, or in a place specified by your `NE_GLOBAL_DIR' environment",
  "variable) for a macro file by that name.",
  "",
  "*Warning:* to improve (greatly) efficiency, the first time a macro is",
  "executed it is cached into a hash table and is kept _forever_ in memory",
  "unless the `UnloadMacros' command is issued; see `UnloadMacros'.",
  "The next time a macro with the same file name is invoked, the cached",
  "list is searched for it before accessing the file using a case",
  "insensitive string comparison. That is, if you call `~/foobar/macro', a",
  "subsequent call for `/usr/MACRO' or even just `MaCrO' will use the",
  "cached version of `~/foobar/macro'.  Note that the cache table is",
  "global to `ne' and not specific to any single document.",
};

const char * const MARK_HELP[14] = {
  "Syntax: Mark [0|1]",
  "Abbreviation: M",
  "",
  "sets the mark at the current position or cancels the previous mark.",
  "The mark can then be used to perform clip operations. The clip commands",
  "act on the characters lying between the mark and the cursor.",
  "",
  "   If you invoke `Mark' with no arguments, it will toggle the mark. If",
  "you specify 0 or 1, the mark will be canceled or set to the current",
  "position, respectively.  A capital `M' appears on the status bar, if",
  "the mark is active.",
  "",
  "   See `Record', for the reason the mark is implemented as a flag.",
};

const char * const MARKVERT_HELP[10] = {
  "Syntax: MarkVert [0|1]",
  "Abbreviation: MV",
  "",
  "is the same as `Mark', but the mark is interpreted as vertical by the",
  "clip handling commands. This means that the region manipulated by the",
  "cut/paste commands is the rectangle having as vertices the cursor and",
  "the mark.  Moreover, a capital `V', rather than a capital `M', will",
  "appear on the status bar. Vertical cut/paste operations are useful for",
  "handling structured program indentation.",
};

const char * const MATCHBRACKET_HELP[8] = {
  "Syntax: MatchBracket",
  "Abbreviation: MB",
  "",
  "moves the cursor to the bracket associated with the bracket the cursor",
  "is on. If the cursor is not on a bracket, or there is no bracket",
  "associated with the current one, an error message is issued. Recognized",
  "brackets are `{}', `()', `[]' and `<>'.",
};

const char * const MODIFIED_HELP[15] = {
  "Syntax: Modified [0|1]",
  "Abbreviation: MOD",
  "",
  "sets the modified flag.  This flag is set automatically whenever a",
  "buffer is modified, and is used to determine which buffers need to be",
  "saved when `ne' exits.  Normally you would not alter this flag, but",
  "when a buffer is inadvertently modified and you don't want the changes",
  "saved, `Modified' provides a way to make `ne' consider the buffer",
  "unchanged.",
  "",
  "   If you invoke `Modified' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An asterisk (`*') will appear on the status bar if the",
  "flag is true.",
};

const char * const MOVEBOS_HELP[6] = {
  "Syntax: MoveBOS",
  "Abbreviation: BOS",
  "",
  "moves the cursor to the lowest line currently visible (`BOS' = bottom of",
  "screen).",
};

const char * const MOVEEOF_HELP[5] = {
  "Syntax: MoveEOF",
  "Abbreviation: EOF",
  "",
  "moves the cursor to the end of the document (`EOF' = end of file).",
};

const char * const MOVEEOL_HELP[5] = {
  "Syntax: MoveEOL",
  "Abbreviation: EOL",
  "",
  "moves the cursor to the end of the current line  (`EOL' = end of line).",
};

const char * const MOVEEOW_HELP[8] = {
  "Syntax: MoveEOW",
  "Abbreviation: EOW",
  "",
  "moves the cursor one character past the end of the current word.",
  "",
  "   `MoveEOW' is extremely useful in macros, because it allows you to",
  "copy precisely the word the cursor is on.",
};

const char * const MOVEINCDOWN_HELP[9] = {
  "Syntax: MoveIncDown",
  "Abbreviation: MID",
  "",
  "moves the cursor incrementally towards the end of the document.  More",
  "precisely, if the cursor is not on the end of the line it lies on, then",
  "it is moved to the end of that line. Otherwise, if it is on the last",
  "line of the screen, then it is moved to the end of the document;",
  "otherwise, it is moved to the last line of the screen.",
};

const char * const MOVEINCUP_HELP[9] = {
  "Syntax: MoveIncUp",
  "Abbreviation: MIU",
  "",
  "moves the cursor incrementally towards the beginning of the document.",
  "More precisely, if the cursor is not on the start of the line it lies",
  "on, then it is moved to the start of that line. Otherwise, if it is on",
  "the first line of the screen, then it is moved to the start of the",
  "document; otherwise, it is moved to the first line of the screen.",
};

const char * const MOVELEFT_HELP[6] = {
  "Syntax: MoveLeft [N]",
  "Abbreviation: ML",
  "",
  "moves the cursor to the left by one character N times. If the optional",
  "N argument is not specified, it is assumed to be one.",
};

const char * const MOVERIGHT_HELP[6] = {
  "Syntax: MoveRight [N]",
  "Abbreviation: MR",
  "",
  "moves the cursor to the right by one character N times. If the optional",
  "N argument is not specified, it is assumed to be one.",
};

const char * const MOVESOF_HELP[5] = {
  "Syntax: MoveSOF",
  "Abbreviation: SOF",
  "",
  "moves the cursor to the start of the document (`SOF' = start of file).",
};

const char * const MOVESOL_HELP[6] = {
  "Syntax: MoveSOL",
  "Abbreviation: SOL",
  "",
  "moves the cursor to the start of the current line (`SOL' = start of",
  "line).",
};

const char * const MOVETOS_HELP[5] = {
  "Syntax: MoveTOS",
  "Abbreviation: TOS",
  "",
  "moves the cursor to the top line of the screen (`TOS' = top of screen).",
};

const char * const NEWDOC_HELP[8] = {
  "Syntax: NewDoc",
  "Abbreviation: N",
  "",
  "creates a new, empty, unnamed document that becomes the current",
  "document.  The position of the document in the document list is just",
  "after the current document. The preferences of the new document are a",
  "copy of the preferences of the current document.",
};

const char * const NEXTDOC_HELP[5] = {
  "Syntax: NextDoc",
  "Abbreviation: ND",
  "",
  "sets as current document the next document in the document list.",
};

const char * const NEXTPAGE_HELP[8] = {
  "Syntax: NextPage [N]",
  "Abbreviation: NP",
  "",
  "moves the cursor N pages forward, if the cursor is on the last line of",
  "the screen; otherwise moves the cursor to the last line of the screen,",
  "and moves by N-1 pages. If the optional N argument is not specified, it",
  "is assumed to be one.",
};

const char * const NEXTWORD_HELP[6] = {
  "Syntax: NextWord [N]",
  "Abbreviation: NW",
  "",
  "moves the cursor to the next word N times. If the optional N argument",
  "is not specified, it is assumed to be one.",
};

const char * const NOFILEREQ_HELP[10] = {
  "Syntax: NoFileReq [0|1]",
  "Abbreviation: NFR",
  "",
  "sets the file requester flag. When this flag is true, the file",
  "requester is never opened, under any circumstances.",
  "",
  "   If you invoke `NoFileReq' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively.",
};

const char * const NOP_HELP[5] = {
  "Syntax: NOP",
  "Abbreviation: NOP",
  "",
  "does nothing. Mainly useful for inhibiting standard key bindings.",
};

const char * const OPEN_HELP[18] = {
  "Syntax: Open [FILENAME]",
  "Abbreviation: O",
  "",
  "loads the file specified by the FILENAME string into the current",
  "document.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can input the file name",
  "on the command line, the default being the current document name, if",
  "available.",
  "",
  "   If the current document is marked as modified at the time the",
  "command is issued, you have to confirm the action.",
};

const char * const OPENCLIP_HELP[14] = {
  "Syntax: OpenClip [FILENAME]",
  "Abbreviation: OC",
  "",
  "loads the given file name as the current clip, just as if you cut or",
  "copied it from the current document; see `Copy'.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester will open and you will be prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can enter the file name",
  "on the input line.",
};

const char * const OPENMACRO_HELP[14] = {
  "Syntax: OpenMacro [FILENAME]",
  "Abbreviation: OM",
  "",
  "loads the given file name as the current macro just as if you",
  "`Record'ed it; see `Record'.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can input the file name",
  "on the command line.",
};

const char * const OPENNEW_HELP[6] = {
  "Syntax: OpenNew [FILENAME]",
  "Abbreviation: ON",
  "",
  "is the same as `Open', but loads the file specified by the FILENAME",
  "string into a new document. See `Open'.",
};

const char * const PAGEDOWN_HELP[6] = {
  "Syntax: PageDown [N]",
  "Abbreviation: PDN",
  "",
  "pages the screen forward by N screens.  If N is not specified, it is",
  "assumed to be one.",
};

const char * const PAGEUP_HELP[6] = {
  "Syntax: PageUp [N]",
  "Abbreviation: PUP",
  "",
  "pages the screen backward by N screens.  If N is not specified, it is",
  "assumed to be one.",
};

const char * const PARAGRAPH_HELP[24] = {
  "Syntax: Paragraph [N]",
  "Abbreviation: PA",
  "",
  "reformats N paragraphs from the cursor position onwards. If N is not",
  "specified, it is assumed to be one. The paragraph are formatted",
  "relatively to the value of the right margin as set by the `RightMargin'",
  "command. See `RightMargin'.",
  "",
  "   `ne''s notion of a paragraph includes the current non-blank line",
  "(regardless of its leading white space) and all subsequent non-blank",
  "lines that have identical (to each other's--not to the first line's)",
  "leading white space. Therefore your paragraphs can have various first",
  "line indentations and left margins.",
  "",
  "   After the `Paragraph' command completes, your cursor will be",
  "positioned on the first non-blank character after the last reformatted",
  "paragraph (or, if there is no such character, at the end of the",
  "document).",
  "",
  "   If you think paragraphing should insert \"smart\" spaces after full",
  "stops and colons, and do other \"smart\" things such as justification,",
  "you should consider using a text formatter. TeX is usually the best",
  "choice.",
};

const char * const PASTE_HELP[7] = {
  "Syntax: Paste [N]",
  "Abbreviation: P",
  "",
  "pastes the contents of specified clip into the current document at the",
  "cursor position. If you don't specify the clip number, the current clip",
  "is used; Specify which clip is current with `ClipNumber'.",
};

const char * const PASTEVERT_HELP[7] = {
  "Syntax: PasteVert [N]",
  "Abbreviation: PV",
  "",
  "vertically pastes the contents of the specified clip, the default being",
  "the current clip. Each line of the clip is inserted on consecutive",
  "lines at the horizontal cursor position.",
};

const char * const PLAY_HELP[15] = {
  "Syntax: Play [TIMES]",
  "Abbreviation: PL",
  "",
  "plays the current macro for the given number of times. If the optional",
  "argument TIMES is not specified, you can enter it on the input line.",
  "",
  "   A (possibly iterated) macro execution terminates as soon as its",
  "stream of instructions is exhausted, or one of its commands returns an",
  "error. This means that, for instance, you can perform some complex",
  "operation on all the lines contaning a certain pattern by recording a",
  "macro that searches for the pattern and performs the operation, and",
  "then playing it a preposterously huge number of times.",
  "",
  "   Execution of a macro can be interrupted by `<Control>-\\'.",
};

const char * const POPPREFS_HELP[24] = {
  "Syntax: PopPrefs [N]",
  "Abbreviation: POPP",
  "",
  "pops N sets of preferences from the prefs stack (where they were placed",
  "previously by `PushPrefs') and applies those preferences to the current",
  "buffer. See `PushPrefs'. If not specified, N defaults to one.",
  "Note that the preferences stack is global, not buffer specific.",
  "Therefore you could `PushPrefs' one buffer's preferences, switch",
  "buffers, then `PopPrefs' those settings altering the preferences for",
  "the second buffer. The maximum preferences stack depth is 32.",
  "",
  "   `PushPrefs' and `PopPrefs' are useful in macros that require certain",
  "preferences to work properly.  A macro can `PushPrefs', change any",
  "preferences necessary, do its work, then `PopPrefs' to restore the",
  "users previous preferences settings.",
  "",
  "PopPrefs restores the following values from the prefs stack:",
  "",
  "        AutoIndent   DoUndo    NoFileReq    StatusBar",
  "        AutoPrefs    FastGUI   PreserveCR   TabSize",
  "        Binary       FreeForm  ReadOnly     Turbo",
  "        CaseSearch   HexCode   RightMargin  VerboseMacros",
  "        ClipNumber   Insert    SearchBack   WordWrap",
};

const char * const PRESERVECR_HELP[15] = {
  "Syntax: PreserveCR [0|1]",
  "Abbreviation: PCR",
  "",
  "sets the preserve carriage returns flag.  When a file is loaded into a",
  "buffer for which this flag is false, both CR (carriage return) and NL",
  "(new line) characters are treated as line terminators.  If the flag is",
  "true, CR characters do not act as line terminators but are instead",
  "preserved in the buffer. This flag has no effect except when loading a",
  "file into a buffer.",
  "",
  "   If you invoke `PreserveCR' with no arguments, it will toggle the",
  "flag.  If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An upper case `P' will appear on the status bar if the",
  "flag is true.",
};

const char * const PREVDOC_HELP[5] = {
  "Syntax: PrevDoc",
  "Abbreviation: PD",
  "",
  "sets as current document the previous document in the document list.",
};

const char * const PREVPAGE_HELP[8] = {
  "Syntax: PrevPage [N]",
  "Abbreviation: PP",
  "",
  "moves the cursor N pages backward, if the cursor is on the first line",
  "of the screen; otherwise moves the cursor to the first line of the",
  "screen, and moves by N-1 pages. If the optional N argument is not",
  "specified, it is assumed to be one.",
};

const char * const PREVWORD_HELP[8] = {
  "Syntax: PrevWord [N]",
  "Abbreviation: PW",
  "",
  "moves the cursor to the first character of the previous word N times.",
  "If the optional N argument is not specified, it is assumed to be one",
  "(in which case, if the cursor is in the middle of a word the effect is",
  "just to move it to the start of that word).",
};

const char * const PUSHPREFS_HELP[24] = {
  "Syntax: PushPrefs [N]",
  "Abbreviation: PUSHP",
  "",
  "pushes N copies of the user preferences onto a stack. If not specified,",
  "N defaults to one. Use the `PopPrefs' command to pop preferences off",
  "the stack and restore the values. See `PopPrefs'. Note that the",
  "preferences stack is global, not buffer-specific, so you could",
  "`PushPrefs' one buffer's preferences, switch buffers, then `PopPrefs'",
  "those preferences, thereby altering the preferences for the second",
  "buffer. The maximum preferences stack depth is 32.",
  "",
  "   `PushPrefs' and `PopPrefs' are useful in macros that require certain",
  "preferences to work properly.  A macro can `PushPrefs', change any",
  "preferences necessary, do its work, then `PopPrefs' to restore the",
  "users previous preferences settings.",
  "",
  "`PushPrefs' saves the following values on the prefs stack:",
  "",
  "        AutoIndent   DoUndo    NoFileReq    StatusBar",
  "        AutoPrefs    FastGUI   PreserveCR   TabSize",
  "        Binary       FreeForm  ReadOnly     Turbo",
  "        CaseSearch   HexCode   RightMargin  VerboseMacros",
  "        ClipNumber   Insert    SearchBack   WordWrap",
};

const char * const QUIT_HELP[6] = {
  "Syntax: Quit",
  "Abbreviation: Q",
  "",
  "closes all documents and exits. If any documents are modified, you have",
  "to confirm the action.",
};

const char * const READONLY_HELP[13] = {
  "Syntax: ReadOnly [0|1]",
  "Abbreviation: RO",
  "",
  "sets the read only flag. When this flag is true, no editing can be",
  "performed on the document (any such attempt produces an error message).",
  "This flag is automatically set whenever you open a file that you cannot",
  "write to.  See `Open'.",
  "",
  "   If you invoke `ReadOnly' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `r' will appear on the status bar if the",
  "flag is true.",
};

const char * const RECORD_HELP[21] = {
  "Syntax: Record [0|1]",
  "Abbreviation: Rec",
  "",
  "sets the recording state flag. When this flag becomes true, `ne' starts",
  "recording your actions in a new macro. When it becomes false, the macro",
  "recording is stopped, and the macro can be played or saved via ",
  "`Play', or `SaveMacro'.",
  "",
  "   If you call invoke `Record' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An upper case `R' will appear on the status bar if the",
  "flag is true.",
  "",
  "   The reason for providing a flag instead of an explicit start/stop",
  "recording command pair is that this way it is possible to bind both",
  "starting and stopping macro recording to a single key while still being",
  "able to specify \"absolute\" menu items (by using `Record 0' and `Record",
  "1'). For instance, the default key binding for `<Control>-T' is simply",
  "`Record', which means that this shortcut can be used both for",
  "initiating and for terminating a macro recording.",
};

const char * const REDO_HELP[8] = {
  "Syntax: Redo [N]",
  "Abbreviation: RE",
  "",
  "redoes the last N actions undone by `Undo' (as long as you don't take",
  "any actions that change the text between the `Undo' and `Redo'",
  "commands). If N is not specified, it is assumed to be one. You can only",
  "`Redo' actions that have been `Undo'ne. See `Undo'.",
};

const char * const REFRESH_HELP[11] = {
  "Syntax: Refresh",
  "Abbreviation: REF",
  "",
  "refreshes the display. `Refresh' is very important, and should",
  "preferably be bound to the `<Control>-L' sequence, for historical",
  "reasons. It can always happen that a noisy phone line or a quirk in the",
  "terminal corrupts the display. This command restores it from scratch.",
  "",
  "   `Refresh' has the side effect of checking to see if your window size",
  "has changed, and will modify the display to take that into account.",
};

const char * const REPEATLAST_HELP[26] = {
  "Syntax: RepeatLast [TIMES]",
  "Abbreviation: RL",
  "",
  "repeats for the given number of times the last find or replace operation",
  "(with replace we mean here a single replace, even if the last `Replace'",
  "operation ended with a global substitution).",
  "",
  "   `RepeatLast' is especially useful for researching a given number of",
  "times, or replacing something a given number of times. The standard",
  "technique for accomplishing this is:",
  "",
  "  1. `Find' (or `FindRegExp') the string you are interested in;",
  "",
  "  2. if you want to repeat a replace operation, `ReplaceOnce' with the",
  "     replacement string you are interested in;",
  "",
  "  3. now issue a `RepeatLast N-1' command, where N is the number of",
  "     occurrences you wanted to skip over, or replace.",
  "",
  "",
  "   The important thing about this sequence of actions is that it will",
  "work this way even in a macro. The `Replace' command cannot be used in",
  "a macro unless you really want to interact with `ne' during the macro",
  "execution. Avoiding interaction during macros is the primary reason the",
  "commands `ReplaceAll' and `ReplaceOnce' are provided.",
};

const char * const REPLACE_HELP[46] = {
  "Syntax: Replace [STRING]",
  "Abbreviation: R",
  "",
  "moves to the first match of the most recent find string or regular",
  "expression and prompts you for which action to perform. You can choose",
  "among:",
  "",
  "   * replacing the string found with the given string and moving to the",
  "     next match (`Yes');",
  "",
  "   * moving to the next match (`No');",
  "",
  "   * replacing the string found with the given string, and stopping the",
  "     search (`Last');",
  "",
  "   * stopping the search immediately (`Quit');",
  "",
  "   * replacing _all_ occurrences of the find string with the given",
  "     string (`All');",
  "",
  "   * reversing the search direction (`Backward' or `Forward'); this",
  "     choice will also modify the value of the back search flag.  See",
  "     `SearchBack'.",
  "",
  "",
  "   `Replace' is mainly useful for interactive editing. `ReplaceOnce',",
  "`ReplaceAll' and `RepeatLast' are more suited to macros.",
  "",
  "   If no find string was ever specified, you can enter it on the input",
  "line.  If the optional argument STRING is not specified, you can enter",
  "it on the input line, the default being the last string used. When the",
  "last search was a regular expression search, there are some special",
  "features you can use in the replace string . See `FindRegExp'.",
  "",
  "   Note that normally a search starts just one character after the",
  "cursor.  However, when `Replace' is invoked, the search starts at the",
  "character just _under_ the cursor, so that you can safely `Find' a",
  "pattern and `Replace' it without having to move back.",
  "",
  "*Warning:* when recording a macro with `Record', there is no",
  "trace in the macro of your interaction with `ne' during the replacement",
  "process. When the macro is played, you will again have to choose which",
  "actions to perform. If you want to apply automatic replacement of",
  "strings for a certain number of times, you should look at ",
  "`ReplaceOnce', `ReplaceAll', and `RepeatLast'.",
};

const char * const REPLACEALL_HELP[12] = {
  "Syntax: ReplaceAll [STRING]",
  "Abbreviation: RA",
  "",
  "is similar to `ReplaceOnce', but replaces _all_ occurrences of the last",
  "search pattern with the given replacement string.",
  "",
  "   If the optional argument STRING is not specified, you can enter it on",
  "the input line, the default being the last string used.",
  "",
  "   Note that `Undo' will restore _all_ the occurrences of the search",
  "pattern replaced by `ReplaceAll'. See `Undo'.",
};

const char * const REPLACEONCE_HELP[10] = {
  "Syntax: ReplaceOnce [STRING]",
  "Abbreviation: R1",
  "",
  "acts just like `Replace', but without any interaction with you (unless",
  "there is no find string). The first string matched by the last search",
  "pattern, if it exists, is replaced by the given replacement string.",
  "",
  "   If the optional argument STRING is not specified, you can enter it on",
  "the input line, the default being the last string used.",
};

const char * const RIGHTMARGIN_HELP[12] = {
  "Syntax: RightMargin [N]",
  "Abbreviation: RM",
  "",
  "sets the right margin for all formatting operations, and for `WordWrap'.",
  "See `WordWrap'.",
  "",
  "   If the optional argument N is not specified, you can enter it on the",
  "input line, the default being the current value of the right margin.",
  "",
  "   A value of zero for N will force `ne' to use (what it thinks it is)",
  "the current screen width as right margin.",
};

const char * const SAVE_HELP[13] = {
  "Syntax: Save",
  "Abbreviation: S",
  "",
  "saves the current document using its default file name.",
  "",
  "   If the current document is unnamed, the file requester will open and",
  "you will be prompted to select a file. (You can inhibit the file",
  "requester opening by using the `NoFileReq' command; see ",
  "`NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can input the file name",
  "on the command line.",
};

const char * const SAVEAS_HELP[14] = {
  "Syntax: SaveAs [FILENAME]",
  "Abbreviation: SA",
  "",
  "saves the current document using the specified string as the file name.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester will open and you will be prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can enter the file name",
  "on the input line, the default being the current document name, if",
  "available.",
};

const char * const SAVEAUTOPREFS_HELP[7] = {
  "Syntax: SaveAutoPrefs",
  "Abbreviation: SAP",
  "",
  "saves the current preferences on the file in `~/.ne' associated with",
  "the current document's file name extension. If the current file name",
  "has no extension, an error message is issued.  See `AutoPrefs'.",
};

const char * const SAVECLIP_HELP[13] = {
  "Syntax: SaveClip [FILENAME]",
  "Abbreviation: SC",
  "",
  "saves the current clip on the given file name.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester will open and you will be prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can enter the file name",
  "on the input line.",
};

const char * const SAVEDEFPREFS_HELP[6] = {
  "Syntax: SaveDefPrefs",
  "Abbreviation: SDP",
  "",
  "saves the current preferences on the `~/.ne/.default#ap' file.  This",
  "file is always loaded by `ne' at startup.",
};

const char * const SAVEMACRO_HELP[20] = {
  "Syntax: SaveMacro [FILENAME]",
  "Abbreviation: SM",
  "",
  "saves the current macro in a file with the given name.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.)",
  "",
  "   If you escape from the file requester, you can input the file name",
  "on the command line.",
  "",
  "   `SaveMacro' is of course most useful for saving macros you just",
  "recorded. The macros can then be loaded as normal text files for",
  "further editing, if necessary. Note that `SaveMacro' converts",
  "`InsertChar' commands into a possibly smaller number of `InsertString'",
  "commands. This makes macros easier to read and edit. See ",
  "`InsertChar', and `InsertString'.",
};

const char * const SAVEPREFS_HELP[11] = {
  "Syntax: SavePrefs [FILENAME]",
  "Abbreviation: SP",
  "",
  "saves the current preferences on the given file.",
  "",
  "   If the optional FILENAME argument is not specified, the file",
  "requester is opened, and you are prompted to select a file. (You can",
  "inhibit the file requester opening by using the `NoFileReq' command;",
  "see `NoFileReq'.) If you escape from the file requester, you can",
  "input the file name on the command line.",
};

const char * const SEARCHBACK_HELP[14] = {
  "Syntax: SearchBack [0|1]",
  "Abbreviation: SB",
  "",
  "sets the back search flag. When this flag is true, every search or",
  "replacement command is performed backwards.",
  "",
  "   If you invoke `SearchBack' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `b' will appear on the status bar if the",
  "flag is true.",
  "",
  "   Note that this flag also can be set through interactions with the",
  "`Replace' command. See `Replace'.",
};

const char * const SELECTDOC_HELP[14] = {
  "Syntax: SelectDoc",
  "Abbreviation: SD",
  "",
  "displays a requester containing the names of all the documents in",
  "memory. You select whichever document you want to become the current",
  "document.",
  "",
  "   If you escape from the requester the requester goes away and you are",
  "returned to your original current document.",
  "",
  "   `SelectDoc' is especially useful if you have a large number of",
  "documents open (say, more than 10). Otherwise, `NextDoc' and `PrevDoc'",
  "should be enough. See `NextDoc', and `PrevDoc'.",
};

const char * const SETBOOKMARK_HELP[10] = {
  "Syntax: SetBookmark [N|-]",
  "Abbreviation: SBM",
  "",
  "sets the Nth bookmark to the current cursor position. If the optional N",
  "argument is not specified, it is assumed to be zero. You can also unset",
  "the `-' automatic bookmark, but it will be reset automatically to the",
  "current position whenever a `GotoBookmark' command is issued. Each",
  "document's valid bookmark designations are 0 to 9, and the `-' automatic",
  "bookmark.",
};

const char * const STATUSBAR_HELP[19] = {
  "Syntax: StatusBar [0|1]",
  "Abbreviation: ST",
  "",
  "sets the status bar flag. When this flag is true, the status bar is",
  "displayed at the bottom of the screen. There are only two reasons to",
  "turn off the status bar we are aware of:",
  "",
  "   * if you are using `ne' through a slow connection, updating the",
  "     line/column indicator can really slow down editing;",
  "",
  "   * scrolling caused by cursor movement on terminals that do not allow",
  "     to set a scrolling region can produce annoying flashes at the",
  "     bottom of the screen.",
  "",
  "",
  "   If you invoke `StatusBar' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively.",
};

const char * const SUSPEND_HELP[6] = {
  "Syntax: Suspend",
  "Abbreviation: SU",
  "",
  "suspends `ne' and returns you to a shell prompt; usually, the shell",
  "command `fg' is used to resume `ne'.",
};

const char * const SYSTEM_HELP[10] = {
  "Syntax: System [COMMAND]",
  "Abbreviation: SYS",
  "",
  "asks the shell to execute COMMAND. The terminal is temporarily reset to",
  "the state it was in before `ne''s activation, and COMMAND is started.",
  "When the execution is finished, control returns to `ne'.",
  "",
  "   If the optional argument COMMAND is not specified, you can enter it",
  "on the input line.",
};

const char * const TABSIZE_HELP[9] = {
  "Syntax: TabSize [SIZE]",
  "Abbreviation: TS",
  "",
  "sets the number of spaces `ne' will use when expanding a TAB character.",
  "",
  "   If the optional argument SIZE is not specified, you can enter it on",
  "the input line, the default being the current TAB size. Allowed values",
  "are strictly between 0 and half the width of the screen.",
};

const char * const THROUGH_HELP[15] = {
  "Syntax: Through [COMMAND]",
  "Abbreviation: T",
  "",
  "asks the shell to execute COMMAND, piping the current block in the",
  "standard input, and replacing it with the output of the command. This",
  "command is most useful with filters, such as `sort'. Its practical",
  "effect is to pass the block through the specified filter.",
  "",
  "   Note that by selecting an empty block (or equivalently by having the",
  "mark unset) you can use `Through' to insert the output of any UN*X",
  "command in your file.",
  "",
  "   If the optional argument COMMAND is not specified, you can enter it",
  "on the input line.",
};

const char * const TOGGLESEOF_HELP[10] = {
  "Syntax: ToggleSEOF",
  "Abbreviation: TSEOF",
  "",
  "moves the cursor to the start of document, if it is not already there;",
  "otherwise, moves it to the end of the document.",
  "",
  "   This kind of toggling command is very useful in order to gain some",
  "keystrokes on systems with very few keys. See also `ToggleSEOL',",
  "`MoveSOF', and `MoveEOF'.",
};

const char * const TOGGLESEOL_HELP[10] = {
  "Syntax: ToggleSEOL",
  "Abbreviation: TSEOL",
  "",
  "moves the cursor to the start of the current line, if it is not already",
  "there; otherwise, moves it to the end of the current line.",
  "",
  "   This kind of toggling command is very useful in order to gain some",
  "keystrokes on systems with very few keys. See also `ToggleSEOF',",
  "`MoveSOL', and `MoveEOL'.",
};

const char * const TOLOWER_HELP[5] = {
  "Syntax: ToLower [N]",
  "Abbreviation: TL",
  "",
  "acts exactly like `ToUpper', but lowers the case. See `ToUpper'.",
};

const char * const TOUPPER_HELP[15] = {
  "Syntax: ToUpper [N]",
  "Abbreviation: TU",
  "",
  "shifts to upper case the letters from the cursor position up to the end",
  "of a word, and moves to the first letter of next word for N times.",
  "",
  "   The description of the command may seem a little bit cryptic. What",
  "is really happening is that there are situations where you only want to",
  "upper case the last part of a word. In this case, you just have to",
  "position the cursor in the first character you want to upper case, and",
  "use `ToUpper' with no argument.",
  "",
  "   If you apply `ToUpper' on the first character of a word, it will",
  "just upper case N words.",
};

const char * const TURBO_HELP[29] = {
  "Syntax: Turbo [STEPS]",
  "Abbreviation: TUR",
  "",
  "sets the turbo parameter. Iterated actions and global replaces will",
  "update at most STEPS line of the screen (or at most twice the number of",
  "visible rows if STEPS is zero); then, update will be delayed to the end",
  "of the action.",
  "",
  "   This feature is most useful when massive operations (such as",
  "replacing thousands of occurrences of a pattern) have to be performed.",
  "After having updated STEPS lines, `ne' can proceed at maximum speed,",
  "because no visual update has to be performed.",
  "",
  "   The value of the turbo parameter has to be adapted to the kind of",
  "terminal you are using. Very high values can be good on high-speed",
  "terminals, since the time required for the visual updates is very small,",
  "and it is always safer to look at what the editor is really doing. On",
  "slow terminals, however, small values ensure that operations such as",
  "paragraph formatting will not take too long.",
  "",
  "   You have to be careful about setting the turbo parameter too low.",
  "`ne' keeps track internally of the part of the screen that needs",
  "refresh in a very rough way. This means that a value of less than, say,",
  "8 will force it to do a lot of unnecessary refresh.",
  "",
  "   The default value of this parameter is zero, which means twice the",
  "number of lines of the screen; for several reasons this does seem to be",
  "a good value.",
};

const char * const UNDELLINE_HELP[15] = {
  "Syntax: UndelLine [N]",
  "Abbreviation: UL",
  "",
  "inserts at the cursor position for N times the last non-empty line that",
  "was deleted with the `DeleteLine' command. If N is not specified, it is",
  "assumed to be one.",
  "",
  "   `UndelLine' is most useful in that it allows a very fast way of",
  "moving one line around. Just delete it, and undelete it somewhere else.",
  "It is also an easy way to replicate a line without getting involved",
  "with clips.",
  "",
  "   Note that `UndelLine' works independently of the status of the undo",
  "flag. See `DoUndo'.",
};

const char * const UNDO_HELP[9] = {
  "Syntax: Undo [N]",
  "Abbreviation: U",
  "",
  "undoes the last N actions. If N is not specified, it is assumed to be",
  "one. After you undo a number of actions, you can `Redo' all or some of",
  "them; see `Redo'. However, if you take any new actions after",
  "having `Undo'ne some, you can no longer `Redo' those `Undo'ne actions.",
  "See `Redo'.",
};

const char * const UNLOADMACROS_HELP[12] = {
  "Syntax: UnloadMacros",
  "Abbreviation: UM",
  "",
  "frees the macro cache list. After this command, the `Macro' command",
  "will be forced to search for the file containing the macros it has to",
  "play.",
  "",
  "   `UnloadMacros' is especially useful if you are experimenting with a",
  "macro bound to some keystroke, and you are interactively modifying it",
  "and playing it.  `UnloadMacros' forces `ne' to look for the newer",
  "version available.",
};

const char * const UNSETBOOKMARK_HELP[10] = {
  "Syntax: UnsetBookmark [N|-]",
  "Abbreviation: UBM",
  "",
  "unsets the Nth bookmark, making it as if it had never been set; see",
  "`SetBookmark'. If the optional N argument is not specified, it is",
  "assumed to be zero. You can also unset the `-' automatic bookmark, but",
  "it will be reset automatically to the current position whenever a",
  "`GotoBookmark' command is issued. Each document's valid bookmark",
  "designations are 0 to 9, and the  `-' automatic bookmark.",
};

const char * const UTF8_HELP[20] = {
  "Syntax: UTF8 [0|1]",
  "Abbreviation: U8",
  "",
  "sets the UTF-8 flag.  When this flag is true, `ne' considers the",
  "current buffer as UTF-8 coded.  Note that this flag is set",
  "automatically upon file loading (if possible) if you required automatic",
  "detection. See `UTF8Auto'.",
  "",
  "   If you invoke `UTF8' with no arguments, it will toggle the flag.  If",
  "you specify 0 or 1, the flag will be set to false or true,",
  "respectively. When you try to set this flag, the buffer will be checked",
  "for UTF-8 compliance, and you will get an error message in case of",
  "failure. When you try to reset it, the buffer is set to ASCII or",
  "ISO8859, depending on its content.  A `U' will appear on the status bar",
  "if the flag is true. Alternatively, an `A' or an `8' will be displayed",
  "to denote whether the buffer is composed esclusively by US-ASCII",
  "characters, or also by other 8-bit characters (which are likely to be",
  "ISO-8859 encoded). Note that each time this command modifies the buffer",
  "encoding, it also resets the undo buffer.",
};

const char * const UTF8AUTO_HELP[14] = {
  "Syntax: UTF8Auto [0|1]",
  "Abbreviation: U8A",
  "",
  "sets the UTF-8 automatic-detection flag.  When this flag is true, `ne'",
  "will try to guess whether a file just loaded is UTF-8 encoded.",
  "Moreover, when a non US-ASCII character is inserted in a pure US-ASCII",
  "buffer, ne will automatically switch to UTF-8. See `UTF8'. The",
  "flag is true by default if `ne' detects UTF-8 I/O at startup. See ",
  "`UTF8IO'.",
  "",
  "   If you invoke `UTF8Auto' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively.",
};

const char * const UTF8IO_HELP[13] = {
  "Syntax: UTF8IO [0|1]",
  "Abbreviation: U8IO",
  "",
  "sets the UTF-8 input/output flag.  This flag is set automatically",
  "depending on your locale setting, and is used to determine whether",
  "communication with the user (keyboard and terminal) should be UTF-8",
  "encoded. Normally you would not alter this flag, but sometimes `ne' may",
  "make the wrong guess (e.g., when you are remotely connected).",
  "",
  "   If you invoke `UTF8IO' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. An `@' will appear on the status bar if the flag is true.",
};

const char * const VERBOSEMACROS_HELP[17] = {
  "Syntax: VerboseMacros [0|1]",
  "Abbreviation: VM",
  "",
  "sets the verbose macros flag. When this flag is true, all macros",
  "generated by recording or by automatic preferences saving will contain",
  "full names, instead of short names. This is highly desirable if you are",
  "going to edit the macro manually, but it can slow down command parsing.",
  "",
  "   If you invoke `VerboseMacros' with no arguments, it will toggle the",
  "flag. If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `v' will appear on the status bar if the",
  "flag is true.",
  "",
  "   The only reason to use this flag is when recording a macro that will",
  "be played a great number of times. Automatic preferences files are too",
  "short to be an issue with respect to execution timing.",
};

const char * const WORDWRAP_HELP[12] = {
  "Syntax: WordWrap [0|1]",
  "Abbreviation: WW",
  "",
  "sets the word wrap flag. When this flag is true, `ne' will automatically",
  "break lines of text longer than the current right margin while you type",
  "them. See `RightMargin'.",
  "",
  "   If you invoke `WordWrap' with no arguments, it will toggle the flag.",
  "If you specify 0 or 1, the flag will be set to false or true,",
  "respectively. A lower case `w' will appear on the status bar if the",
  "flag is true.",
};

/* This file was automatically generated by info2src.pl. */
