/* $Id: BioSource.cpp 489235 2016-01-11 17:03:30Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'seqfeat.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/seqfeat/BioSource.hpp>
#include <objects/seqfeat/Org_ref.hpp>
#include <objects/seqfeat/OrgName.hpp>
#include <objects/seqfeat/OrgMod.hpp>
#include <objects/seqfeat/SubSource.hpp>
#include <objects/seqfeat/PCRReactionSet.hpp>
#include <algorithm>
#include <set>
#include <util/static_map.hpp>
#include <corelib/ncbistr.hpp>
#include <corelib/ncbistre.hpp>
#include <corelib/ncbienv.hpp>
#include <corelib/ncbiobj.hpp>
#include <corelib/ncbi_limits.h>
#include <memory>
#include <set>
#include <list>
#include <vector>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CBioSource::~CBioSource(void)
{
}


int CBioSource::GetGenCode(int def) const
{
    try {
        TGenome genome = CanGetGenome() ? GetGenome() : eGenome_unknown;

        if ( !CanGetOrg()  ||  !GetOrg().CanGetOrgname() ) {
            return def; // assume standard genetic code
        }
        const COrgName& orn = GetOrg().GetOrgname();

        switch ( genome ) {
        case eGenome_kinetoplast:
        case eGenome_mitochondrion:
        case eGenome_hydrogenosome:
        case eGenome_plasmid_in_mitochondrion:
            {
                // mitochondrial code
                if (orn.IsSetMgcode()) {
                    return orn.GetMgcode();
                }
                return def;
            }
        case eGenome_chloroplast:
        case eGenome_chromoplast:
        case eGenome_plastid:
        case eGenome_cyanelle:
        case eGenome_apicoplast:
        case eGenome_leucoplast:
        case eGenome_proplastid:
        case eGenome_chromatophore:
        case eGenome_plasmid_in_plastid:
            {
                // bacteria and plant plastid code
                if (orn.IsSetPgcode()) {
                    int pgcode = orn.GetPgcode();
                    if (pgcode > 0) return pgcode;
                }
                // bacteria and plant plastids default to code 11.
                return 11;
            }
        default:
            {
                if (orn.IsSetGcode()) {
                    return orn.GetGcode();
                }
                return def;
            }
        }
    } catch (...) {
        return def; // was 0(!)
    }
}

typedef SStaticPair<const char *, CBioSource::EGenome> TGenomeKey;

static const TGenomeKey genome_key_to_subtype [] = {
    {  "apicoplast",                CBioSource::eGenome_apicoplast        },
    {  "chloroplast",               CBioSource::eGenome_chloroplast       },
    {  "chromatophore",             CBioSource::eGenome_chromatophore     },
    {  "chromoplast",               CBioSource::eGenome_chromoplast       },
    {  "cyanelle",                  CBioSource::eGenome_cyanelle          },
    {  "endogenous_virus",          CBioSource::eGenome_endogenous_virus  },
    {  "extrachrom",                CBioSource::eGenome_extrachrom        },
    {  "genomic",                   CBioSource::eGenome_genomic           },
    {  "hydrogenosome",             CBioSource::eGenome_hydrogenosome     },
    {  "insertion_seq",             CBioSource::eGenome_insertion_seq     },
    {  "kinetoplast",               CBioSource::eGenome_kinetoplast       },
    {  "leucoplast",                CBioSource::eGenome_leucoplast        },
    {  "macronuclear",              CBioSource::eGenome_macronuclear      },
    {  "mitochondrion",             CBioSource::eGenome_mitochondrion     },
    {  "mitochondrion:kinetoplast", CBioSource::eGenome_kinetoplast       },
    {  "nucleomorph",               CBioSource::eGenome_nucleomorph       },
    {  "plasmid",                   CBioSource::eGenome_plasmid           },
    {  "plastid",                   CBioSource::eGenome_plastid           },
    {  "plastid:apicoplast",        CBioSource::eGenome_apicoplast        },
    {  "plastid:chloroplast",       CBioSource::eGenome_chloroplast       },
    {  "plastid:chromatophore", CBioSource::eGenome_chromatophore         },
    {  "plastid:chromoplast", CBioSource::eGenome_chromoplast             },
    {  "plastid:cyanelle",          CBioSource::eGenome_cyanelle          },
    {  "plastid:leucoplast",        CBioSource::eGenome_leucoplast        },
    {  "plastid:proplastid",        CBioSource::eGenome_proplastid        },
    {  "proplastid",                CBioSource::eGenome_proplastid        },
    {  "proviral",                  CBioSource::eGenome_proviral          },
    {  "transposon",                CBioSource::eGenome_transposon        },
    {  "unknown",                   CBioSource::eGenome_unknown           },
    {  "virion",                    CBioSource::eGenome_virion            }
};


typedef CStaticPairArrayMap <const char*, CBioSource::EGenome, PNocase_CStr> TGenomeMap;
DEFINE_STATIC_ARRAY_MAP(TGenomeMap, sm_GenomeKeys, genome_key_to_subtype);

CBioSource::EGenome CBioSource::GetGenomeByOrganelle (const string& organelle, NStr::ECase use_case, bool starts_with)
{
    CBioSource::EGenome gtype = CBioSource::eGenome_unknown;

    if (use_case == NStr::eCase && !starts_with) {       
        TGenomeMap::const_iterator g_iter = sm_GenomeKeys.find (organelle.c_str ());
        if (g_iter == sm_GenomeKeys.end()) {
            if (NStr::Equal(organelle, "mitochondrial")) {
                gtype = CBioSource::eGenome_mitochondrion;
            }
        } else {
            gtype = g_iter->second;
        }
    } else {
        TGenomeMap::const_iterator g_iter = sm_GenomeKeys.begin();
        if (starts_with) {
            if (NStr::StartsWith(organelle, "mitochondrial", use_case)){
                gtype = CBioSource::eGenome_mitochondrion;
            } else {
                string match;
                while (g_iter != sm_GenomeKeys.end() && gtype == CBioSource::eGenome_unknown) {
                    match = g_iter->first;
                    if (NStr::StartsWith(organelle, match.c_str(), use_case)) {
                        if (organelle.length() == match.length()
                            || (match.length() < organelle.length() && isspace(organelle[match.length()]))) {
                            gtype = g_iter->second;
                        }
                    }
                    ++g_iter;
                }
            }
        } else {
            if (NStr::Equal(organelle, "mitochondrial", use_case)) {
                gtype = CBioSource::eGenome_mitochondrion;
            } else {
                while (g_iter != sm_GenomeKeys.end() && gtype == CBioSource::eGenome_unknown) {
                    if (NStr::Equal(organelle, g_iter->first, use_case)) {
                        gtype = g_iter->second;
                    }
                    ++g_iter;
                }
            }
        }
    }
    return gtype;
}


string CBioSource::GetOrganelleByGenome (unsigned int genome)
{
    string organelle = kEmptyStr;
    TGenomeMap::const_iterator g_iter = sm_GenomeKeys.begin();
    while (g_iter != sm_GenomeKeys.end() &&
           unsigned(g_iter->second) != genome) {
        ++g_iter;
    }
    if (g_iter != sm_GenomeKeys.end()) {
        organelle = g_iter->first;
    }
    return organelle;
}


typedef SStaticPair<const char *, CBioSource::EOrigin> TOriginKey;

static const TOriginKey origin_key_to_subtype [] = {
    {  "artificial",                CBioSource::eOrigin_artificial    },
    {  "mutant",                    CBioSource::eOrigin_mut           },
    {  "natural",                   CBioSource::eOrigin_natural       },
    {  "natural mutant",            CBioSource::eOrigin_natmut        },
    {  "other",                     CBioSource::eOrigin_other         },
    {  "synthetic",                 CBioSource::eOrigin_synthetic     },
    {  "unknown",                   CBioSource::eOrigin_unknown       }
};

static const TOriginKey origin_synonyms [] = {
    {  "mut",                       CBioSource::eOrigin_mut           },
    {  "nat mut",                   CBioSource::eOrigin_natmut        },
    {  "natmut",                    CBioSource::eOrigin_natmut        }
};


typedef CStaticPairArrayMap <const char*, CBioSource::EOrigin, PNocase_CStr> TOriginMap;
DEFINE_STATIC_ARRAY_MAP(TOriginMap, sm_OriginKeys, origin_key_to_subtype);
DEFINE_STATIC_ARRAY_MAP(TOriginMap, sm_OriginSynonyms, origin_synonyms);

CBioSource::EOrigin CBioSource::GetOriginByString (const string& origin, NStr::ECase use_case, bool starts_with)
{
    CBioSource::EOrigin gtype = CBioSource::eOrigin_unknown;

    if (use_case == NStr::eCase && !starts_with) {
        TOriginMap::const_iterator g_iter = sm_OriginKeys.find (origin.c_str ());
        if (g_iter == sm_OriginKeys.end ()) {
            g_iter = sm_OriginSynonyms.find (origin.c_str());
            if (g_iter != sm_OriginSynonyms.end ()) {
                gtype = g_iter->second;
            }
        } else {
            gtype = g_iter->second;
        }
    } else {
        TOriginMap::const_iterator g_iter = sm_OriginKeys.begin();
        bool found = false;
        if (starts_with) {
            string match;
            while (g_iter != sm_OriginKeys.end() && !found) {
                match = g_iter->first;
                if (NStr::StartsWith(origin, match.c_str(), use_case)) {
                    if (origin.length() == match.length()
                        || (match.length() < origin.length() && isspace (origin[match.length()]))) {
                        gtype = g_iter->second;
                        found = true;
                    }
                }
                ++g_iter;
            }
            if (!found) {
                g_iter = sm_OriginSynonyms.begin();
                while (g_iter != sm_OriginSynonyms.end() && !found) {
                    match = g_iter->first;
                    if (NStr::StartsWith(origin, match.c_str(), use_case)) {
                        if (origin.length() == match.length()
                            || (match.length() < origin.length() && isspace (origin[match.length()]))) {
                            gtype = g_iter->second;
                            found = true;
                        }
                    }
                    ++g_iter;
                }
            }
        } else {
            while (g_iter != sm_OriginKeys.end() && !found) {
                if (NStr::Equal(origin, g_iter->first, use_case)) {
                    gtype = g_iter->second;
                }
                ++g_iter;
            }
            if (!found) {
                g_iter = sm_OriginSynonyms.begin();
                while (g_iter != sm_OriginSynonyms.end() && !found) {
                    if (NStr::Equal(origin, g_iter->first, use_case)) {
                        gtype = g_iter->second;
                    }
                    ++g_iter;
                }
            }
        }
    }
    return gtype;
}


string CBioSource::GetStringFromOrigin (unsigned int origin)
{
    string origin_str = "";
    TOriginMap::const_iterator g_iter = sm_OriginKeys.begin();
    while (g_iter != sm_OriginKeys.end() &&
           unsigned(g_iter->second) != origin) {
        ++g_iter;
    }
    if (g_iter != sm_OriginKeys.end()) {
        origin_str = g_iter->first;
    }
    return origin_str;
}


bool CBioSource::IsSetTaxname(void) const
{
    return IsSetOrg () && GetOrg ().IsSetTaxname ();
}

const string& CBioSource::GetTaxname(void) const
{
    return GetOrg ().GetTaxname ();
}

bool CBioSource::IsSetCommon(void) const
{
    return IsSetOrg () && GetOrg ().IsSetCommon ();
}

const string& CBioSource::GetCommon(void) const
{
    return GetOrg ().GetCommon ();
}

bool CBioSource::IsSetLineage(void) const
{
    return IsSetOrg () && GetOrg ().IsSetLineage ();
}

const string& CBioSource::GetLineage(void) const
{
    return GetOrg ().GetLineage ();
}

bool CBioSource::IsSetGcode(void) const
{
    return IsSetOrg () && GetOrg ().IsSetGcode ();
}

int CBioSource::GetGcode(void) const
{
    return GetOrg ().GetGcode ();
}

bool CBioSource::IsSetMgcode(void) const
{
    return IsSetOrg () && GetOrg ().IsSetMgcode ();
}

int CBioSource::GetMgcode(void) const
{
    return GetOrg ().GetMgcode ();
}

bool CBioSource::IsSetPgcode(void) const
{
    return IsSetOrg () && GetOrg ().IsSetPgcode ();
}

int CBioSource::GetPgcode(void) const
{
    return GetOrg ().GetPgcode ();
}

bool CBioSource::IsSetDivision(void) const
{
    return IsSetOrg () && GetOrg ().IsSetDivision ();
}

const string& CBioSource::GetDivision(void) const
{
    return GetOrg ().GetDivision ();
}

bool CBioSource::IsSetOrgname(void) const
{
    return IsSetOrg () && GetOrg ().IsSetOrgname ();
}

const COrgName& CBioSource::GetOrgname(void) const
{
    return GetOrg ().GetOrgname ();
}

bool CBioSource::IsSetOrgMod(void) const
{
  return IsSetOrg () && GetOrg ().IsSetOrgMod ();
}


string CBioSource::GetRepliconName(void) const
{
    ITERATE (CBioSource::TSubtype, sit, GetSubtype()) {
        if ((*sit)->IsSetSubtype() && (*sit)->GetSubtype() == CSubSource::eSubtype_plasmid_name
            && (*sit)->IsSetName()) {
            return (*sit)->GetName();
        }
    }

    if (IsSetGenome() && GetGenome() == CBioSource::eGenome_chromosome) {
        ITERATE (CBioSource::TSubtype, sit, GetSubtype()) {
            if ((*sit)->IsSetSubtype() && (*sit)->GetSubtype() == CSubSource::eSubtype_linkage_group
                && (*sit)->IsSetName()) {
                return (*sit)->GetName();
            }
        }
    }

    ITERATE (CBioSource::TSubtype, sit, GetSubtype()) {
        if ((*sit)->IsSetSubtype() && (*sit)->GetSubtype() == CSubSource::eSubtype_chromosome
            && (*sit)->IsSetName()) {
            return (*sit)->GetName();
        }
    }

    // no other name found
    if (IsSetGenome()) {
        switch (GetGenome()) {
            case CBioSource::eGenome_plasmid:
            case CBioSource::eGenome_plasmid_in_mitochondrion:
            case CBioSource::eGenome_plasmid_in_plastid:
                return "unnamed";
                break;
            case CBioSource::eGenome_chromosome:
                return "ANONYMOUS";
                break;
            case CBioSource::eGenome_kinetoplast:
                return "kinetoplast";
                break;
            case CBioSource::eGenome_plastid:
            case CBioSource::eGenome_chloroplast:
            case CBioSource::eGenome_chromoplast:
            case CBioSource::eGenome_apicoplast:
            case CBioSource::eGenome_leucoplast:
            case CBioSource::eGenome_proplastid:
            case CBioSource::eGenome_chromatophore:
                return "Pltd";
                break;
            case CBioSource::eGenome_mitochondrion:
            case CBioSource::eGenome_hydrogenosome:
                return "MT";
                break;
        }
    }
    return kEmptyStr;
}


string CBioSource::GetBioprojectType (void) const
{
    if (IsSetGenome()) {
        switch (GetGenome()) {
            case CBioSource::eGenome_plasmid:
            case CBioSource::eGenome_plasmid_in_mitochondrion:
            case CBioSource::eGenome_plasmid_in_plastid:
                return "ePlasmid";
                break;
        }
    }

    ITERATE (CBioSource::TSubtype, sit, GetSubtype()) {
        if ((*sit)->IsSetSubtype() && (*sit)->GetSubtype() == CSubSource::eSubtype_plasmid_name) {
            return "ePlasmid";
        }
    }

    if (IsSetGenome() && GetGenome() == CBioSource::eGenome_chromosome) {
        ITERATE (CBioSource::TSubtype, sit, GetSubtype()) {
            if ((*sit)->IsSetSubtype() && (*sit)->GetSubtype() == CSubSource::eSubtype_linkage_group) {
                return "eLinkageGroup";
            }
        }
    }

    return "eChromosome";
}


string CBioSource::GetBioprojectLocation(void) const
{
    if (IsSetGenome() && GetGenome() == CBioSource::eGenome_chromosome) {
        return "eNuclearProkaryote";
    }

    if (IsSetGenome()) {
        switch (GetGenome()) {
            case CBioSource::eGenome_unknown:
            case CBioSource::eGenome_genomic:
                return "eNuclearProkaryote";
                break;
            case CBioSource::eGenome_mitochondrion:
                return "eMitochondrion";
                break;
            case CBioSource::eGenome_kinetoplast:
                return "eKinetoplast";
                break;
            case CBioSource::eGenome_chromosome:
                return "eNuclearProkaryote";
                break;
            case CBioSource::eGenome_chloroplast:
                return "eChloroplast";
                break;
            case CBioSource::eGenome_chromoplast:
                return "eChromoplast";
                break;
            case CBioSource::eGenome_plastid:
                return "ePlastid";
                break;
            case CBioSource::eGenome_macronuclear:
                return "eMacronuclear";
                break;
            case CBioSource::eGenome_extrachrom:
                return "eOtherLoc";
                break;
            case CBioSource::eGenome_cyanelle:
                return "eCyanelle";
                break;
            case CBioSource::eGenome_proviral:
                return "eProviralProphage";
                break;
            case CBioSource::eGenome_virion:
                return "eVirionPhage";
                break;
            case CBioSource::eGenome_nucleomorph:
                return "eNucleomorph";
                break;
            case CBioSource::eGenome_apicoplast:
                return "eApicoplast";
                break;
            case CBioSource::eGenome_leucoplast:
                return "eLeucoplast";
                break;
            case CBioSource::eGenome_proplastid:
                return "eProplastid";
                break;
            case CBioSource::eGenome_endogenous_virus:
                return "eOtherLoc";
                break;
            case CBioSource::eGenome_hydrogenosome:
                return "eHydrogenosome";
                break;
            case CBioSource::eGenome_chromatophore:
                return "eChromatophore";
                break;
        }
    }
    if (NStr::Equal(GetBioprojectType(), "ePlasmid")) {
        return "eNuclearProkaryote";
    }

    return kEmptyStr;
}

static const char* kDisableStrainForwardAttrib = "nomodforward";

void CBioSource::SetDisableStrainForwarding(bool val)
{
    if (val) {
        string attrib = kEmptyStr;
        if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetAttrib()) {
            attrib = GetOrg().GetOrgname().GetAttrib();
        }
        if (NStr::Find(attrib, kDisableStrainForwardAttrib) == string::npos) {
            if (!NStr::IsBlank(attrib)) {
                attrib += ";";
            }
            attrib += kDisableStrainForwardAttrib;
            SetOrg().SetOrgname().SetAttrib(attrib);
        }
    } else {
        if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetAttrib()) {
            NStr::ReplaceInPlace(SetOrg().SetOrgname().SetAttrib(), kDisableStrainForwardAttrib, "");
            NStr::ReplaceInPlace(SetOrg().SetOrgname().SetAttrib(), ";;", "");
            if (NStr::IsBlank(GetOrg().GetOrgname().GetAttrib())) {
                SetOrg().SetOrgname().ResetAttrib();
            }
        }
    }
}


bool CBioSource::GetDisableStrainForwarding() const
{
    bool val = false;
    if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetAttrib()
        && NStr::Find(GetOrg().GetOrgname().GetAttrib(), kDisableStrainForwardAttrib) != string::npos) {
        val = true;
    }
    return val;
}


bool s_MustCopy (int subtype)
{
    if (CSubSource::IsDiscouraged(subtype)) {
        return false;
    } else if (subtype == CSubSource::eSubtype_chromosome
               || subtype == CSubSource::eSubtype_map
               || subtype == CSubSource::eSubtype_plasmid_name
               || subtype == CSubSource::eSubtype_other) {
        return false;
    }
    return true;
}


void CBioSource::x_RemoveStopWords(COrg_ref& org_ref)
{
    if (org_ref.IsSetTaxname() && IsStopWord(org_ref.GetTaxname())) {
        org_ref.ResetTaxname();
    }
    if (org_ref.IsSetOrgMod()) {
        COrgName::TMod::iterator it = org_ref.SetOrgname().SetMod().begin();
        while (it != org_ref.SetOrgname().SetMod().end()) {
            if (IsStopWord((*it)->GetSubname())) {
                it = org_ref.SetOrgname().SetMod().erase(it);
            } else {
                it++;
            }
        }
        if (org_ref.GetOrgname().GetMod().empty()) {
            org_ref.SetOrgname().ResetMod();
        }
    }
}


bool CBioSource::BiosampleDiffsOkForUpdate(const TFieldDiffList& diffs) const
{
    ITERATE(TFieldDiffList, it, diffs) {
        if (!NStr::IsBlank((*it)->GetSrcVal())) {
            return false;
        }
    }
    return true;
}


void CBioSource::UpdateWithBioSample(const CBioSource& biosample, bool force, bool is_local_copy)
{
    TFieldDiffList diffs = GetBiosampleDiffs(biosample, is_local_copy);
    if (!force && !BiosampleDiffsOkForUpdate(diffs)) {        
        // throw exception
        NCBI_THROW(CException, eUnknown, "Conflicts found");                      
    }

    ITERATE(TFieldDiffList, it, diffs) {
        if (NStr::EqualNocase((*it)->GetFieldName(), "Organism Name")) {
            SetOrg().SetTaxname((*it)->GetSampleVal());
            if (GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetName()) {
                SetOrg().SetOrgname().ResetName();
            }
        } else if (NStr::EqualNocase((*it)->GetFieldName(), "Tax ID")) {
            try {
                SetOrg().SetTaxId(atoi((*it)->GetSampleVal().c_str()));
            } catch (...) {
                NCBI_THROW(CException, eUnknown, "Non-integer Tax ID value");
            }
        } else {
            string sample_val = (*it)->GetSampleVal();
            if (IsStopWord(sample_val)) { 
                sample_val = ""; 
            }
            try {
                COrgMod::TSubtype subtype = COrgMod::GetSubtypeValue((*it)->GetFieldName());
                RemoveOrgMod(subtype);
                
                if (!NStr::IsBlank(sample_val)) {
                    CRef<COrgMod> mod(new COrgMod());
                    mod->SetSubtype(subtype);
                    mod->SetSubname(sample_val);
                    SetOrg().SetOrgname().SetMod().push_back(mod);
                }
            } catch (...) {
                try {
                    CSubSource::TSubtype subtype = CSubSource::GetSubtypeValue((*it)->GetFieldName());
                    RemoveSubSource(subtype);
                    if (!NStr::IsBlank(sample_val)) {
                        CRef<CSubSource> sub(new CSubSource());
                        sub->SetSubtype(subtype);
                        sub->SetName(sample_val);
                        SetSubtype().push_back(sub);
                    }
                } catch (...) {
                    NCBI_THROW(CException, eUnknown, "Unknown field name");
                }
            }
        }
    }

    AutoFix();
}


void CBioSource::x_ClearCoordinatedBioSampleSubSources()
{
    if (!IsSetSubtype()) {
        return;
    }
    CBioSource::TSubtype::iterator it = SetSubtype().begin();
    while (it != SetSubtype().end()) {
        if (s_MustCopy((*it)->GetSubtype())) {
            it = SetSubtype().erase(it);
        } else {
            ++it;
        }
    }
}


static const char* kOrgModNote   = "orgmod_note";
static const char* kSubSrcNote   = "subsrc_note";
static const char* kOrganismName = "Organism Name";
static const char* kTaxId        = "Tax ID";

CBioSource::TNameValList CBioSource::GetNameValPairs() const
{
    TNameValList list;

    if (IsSetOrg() && GetOrg().IsSetTaxname()) {
        list.push_back(TNameVal(kOrganismName, GetOrg().GetTaxname()));
    }
    if (IsSetOrg()) {
        int taxid = GetOrg().GetTaxId();
        if (taxid > 0) {
            try {
                string val = NStr::NumericToString(taxid);
                list.push_back(TNameVal(kTaxId, val));
            } catch (...) {
            }
        }
    }

    TNameValList extra = x_GetOrgModNameValPairs();
    ITERATE(TNameValList, it, extra) {
        list.push_back(*it);
    }
    extra = x_GetSubtypeNameValPairs();
    ITERATE(TNameValList, it, extra) {
        list.push_back(*it);
    }

    return list;
}


int s_iCompareNameVals (const CBioSource::TNameVal& f1, const CBioSource::TNameVal& f2)
{
    int cmp = NStr::Compare (f1.first, f2.first);
    if (cmp == 0) {
        bool stop1 = CBioSource::IsStopWord(f1.second);
        bool stop2 = CBioSource::IsStopWord(f2.second);
        if (stop1 && stop2) {
            // equal
            cmp = 0;
        } else if (stop1) {
            // first is less
            cmp = -1;
        } else if (stop2) {
            // second is less
            cmp = 1;
        } else {
            cmp = NStr::CompareNocase (f1.second, f2.second);
            if (cmp == 0) {
                cmp = NStr::Compare(f1.second, f2.second);
            }
        }
    }
    return cmp;
}


bool s_CompareNameVals (const CBioSource::TNameVal& f1, const CBioSource::TNameVal& f2)
{ 
    int cmp = s_iCompareNameVals (f1, f2);
    if (cmp < 0) {
        return true;
    } else {
        return false;
    }        
}


CBioSource::TNameValList CBioSource::x_GetOrgModNameValPairs() const
{
    TNameValList list;
    if (IsSetOrgMod()) {
        ITERATE(COrgName::TMod, it, GetOrg().GetOrgname().GetMod()) {
            if ((*it)->IsSetSubname() && (*it)->IsSetSubtype()) {
                string label;
                if ((*it)->GetSubtype() == COrgMod::eSubtype_other) {
                    label = kOrgModNote;
                } else {
                    label = COrgMod::GetSubtypeName((*it)->GetSubtype());
                }
                list.push_back(TNameVal(label, (*it)->GetSubname()));
            }
        }
    }
    sort(list.begin(), list.end(), s_CompareNameVals);
    return list;
}


CBioSource::TNameValList CBioSource::x_GetSubtypeNameValPairs() const
{
    TNameValList list;
    if (IsSetSubtype()) {
        ITERATE(CBioSource::TSubtype, it, GetSubtype()) {
            if ((*it)->IsSetName() && (*it)->IsSetSubtype()) {
                CSubSource::TSubtype st = (*it)->GetSubtype();
                string label;
                if (st == CSubSource::eSubtype_other) {
                    label = kSubSrcNote;
                } else {
                    label = CSubSource::GetSubtypeName(st);
                }
                string val = (*it)->GetName();
                if (CSubSource::NeedsNoText(st) && NStr::IsBlank(val)) {
                    val = "true";
                }
                list.push_back(TNameVal(label, val));
            }
        }
    }
    sort(list.begin(), list.end(), s_CompareNameVals);
    return list;
}


static const char* const s_IgnoreCaseQuals[] = {
    "cell-type",
    "collected-by",
    "dev-stage",
    "frequency",
    "group",
    "identified-by",
    "isolation-source",
    "map",
    "metagenome-source",
    "note",
    "phenotype",
    "sex",
    "subgroup",
    "tissue-type"
};

typedef CStaticArraySet<const char*, PNocase_CStr> TCIgnoreCaseQualsSet;
static const TCIgnoreCaseQualsSet s_IgnoreCaseQualsSet(s_IgnoreCaseQuals, sizeof(s_IgnoreCaseQuals), __FILE__, __LINE__);

bool s_MayIgnoreCase(const string& value)
{   
    return s_IgnoreCaseQualsSet.find(value.c_str()) != s_IgnoreCaseQualsSet.end();
}


static const char* const s_TaxNameElementQuals[] = {
    "biovar",
    "chemovar",
    "forma",
    "forma-specialis",
    "genotype",
    "pathovar",
    "serotype",
    "serovar",
    "subspecies",
    "variety"
};

typedef CStaticArraySet<const char*, PNocase_CStr> TCTaxNameElementQualsSet;
static const TCTaxNameElementQualsSet s_TaxNameElementQualsSet(s_TaxNameElementQuals, sizeof(s_TaxNameElementQuals), __FILE__, __LINE__);

bool s_IsTaxNameElement(const string& value)
{   
    return s_TaxNameElementQualsSet.find(value.c_str()) != s_TaxNameElementQualsSet.end();
}


typedef enum {
    eConflictIgnoreAll = 0,
    eConflictIgnoreMissingInBioSource,
    eConflictIgnoreMissingInBioSample
} EConflictIgnoreType;


typedef struct ignoreconflict {
    const char*         qual_name;
    EConflictIgnoreType ignore_type;
} IgnoreConflictData;


static IgnoreConflictData sIgnoreConflictList[] = {
    { "chromosome", eConflictIgnoreMissingInBioSample } ,
    { "endogenous-virus-name", eConflictIgnoreMissingInBioSample } ,
    { "germline", eConflictIgnoreMissingInBioSample } ,
    { "insertion-seq-name", eConflictIgnoreMissingInBioSample } ,
    { "linkage-group", eConflictIgnoreMissingInBioSample } ,
    { "map", eConflictIgnoreMissingInBioSample } ,
    { "plasmid-name", eConflictIgnoreMissingInBioSample } ,
    { "pop-variant", eConflictIgnoreMissingInBioSample } ,
    { "rearranged", eConflictIgnoreMissingInBioSample } ,
    { "segment", eConflictIgnoreMissingInBioSample } ,
    { "transgenic", eConflictIgnoreMissingInBioSample } ,
    { "transposon-name", eConflictIgnoreMissingInBioSample } ,
    { "whole-replicon", eConflictIgnoreMissingInBioSample } ,
    { "acronym", eConflictIgnoreAll },
    { "common", eConflictIgnoreAll } ,
    { "dosage", eConflictIgnoreAll } ,
    { "gb-acronym", eConflictIgnoreAll } ,
    { "gb-anamorph", eConflictIgnoreAll } ,
    { "gb-synonym", eConflictIgnoreAll } ,
    { "lineage", eConflictIgnoreAll } ,
    { "old-lineage", eConflictIgnoreAll } ,
    { "old-name", eConflictIgnoreAll } ,
    { "synonym", eConflictIgnoreAll } ,
    { "type-material", eConflictIgnoreAll },
    { "StructuredCommentPrefix", eConflictIgnoreAll} ,
    { "StructuredCommentSuffix", eConflictIgnoreAll}
};


bool s_SameExceptPrecision (double val1, double val2)
{
    if (val1 > 180.0 || val2 > 180.0) {
        return false;
    }
    char buf1[20];
    char buf2[20];
    sprintf(buf1, "%0.2f", val1);
    sprintf(buf2, "%0.2f", val2);
    if (strcmp(buf1, buf2) == 0) {
        return true;
    }
    return false;
}
    

bool CBioSource::ShouldIgnoreConflict(const string& label, string src_val, string sample_val, bool is_local_copy)
{
    size_t i;
    bool rval = false;

    // ignore if BioSource value is blank and BioSample value is a stop word
    if (NStr::IsBlank(src_val) && CBioSource::IsStopWord(sample_val)) {
        return true;
    }

    // ignore if case matches exactly
    if (s_MayIgnoreCase(label)) {
        if (NStr::EqualNocase(src_val, sample_val)) {
            return true;
        }
    } else {
        if (NStr::EqualCase(src_val, sample_val)) {
            return true;
        }
    }

    if (!NStr::IsBlank(src_val) && !NStr::IsBlank(sample_val)) {
        try {
            CSubSource::TSubtype subtype = CSubSource::GetSubtypeValue(label);
            string test_val = CSubSource::AutoFix(subtype, sample_val);
            if (!NStr::IsBlank(test_val)) {
                if (NStr::Equal(src_val, test_val)) {
                    return true;
                } 
            }
        } catch (...) {
            try {
                COrgMod::TSubtype subtype = COrgMod::GetSubtypeValue(label);
                string test_val = COrgMod::AutoFix(subtype, sample_val);
                if (!NStr::IsBlank(test_val)) {
                    if (NStr::Equal(src_val, test_val)) {
                        return true;
                    }
                }
            } catch (...) {
            }
        }
    }

    for (i = 0; i < ArraySize(sIgnoreConflictList); i++) {
        if (NStr::EqualNocase(label, sIgnoreConflictList[i].qual_name)) {
            EConflictIgnoreType ignore_type = sIgnoreConflictList[i].ignore_type;
            if (is_local_copy && ignore_type == eConflictIgnoreMissingInBioSample) {
                ignore_type = eConflictIgnoreAll;
            }
            switch (ignore_type) {
                case eConflictIgnoreAll:
                    rval = true;
                    break;
                case eConflictIgnoreMissingInBioSource:
                    if (NStr::IsBlank(src_val)) {
                      rval = true;
                    }
                    break;
                case eConflictIgnoreMissingInBioSample:
                    if (NStr::IsBlank(sample_val) || CBioSource::IsStopWord(sample_val)) {
                      rval = true;
                    }
                    break;
            }
            break;
        }
    }
    // special handling for lat-lon
    if (!rval && NStr::EqualNocase(label, "lat-lon")) {
        bool src_format_correct, src_precision_correct,
             src_lat_in_range, src_lon_in_range;
        double src_lat_value, src_lon_value;
        CSubSource::IsCorrectLatLonFormat(src_val, src_format_correct, src_precision_correct,
                                          src_lat_in_range, src_lon_in_range,
                                          src_lat_value, src_lon_value);
        bool smpl_format_correct, smpl_precision_correct,
             smpl_lat_in_range, smpl_lon_in_range;
        double smpl_lat_value, smpl_lon_value;
        CSubSource::IsCorrectLatLonFormat(sample_val, smpl_format_correct, smpl_precision_correct,
                                          smpl_lat_in_range, smpl_lon_in_range,
                                          smpl_lat_value, smpl_lon_value);
        if (src_format_correct && smpl_format_correct 
            && s_SameExceptPrecision(src_lat_value, smpl_lat_value)
            && s_SameExceptPrecision(src_lon_value, smpl_lon_value)) {
            rval = true;
        }
    }
    // special handling for collection-date
    if (!rval && NStr::EqualNocase(label, "collection-date")) {
        try {
            CRef<CDate> src_date = CSubSource::DateFromCollectionDate(src_val);
            CRef<CDate> smpl_date = CSubSource::DateFromCollectionDate(sample_val);
            if (src_date && smpl_date && src_date->Equals(*smpl_date)) {
                rval = true;
            }
        } catch (...) {
        }
    }
    // special handling for country
    if (!rval && NStr::EqualNocase(label, "country")) {
        NStr::ReplaceInPlace(src_val, ": ", ":");
        NStr::ReplaceInPlace(sample_val, ": ", ":");
        if (NStr::Equal(src_val, sample_val)) {
            rval = true;
        }
    }
    // special handling for altitude
    if (!rval && NStr::EqualNocase(label, "altitude")) {
        if (NStr::EndsWith(src_val, ".") && !NStr::EndsWith(sample_val, ".")
            && NStr::EqualNocase(src_val.substr(0, src_val.length() - 1), sample_val)) {
            rval = true;
        }
    }
    return rval;
}


void GetFieldDiffsFromNameValLists(TFieldDiffList& list,
                                   CBioSource::TNameValList& list1, 
                                   CBioSource::TNameValList& list2,
                                   bool is_local_copy)
{
    CBioSource::TNameValList::iterator it1 = list1.begin();
    CBioSource::TNameValList::iterator it2 = list2.begin();

    while (it1 != list1.end() && it2 != list2.end()) {
        int cmp = NStr::Compare(it1->first, it2->first);
        if (cmp == 0) {
            if (!CBioSource::ShouldIgnoreConflict(it1->first, it1->second, it2->second, is_local_copy)) {
                CRef<CFieldDiff> diff(new CFieldDiff(it1->first, it1->second, it2->second));
                list.push_back(diff);
            }
            it1++;
            it2++;
        } else if (cmp < 0) {
            if (!CBioSource::ShouldIgnoreConflict(it1->first, it1->second, "", is_local_copy)) {
                CRef<CFieldDiff> diff(new CFieldDiff(it1->first, it1->second, ""));
                list.push_back(diff);
            }
            it1++;
        } else {
            // cmp > 0
            if (!CBioSource::ShouldIgnoreConflict(it2->first, "", it2->second, is_local_copy)) {
                CRef<CFieldDiff> diff(new CFieldDiff(it2->first, "", it2->second));
                list.push_back(diff);
            }
            it2++;
        }
    }
    while (it1 != list1.end()) {
        if (!CBioSource::ShouldIgnoreConflict(it1->first, it1->second, "", is_local_copy)) {
            CRef<CFieldDiff> diff(new CFieldDiff(it1->first, it1->second, ""));
            list.push_back(diff);
        }
        it1++;
    }
    while (it2 != list2.end()) {
        if (!CBioSource::ShouldIgnoreConflict(it2->first, "", it2->second, is_local_copy)) {
            CRef<CFieldDiff> diff(new CFieldDiff(it2->first, "", it2->second));
            list.push_back(diff);
        }
        it2++;
    }
}


void CBioSource::x_RemoveNameElementDiffs(const CBioSource& biosample, TFieldDiffList& diff_list) const
{
    string src_tax = "";
    if (IsSetOrg() && GetOrg().IsSetTaxname()) {
        src_tax = GetOrg().GetTaxname();
    }
    string sample_tax = "";
    if (biosample.IsSetOrg() && biosample.GetOrg().IsSetTaxname()) {
        sample_tax = biosample.GetOrg().GetTaxname();
    }
    TFieldDiffList::iterator it = diff_list.begin();
    while (it != diff_list.end()) {
        bool remove = false;
        if (s_IsTaxNameElement((*it)->GetFieldName())) {
            if (NStr::IsBlank((*it)->GetSampleVal())
                && NStr::Find(sample_tax, (*it)->GetSrcVal()) != string::npos) {
                // if value is missing from BioSample, but is present in BioSample taxname,
                // ignore
                remove = true;
            } else if (NStr::IsBlank((*it)->GetSrcVal())
                       && NStr::Find(src_tax, (*it)->GetSampleVal()) != string::npos) {
                // if value is missing from BioSource, but is present in BioSource taxname,
                // ignore
                remove = true;
            }
        }
        if (remove) {
            it = diff_list.erase(it);
        } else {
            it++;
        }
    }
}


void RemoveDiffByName(TFieldDiffList& diff_list, string pair_name)
{
    TFieldDiffList::iterator it = diff_list.begin();
    while (it != diff_list.end()) {
        if (NStr::EqualNocase((*it)->GetFieldName(), pair_name)) {
            it = diff_list.erase(it);
        } else {
            it++;
        }
    }
}


bool CBioSource::x_ShouldIgnoreNoteForBiosample() const
{
    if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetLineage()
        && NStr::Find(GetOrg().GetOrgname().GetLineage(), "unclassified sequences; metagenomes") != string::npos) {
        return true;
    } else {
        return false;
    }
}


TFieldDiffList CBioSource::GetBiosampleDiffs(const CBioSource& biosample, bool is_local_copy) const
{
    TFieldDiffList rval;

    TNameValList src_list = GetNameValPairs();
    sort(src_list.begin(), src_list.end(), s_CompareNameVals);

    TNameValList sample_list = biosample.GetNameValPairs();
    sort(sample_list.begin(), sample_list.end(), s_CompareNameVals);

    GetFieldDiffsFromNameValLists(rval, src_list, sample_list, is_local_copy);
    x_RemoveNameElementDiffs(biosample, rval);

    if (x_ShouldIgnoreNoteForBiosample() && biosample.x_ShouldIgnoreNoteForBiosample()) {
        RemoveDiffByName(rval, "orgmod_note");
        RemoveDiffByName(rval, "subsrc_note");
    }

    return rval;
}


static const char* const s_StopWords[] = {
    "-",
    "?",
    "missing",
    "n/a",
    "na",
    "none",
    "not applicable",
    "not available",
    "not collected",
    "not determined",
    "not provided",
    "not recorded",
    "null",
    "unk",
    "unknown",
    "unspecified"
};

typedef CStaticArraySet<const char*, PNocase_CStr> TCStopWordStrSet;
static const TCStopWordStrSet s_StopWordsSet(s_StopWords, sizeof(s_StopWords), __FILE__, __LINE__);


bool CBioSource::IsStopWord(const string& value)
{   
    if (s_StopWordsSet.find(value.c_str()) != s_StopWordsSet.end()) {
        return true;
    } else {
        return false;
    }
}


void CBioSource::AutoFix()
{
    if (IsSetSubtype()) {
        CBioSource::TSubtype::iterator it = SetSubtype().begin();
        while (it != SetSubtype().end()) {
            (*it)->AutoFix();
            if ((*it)->IsSetSubtype()
                && !CSubSource::NeedsNoText((*it)->GetSubtype())
                && (!(*it)->IsSetName() || NStr::IsBlank((*it)->GetName()))) {
                it = SetSubtype().erase(it);
            } else {
                it++;
            }
        }
        if (GetSubtype().empty()) {
            ResetSubtype();
        }
    }
    if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetMod()) {
        COrgName::TMod::iterator it = SetOrg().SetOrgname().SetMod().begin();
        while (it != SetOrg().SetOrgname().SetMod().end()) {
            (*it)->AutoFix();
            if ((*it)->IsSetSubtype()
                && (!(*it)->IsSetSubname() || NStr::IsBlank((*it)->GetSubname()))) {
                it = SetOrg().SetOrgname().SetMod().erase(it);
            } else {
                it++;
            }
        }
        if (GetOrg().GetOrgname().GetMod().empty()) {
            SetOrg().SetOrgname().ResetMod();
        }
    }
}


void CBioSource::RemoveCultureNotes(bool is_species_level)
{
    if (IsSetSubtype()) {
        CBioSource::TSubtype::iterator it = SetSubtype().begin();
        while (it != SetSubtype().end()) {
            if ((*it)->IsSetSubtype() && (*it)->GetSubtype() == CSubSource::eSubtype_other) {
                CSubSource::RemoveCultureNotes((*it)->SetName(), is_species_level);
                if (NStr::IsBlank((*it)->GetName())) {
                    it = SetSubtype().erase(it);
                } else {
                    it++;
                }
            } else {
                it++;
            }
        }
        if (GetSubtype().empty()) {
            ResetSubtype();
        }
    }
}

static const char* s_SpecialLineageWords[] = {
    "Class",
    "Classification",
    "Domain",
    "Family",
    "Genus",
    "Kingdom",
    "Lineage",
    "Note",
    "Order",
    "Organism",
    "Phylum",
    "Species",
    "Superfamily",
    "Tax class/lineage",
    "Taxonomic classification", 
    "Taxonomic Classification is",
    "Taxonomy"
};

typedef vector<CTempString> TWordList;

// workaround for std::replace_if
static inline bool s_IsPunct( char ch ) { return ispunct((unsigned char)ch) != 0; }

static void s_GetWordListFromText(string& str, TWordList& word_list)
{
    if (str.empty()) {
        return;
    }
    std::replace_if(str.begin(), str.end(), s_IsPunct, ' ');
    NStr::Tokenize(str, " ", word_list, NStr::eMergeDelims);
}


static bool s_DoesTextContainOnlyTheseWords(const string& text, const TWordList& word_list)
{
    if (text.empty()) {
        return false;
    }
    bool match = true, at_least_one = false;

    const char* orig = text.c_str();
    const char* ch = orig;

    while (isspace((unsigned char)(*ch)) || ispunct((unsigned char)(*ch))) {
        ++ch;
    }
    while (*ch != 0 && match) {
        match = false;
        for (TWordList::const_iterator word = word_list.begin(); word != word_list.end() && !match; ++word) {
            size_t length = word->size();
            if (NStr::strncasecmp(ch, word->data(), length) == 0) {
                unsigned char next = *(ch + length);
                if (next == '\0' || isspace(next) || ispunct(next)) {
                    match = true;
                    ch += length;
                    at_least_one = true;
                }
            }
        }
        while (isspace((unsigned char)(*ch)) || ispunct((unsigned char)(*ch))) {
            ++ch;
        }
    }
    return (match && at_least_one);
}


bool CBioSource::RemoveLineageSourceNotes()
{
    if (!IsSetOrg()  || !IsSetLineage() || GetOrg().GetTaxId() == 0) {
        return false;
    }
    bool any_removed = false;

    // gather all words that appear in lineage, taxname and in s_SpecialLineageWords
    TWordList word_list;

    string lineage(GetLineage());
    s_GetWordListFromText(lineage, word_list);
   
    string taxname(GetTaxname());
    s_GetWordListFromText(taxname, word_list);
    
    for (unsigned int i = 0; i < ArraySize(s_SpecialLineageWords); ++i) {
        word_list.push_back(s_SpecialLineageWords[i]);
    }

    if (IsSetSubtype()) {
        CBioSource::TSubtype::iterator it = SetSubtype().begin();
        while (it != SetSubtype().end()) {
            CRef<CSubSource> subsrc = *it;
            bool removed = false;
            if (subsrc->IsSetSubtype() && subsrc->GetSubtype() == CSubSource::eSubtype_other) {
                if (subsrc->IsSetName()) {
                    if (s_DoesTextContainOnlyTheseWords(subsrc->GetName(), word_list)) {
                        // remove this subsource note
                        it = SetSubtype().erase(it);
                        removed = true;
                        any_removed = true;
                    } 
                }
            }
            if (!removed) {
                ++it;
            }
        }
        if (GetSubtype().empty()) {
            ResetSubtype();
        }
    }

    if (IsSetOrgname() && GetOrg().GetOrgname().IsSetMod()) {
        COrgName::TMod::iterator iter = SetOrg().SetOrgname().SetMod().begin();
        while (iter != SetOrg().SetOrgname().SetMod().end()) {
            CRef<COrgMod> orgmod = *iter;
            bool removed = false;
            if (orgmod->IsSetSubtype() && orgmod->GetSubtype() == COrgMod::eSubtype_other) {
                if (orgmod->IsSetSubname()) {
                    if (s_DoesTextContainOnlyTheseWords(orgmod->GetSubname(), word_list)) {
                        // remove this orgmod note
                        iter = SetOrg().SetOrgname().SetMod().erase(iter);
                        removed = true;
                        any_removed = true;
                    } 
                }
            }
            if (!removed) {
                ++iter;
            }
        }
        if (GetOrg().GetOrgname().GetMod().empty()) {
            SetOrg().SetOrgname().ResetMod();
        }
    }

    return any_removed;
}


bool CBioSource::RemoveSubSource(int subtype)
{
    bool rval = false;

    if (IsSetSubtype()) {
        CBioSource::TSubtype::iterator it = SetSubtype().begin();
        while (it != SetSubtype().end()) {
            if ((*it)->IsSetSubtype() && (*it)->GetSubtype() == subtype) {
                it = SetSubtype().erase(it);
                rval = true;
            } else {
                it++;
            }
        }
        if (GetSubtype().empty()) {
            ResetSubtype();
        }
    }
    return rval;
}


bool CBioSource::RemoveOrgMod(int subtype)
{
    bool rval = false;

    if (IsSetOrg() && GetOrg().IsSetOrgname() && GetOrg().GetOrgname().IsSetMod()) {
        COrgName::TMod::iterator it = SetOrg().SetOrgname().SetMod().begin();
        while (it != SetOrg().SetOrgname().SetMod().end()) {
            if ((*it)->IsSetSubtype() && (*it)->GetSubtype() == subtype) {
                it = SetOrg().SetOrgname().SetMod().erase(it);
                rval = true;
            } else {
                it++;
            }
        }
        if (GetOrg().GetOrgname().GetMod().empty()) {
            SetOrg().SetOrgname().ResetMod();
        }
    }
    return rval;
}


#define MAKE_COMMON_INT(o1,o2,o3,Field) \
    if (o1.IsSet##Field() && o2.IsSet##Field() && o1.Get##Field() == o2.Get##Field()) o3.Set##Field(o1.Get##Field());

CRef<CBioSource> CBioSource::MakeCommon( const CBioSource& other) const
{
    if (!IsSetOrg() || !other.IsSetOrg()) {
        return CRef<CBioSource>(NULL);
    }

    CRef<COrg_ref> common_org = GetOrg().MakeCommon(other.GetOrg());
    if (!common_org) {
        return CRef<CBioSource>(NULL);
    }

    CRef<CBioSource> common_src(new CBioSource());
    common_src->SetOrg().Assign(*common_org);

    // copy common subtypes
    if (IsSetSubtype() && other.IsSetSubtype()) {
        ITERATE(TSubtype, it1, GetSubtype()) {
            bool found = false;
            ITERATE(TSubtype, it2, other.GetSubtype()) {
                if ((*it1)->Equals(**it2)) {
                    found = true;
                    break;
                }
            }
            if (found) {
                CRef<CSubSource> add(new CSubSource());
                add->Assign(**it1);
                common_src->SetSubtype().push_back(add);
            }
        }
    }

    MAKE_COMMON_INT((*this), other, (*common_src), Genome);
    MAKE_COMMON_INT((*this), other, (*common_src), Origin);
    
    if (IsSetPcr_primers() && other.IsSetPcr_primers() && GetPcr_primers().Equals(other.GetPcr_primers())) {
        common_src->SetPcr_primers().Assign(GetPcr_primers());
    }

    return common_src;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1883, CRC32: e1194deb */
