/* $Id: Prot_pos.hpp 415806 2013-10-21 19:06:34Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Prot_pos.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Prot_pos_.hpp


#ifndef OBJECTS_SEQALIGN_PROT_POS_HPP
#define OBJECTS_SEQALIGN_PROT_POS_HPP


// generated includes
#include <objects/seqalign/Prot_pos_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CProt_pos : public CProt_pos_Base
{
    typedef CProt_pos_Base Tparent;
public:
    // constructor
    CProt_pos(void);
    // destructor
    ~CProt_pos(void);

    // Get valid frame value (1, 2, or 3)
    // default 0 is returned as 1
    CProt_pos_Base::TFrame GetFrame() const;

private:
    // Prohibit copy constructor and assignment operator
    CProt_pos(const CProt_pos& value);
    CProt_pos& operator=(const CProt_pos& value);

};

/////////////////// CProt_pos inline methods

// constructor
inline
CProt_pos::CProt_pos(void)
{
}

inline
CProt_pos_Base::TFrame CProt_pos::GetFrame() const
{
    CProt_pos_Base::TFrame frame = CProt_pos_Base::GetFrame();
    if (frame == 0)
        frame = 1;
    return frame;
}

/////////////////// end of CProt_pos inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_PROT_POS_HPP
/* Original file checksum: lines: 86, chars: 2403, CRC32: 18591b41 */
