/* $Id: Ncbi_mime_asn1.cpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'ncbimime.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/ncbimime/Ncbi_mime_asn1.hpp>

// generated classes

// custom includes
#include <objects/mmdb1/Molecule_graph.hpp>
#include <serial/iterator.hpp>


BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CNcbi_mime_asn1::~CNcbi_mime_asn1(void)
{
}

// Cn3D 4.1 can't handle the sid field in the molecule graph, so call this
// function before writing data for export to Cn3D. Returns true if any SIDs
// were removed; false if no changes were made.
bool CNcbi_mime_asn1::RemoveSIDs(void)
{
    bool anyRemoved = false;
    
    for (CTypeIterator<CMolecule_graph> moleculeGraph(Begin(*this)); moleculeGraph; ++moleculeGraph ) {
        if (moleculeGraph->IsSetSid()) {
            moleculeGraph->ResetSid();
            anyRemoved = true;
        }
    }
    
    return anyRemoved;
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1908, CRC32: 46739190 */
