/* $Id: Id_pat.cpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Id_pat.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CId_pat::~CId_pat(void)
{
}


bool CId_pat::Id_Match(const C_Id& id1, const C_Id& id2)
{
	C_Id::E_Choice type1 = id1.Which();
	C_Id::E_Choice type2 = id2.Which();

	if (type1 != type2)
		return false;

    switch ( type1 ) {
    case C_Id::e_Number:
        return AStrEquiv(id1.GetNumber(), id2.GetNumber(), PNocase());
    case C_Id::e_App_number:
        return AStrEquiv(id1.GetApp_number(), id2.GetApp_number(), PNocase());
    default:
        return false;
    }
}
	

// comparison function
bool CId_pat::Match(const CId_pat& idp2) const
{
    return AStrEquiv(GetCountry(), idp2.GetCountry(), PNocase()) &&
        Id_Match(GetId(), idp2.GetId());
}


bool CId_pat::GetLabelV1(string* label, TLabelFlags) const
{
    return x_GetLabelV1(label, false, 0, 0, 0, 0, 0,
                        &GetCountry(), &GetSomeNumber());
}


bool CId_pat::GetLabelV2(string* label, TLabelFlags flags) const
{
    // Not handled in asn2gnb5.c; another option might be to return false.
    return GetLabelV1(label, flags);
}


const string& CId_pat::GetSomeNumber(void) const
{
    switch (GetId().Which()) {
    case C_Id::e_Number:      return GetId().GetNumber();
    case C_Id::e_App_number:  return GetId().GetApp_number();
    default:                  return kEmptyStr;
    }
}
	
END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1877, CRC32: 1b7c366f */
