/* $Id: MSModSpecSet.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @MSModSpecSet.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: MSModSpecSet_.hpp


#ifndef OBJECTS_OMSSA_MSMODSPECSET_HPP
#define OBJECTS_OMSSA_MSMODSPECSET_HPP


// generated includes
#include <objects/omssa/MSModSpecSet_.hpp>
#include <objects/omssa/MSMod.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_OMSSA_EXPORT CMSModSpecSet : public CMSModSpecSet_Base
{
    typedef CMSModSpecSet_Base Tparent;
public:
    // constructor
    CMSModSpecSet(void);
    // destructor
    ~CMSModSpecSet(void);

    //! concatenates in another CMSModSpecSet 
    void Append(const CMSModSpecSet &ModsIn);

    //! creates arrays for the existing set
    void CreateArrays(void);

    //! Have the arrays been intialized?
    bool IsArrayed(void);

    //! get modification AA's
    /*!
    \param Mod the modification number
    \param Number the residue number for the modification type
    */
    char GetModChar(int Mod, int Number) const;

    //! get the number of modification AA's
    /*!
    \param Mod the modification number
    */
    int GetModNumChars(int Mod) const;

    //! get modification mass
    /*!
    \param Mod the modification number
    */
    int GetModMass(int Mod) const;

    /** 
     * get neutral loss
     *
     * @param Mod the modification number
     */
    int GetNeutralLoss(int Mod) const;

    //! get modification friendly name
    /*!
    \param Mod the modification number
    */
    const char * GetModName(int Mod) const;

    //! get unimod name
    /*!
    \param Mod the modification number
    */
    const char * GetUnimodName(int Mod) const;

    //! get modification type
    /*!
    \param Mod the modification number
    */
    EMSModType GetModType(int Mod) const;

    //! the maximum size of an modification friendly name
    static const int kMaxNameSize = 128;

    //! the maximum number of AA's a modification can affect
    static const int kMaxAAs = 3;

private:
    // Prohibit copy constructor and assignment operator
    CMSModSpecSet(const CMSModSpecSet& value);
    CMSModSpecSet& operator=(const CMSModSpecSet& value);

    //! the AA's affected
    char ModChar[eMSMod_max][kMaxAAs];

    //! the number of AA's affected
    int NumModChars[eMSMod_max];

    //! the integer scaled mass of the mod
    int ModMass[eMSMod_max];

    //! the integer scaled mass of the neutral loss
    int NeutralLoss[eMSMod_max];

    //! friendly names
    char ModNames[eMSMod_max][kMaxNameSize];

    //! friendly names
    char UnimodNames[eMSMod_max][kMaxNameSize];

    //! categorizes existing mods as the types EMSModType
    EMSModType ModTypes[eMSMod_max];

    //! Have the arrays been intialized?
    bool isArrayed;
};

/////////////////// CMSModSpecSet inline methods

// constructor
inline
CMSModSpecSet::CMSModSpecSet(void): isArrayed(false)
{
}

//! Have the arrays been intialized?
inline
bool CMSModSpecSet::IsArrayed(void)
{
    return isArrayed;
}

//! get modification AA's
/*!
\param Mod the modification number
\param Number the residue number for the modification type
*/

inline
char CMSModSpecSet::GetModChar(int Mod, int Number) const
{
    return ModChar[Mod][Number];
}

//! get the number of modification AA's
/*!
\param Mod the modification number
*/
inline
int CMSModSpecSet::GetModMass(int Mod) const
{
    return ModMass[Mod];
}

inline
int CMSModSpecSet::GetNeutralLoss(int Mod) const
{
    return NeutralLoss[Mod];
}

//! get modification mass
/*!
\param Mod the modification number
*/
inline
int CMSModSpecSet::GetModNumChars(int Mod) const
{
    return NumModChars[Mod];
}

//! get modification friendly name
/*!
\param Mod the modification number
*/
inline
const char * CMSModSpecSet::GetModName(int Mod) const
{
    return ModNames[Mod];
}

//! get unimod name
/*!
\param Mod the modification number
*/
inline
const char * CMSModSpecSet::GetUnimodName(int Mod) const
{
    return UnimodNames[Mod];
}

//! get modification type
/*!
\param Mod the modification number
*/
inline
EMSModType CMSModSpecSet::GetModType(int Mod) const
{
    return ModTypes[Mod];
}


/////////////////// end of CMSModSpecSet inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_OMSSA_MSMODSPECSET_HPP
/* Original file checksum: lines: 94, chars: 2623, CRC32: 8e1d1026 */
