#ifndef NCBI_GENERAL_EXCEPTION__HPP
#define NCBI_GENERAL_EXCEPTION__HPP

/*  $Id: general_exception.hpp 371868 2012-08-13 15:10:25Z rafanovi $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* Authors:
*	Andrei Gourianov
*
* File Description:
*   General library exceptions
*/

#include <corelib/ncbiexpt.hpp>
#include <corelib/ncbistr.hpp>


BEGIN_NCBI_SCOPE

class CGeneralException : public CException
{
    NCBI_EXCEPTION_DEFAULT(CGeneralException,CException);
};

class CGeneralParseException : public CParseTemplException<CGeneralException>
{
public:
    enum EErrCode {
        eFormat
    };
    virtual const char* GetErrCodeString(void) const
    {
        switch (GetErrCode()) {
        case eFormat:    return "eFormat";
        default:         return CException::GetErrCodeString();
        }
    }
    NCBI_EXCEPTION_DEFAULT2(CGeneralParseException,
        CParseTemplException<CGeneralException>,std::string::size_type);
};


END_NCBI_SCOPE

#endif // NCBI_GENERAL_EXCEPTION__HPP
