/*
 * Decompiled with CFR 0.152.
 */
package ptbgui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import ptbgui.ArgsParser;
import ptbgui.CheckListMouseAdapter;
import ptbgui.CheckListRenderer;
import ptbgui.KTagsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtbguiMain
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String[] m_OriginalArgs;
    private ArgsParser m_ArgsParser;
    private Properties m_ArgsProp;
    private Process m_Ptb;
    private BufferedReader m_PtbOut;
    private BufferedReader m_PtbErr;
    private OutputStream m_PtbIn;
    private String m_Params;
    private String m_TmpParams;
    private String m_Key3root;
    private String m_KeyCpath;
    private Map<String, String[]> m_ProjectTags;
    private SortedSet<String> m_UndefSelTags;
    private Vector<String> m_KnownTags;
    private Vector<String> m_CompositeTags;
    private KTagsDialog m_KtagsDlg;
    private eState m_State;
    private JButton jButtonAppsMinus;
    private JButton jButtonAppsPlus;
    private JButton jButtonArgs;
    private JButton jButtonArgsReset;
    private JButton jButtonGCancel;
    private JButton jButtonGOK;
    private JButton jButtonKTags;
    private JButton jButtonLibsMinus;
    private JButton jButtonLibsPlus;
    private JButton jButtonLst;
    private JButton jButtonMore;
    private JButton jButtonOtherMinus;
    private JButton jButtonOtherPlus;
    private JButton jButtonPtb;
    private JButton jButtonSave;
    private JButton jButtonStartOver;
    private JCheckBox jCheckBoxExt;
    private JCheckBox jCheckBoxNoPtb;
    private JCheckBox jCheckBoxNws;
    private JCheckBox jCheckBoxVTune;
    private JCheckBox jCheckBoxVTuneD;
    private JCheckBox jCheckBoxVTuneR;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelApps;
    private JLabel jLabelArgs;
    private JLabel jLabelDone;
    private JLabel jLabelGen;
    private JLabel jLabelLibs;
    private JLabel jLabelOther;
    private JLabel jLabelSln;
    private JLabel jLabelTags;
    private JLabel jLabelUserReq;
    private JList jListApps;
    private JList jListLibs;
    private JList jListOther;
    private JList jListTags;
    private JList jListUserReq;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelAdd;
    private JPanel jPanelAdvanced;
    private JPanel jPanelCmnd;
    private JPanel jPanelDone;
    private JPanel jPanelPrj;
    private JPanel jPanelUserReq;
    private JRadioButton jRadioButtonDLL;
    private JRadioButton jRadioButtonStatic;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane;
    private JTextField jTextField3root;
    private JTextField jTextFieldArch;
    private JTextField jTextFieldCpath;
    private JTextField jTextFieldExt;
    private JTextField jTextFieldIde;
    private JTextField jTextFieldLst;
    private JTextField jTextFieldLstTags;
    private JTextField jTextFieldPtb;
    private JTextField jTextFieldRoot;
    private JTextField jTextFieldSolution;
    private JTextField jTextFieldTags;

    public PtbguiMain() {
        this.initComponents();
        this.initObjects();
        this.resetState();
    }

    private void initObjects() {
        this.m_ArgsParser = new ArgsParser();
        this.m_ProjectTags = new HashMap<String, String[]>();
        this.m_UndefSelTags = new TreeSet<String>();
        this.m_KnownTags = new Vector();
        this.m_CompositeTags = new Vector();
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRadioButtonStatic);
        group.add(this.jRadioButtonDLL);
        this.initCheckList(this.jListApps);
        this.initCheckList(this.jListLibs);
        this.initCheckList(this.jListOther);
        this.initCheckList(this.jListTags);
        this.initCheckList(this.jListUserReq);
    }

    private void resetState() {
        this.jTabbedPane.setSelectedIndex(0);
        this.jTabbedPane.setEnabledAt(0, true);
        this.jTabbedPane.setEnabledAt(1, true);
        this.jTabbedPane.setEnabledAt(2, false);
        this.jTabbedPane.setEnabledAt(3, false);
        this.jTabbedPane.setEnabledAt(4, false);
        this.m_State = eState.beforePtb;
        this.jButtonGOK.setText("Next");
        this.jButtonGOK.setEnabled(true);
        this.jButtonGOK.setVisible(true);
        this.jButtonGCancel.setText("Cancel");
        this.jButtonGCancel.setEnabled(true);
        this.jButtonGCancel.setVisible(true);
        ((DefaultListModel)this.jListApps.getModel()).clear();
        ((DefaultListModel)this.jListLibs.getModel()).clear();
        ((DefaultListModel)this.jListOther.getModel()).clear();
        ((DefaultListModel)this.jListTags.getModel()).clear();
        ((DefaultListModel)this.jListUserReq.getModel()).clear();
        this.showMoreAdvanced(false);
    }

    private void showMoreAdvanced(boolean show) {
        this.jCheckBoxNoPtb.setVisible(show);
        this.jCheckBoxNws.setVisible(show);
        this.jCheckBoxExt.setVisible(show);
        this.jLabel1.setVisible(show);
        this.jLabel2.setVisible(show);
        this.jTextFieldPtb.setVisible(show);
        this.jTextFieldRoot.setVisible(show);
        this.jButtonPtb.setVisible(show);
        this.jButtonMore.setText(show ? "< less" : "more >");
    }

    private void initData() {
        this.initData(this.m_OriginalArgs);
    }

    private void initData(String[] args) {
        if (this.m_OriginalArgs == null) {
            this.m_OriginalArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.m_OriginalArgs[i] = args[i];
            }
        }
        this.m_ArgsParser.init(args);
        this.setPathText((JTextComponent)this.jTextFieldPtb, this.m_ArgsParser.getPtb(), true);
        this.setPathText((JTextComponent)this.jTextFieldRoot, this.m_ArgsParser.getRoot(), true);
        this.setPathText((JTextComponent)this.jTextFieldLst, this.m_ArgsParser.getRoot(), this.m_ArgsParser.getSubtree());
        this.setPathText((JTextComponent)this.jTextFieldSolution, this.m_ArgsParser.getSolutionFile(), false);
        this.jTextFieldTags.setToolTipText("Expression. For example:  (core || web) && !test");
        this.jTextFieldLstTags.setToolTipText("When 'Use project tags' field above is empty, default tags will be used");
        if (this.m_ArgsParser.getArgsFile().length() > 0) {
            this.initData(this.m_ArgsParser.getArgsFile(), (Boolean)true);
            return;
        }
        this.jTextFieldTags.setText(this.m_ArgsParser.getProjTag());
        this.jTextFieldLstTags.setText("");
        this.jTextFieldIde.setText(this.m_ArgsParser.getIde());
        String arch = this.m_ArgsParser.getArch();
        this.jTextFieldArch.setText(arch);
        if (arch.equals("Win32") || arch.equals("x64")) {
            this.jTextFieldArch.setToolTipText("Win32 or x64");
        }
        this.jRadioButtonDLL.setSelected(this.m_ArgsParser.getDll());
        this.jRadioButtonStatic.setSelected(!this.m_ArgsParser.getDll());
        this.jCheckBoxNoPtb.setSelected(this.m_ArgsParser.m_nobuildptb);
        this.jCheckBoxNws.setSelected(this.m_ArgsParser.m_nws);
        this.jCheckBoxExt.setSelected(this.m_ArgsParser.m_ext);
        this.jTextFieldExt.setText(this.m_ArgsParser.getExtRoot());
        this.jLabelArgs.setText(" ");
        this.jButtonArgsReset.setEnabled(false);
        if (this.m_ArgsProp != null) {
            this.m_ArgsProp.clear();
        }
        this.adjustArch();
        this.initKnownTags();
        this.initTagsFromSubtree();
    }

    private void adjustArch() {
        File build_root = new File(this.m_ArgsParser.getBuildRoot());
        File[] arrFile = build_root.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().matches("__configured_platform.*");
            }
        });
        this.jTextFieldArch.setEditable(arrFile == null || arrFile.length == 0);
    }

    private void adjustBuildType() {
        this.m_ArgsParser.setDll(this.jRadioButtonDLL.isSelected(), true);
        this.setPathText((JTextComponent)this.jTextFieldSolution, this.m_ArgsParser.getSolutionFile(), false);
    }

    private void initData(String file, Boolean fromArgs) {
        try {
            if (this.m_ArgsProp != null) {
                this.m_ArgsProp.clear();
            } else {
                this.m_ArgsProp = new Properties();
            }
            this.m_ArgsProp.load(new FileInputStream(new File(file)));
            this.initData(this.m_ArgsProp, fromArgs);
            this.jLabelArgs.setText(file);
            this.jButtonArgsReset.setEnabled(fromArgs == false);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "This file does not contain valid data", "Error", 0);
        }
    }

    private void initData(Properties prop, Boolean fromArgs) {
        String v;
        if (fromArgs.booleanValue()) {
            v = this.m_ArgsParser.getRoot();
        } else {
            v = PtbguiMain.getProp(prop, "__arg_root");
            this.setPathText((JTextComponent)this.jTextFieldRoot, PtbguiMain.getProp(prop, "__arg_root"), true);
            this.setPathText((JTextComponent)this.jTextFieldSolution, PtbguiMain.getProp(prop, "__arg_solution"), false);
        }
        this.setPathText((JTextComponent)this.jTextFieldLst, v, PtbguiMain.getProp(prop, "__arg_subtree"));
        this.jTextFieldTags.setText(PtbguiMain.getProp(prop, "__arg_projtag"));
        this.jTextFieldLstTags.setText("");
        this.jTextFieldIde.setText(PtbguiMain.getProp(prop, "__arg_ide"));
        this.jTextFieldArch.setText(PtbguiMain.getProp(prop, "__arg_arch"));
        this.jRadioButtonDLL.setSelected(PtbguiMain.getProp(prop, "__arg_dll").equals("yes"));
        this.jRadioButtonStatic.setSelected(!this.jRadioButtonDLL.isSelected());
        this.jCheckBoxNoPtb.setSelected(PtbguiMain.getProp(prop, "__arg_nobuildptb").equals("yes"));
        this.jCheckBoxNws.setSelected(PtbguiMain.getProp(prop, "__arg_nws").equals("yes"));
        this.jCheckBoxExt.setSelected(PtbguiMain.getProp(prop, "__arg_ext").equals("yes"));
        this.jTextFieldExt.setText(PtbguiMain.getProp(prop, "__arg_extroot"));
        this.adjustArch();
        this.initKnownTags();
        this.initTagsFromSubtree();
    }

    private void initKnownTags() {
        String from = this.jTextFieldRoot.getText() + "/src/build-system/project_tags.txt";
        int n = 0;
        this.m_KnownTags.clear();
        this.m_CompositeTags.clear();
        if (!ArgsParser.existsPath(from)) {
            return;
        }
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(new File(PtbguiMain.nativeFileSeparator(from)))));
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                String[] t = line.split("=");
                if (t.length > 1) {
                    this.m_CompositeTags.add(line.trim());
                    continue;
                }
                t = line.split("[, ]");
                for (int i = 0; i < t.length; ++i) {
                    if (t[i].trim().length() == 0) continue;
                    ++n;
                    this.m_KnownTags.add(t[i].trim());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
    }

    private void initTagsFromSubtree() {
        this.jTextFieldLstTags.setText("");
        String lst = this.jTextFieldRoot.getText() + File.separatorChar + this.jTextFieldLst.getText();
        File f = new File(PtbguiMain.nativeFileSeparator(lst));
        if (f.isFile()) {
            try {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                String key = "#define TAGS";
                while ((line = r.readLine()) != null) {
                    if (!(line = line.trim()).startsWith(key)) continue;
                    line = line.replaceAll(key, "");
                    line = line.replaceAll("\\[", "");
                    line = line.replaceAll("\\]", "");
                    line = line.trim();
                    this.jTextFieldLstTags.setText(line);
                    break;
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void updateData() {
        this.m_ArgsParser.setPtb(this.jTextFieldPtb.getText());
        if (this.m_ArgsProp != null && !this.m_ArgsProp.isEmpty()) {
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_root", this.jTextFieldRoot.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_subtree", this.jTextFieldLst.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_solution", this.jTextFieldSolution.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_projtag", this.jTextFieldTags.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_ide", this.jTextFieldIde.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_arch", this.jTextFieldArch.getText());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_dll", this.jRadioButtonDLL.isSelected());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_nobuildptb", this.jCheckBoxNoPtb.isSelected());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_nws", this.jCheckBoxNws.isSelected());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_ext", this.jCheckBoxExt.isSelected());
            PtbguiMain.setProp(this.m_ArgsProp, "__arg_extroot", this.jTextFieldExt.getText());
            try {
                File f = File.createTempFile("PTBconf", ".ini");
                f.deleteOnExit();
                FileOutputStream fout = new FileOutputStream(f);
                Enumeration<?> props = this.m_ArgsProp.propertyNames();
                while (props.hasMoreElements()) {
                    String key = props.nextElement().toString();
                    String value = this.m_ArgsProp.getProperty(key);
                    String line = key + "=" + value + "\n";
                    fout.write(line.getBytes());
                }
                fout.flush();
                fout.close();
                this.m_TmpParams = f.getPath();
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
            this.m_ArgsParser.setArgsFile(this.m_TmpParams);
        } else {
            this.m_ArgsParser.setRoot(this.jTextFieldRoot.getText());
            this.m_ArgsParser.setSubtree(this.jTextFieldLst.getText());
            this.m_ArgsParser.setSolutionFile(this.jTextFieldSolution.getText());
            this.m_ArgsParser.setProjTag(this.jTextFieldTags.getText());
            this.m_ArgsParser.setArch(this.jTextFieldArch.getText());
            this.m_ArgsParser.setDll(this.jRadioButtonDLL.isSelected(), false);
            this.m_ArgsParser.m_nobuildptb = this.jCheckBoxNoPtb.isSelected();
            this.m_ArgsParser.m_nws = this.jCheckBoxNws.isSelected();
            this.m_ArgsParser.m_ext = this.jCheckBoxExt.isSelected();
            this.m_ArgsParser.setExtRoot(this.jTextFieldExt.getText());
            this.m_ArgsParser.setArgsFile(null);
        }
    }

    public static String nativeFileSeparator(String s) {
        return s.replace('/', File.separatorChar);
    }

    public static String getProp(Properties prop, String key) {
        return prop.containsKey(key) ? PtbguiMain.nativeFileSeparator(prop.getProperty(key).trim()) : "";
    }

    public static String portableFileSeparator(String s) {
        return s.replace(File.separatorChar, '/');
    }

    public static void setProp(Properties prop, String key, String value) {
        prop.setProperty(key, PtbguiMain.portableFileSeparator(value));
    }

    public static void setProp(Properties prop, String key, boolean value) {
        prop.setProperty(key, value ? "yes" : "no");
    }

    public static boolean copyFile(String from, String to) {
        boolean res = true;
        if (!from.equals(to)) {
            try {
                int len;
                FileInputStream in = new FileInputStream(new File(from));
                FileOutputStream out = new FileOutputStream(new File(to));
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                res = false;
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
        return res;
    }

    private void setPathText(JTextComponent c, String path, boolean verify) {
        c.setText(path);
        if (!verify || ArgsParser.existsPath(path)) {
            c.setForeground(SystemColor.controlText);
            c.setToolTipText("");
        } else {
            c.setForeground(Color.red);
            c.setToolTipText("Path not found");
        }
    }

    private void setPathText(JTextComponent c, String root, String path) {
        c.setText(path);
        if (ArgsParser.existsPath(root + File.separator + path)) {
            c.setForeground(SystemColor.controlText);
            c.setToolTipText("");
        } else {
            c.setForeground(Color.red);
            c.setToolTipText("Path not found");
        }
    }

    private void processPtbOutput() {
        String line;
        while (this.isPtbRunning()) {
            try {
                Thread.sleep(3L);
                while (this.m_PtbErr != null && this.m_PtbErr.ready() && (line = this.m_PtbErr.readLine()) != null) {
                    System.err.println(line);
                }
                while (this.m_PtbOut != null && this.m_PtbOut.ready() && (line = this.m_PtbOut.readLine()) != null) {
                    if (line.startsWith("*PTBGUI{* custom")) {
                        this.processAdditionalParams();
                        return;
                    }
                    if (line.startsWith("*PTBGUI{* projects")) {
                        this.processProjects();
                        return;
                    }
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
        try {
            while (this.m_PtbErr != null && this.m_PtbErr.ready() && (line = this.m_PtbErr.readLine()) != null) {
                System.err.println(line);
            }
            while (this.m_PtbOut != null && this.m_PtbOut.ready() && (line = this.m_PtbOut.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
        if (this.m_State == eState.gotProjects || this.m_State == eState.got3rdparty) {
            this.processDone(this.m_Ptb.exitValue());
            return;
        }
        System.exit(this.m_Ptb != null ? this.m_Ptb.exitValue() : 1);
    }

    private void processAdditionalParams() {
        this.m_State = eState.got3rdparty;
        this.jButtonGOK.setText("Next");
        this.jButtonGCancel.setEnabled(true);
        int i = this.jTabbedPane.indexOfComponent(this.jPanelAdd);
        this.jTabbedPane.setEnabledAt(i, true);
        this.jTabbedPane.setSelectedIndex(i);
        this.jTextField3root.setText("");
        this.jTextField3root.setEnabled(false);
        this.jTextFieldCpath.setText("");
        this.jTextFieldCpath.setEnabled(false);
        this.jCheckBoxVTuneR.setEnabled(false);
        this.jCheckBoxVTuneR.setVisible(false);
        this.jCheckBoxVTuneD.setEnabled(false);
        this.jCheckBoxVTuneD.setVisible(false);
        this.jCheckBoxVTune.setSelected(false);
        this.jCheckBoxVTune.setEnabled(false);
        this.jPanelUserReq.setVisible(false);
        boolean vtune = false;
        String[] userRequests = new String[]{};
        String[] enabledRequests = new String[]{};
        try {
            String line;
            while (this.m_PtbOut != null && (line = this.m_PtbOut.readLine()) != null) {
                if (line.startsWith("*PTBGUI}*")) {
                    if (vtune) {
                        this.jCheckBoxVTune.setEnabled(true);
                        this.jCheckBoxVTuneR.setEnabled(true);
                        this.jCheckBoxVTuneD.setEnabled(true);
                        this.jCheckBoxVTune.setSelected(this.jCheckBoxVTuneR.isSelected() || this.jCheckBoxVTuneD.isSelected());
                        this.jCheckBoxVTuneD.setVisible(this.jCheckBoxVTune.isSelected());
                        this.jCheckBoxVTuneR.setVisible(this.jCheckBoxVTune.isSelected());
                    }
                    if (userRequests.length > 0) {
                        this.jPanelUserReq.setVisible(true);
                        for (int r = 0; r < userRequests.length; ++r) {
                            boolean sel = false;
                            for (int e = 0; !sel && e < enabledRequests.length; ++e) {
                                sel = userRequests[r].equals(enabledRequests[e]);
                            }
                            this.addProject(this.jListUserReq, userRequests[r], sel);
                        }
                    }
                    return;
                }
                String[] kv = line.split("=");
                if (kv.length <= 1) continue;
                String k = kv[0].trim();
                String v = kv[1].trim();
                if (k.equals("ThirdPartyBasePath") || k.equals("XCode_ThirdPartyBasePath")) {
                    this.m_Key3root = k;
                    this.jTextField3root.setEnabled(true);
                    this.setPathText((JTextComponent)this.jTextField3root, PtbguiMain.nativeFileSeparator(v), true);
                    continue;
                }
                if (k.equals("ThirdParty_C_ncbi") || k.equals("XCode_ThirdParty_C_ncbi")) {
                    this.m_KeyCpath = k;
                    this.jTextFieldCpath.setEnabled(true);
                    this.setPathText((JTextComponent)this.jTextFieldCpath, PtbguiMain.nativeFileSeparator(v), true);
                    continue;
                }
                if (k.equals("__TweakVTuneR")) {
                    vtune = true;
                    this.jCheckBoxVTuneR.setSelected(v.equals("yes"));
                    continue;
                }
                if (k.equals("__TweakVTuneD")) {
                    vtune = true;
                    this.jCheckBoxVTuneD.setSelected(v.equals("yes"));
                    continue;
                }
                if (k.equals("__UserRequests")) {
                    userRequests = v.split(" ");
                    continue;
                }
                if (!k.equals("__EnabledUserRequests")) continue;
                enabledRequests = v.split(" ");
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
    }

    private void doneAdditionalParams() {
        if (this.isPtbRunning()) {
            try {
                String yn;
                String s = "*PTBGUI{* custom\n";
                this.m_PtbIn.write(s.getBytes());
                if (this.jTextField3root.isEnabled()) {
                    s = this.m_Key3root + " = " + this.jTextField3root.getText() + "\n";
                    this.m_PtbIn.write(s.getBytes());
                }
                if (this.jTextFieldCpath.isEnabled()) {
                    s = this.m_KeyCpath + " = " + this.jTextFieldCpath.getText() + "\n";
                    this.m_PtbIn.write(s.getBytes());
                }
                String string = yn = this.jCheckBoxVTune.isSelected() && this.jCheckBoxVTuneR.isSelected() ? "yes" : "no";
                if (this.jCheckBoxVTuneR.isEnabled()) {
                    s = "__TweakVTuneR = " + yn + "\n";
                    this.m_PtbIn.write(s.getBytes());
                }
                String string2 = yn = this.jCheckBoxVTune.isSelected() && this.jCheckBoxVTuneD.isSelected() ? "yes" : "no";
                if (this.jCheckBoxVTuneD.isEnabled()) {
                    s = "__TweakVTuneD = " + yn + "\n";
                    this.m_PtbIn.write(s.getBytes());
                }
                if (this.jPanelUserReq.isVisible()) {
                    s = "__EnabledUserRequests =";
                    DefaultListModel model = (DefaultListModel)this.jListUserReq.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        JCheckBox b = (JCheckBox)model.getElementAt(i);
                        if (!b.isSelected()) continue;
                        s = s + " " + b.getText();
                    }
                    s = s + "\n";
                    this.m_PtbIn.write(s.getBytes());
                }
                s = "*PTBGUI}* custom\n";
                this.m_PtbIn.write(s.getBytes());
                this.m_PtbIn.flush();
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void initCheckList(JList list) {
        list.setModel(new DefaultListModel());
        list.setCellRenderer(new CheckListRenderer());
        list.addMouseListener(new CheckListMouseAdapter());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PtbguiMain.this.jListSelectionChanged(evt);
            }
        });
    }

    private void addProject(JList list, String project, boolean selected) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        JCheckBox b = new JCheckBox();
        b.setText(project);
        b.setSelected(selected);
        model.addElement(b);
    }

    private void selectProjects(JList list, boolean select) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckBox b = (JCheckBox)model.getElementAt(i);
            b.setSelected(select);
        }
        this.countSelected();
        list.repaint();
    }

    private void selectProjects(JList list, Vector<String> selected, Vector<String> unselected) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            int t;
            JCheckBox b = (JCheckBox)model.getElementAt(i);
            String prj = b.getText();
            if (!this.m_ProjectTags.containsKey(prj)) continue;
            String[] tags = this.m_ProjectTags.get(prj);
            boolean done = false;
            for (t = 0; !done && t < tags.length; ++t) {
                if (!unselected.contains(tags[t])) continue;
                b.setSelected(false);
                done = true;
            }
            for (t = 0; !done && t < tags.length; ++t) {
                if (!selected.contains(tags[t])) continue;
                b.setSelected(true);
                done = true;
            }
        }
        list.repaint();
    }

    private void checkProjectSelection(JList list, Vector<String> selected, Vector<String> unselected) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            int t;
            JCheckBox b = (JCheckBox)model.getElementAt(i);
            String prj = b.getText();
            if (!this.m_ProjectTags.containsKey(prj)) continue;
            String[] tags = this.m_ProjectTags.get(prj);
            boolean hasProhibited = false;
            for (t = 0; t < tags.length; ++t) {
                if (!unselected.contains(tags[t])) continue;
                if (b.isSelected()) {
                    this.m_UndefSelTags.add(tags[t]);
                }
                hasProhibited = true;
            }
            if (hasProhibited) continue;
            for (t = 0; t < tags.length; ++t) {
                if (!selected.contains(tags[t]) || b.isSelected()) continue;
                this.m_UndefSelTags.add(tags[t]);
            }
        }
    }

    private int getSelectedCount(JList list) {
        int count = 0;
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckBox b = (JCheckBox)model.getElementAt(i);
            if (!b.isSelected()) continue;
            ++count;
        }
        return count;
    }

    private void countSelected() {
        String t = "Applications (" + this.getSelectedCount(this.jListApps) + "/" + this.jListApps.getModel().getSize() + ")";
        this.jLabelApps.setText(t);
        t = "Libraries (" + this.getSelectedCount(this.jListLibs) + "/" + this.jListLibs.getModel().getSize() + ")";
        this.jLabelLibs.setText(t);
        t = "Other (" + this.getSelectedCount(this.jListOther) + "/" + this.jListOther.getModel().getSize() + ")";
        this.jLabelOther.setText(t);
        this.verifyTagSelection();
    }

    private void verifyTagSelection() {
        JCheckBox b;
        int i;
        Vector<String> selected = new Vector<String>();
        Vector<String> unselected = new Vector<String>();
        DefaultListModel model = (DefaultListModel)this.jListTags.getModel();
        for (i = 0; i < model.getSize(); ++i) {
            b = (JCheckBox)model.getElementAt(i);
            if (b.isSelected()) {
                selected.add(b.getText());
                continue;
            }
            unselected.add(b.getText());
        }
        this.m_UndefSelTags.clear();
        this.checkProjectSelection(this.jListApps, selected, unselected);
        this.checkProjectSelection(this.jListLibs, selected, unselected);
        this.checkProjectSelection(this.jListOther, selected, unselected);
        for (i = 0; i < model.getSize(); ++i) {
            b = (JCheckBox)model.getElementAt(i);
            if (!this.m_UndefSelTags.contains(b.getText()) || !b.isSelected()) continue;
            b.setSelected(false);
        }
        CheckListRenderer r = (CheckListRenderer)this.jListTags.getCellRenderer();
        r.setUndefinedSelection(this.m_UndefSelTags);
        this.jListTags.repaint();
    }

    private void jListSelectionChanged(MouseEvent evt) {
        JList list = (JList)evt.getSource();
        if (list == this.jListTags) {
            int index;
            Vector<String> selected = new Vector<String>();
            Vector<String> unselected = new Vector<String>();
            DefaultListModel model = (DefaultListModel)this.jListTags.getModel();
            JCheckBox item = (JCheckBox)model.getElementAt(index = this.jListTags.locationToIndex(evt.getPoint()));
            if (this.m_UndefSelTags.contains(item.getText()) && !item.isSelected()) {
                item.setSelected(true);
                this.jListTags.repaint();
            }
            if (item.isSelected()) {
                selected.add(item.getText());
            } else {
                unselected.add(item.getText());
            }
            this.selectProjects(this.jListApps, selected, unselected);
            this.selectProjects(this.jListLibs, selected, unselected);
            this.selectProjects(this.jListOther, selected, unselected);
        }
        this.countSelected();
    }

    private void writeSelected(JList list, OutputStream out) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckBox b = (JCheckBox)model.getElementAt(i);
            if (!b.isSelected()) continue;
            try {
                String s = b.getText() + "\n";
                out.write(s.getBytes());
                continue;
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void processProjects() {
        this.m_State = eState.gotProjects;
        this.jButtonGOK.setText("Generate project");
        this.jButtonGCancel.setEnabled(true);
        int i = this.jTabbedPane.indexOfComponent(this.jPanelPrj);
        this.jTabbedPane.setEnabledAt(i, true);
        this.jTabbedPane.setSelectedIndex(i);
        TreeSet<String> alltags = new TreeSet<String>();
        try {
            String line;
            while (this.m_PtbOut != null && (line = this.m_PtbOut.readLine()) != null) {
                if (line.startsWith("*PTBGUI}*")) {
                    Iterator tt = alltags.iterator();
                    while (tt.hasNext()) {
                        this.addProject(this.jListTags, (String)tt.next(), false);
                    }
                    this.countSelected();
                    return;
                }
                String[] kv = line.split(",");
                if (kv.length <= 2) continue;
                String prj = kv[0].trim();
                String type = kv[1].trim();
                boolean selected = kv[2].trim().equals("select");
                if (type.equals("lib")) {
                    this.addProject(this.jListLibs, prj, selected);
                } else if (type.equals("app")) {
                    this.addProject(this.jListApps, prj, selected);
                } else {
                    this.addProject(this.jListOther, prj, selected);
                }
                if (kv.length <= 4) continue;
                String[] tags = kv[4].trim().split("/");
                for (int t = 0; t < tags.length; ++t) {
                    alltags.add(tags[t]);
                }
                this.m_ProjectTags.put(prj, tags);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
    }

    private void doneProjects() {
        if (this.isPtbRunning()) {
            try {
                String s = "*PTBGUI{* projects\n";
                this.m_PtbIn.write(s.getBytes());
                this.writeSelected(this.jListApps, this.m_PtbIn);
                this.writeSelected(this.jListLibs, this.m_PtbIn);
                this.writeSelected(this.jListOther, this.m_PtbIn);
                s = "*PTBGUI}* projects\n";
                this.m_PtbIn.write(s.getBytes());
                this.m_PtbIn.flush();
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void processDone(int exitcode) {
        this.m_State = eState.donePtb;
        this.jButtonGOK.setVisible(false);
        this.jButtonGCancel.setEnabled(true);
        this.jButtonGCancel.setText("Finish");
        int i = this.jTabbedPane.indexOfComponent(this.jPanelDone);
        this.jTabbedPane.setEnabledAt(i, true);
        this.jTabbedPane.setSelectedIndex(i);
        if (exitcode == 0) {
            this.jLabelDone.setText("Configuration has completed successfully");
            this.jLabelSln.setText(this.m_ArgsParser.getSolution());
            this.jLabelSln.setVisible(true);
            this.jLabelGen.setVisible(true);
        } else {
            this.jLabelDone.setText("Configuration has FAILED");
            this.jLabelSln.setVisible(false);
            this.jLabelGen.setVisible(false);
        }
        File args = new File(this.m_ArgsParser.getSolution());
        this.m_Params = args.getParent() + File.separator + "project_tree_builder.ini.custom";
        File prm = new File(this.m_Params);
        this.jButtonSave.setEnabled(prm.exists());
    }

    private void startPtb() {
        this.updateData();
        String[] cmdline = this.m_ArgsParser.createCommandline();
        for (int i = 0; i < cmdline.length; ++i) {
            System.err.print(cmdline[i]);
            System.err.print(" ");
        }
        System.err.println("");
        Runtime r = Runtime.getRuntime();
        try {
            String cwd = System.getProperty("user.dir");
            this.m_Ptb = r.exec(cmdline, null, new File(cwd));
            this.m_PtbIn = this.m_Ptb.getOutputStream();
            InputStream out = this.m_Ptb.getInputStream();
            InputStream err = this.m_Ptb.getErrorStream();
            this.m_PtbOut = new BufferedReader(new InputStreamReader(out));
            this.m_PtbErr = new BufferedReader(new InputStreamReader(err));
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
    }

    private void stopPtb() {
        if (this.isPtbRunning()) {
            try {
                String s = "*PTBGUIabort*\n";
                this.m_PtbIn.write(s.getBytes());
                this.m_PtbIn.flush();
                for (int i = 0; i < 5 && this.isPtbRunning(); ++i) {
                    Thread.sleep(300L);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
        if (this.isPtbRunning()) {
            this.m_Ptb.destroy();
        }
        if (ArgsParser.existsPath(this.m_TmpParams)) {
            System.gc();
            new File(this.m_TmpParams).delete();
        }
    }

    private boolean isPtbRunning() {
        boolean isRunning = false;
        if (this.m_Ptb != null) {
            try {
                this.m_Ptb.exitValue();
            }
            catch (IllegalThreadStateException e) {
                isRunning = true;
            }
        }
        return isRunning;
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelCmnd = new JPanel();
        this.jTextFieldTags = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldLst = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonLst = new JButton();
        this.jLabel11 = new JLabel();
        this.jButtonArgs = new JButton();
        this.jRadioButtonStatic = new JRadioButton();
        this.jRadioButtonDLL = new JRadioButton();
        this.jSeparator2 = new JSeparator();
        this.jLabel14 = new JLabel();
        this.jLabelArgs = new JLabel();
        this.jButtonArgsReset = new JButton();
        this.jButtonKTags = new JButton();
        this.jLabel10 = new JLabel();
        this.jTextFieldLstTags = new JTextField();
        this.jPanelAdvanced = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldPtb = new JTextField();
        this.jButtonPtb = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldSolution = new JTextField();
        this.jCheckBoxNoPtb = new JCheckBox();
        this.jCheckBoxNws = new JCheckBox();
        this.jCheckBoxExt = new JCheckBox();
        this.jTextFieldExt = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldIde = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldArch = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldRoot = new JTextField();
        this.jButtonMore = new JButton();
        this.jPanelAdd = new JPanel();
        this.jLabel8 = new JLabel();
        this.jTextField3root = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldCpath = new JTextField();
        this.jCheckBoxVTuneR = new JCheckBox();
        this.jCheckBoxVTuneD = new JCheckBox();
        this.jCheckBoxVTune = new JCheckBox();
        this.jPanelUserReq = new JPanel();
        this.jLabelUserReq = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jListUserReq = new JList();
        this.jPanelPrj = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabelApps = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListApps = new JList();
        this.jButtonAppsPlus = new JButton();
        this.jButtonAppsMinus = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabelLibs = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListLibs = new JList();
        this.jButtonLibsMinus = new JButton();
        this.jButtonLibsPlus = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabelOther = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jListOther = new JList();
        this.jButtonOtherMinus = new JButton();
        this.jButtonOtherPlus = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabelTags = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jListTags = new JList();
        this.jPanelDone = new JPanel();
        this.jLabelDone = new JLabel();
        this.jButtonSave = new JButton();
        this.jButtonStartOver = new JButton();
        this.jLabelGen = new JLabel();
        this.jLabelSln = new JLabel();
        this.jButtonGCancel = new JButton();
        this.jButtonGOK = new JButton();
        this.jLabel13 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("The Toolkit configuration parameters");
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PtbguiMain.this.formWindowClosing(evt);
            }
        });
        this.jTextFieldTags.setText("jTextFieldTags");
        this.jLabel4.setText("Use project tags");
        this.jTextFieldLst.setText("jTextFieldLst");
        this.jTextFieldLst.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PtbguiMain.this.jTextFieldLstFocusLost(evt);
            }
        });
        this.jLabel3.setText("Subtree, or LST file");
        this.jButtonLst.setText("...");
        this.jButtonLst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonLstActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Originally loaded from");
        this.jButtonArgs.setText("Load from file...");
        this.jButtonArgs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonArgsActionPerformed(evt);
            }
        });
        this.jRadioButtonStatic.setText("Static");
        this.jRadioButtonStatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jRadioButtonStaticActionPerformed(evt);
            }
        });
        this.jRadioButtonDLL.setText("Dynamic");
        this.jRadioButtonDLL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jRadioButtonDLLActionPerformed(evt);
            }
        });
        this.jLabel14.setText("Build libraries as");
        this.jLabelArgs.setText("l");
        this.jLabelArgs.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonArgsReset.setText("Reset");
        this.jButtonArgsReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonArgsResetActionPerformed(evt);
            }
        });
        this.jButtonKTags.setText("...");
        this.jButtonKTags.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonKTagsActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Default project tags");
        this.jTextFieldLstTags.setEditable(false);
        this.jTextFieldLstTags.setText("jTextFieldLstTags");
        GroupLayout jPanelCmndLayout = new GroupLayout(this.jPanelCmnd);
        this.jPanelCmnd.setLayout(jPanelCmndLayout);
        jPanelCmndLayout.setHorizontalGroup(jPanelCmndLayout.createParallelGroup(1).add(jPanelCmndLayout.createSequentialGroup().addContainerGap().add(jPanelCmndLayout.createParallelGroup(1).add(jPanelCmndLayout.createSequentialGroup().add(jPanelCmndLayout.createParallelGroup(1).add(jPanelCmndLayout.createSequentialGroup().add(this.jLabel14, -2, 149, -2).addPreferredGap(0).add(jPanelCmndLayout.createParallelGroup(2, false).add(1, this.jRadioButtonDLL, -1, -1, Short.MAX_VALUE).add(1, this.jRadioButtonStatic, -1, 166, Short.MAX_VALUE))).add(this.jSeparator2, -1, 624, Short.MAX_VALUE).add(jPanelCmndLayout.createSequentialGroup().add(jPanelCmndLayout.createParallelGroup(1, false).add(this.jLabel11, -1, -1, Short.MAX_VALUE).add(this.jButtonArgs, -2, 167, -2)).addPreferredGap(0).add(jPanelCmndLayout.createParallelGroup(1).add(this.jLabelArgs, -1, 451, Short.MAX_VALUE).add(this.jButtonArgsReset, -2, 87, -2))).add(2, jPanelCmndLayout.createSequentialGroup().add(jPanelCmndLayout.createParallelGroup(2).add(1, jPanelCmndLayout.createSequentialGroup().add(this.jLabel4, -2, 149, -2).addPreferredGap(0).add(this.jTextFieldTags, -1, 398, Short.MAX_VALUE)).add(jPanelCmndLayout.createSequentialGroup().add(this.jLabel3, -2, 148, -2).addPreferredGap(0).add(this.jTextFieldLst, -1, 399, Short.MAX_VALUE))).add(18, 18, 18).add(jPanelCmndLayout.createParallelGroup(1).add(this.jButtonKTags, -2, 55, -2).add(this.jButtonLst, -2, 55, -2)))).addContainerGap()).add(jPanelCmndLayout.createSequentialGroup().add(this.jLabel10, -2, 149, -2).addPreferredGap(0).add(this.jTextFieldLstTags, -1, 398, Short.MAX_VALUE).add(83, 83, 83)))));
        jPanelCmndLayout.setVerticalGroup(jPanelCmndLayout.createParallelGroup(1).add(jPanelCmndLayout.createSequentialGroup().add(jPanelCmndLayout.createParallelGroup(1).add(jPanelCmndLayout.createSequentialGroup().addContainerGap().add(this.jRadioButtonStatic).addPreferredGap(0).add(this.jRadioButtonDLL)).add(jPanelCmndLayout.createSequentialGroup().add(24, 24, 24).add(this.jLabel14))).add(19, 19, 19).add(jPanelCmndLayout.createParallelGroup(3).add(this.jLabel3).add(this.jTextFieldLst, -2, -1, -2).add(this.jButtonLst, -2, 23, -2)).addPreferredGap(1).add(jPanelCmndLayout.createParallelGroup(3).add(this.jLabel4).add(this.jTextFieldTags, -2, -1, -2).add(this.jButtonKTags, -2, 23, -2)).addPreferredGap(1).add(jPanelCmndLayout.createParallelGroup(2).add(this.jLabel10).add(this.jTextFieldLstTags, -2, -1, -2)).addPreferredGap(0, 27, Short.MAX_VALUE).add(this.jSeparator2, -2, 10, -2).addPreferredGap(0).add(jPanelCmndLayout.createParallelGroup(3).add(this.jButtonArgs, -2, 23, -2).add(this.jButtonArgsReset)).addPreferredGap(0).add(jPanelCmndLayout.createParallelGroup(3).add(this.jLabel11).add(this.jLabelArgs)).add(36, 36, 36)));
        this.jTabbedPane.addTab("Configuration", this.jPanelCmnd);
        this.jLabel1.setText("Project tree builder");
        this.jTextFieldPtb.setText("jTextFieldPtb");
        this.jButtonPtb.setText("...");
        this.jButtonPtb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonPtbActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Solution to generate");
        this.jTextFieldSolution.setText("jTextFieldSolution");
        this.jCheckBoxNoPtb.setText("Exclude 'Build PTB' step from CONFIGURE project");
        this.jCheckBoxNws.setText("Do not scan the whole source tree for missing project dependencies");
        this.jCheckBoxExt.setText("Use external libraries instead of missing in-tree ones");
        this.jTextFieldExt.setText("jTextFieldExt");
        this.jLabel12.setText("Look for missing libraries in this tree");
        this.jLabel6.setText("Target IDE");
        this.jTextFieldIde.setEditable(false);
        this.jTextFieldIde.setText("jTextFieldIde");
        this.jLabel7.setText("Target architecture");
        this.jTextFieldArch.setText("jTextFieldArch");
        this.jLabel2.setText("Source root");
        this.jTextFieldRoot.setText("jTextFieldRoot");
        this.jTextFieldRoot.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PtbguiMain.this.jTextFieldRootFocusLost(evt);
            }
        });
        this.jButtonMore.setText("more >");
        this.jButtonMore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonMoreActionPerformed(evt);
            }
        });
        GroupLayout jPanelAdvancedLayout = new GroupLayout(this.jPanelAdvanced);
        this.jPanelAdvanced.setLayout(jPanelAdvancedLayout);
        jPanelAdvancedLayout.setHorizontalGroup(jPanelAdvancedLayout.createParallelGroup(1).add(jPanelAdvancedLayout.createSequentialGroup().addContainerGap().add(jPanelAdvancedLayout.createParallelGroup(1).add(jPanelAdvancedLayout.createSequentialGroup().add(jPanelAdvancedLayout.createParallelGroup(1).add(this.jLabel12, -1, 223, Short.MAX_VALUE).add(this.jLabel5, -1, 223, Short.MAX_VALUE).add(this.jLabel6, -1, 223, Short.MAX_VALUE).add(this.jLabel7, -1, 223, Short.MAX_VALUE)).addPreferredGap(0).add(jPanelAdvancedLayout.createParallelGroup(1).add(jPanelAdvancedLayout.createSequentialGroup().add(jPanelAdvancedLayout.createParallelGroup(2, false).add(1, this.jTextFieldIde).add(1, this.jTextFieldArch, -1, 112, Short.MAX_VALUE)).add(289, 289, 289)).add(2, jPanelAdvancedLayout.createSequentialGroup().add(jPanelAdvancedLayout.createParallelGroup(2).add(1, this.jTextFieldSolution, -1, 397, Short.MAX_VALUE).add(this.jTextFieldExt, -1, 397, Short.MAX_VALUE).add(1, this.jButtonMore)).addContainerGap()))).add(jPanelAdvancedLayout.createSequentialGroup().add(jPanelAdvancedLayout.createParallelGroup(2).add(this.jCheckBoxNws, -1, 444, Short.MAX_VALUE).add(this.jCheckBoxNoPtb, -1, 444, Short.MAX_VALUE).add(1, this.jCheckBoxExt, -1, 444, Short.MAX_VALUE)).add(190, 190, 190)).add(jPanelAdvancedLayout.createSequentialGroup().add(jPanelAdvancedLayout.createParallelGroup(2, false).add(1, this.jLabel2, -1, -1, Short.MAX_VALUE).add(1, this.jLabel1, -1, 188, Short.MAX_VALUE)).addPreferredGap(1).add(jPanelAdvancedLayout.createParallelGroup(1).add(jPanelAdvancedLayout.createSequentialGroup().add(this.jTextFieldPtb, -1, 365, Short.MAX_VALUE).addPreferredGap(0).add(this.jButtonPtb, -2, 55, -2)).add(this.jTextFieldRoot, -1, 426, Short.MAX_VALUE)).addContainerGap()))));
        jPanelAdvancedLayout.setVerticalGroup(jPanelAdvancedLayout.createParallelGroup(1).add(jPanelAdvancedLayout.createSequentialGroup().addContainerGap().add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel6).add(this.jTextFieldIde, -2, -1, -2)).addPreferredGap(0).add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel7).add(this.jTextFieldArch, -2, -1, -2)).addPreferredGap(0).add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel5).add(this.jTextFieldSolution, -2, -1, -2)).addPreferredGap(1).add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel12).add(this.jTextFieldExt, -2, -1, -2)).addPreferredGap(0).add(this.jButtonMore).addPreferredGap(1).add(this.jCheckBoxNoPtb).addPreferredGap(0).add(this.jCheckBoxNws).addPreferredGap(0).add(this.jCheckBoxExt).addPreferredGap(1).add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel1).add(this.jTextFieldPtb, -2, -1, -2).add(this.jButtonPtb, -2, 23, -2)).addPreferredGap(0).add(jPanelAdvancedLayout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldRoot, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Advanced", this.jPanelAdvanced);
        this.jLabel8.setText("Root directory of 3-rd party libraries");
        this.jTextField3root.setText("jTextField3root");
        this.jLabel9.setText("Path to the NCBI C Toolkit");
        this.jTextFieldCpath.setText("jTextFieldCpath");
        this.jCheckBoxVTuneR.setText("Release");
        this.jCheckBoxVTuneD.setText("Debug");
        this.jCheckBoxVTune.setText("Add VTune configurations:");
        this.jCheckBoxVTune.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jCheckBoxVTuneActionPerformed(evt);
            }
        });
        this.jLabelUserReq.setText("Additional requests");
        this.jListUserReq.setSelectionMode(0);
        this.jScrollPane5.setViewportView(this.jListUserReq);
        GroupLayout jPanelUserReqLayout = new GroupLayout(this.jPanelUserReq);
        this.jPanelUserReq.setLayout(jPanelUserReqLayout);
        jPanelUserReqLayout.setHorizontalGroup(jPanelUserReqLayout.createParallelGroup(1).add(jPanelUserReqLayout.createSequentialGroup().addContainerGap().add(jPanelUserReqLayout.createParallelGroup(1).add(this.jScrollPane5, -2, 122, -2).add(this.jLabelUserReq, -1, 122, Short.MAX_VALUE)).addContainerGap()));
        jPanelUserReqLayout.setVerticalGroup(jPanelUserReqLayout.createParallelGroup(1).add(jPanelUserReqLayout.createSequentialGroup().addContainerGap().add(this.jLabelUserReq).addPreferredGap(0).add(this.jScrollPane5, -1, 144, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanelAddLayout = new GroupLayout(this.jPanelAdd);
        this.jPanelAdd.setLayout(jPanelAddLayout);
        jPanelAddLayout.setHorizontalGroup(jPanelAddLayout.createParallelGroup(1).add(jPanelAddLayout.createSequentialGroup().addContainerGap().add(jPanelAddLayout.createParallelGroup(1).add(this.jPanelUserReq, -2, -1, -2).add(jPanelAddLayout.createSequentialGroup().add(jPanelAddLayout.createParallelGroup(1, false).add(this.jCheckBoxVTune, -1, -1, Short.MAX_VALUE).add(this.jLabel9, -1, -1, Short.MAX_VALUE).add(this.jLabel8, -1, 209, Short.MAX_VALUE)).add(jPanelAddLayout.createParallelGroup(1).add(jPanelAddLayout.createSequentialGroup().addPreferredGap(1).add(jPanelAddLayout.createParallelGroup(1).add(this.jTextFieldCpath, -1, 405, Short.MAX_VALUE).add(this.jTextField3root, -1, 405, Short.MAX_VALUE))).add(jPanelAddLayout.createSequentialGroup().add(72, 72, 72).add(this.jCheckBoxVTuneR).add(18, 18, 18).add(this.jCheckBoxVTuneD))))).addContainerGap()));
        jPanelAddLayout.setVerticalGroup(jPanelAddLayout.createParallelGroup(1).add(jPanelAddLayout.createSequentialGroup().addContainerGap().add(jPanelAddLayout.createParallelGroup(3).add(this.jLabel8).add(this.jTextField3root, -2, -1, -2)).addPreferredGap(0).add(jPanelAddLayout.createParallelGroup(3).add(this.jLabel9).add(this.jTextFieldCpath, -2, -1, -2)).addPreferredGap(0).add(jPanelAddLayout.createParallelGroup(3).add(this.jCheckBoxVTuneR).add(this.jCheckBoxVTuneD).add(this.jCheckBoxVTune)).addPreferredGap(1).add(this.jPanelUserReq, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Libraries and Tools", this.jPanelAdd);
        this.jPanelPrj.setLayout(new GridLayout(1, 0));
        this.jPanel2.setPreferredSize(new Dimension(165, 280));
        this.jLabelApps.setText("Applications");
        this.jListApps.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListApps);
        this.jButtonAppsPlus.setText("+all");
        this.jButtonAppsPlus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonAppsPlusActionPerformed(evt);
            }
        });
        this.jButtonAppsMinus.setText("-all");
        this.jButtonAppsMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonAppsMinusActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jButtonAppsPlus).addPreferredGap(0).add(this.jButtonAppsMinus).add(43, 43, 43)).add(jPanel2Layout.createSequentialGroup().add(this.jLabelApps).addContainerGap()).add(this.jScrollPane1, -1, 151, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabelApps).addPreferredGap(0).add(this.jScrollPane1, -1, 215, Short.MAX_VALUE).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jButtonAppsPlus).add(this.jButtonAppsMinus))));
        this.jPanel3.setPreferredSize(new Dimension(160, 280));
        this.jLabelLibs.setText("Libraries");
        this.jListLibs.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jListLibs);
        this.jButtonLibsMinus.setText("-all");
        this.jButtonLibsMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonLibsMinusActionPerformed(evt);
            }
        });
        this.jButtonLibsPlus.setText("+all");
        this.jButtonLibsPlus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonLibsPlusActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jLabelLibs).addContainerGap(116, Short.MAX_VALUE)).add(jPanel3Layout.createSequentialGroup().add(this.jButtonLibsPlus).addPreferredGap(0).add(this.jButtonLibsMinus).addContainerGap()).add(this.jScrollPane2, -1, 156, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jLabelLibs).addPreferredGap(0).add(this.jScrollPane2, -1, 215, Short.MAX_VALUE).addPreferredGap(0).add(jPanel3Layout.createParallelGroup(3).add(this.jButtonLibsPlus).add(this.jButtonLibsMinus))));
        this.jPanel4.setPreferredSize(new Dimension(150, 280));
        this.jLabelOther.setText("Other");
        this.jListOther.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.jListOther);
        this.jButtonOtherMinus.setText("-all");
        this.jButtonOtherMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonOtherMinusActionPerformed(evt);
            }
        });
        this.jButtonOtherPlus.setText("+all");
        this.jButtonOtherPlus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonOtherPlusActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(this.jLabelOther).addContainerGap(118, Short.MAX_VALUE)).add(jPanel4Layout.createSequentialGroup().add(this.jButtonOtherPlus).addPreferredGap(0).add(this.jButtonOtherMinus).addContainerGap()).add(this.jScrollPane3, -1, 146, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(this.jLabelOther).addPreferredGap(0).add(this.jScrollPane3, -1, 215, Short.MAX_VALUE).addPreferredGap(0).add(jPanel4Layout.createParallelGroup(3).add(this.jButtonOtherPlus).add(this.jButtonOtherMinus))));
        this.jPanel5.setPreferredSize(new Dimension(140, 280));
        this.jLabelTags.setText("Tags");
        this.jListTags.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.jListTags);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().add(this.jLabelTags).addContainerGap(111, Short.MAX_VALUE)).add(this.jScrollPane4, -1, 134, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().add(this.jLabelTags).addPreferredGap(0).add(this.jScrollPane4, -1, 215, Short.MAX_VALUE).add(29, 29, 29)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jPanel2, -1, 151, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel3, -1, 156, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel4, -1, 146, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel5, -1, 134, Short.MAX_VALUE).add(29, 29, 29)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jPanel5, -1, 264, Short.MAX_VALUE).add(this.jPanel4, -1, 264, Short.MAX_VALUE).add(2, this.jPanel3, -1, 264, Short.MAX_VALUE).add(this.jPanel2, -1, 264, Short.MAX_VALUE)).addContainerGap()));
        this.jPanelPrj.add(this.jPanel1);
        this.jTabbedPane.addTab("Projects", this.jPanelPrj);
        this.jLabelDone.setHorizontalAlignment(0);
        this.jLabelDone.setText("jLabelDone");
        this.jButtonSave.setText("Save configuration parameters into a file...");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonStartOver.setText("Start over");
        this.jButtonStartOver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonStartOverActionPerformed(evt);
            }
        });
        this.jLabelGen.setHorizontalAlignment(0);
        this.jLabelGen.setText("Generated project file:");
        this.jLabelSln.setHorizontalAlignment(0);
        this.jLabelSln.setText("jLabelSln");
        GroupLayout jPanelDoneLayout = new GroupLayout(this.jPanelDone);
        this.jPanelDone.setLayout(jPanelDoneLayout);
        jPanelDoneLayout.setHorizontalGroup(jPanelDoneLayout.createParallelGroup(1).add(jPanelDoneLayout.createSequentialGroup().addContainerGap().add(jPanelDoneLayout.createParallelGroup(1).add(2, this.jButtonStartOver, -2, 305, -2).add(2, this.jButtonSave, -2, 305, -2).add(this.jLabelDone, -1, 624, Short.MAX_VALUE).add(this.jLabelGen, -1, 624, Short.MAX_VALUE).add(this.jLabelSln, -1, 624, Short.MAX_VALUE)).addContainerGap()));
        jPanelDoneLayout.setVerticalGroup(jPanelDoneLayout.createParallelGroup(1).add(2, jPanelDoneLayout.createSequentialGroup().add(29, 29, 29).add(this.jLabelDone).add(18, 18, 18).add(this.jLabelGen).addPreferredGap(1).add(this.jLabelSln).addPreferredGap(0, 118, Short.MAX_VALUE).add(this.jButtonSave).addPreferredGap(1).add(this.jButtonStartOver).addContainerGap()));
        this.jTabbedPane.addTab("Done", this.jPanelDone);
        this.jButtonGCancel.setText("Cancel");
        this.jButtonGCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonGCancelActionPerformed(evt);
            }
        });
        this.jButtonGOK.setText("Next");
        this.jButtonGOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtbguiMain.this.jButtonGOKActionPerformed(evt);
            }
        });
        this.jLabel13.setText("  version 1.3.1");
        this.jLabel13.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jLabel13).addPreferredGap(0, 228, Short.MAX_VALUE).add(this.jButtonGOK, -2, 276, -2).addPreferredGap(1).add(this.jButtonGCancel)).add(this.jTabbedPane, -1, 649, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jTabbedPane, -1, 314, Short.MAX_VALUE).add(11, 11, 11).add(layout.createParallelGroup(3).add(this.jButtonGCancel).add(this.jButtonGOK).add(this.jLabel13)).addContainerGap()));
        this.pack();
    }

    private void jButtonPtbActionPerformed(ActionEvent evt) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.jLabel1.getText());
        File f = new File(this.jTextFieldPtb.getText());
        fd.setCurrentDirectory(f.getParentFile());
        if (fd.showOpenDialog(this) == 0) {
            this.setPathText((JTextComponent)this.jTextFieldPtb, fd.getSelectedFile().getPath(), true);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stopPtb();
        this.processPtbOutput();
    }

    private void jButtonLstActionPerformed(ActionEvent evt) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.jLabel3.getText());
        String root = this.jTextFieldRoot.getText();
        String lst = root + File.separator + this.jTextFieldLst.getText();
        File flst = new File(ArgsParser.existsPath(lst) ? lst : root);
        fd.setCurrentDirectory(flst.isDirectory() ? flst : flst.getParentFile());
        if (fd.showOpenDialog(this) == 0) {
            String f = fd.getSelectedFile().getPath();
            if (f.startsWith(root)) {
                if ((f = f.substring(root.length())).startsWith("\\") || f.startsWith("/")) {
                    f = f.substring(1);
                }
                this.setPathText((JTextComponent)this.jTextFieldLst, root, f);
            } else {
                JOptionPane.showMessageDialog(this, "The file must be in the same tree", "Error", 0);
            }
            this.initTagsFromSubtree();
        }
    }

    private void jButtonArgsActionPerformed(ActionEvent evt) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.jLabel3.getText());
        String args = this.jLabelArgs.getText();
        if (ArgsParser.existsPath(args)) {
            File f = new File(args);
            fd.setCurrentDirectory(f.getParentFile());
        } else {
            fd.setCurrentDirectory(new File("."));
        }
        if (fd.showOpenDialog(this) == 0) {
            this.initData(fd.getSelectedFile().getPath(), (Boolean)false);
        }
    }

    private void jButtonGCancelActionPerformed(ActionEvent evt) {
        this.stopPtb();
        this.processPtbOutput();
    }

    private void jButtonGOKActionPerformed(ActionEvent evt) {
        if (this.m_State == eState.beforePtb) {
            this.startPtb();
        } else if (this.m_State == eState.got3rdparty) {
            this.doneAdditionalParams();
        } else if (this.m_State == eState.gotProjects) {
            this.doneProjects();
        }
        if (this.isPtbRunning()) {
            this.jButtonGOK.setText("Please wait...");
            this.jButtonGOK.setForeground(Color.red);
            this.jButtonGOK.paintImmediately(0, 0, this.jButtonGOK.getWidth(), this.jButtonGOK.getHeight());
            this.jButtonGOK.setForeground(SystemColor.controlText);
            this.jButtonGCancel.setText("Stop");
        }
        this.processPtbOutput();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        Object f;
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.jButtonSave.getText());
        String args = this.jLabelArgs.getText();
        if (ArgsParser.existsPath(args)) {
            f = new File(args);
            fd.setCurrentDirectory(((File)f).getParentFile());
        } else {
            fd.setCurrentDirectory(new File("."));
        }
        if (fd.showSaveDialog(this) == 0) {
            try {
                f = fd.getSelectedFile().getPath();
                PtbguiMain.copyFile(this.m_Params, (String)f);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void jButtonArgsResetActionPerformed(ActionEvent evt) {
        this.initData();
    }

    private void jButtonAppsPlusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListApps, true);
    }

    private void jButtonAppsMinusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListApps, false);
    }

    private void jButtonLibsPlusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListLibs, true);
    }

    private void jButtonLibsMinusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListLibs, false);
    }

    private void jButtonOtherPlusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListOther, true);
    }

    private void jButtonOtherMinusActionPerformed(ActionEvent evt) {
        this.selectProjects(this.jListOther, false);
    }

    private void jButtonStartOverActionPerformed(ActionEvent evt) {
        this.resetState();
        this.initData();
    }

    private void jButtonMoreActionPerformed(ActionEvent evt) {
        this.showMoreAdvanced(!this.jCheckBoxNoPtb.isVisible());
    }

    private void jCheckBoxVTuneActionPerformed(ActionEvent evt) {
        this.jCheckBoxVTuneD.setVisible(this.jCheckBoxVTune.isSelected());
        this.jCheckBoxVTuneR.setVisible(this.jCheckBoxVTune.isSelected());
    }

    private void jRadioButtonStaticActionPerformed(ActionEvent evt) {
        this.adjustBuildType();
    }

    private void jRadioButtonDLLActionPerformed(ActionEvent evt) {
        this.adjustBuildType();
    }

    private void jButtonKTagsActionPerformed(ActionEvent evt) {
        if (this.m_KtagsDlg == null) {
            this.m_KtagsDlg = new KTagsDialog((Frame)this, false);
            this.m_KtagsDlg.setLocationRelativeTo(this);
        }
        if (!this.m_KtagsDlg.isVisible()) {
            this.m_KtagsDlg.setTextData(this.m_KnownTags, this.m_CompositeTags);
            this.m_KtagsDlg.setVisible(true);
        }
    }

    private void jTextFieldLstFocusLost(FocusEvent evt) {
        this.initTagsFromSubtree();
    }

    private void jTextFieldRootFocusLost(FocusEvent evt) {
        this.initTagsFromSubtree();
    }

    public static void main(String[] args) {
        PtbguiMain ptbgui = new PtbguiMain();
        ptbgui.initData(args);
        ptbgui.setLocationRelativeTo(null);
        ptbgui.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum eState {
        beforePtb,
        got3rdparty,
        gotProjects,
        donePtb;

    }
}

