/* $Id: Seq_id.cpp 257863 2011-03-16 15:09:56Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <corelib/ncbiutil.hpp>
#include <corelib/ncbiapp.hpp>
#include <util/line_reader.hpp>
#include <util/static_map.hpp>
#include <util/util_misc.hpp>
#include <serial/serialimpl.hpp>

#include <objects/seq/Bioseq.hpp>
#include <objects/seq/Seq_inst.hpp>

#include <objects/seqloc/Seq_id.hpp>
#include <objects/seqloc/Textseq_id.hpp>
#include <objects/seqloc/Giimport_id.hpp>
#include <objects/seqloc/Patent_seq_id.hpp>
#include <objects/seqloc/PDB_seq_id.hpp>

#include <objects/biblio/Id_pat.hpp>

#include <objects/general/Object_id.hpp>
#include <objects/general/Dbtag.hpp>
#include <objects/general/Date.hpp>
#include <objects/general/Date_std.hpp>
#include <objects/misc/error_codes.hpp>

#include "accguide.inc"


#define NCBI_USE_ERRCODE_X   Objects_SeqId

// generated classes

BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE // namespace ncbi::objects::


// constructor
CSeq_id::CSeq_id(void)
{
    return;
}

// destructor
CSeq_id::~CSeq_id(void)
{
    return;
}


static void s_SplitVersion(const string& acc_in, string& acc, int& ver)
{
    string verstr;
    NStr::SplitInTwo(acc_in, ".", acc, verstr);
    if (verstr.empty()) {
        ver = 0;
    } else {
        ver = NStr::StringToNumeric(verstr);
        if (ver <= 0) {
            NCBI_THROW(CSeqIdException, eFormat,
                       "Version embedded in accession " + acc_in
                       + " is not a positive integer");
        }
    }
}


const CTextseq_id* CSeq_id::GetTextseq_Id(void) const
{
    switch ( Which() ) {
    case e_Genbank:
        return &GetGenbank();
    case e_Embl:
        return &GetEmbl();
    case e_Ddbj:
        return &GetDdbj();
    case e_Pir:
        return &GetPir();
    case e_Swissprot:
        return &GetSwissprot();
    case e_Other:
        return &GetOther();
    case e_Prf:
        return &GetPrf();
    case e_Tpg:
        return &GetTpg();
    case e_Tpe:
        return &GetTpe();
    case e_Tpd:
        return &GetTpd();
    case e_Gpipe:
        return &GetGpipe();
    case e_Named_annot_track:
        return &GetNamed_annot_track();
    default:
        return 0;
    }
}


inline
void x_Assign(CObject_id& dst, const CObject_id& src)
{
    switch ( src.Which() ) {
    case CObject_id::e_not_set:
        dst.Reset();
        return;
    case CObject_id::e_Id:
        dst.SetId(src.GetId());
        return;
    case CObject_id::e_Str:
        dst.SetStr(src.GetStr());
        return;
    default:
        NCBI_THROW(CSeqIdException, eFormat, "invalid Object-id variant");
    }
}


inline
void x_Assign(CGiimport_id& dst, const CGiimport_id& src)
{
    dst.SetId(src.GetId());
    if ( src.IsSetDb() ) {
        dst.SetDb(src.GetDb());
    }
    else {
        dst.ResetDb();
    }
    if ( src.IsSetRelease() ) {
        dst.SetRelease(src.GetRelease());
    }
    else {
        dst.ResetRelease();
    }
}


inline
void x_Assign(CTextseq_id& dst, const CTextseq_id& src)
{
    if ( src.IsSetName() ) {
        dst.SetName(src.GetName());
    }
    else {
        dst.ResetName();
    }
    if ( src.IsSetAccession() ) {
        dst.SetAccession(src.GetAccession());
    }
    else {
        dst.ResetAccession();
    }
    if ( src.IsSetRelease() ) {
        dst.SetRelease(src.GetRelease());
    }
    else {
        dst.ResetRelease();
    }
    if ( src.IsSetVersion() ) {
        dst.SetVersion(src.GetVersion());
    }
    else {
        dst.ResetVersion();
    }
}


inline
void x_Assign(CDbtag& dst, const CDbtag& src)
{
    dst.SetDb(src.GetDb());
    x_Assign(dst.SetTag(), src.GetTag());
}


inline
void x_Assign(CPatent_seq_id& dst, const CPatent_seq_id& src)
{
    dst.SetSeqid(src.GetSeqid());
    dst.SetCit().Assign(src.GetCit());
}


inline
void x_Assign(CDate& dst, const CDate& src)
{
    dst.Assign(src);
}


inline
void x_Assign(CPDB_seq_id& dst, const CPDB_seq_id& src)
{
    dst.SetMol().Set(src.GetMol());
    if ( src.IsSetChain() ) {
        dst.SetChain(src.GetChain());
    }
    else {
        dst.ResetChain();
    }
    if ( src.IsSetRel() ) {
        dst.SetRel().Assign(src.GetRel());
    }
    else {
        dst.ResetRel();
    }
}


void CSeq_id::Assign(const CSerialObject& obj, ESerialRecursionMode how)
{
    if ( GetTypeInfo() == obj.GetThisTypeInfo() ) {
        const CSeq_id& id = static_cast<const CSeq_id&>(obj);
        switch ( id.Which() ) {
        case e_not_set:
            Reset();
            return;
        case e_Local:
            x_Assign(SetLocal(), id.GetLocal());
            return;
        case e_Gibbsq:
            SetGibbsq(id.GetGibbsq());
            return;
        case e_Gibbmt:
            SetGibbmt(id.GetGibbmt());
            return;
        case e_Giim:
            x_Assign(SetGiim(), id.GetGiim());
            return;
        case e_Pir:
            x_Assign(SetPir(), id.GetPir());
            return;
        case e_Swissprot:
            x_Assign(SetSwissprot(), id.GetSwissprot());
            return;
        case e_Patent:
            x_Assign(SetPatent(), id.GetPatent());
            return;
        case e_Other:
            x_Assign(SetOther(), id.GetOther());
            return;
        case e_General:
            x_Assign(SetGeneral(), id.GetGeneral());
            return;
        case e_Gi:
            SetGi(id.GetGi());
            return;
        case e_Prf:
            x_Assign(SetPrf(), id.GetPrf());
            return;
        case e_Pdb:
            x_Assign(SetPdb(), id.GetPdb());
            return;
        case e_Genbank:
            x_Assign(SetGenbank(), id.GetGenbank());
            return;
        case e_Embl:
            x_Assign(SetEmbl(), id.GetEmbl());
            return;
        case e_Ddbj:
            x_Assign(SetDdbj(), id.GetDdbj());
            return;
        case e_Tpg:
            x_Assign(SetTpg(), id.GetTpg());
            return;
        case e_Tpe:
            x_Assign(SetTpe(), id.GetTpe());
            return;
        case e_Tpd:
            x_Assign(SetTpd(), id.GetTpd());
            return;
        case e_Gpipe:
            x_Assign(SetGpipe(), id.GetGpipe());
            return;
        case e_Named_annot_track:
            x_Assign(SetNamed_annot_track(), id.GetNamed_annot_track());
            return;
        }
    }
    CSerialObject::Assign(obj, how);
}


inline bool CanCmpAcc(CSeq_id::E_Choice choice)
{
    switch ( choice ) {
    case CSeq_id::e_Genbank:
    case CSeq_id::e_Embl:
    case CSeq_id::e_Ddbj:
    case CSeq_id::e_Tpg:
    case CSeq_id::e_Tpe:
    case CSeq_id::e_Tpd:
    case CSeq_id::e_Gpipe:
    case CSeq_id::e_Named_annot_track:
        return true;
    default:
        return false;
    }
}


// Compare() - are SeqIds equivalent?
CSeq_id::E_SIC CSeq_id::Compare(const CSeq_id& sid2) const
{
    if ( Which() != sid2.Which() ) { // Only one case where this will work
        if (!CanCmpAcc(Which()) || !CanCmpAcc(sid2.Which())) {
            return e_DIFF;
        }
        const CTextseq_id *tsip1 = GetTextseq_Id();
        if ( !tsip1 )
            return e_DIFF;

        const CTextseq_id *tsip2 = sid2.GetTextseq_Id();
        if ( !tsip2 )
            return e_DIFF;

        if ( tsip1->Match(*tsip2) ) // id Textseq_id match
            return e_YES;
        else
            return e_NO;
    }

    switch ( Which() ) { // Now we only need to know one
    case e_Local:
        return GetLocal().Match(sid2.GetLocal()) ? e_YES : e_NO;
    case e_Gibbsq:
        return GetGibbsq() == sid2.GetGibbsq() ? e_YES : e_NO;
    case e_Gibbmt:
        return GetGibbmt() == sid2.GetGibbmt() ? e_YES : e_NO;
    case e_Giim:
        return GetGiim().GetId() == sid2.GetGiim().GetId() ? e_YES : e_NO;
    case e_Pir:
        return GetPir().Match(sid2.GetPir()) ? e_YES : e_NO;
    case e_Swissprot:
        return GetSwissprot().Match(sid2.GetSwissprot()) ? e_YES : e_NO;
    case e_Patent:
        return GetPatent().Match(sid2.GetPatent()) ? e_YES : e_NO;
    case e_Other:
        return GetOther().Match(sid2.GetOther()) ? e_YES : e_NO;
    case e_General:
        if ( GetGeneral().Match(sid2.GetGeneral()) ) {
            return e_YES;
        }
        else if ( NStr::CompareNocase(GetGeneral().GetDb(),
            sid2.GetGeneral().GetDb()) ) {
                return e_DIFF;
        }
        return e_NO;
    case e_Gi:
        return GetGi() == sid2.GetGi() ? e_YES : e_NO;
    case e_Prf:
        return GetPrf().Match(sid2.GetPrf()) ? e_YES : e_NO;
    case e_Pdb:
        return GetPdb().Match(sid2.GetPdb()) ? e_YES : e_NO;
    case e_Genbank:
        return GetGenbank().Match(sid2.GetGenbank()) ? e_YES : e_NO;
    case e_Embl:
        return GetEmbl().Match(sid2.GetEmbl()) ? e_YES : e_NO;
    case e_Ddbj:
        return GetDdbj().Match(sid2.GetDdbj()) ? e_YES : e_NO;
    case e_Tpg:
        return GetTpg().Match(sid2.GetTpg()) ? e_YES : e_NO;
    case e_Tpe:
        return GetTpe().Match(sid2.GetTpe()) ? e_YES : e_NO;
    case e_Tpd:
        return GetTpd().Match(sid2.GetTpd()) ? e_YES : e_NO;
    case e_Gpipe:
        return GetGpipe().Match(sid2.GetGpipe()) ? e_YES : e_NO;
    case e_Named_annot_track:
        return GetNamed_annot_track().Match(sid2.GetNamed_annot_track())
            ? e_YES : e_NO;
    default:
        return e_error;
    }
}


int CSeq_id::CompareOrdered(const CSeq_id& sid2) const
{
    int ret = Which() - sid2.Which();
    if ( ret != 0 ) {
        return ret;
    }
    const CTextseq_id *tsip1 = GetTextseq_Id();
    const CTextseq_id *tsip2 = sid2.GetTextseq_Id();
    if ( tsip1 && tsip2 ) {
        return tsip1->Compare(*tsip2);
    }
    switch ( Which() ) { // Now we only need to know one
    case e_Local:
        return GetLocal().Compare(sid2.GetLocal());
    case e_Gibbsq:
        return GetGibbsq() - sid2.GetGibbsq();
    case e_Gibbmt:
        return GetGibbmt() - sid2.GetGibbmt();
    case e_Giim:
        return GetGiim().GetId() - sid2.GetGiim().GetId();
    case e_Patent:
        return GetPatent().Compare(sid2.GetPatent());
    case e_General:
        return GetGeneral().Compare(sid2.GetGeneral());
    case e_Gi:
        return GetGi() - sid2.GetGi();
    case e_Pdb:
        return 0;
    default:
        return this == &sid2? 0: this < &sid2? -1: 1;
    }
}

typedef pair<const char*, CSeq_id::E_Choice> TChoiceMapEntry;
// used for binary searching; must be in order.
static const TChoiceMapEntry sc_ChoiceArray[] = {
    TChoiceMapEntry("???",          CSeq_id::e_not_set),
    TChoiceMapEntry("bbm",          CSeq_id::e_Gibbmt),
    TChoiceMapEntry("bbs",          CSeq_id::e_Gibbsq),
    TChoiceMapEntry("dbj",          CSeq_id::e_Ddbj),
    TChoiceMapEntry("ddbj",         CSeq_id::e_Ddbj),
    TChoiceMapEntry("emb",          CSeq_id::e_Embl),
    TChoiceMapEntry("embl",         CSeq_id::e_Embl),
    TChoiceMapEntry("gb",           CSeq_id::e_Genbank),
    TChoiceMapEntry("genbank",      CSeq_id::e_Genbank),
    TChoiceMapEntry("general",      CSeq_id::e_General),
    TChoiceMapEntry("gi",           CSeq_id::e_Gi),
    TChoiceMapEntry("gibbmt",       CSeq_id::e_Gibbmt),
    TChoiceMapEntry("gibbsq",       CSeq_id::e_Gibbsq),
    TChoiceMapEntry("giim",         CSeq_id::e_Giim),
    TChoiceMapEntry("gim",          CSeq_id::e_Giim),
    TChoiceMapEntry("gnl",          CSeq_id::e_General),
    TChoiceMapEntry("gpipe",        CSeq_id::e_Gpipe),
    TChoiceMapEntry("gpp",          CSeq_id::e_Gpipe),
    TChoiceMapEntry("lcl",          CSeq_id::e_Local),
    TChoiceMapEntry("local",        CSeq_id::e_Local),
    TChoiceMapEntry("named_annot_track", CSeq_id::e_Named_annot_track),
    TChoiceMapEntry("nat",          CSeq_id::e_Named_annot_track),
    TChoiceMapEntry("not_set",      CSeq_id::e_not_set),
    TChoiceMapEntry("oth",          CSeq_id::e_Other), // deprecated vs. ref
    TChoiceMapEntry("other",        CSeq_id::e_Other),
    TChoiceMapEntry("pat",          CSeq_id::e_Patent),
    TChoiceMapEntry("patent",       CSeq_id::e_Patent),
    TChoiceMapEntry("pdb",          CSeq_id::e_Pdb),
    TChoiceMapEntry("pgp",          CSeq_id::e_Patent),
    TChoiceMapEntry("pir",          CSeq_id::e_Pir),
    TChoiceMapEntry("prf",          CSeq_id::e_Prf),
    TChoiceMapEntry("ref",          CSeq_id::e_Other),
    TChoiceMapEntry("sp",           CSeq_id::e_Swissprot),
    TChoiceMapEntry("swissprot",    CSeq_id::e_Swissprot),
    TChoiceMapEntry("tpd",          CSeq_id::e_Tpd),
    TChoiceMapEntry("tpe",          CSeq_id::e_Tpe),
    TChoiceMapEntry("tpg",          CSeq_id::e_Tpg),
    TChoiceMapEntry("tr",           CSeq_id::e_Swissprot)
};
typedef CStaticArrayMap<const char*, CSeq_id::E_Choice, PNocase_CStr> TChoiceMap;
DEFINE_STATIC_ARRAY_MAP(TChoiceMap, sc_ChoiceMap, sc_ChoiceArray);


static const char* const s_TextId[CSeq_id::e_MaxChoice+1] =
{   // FASTA_LONG formats
    "???" , // not-set = ???
    "lcl",  // local = lcl|integer or string
    "bbs",  // gibbsq = bbs|integer
    "bbm",  // gibbmt = bbm|integer
    "gim",  // giim = gim|integer
    "gb",   // genbank = gb|accession|locus
    "emb",  // embl = emb|accession|locus
    "pir",  // pir = pir|accession|name
    "sp",   // swissprot = sp|accession|name *OR* tr|accession|name
    "pat",  // patent = pat|country|patent number (string)|seq number (integer)
            //     *OR* pgp|country|application number|seq number
    "ref",  // other = ref|accession|name|release - changed from oth to ref
    "gnl",  // general = gnl|database(string)|id (string or number)
    "gi",   // gi = gi|integer
    "dbj",  // ddbj = dbj|accession|locus
    "prf",  // prf = prf|accession|name
    "pdb",  // pdb = pdb|entry name (string)|chain id (char)
    "tpg",  // tpg = tpg|accession|name
    "tpe",  // tpe = tpe|accession|name
    "tpd",  // tpd = tpd|accession|name
    "gpp",  // gpipe = gpp|accession|name
    "nat",  // named_annot_track = nat|accession|name
    ""  // Placeholder for end of list
};

CSeq_id::E_Choice CSeq_id::WhichInverseSeqId(const char* SeqIdCode)
{
    TChoiceMap::const_iterator it = sc_ChoiceMap.find(SeqIdCode);
    if (it == sc_ChoiceMap.end()) {
        return e_not_set;
    } else {
        return it->second;
    }
}


typedef pair<const char*, CSeq_id::EAccessionInfo> TAccInfoMapEntry;
// used for binary searching; must be in order.
static const TAccInfoMapEntry sc_AccInfoArray[] = {
    TAccInfoMapEntry("ambiguous_nuc",           CSeq_id::eAcc_ambiguous_nuc),
    TAccInfoMapEntry("ddbj_con",                CSeq_id::eAcc_ddbj_con),
    TAccInfoMapEntry("ddbj_dirsub",             CSeq_id::eAcc_ddbj_dirsub),
    TAccInfoMapEntry("ddbj_est",                CSeq_id::eAcc_ddbj_est),
    TAccInfoMapEntry("ddbj_genome",             CSeq_id::eAcc_ddbj_genome),
    TAccInfoMapEntry("ddbj_gss",                CSeq_id::eAcc_ddbj_gss),
    TAccInfoMapEntry("ddbj_htgs",               CSeq_id::eAcc_ddbj_htgs),
    TAccInfoMapEntry("ddbj_mga",                CSeq_id::eAcc_ddbj_mga),
    TAccInfoMapEntry("ddbj_mrna",               CSeq_id::eAcc_ddbj_mrna),
    TAccInfoMapEntry("ddbj_other_nuc",          CSeq_id::eAcc_ddbj_other_nuc),
    TAccInfoMapEntry("ddbj_patent",             CSeq_id::eAcc_ddbj_patent),
    TAccInfoMapEntry("ddbj_prot",               CSeq_id::eAcc_ddbj_prot),
    TAccInfoMapEntry("ddbj_tpa_chromosome",     CSeq_id::eAcc_ddbj_tpa_chromosome),
    TAccInfoMapEntry("ddbj_tpa_con",            CSeq_id::eAcc_ddbj_tpa_con),
    TAccInfoMapEntry("ddbj_tpa_nuc",            CSeq_id::eAcc_ddbj_tpa_nuc),
    TAccInfoMapEntry("ddbj_tpa_prot",           CSeq_id::eAcc_ddbj_tpa_prot),
    TAccInfoMapEntry("ddbj_tpa_wgs_nuc",        CSeq_id::eAcc_ddbj_tpa_wgs_nuc),
    TAccInfoMapEntry("ddbj_tpa_wgs_prot",       CSeq_id::eAcc_ddbj_tpa_wgs_prot),
    TAccInfoMapEntry("ddbj_tsa_nuc",            CSeq_id::eAcc_ddbj_tsa_nuc),
    TAccInfoMapEntry("ddbj_tsa_prot",           CSeq_id::eAcc_ddbj_tsa_prot),
    TAccInfoMapEntry("ddbj_wgs_nuc",            CSeq_id::eAcc_ddbj_wgs_nuc),
    TAccInfoMapEntry("ddbj_wgs_prot",           CSeq_id::eAcc_ddbj_wgs_prot),
    TAccInfoMapEntry("ddbj_wgsm_nuc",           CSeq_id::eAcc_ddbj_wgsm_nuc),
    TAccInfoMapEntry("ddbj_wgsm_prot",          CSeq_id::eAcc_ddbj_wgsm_prot),
    TAccInfoMapEntry("embl_con",                CSeq_id::eAcc_embl_con),
    TAccInfoMapEntry("embl_ddbj",               CSeq_id::eAcc_embl_ddbj),
    TAccInfoMapEntry("embl_dirsub",             CSeq_id::eAcc_embl_dirsub),
    TAccInfoMapEntry("embl_est",                CSeq_id::eAcc_embl_est),
    TAccInfoMapEntry("embl_genome",             CSeq_id::eAcc_embl_genome),
    TAccInfoMapEntry("embl_htgs",               CSeq_id::eAcc_embl_htgs),
    TAccInfoMapEntry("embl_mga",                CSeq_id::eAcc_embl_mga),
    TAccInfoMapEntry("embl_other_nuc",          CSeq_id::eAcc_embl_other_nuc),
    TAccInfoMapEntry("embl_patent",             CSeq_id::eAcc_embl_patent),
    TAccInfoMapEntry("embl_prot",               CSeq_id::eAcc_embl_prot),
    TAccInfoMapEntry("embl_tpa_nuc",            CSeq_id::eAcc_embl_tpa_nuc),
    TAccInfoMapEntry("embl_tpa_prot",           CSeq_id::eAcc_embl_tpa_prot),
    TAccInfoMapEntry("embl_tsa_nuc",            CSeq_id::eAcc_embl_tsa_nuc),
    TAccInfoMapEntry("embl_tsa_prot",           CSeq_id::eAcc_embl_tsa_prot),
    TAccInfoMapEntry("embl_wgs_nuc",            CSeq_id::eAcc_embl_wgs_nuc),
    TAccInfoMapEntry("embl_wgs_prot",           CSeq_id::eAcc_embl_wgs_prot),
    TAccInfoMapEntry("embl_wgsm_nuc",           CSeq_id::eAcc_embl_wgsm_nuc),
    TAccInfoMapEntry("embl_wgsm_prot",          CSeq_id::eAcc_embl_wgsm_prot),
    TAccInfoMapEntry("gb_backbone",             CSeq_id::eAcc_gb_backbone),
    TAccInfoMapEntry("gb_cdna",                 CSeq_id::eAcc_gb_cdna),
    TAccInfoMapEntry("gb_con",                  CSeq_id::eAcc_gb_con),
    TAccInfoMapEntry("gb_ddbj",                 CSeq_id::eAcc_gb_ddbj),
    TAccInfoMapEntry("gb_dirsub",               CSeq_id::eAcc_gb_dirsub),
    TAccInfoMapEntry("gb_embl",                 CSeq_id::eAcc_gb_embl),
    TAccInfoMapEntry("gb_embl_ddbj",            CSeq_id::eAcc_gb_embl_ddbj),
    TAccInfoMapEntry("gb_est",                  CSeq_id::eAcc_gb_est),
    TAccInfoMapEntry("gb_genome",               CSeq_id::eAcc_gb_genome),
    TAccInfoMapEntry("gb_gsdb",                 CSeq_id::eAcc_gb_gsdb),
    TAccInfoMapEntry("gb_gss",                  CSeq_id::eAcc_gb_gss),
    TAccInfoMapEntry("gb_htgs",                 CSeq_id::eAcc_gb_htgs),
    TAccInfoMapEntry("gb_mga",                  CSeq_id::eAcc_gb_mga),
    TAccInfoMapEntry("gb_other_nuc",            CSeq_id::eAcc_gb_other_nuc),
    TAccInfoMapEntry("gb_patent",               CSeq_id::eAcc_gb_patent),
    TAccInfoMapEntry("gb_patent_prot",          CSeq_id::eAcc_gb_patent_prot),
    TAccInfoMapEntry("gb_prot",                 CSeq_id::eAcc_gb_prot),
    TAccInfoMapEntry("gb_segset",               CSeq_id::eAcc_gb_segset),
    TAccInfoMapEntry("gb_sts",                  CSeq_id::eAcc_gb_sts),
    TAccInfoMapEntry("gb_tpa_chromosome",       CSeq_id::eAcc_gb_tpa_chromosome),
    TAccInfoMapEntry("gb_tpa_con",              CSeq_id::eAcc_gb_tpa_con),
    TAccInfoMapEntry("gb_tpa_nuc",              CSeq_id::eAcc_gb_tpa_nuc),
    TAccInfoMapEntry("gb_tpa_prot",             CSeq_id::eAcc_gb_tpa_prot),
    TAccInfoMapEntry("gb_tpa_wgs_nuc",          CSeq_id::eAcc_gb_tpa_wgs_nuc),
    TAccInfoMapEntry("gb_tpa_wgs_prot",         CSeq_id::eAcc_gb_tpa_wgs_prot),
    TAccInfoMapEntry("gb_tpa_wgsm_nuc",         CSeq_id::eAcc_gb_tpa_wgsm_nuc),
    TAccInfoMapEntry("gb_tpa_wgsm_prot",        CSeq_id::eAcc_gb_tpa_wgsm_prot),
    TAccInfoMapEntry("gb_tsa_nuc",              CSeq_id::eAcc_gb_tsa_nuc),
    TAccInfoMapEntry("gb_tsa_prot",             CSeq_id::eAcc_gb_tsa_prot),
    TAccInfoMapEntry("gb_wgs_nuc",              CSeq_id::eAcc_gb_wgs_nuc),
    TAccInfoMapEntry("gb_wgs_prot",             CSeq_id::eAcc_gb_wgs_prot),
    TAccInfoMapEntry("gb_wgsm_nuc",             CSeq_id::eAcc_gb_wgsm_nuc),
    TAccInfoMapEntry("gb_wgsm_prot",            CSeq_id::eAcc_gb_wgsm_prot),
    TAccInfoMapEntry("general",                 CSeq_id::eAcc_general),
    TAccInfoMapEntry("general_nuc",             CSeq_id::eAcc_general_nuc),
    TAccInfoMapEntry("general_prot",            CSeq_id::eAcc_general_prot),
    TAccInfoMapEntry("gi",                      CSeq_id::eAcc_gi),
    TAccInfoMapEntry("gibbmt",                  CSeq_id::eAcc_gibbmt),
    TAccInfoMapEntry("gibbsq",                  CSeq_id::eAcc_gibbsq),
    TAccInfoMapEntry("giim",                    CSeq_id::eAcc_giim),
    TAccInfoMapEntry("gpipe_chromosome",        CSeq_id::eAcc_gpipe_chromosome),
    TAccInfoMapEntry("gpipe_genomic",           CSeq_id::eAcc_gpipe_genomic),
    TAccInfoMapEntry("gpipe_mrna",              CSeq_id::eAcc_gpipe_mrna),
    TAccInfoMapEntry("gpipe_ncrna",             CSeq_id::eAcc_gpipe_ncrna),
    TAccInfoMapEntry("gpipe_other_nuc",         CSeq_id::eAcc_gpipe_other_nuc),
    TAccInfoMapEntry("gpipe_prot",              CSeq_id::eAcc_gpipe_prot),
    TAccInfoMapEntry("gpipe_scaffold",          CSeq_id::eAcc_gpipe_scaffold),
    TAccInfoMapEntry("gpipe_unreserved",        CSeq_id::eAcc_gpipe_unreserved),
    TAccInfoMapEntry("gsdb_dirsub",             CSeq_id::eAcc_gsdb_dirsub),
    TAccInfoMapEntry("local",                   CSeq_id::eAcc_local),
    TAccInfoMapEntry("maybe_ddbj",              CSeq_id::eAcc_maybe_ddbj),
    TAccInfoMapEntry("maybe_embl",              CSeq_id::eAcc_maybe_embl),
    TAccInfoMapEntry("maybe_gb",                CSeq_id::eAcc_maybe_gb),
    TAccInfoMapEntry("named_annot_track",       CSeq_id::eAcc_named_annot_track),
    TAccInfoMapEntry("patent",                  CSeq_id::eAcc_patent),
    TAccInfoMapEntry("pdb",                     CSeq_id::eAcc_pdb),
    TAccInfoMapEntry("pir",                     CSeq_id::eAcc_pir),
    TAccInfoMapEntry("prf",                     CSeq_id::eAcc_prf),
    TAccInfoMapEntry("refseq_chromosome",       CSeq_id::eAcc_refseq_chromosome),
    TAccInfoMapEntry("refseq_contig",           CSeq_id::eAcc_refseq_contig),
    TAccInfoMapEntry("refseq_genome",           CSeq_id::eAcc_refseq_genome),
    TAccInfoMapEntry("refseq_genomic",          CSeq_id::eAcc_refseq_genomic),
    TAccInfoMapEntry("refseq_mrna",             CSeq_id::eAcc_refseq_mrna),
    TAccInfoMapEntry("refseq_mrna_predicted",   CSeq_id::eAcc_refseq_mrna_predicted),
    TAccInfoMapEntry("refseq_ncrna",            CSeq_id::eAcc_refseq_ncrna),
    TAccInfoMapEntry("refseq_ncrna_predicted",  CSeq_id::eAcc_refseq_ncrna_predicted),
    TAccInfoMapEntry("refseq_prot",             CSeq_id::eAcc_refseq_prot),
    TAccInfoMapEntry("refseq_prot_predicted",   CSeq_id::eAcc_refseq_prot_predicted),
    TAccInfoMapEntry("refseq_unreserved",       CSeq_id::eAcc_refseq_unreserved),
    TAccInfoMapEntry("refseq_wgs_intermed",     CSeq_id::eAcc_refseq_wgs_intermed),
    TAccInfoMapEntry("refseq_wgs_nuc",          CSeq_id::eAcc_refseq_wgs_nuc),
    TAccInfoMapEntry("refseq_wgs_prot",         CSeq_id::eAcc_refseq_wgs_prot),
    TAccInfoMapEntry("refseq_wgsm_intermed",    CSeq_id::eAcc_refseq_wgsm_intermed),
    TAccInfoMapEntry("refseq_wgsm_nuc",         CSeq_id::eAcc_refseq_wgsm_nuc),
    TAccInfoMapEntry("refseq_wgsm_prot",        CSeq_id::eAcc_refseq_wgsm_prot),
    TAccInfoMapEntry("swissprot",               CSeq_id::eAcc_swissprot),
    TAccInfoMapEntry("unknown",                 CSeq_id::eAcc_unknown),
    TAccInfoMapEntry("unreserved_nuc",          CSeq_id::eAcc_unreserved_nuc),
    TAccInfoMapEntry("unreserved_prot",         CSeq_id::eAcc_unreserved_prot)
};
typedef CStaticArrayMap<const char*, CSeq_id::EAccessionInfo, PNocase_CStr> TAccInfoMap;
DEFINE_STATIC_ARRAY_MAP(TAccInfoMap, sc_AccInfoMap, sc_AccInfoArray);

static const char kDigits[] = "0123456789";

struct SAccGuide
{
    typedef CSeq_id::EAccessionInfo TAccInfo;
    typedef map<string, TAccInfo>   TPrefixes;
    typedef pair<string, TAccInfo>  TPair;
    typedef vector<TPair>           TPairs;
    typedef map<string, TPair>      TSpecialMap; // last -> first -> value
    typedef unsigned int            TFormatCode;

    struct SSubMap {
        TPrefixes    prefixes;
        TPairs       wildcards;
        TSpecialMap  specials;
    };
    typedef map<TFormatCode, SSubMap> TMainMap;

    SAccGuide(void) : count(0) { }
    void AddRule(const CTempString& rule);
    TAccInfo Find(TFormatCode fmt, const string& acc_or_pfx,
                  string* key_used = NULL);
    static TFormatCode s_Key(unsigned short letters, unsigned short digits)
        { return TFormatCode(letters) << 16 | digits; }

    unsigned int count;
    TMainMap     rules;
    TPrefixes    general;
};

void SAccGuide::AddRule(const CTempString& rule)
{
    string         tmp1, tmp2;
    vector<string> tokens;
    SIZE_TYPE      pos, pos2;

    ++count;
    rule.Copy(tmp1, 0, rule.find("#")); // strip comment
    NStr::Tokenize(tmp1, " \t", tokens, NStr::eMergeDelims);
    if (tokens.empty()) {
        return;
    } else if (tokens.size() == 2
               &&  NStr::EqualNocase(tokens[0], "version")) {
        unsigned int version = NStr::StringToUInt(tokens[1],
                                                  NStr::fConvErr_NoThrow);
        if (version != 1) {
            ERR_POST_X(2, "SAccGuide::AddRule: " << count
                          << ": Unsupported version " << tokens[1]);
            return;
        }
    } else if ((pos = tokens[0].find('+')) != NPOS
               &&  (tokens.size() == 3
                    ||  (tokens.size() == 4  &&  tokens[3] == "*"))) {
        // _VERIFY(NStr::SplitInTwo(tokens[0], "+", tmp1, tmp2));
        tmp1.assign(tokens[0], 0, pos);
        tmp2.assign(tokens[0], pos + 1, NPOS);
        TFormatCode fmt
            = s_Key(NStr::StringToUInt(tmp1, NStr::fConvErr_NoThrow),
                    NStr::StringToUInt(tmp2, NStr::fConvErr_NoThrow));
        TAccInfoMap::const_iterator it = sc_AccInfoMap.find(tokens[2].c_str());
        if (it == sc_AccInfoMap.end()) {
            string   key_used;
            TAccInfo old = Find(fmt, tokens[1], &key_used);
            if (old != CSeq_id::eAcc_unknown) {
                if ( !key_used.empty() ) {
                    key_used = " (per " + key_used + ')';
                }
                ERR_POST_X(8, Warning << "SAccGuide::AddRule: " << count
                           << ": ignoring refinement of " << tokens[1]
                           << " from 0x" << hex << old << key_used
                           << " to unrecognized accession type " << tokens[2]);
            } else {
                ERR_POST_X(3, "SAccGuide::AddRule: " << count
                           << ": unrecognized accession type " << tokens[2]
                           << " for " << tokens[1]);
            }
        } else {
            TAccInfo value = it->second;
            if (tokens.size() == 4) {
                value = TAccInfo(value | CSeq_id::fAcc_specials);
            }
            if (tokens[1].find_first_of("?*") == NPOS) {
                rules[fmt].prefixes[tokens[1]] = value;
            } else {
                // Account for possible refinements of fallback definitions
                NON_CONST_ITERATE (TPairs, wit, rules[fmt].wildcards) {
                    if (wit->first == tokens[1]) {
                        wit->second = value;
                        return;
                    }
                }
                rules[fmt].wildcards.push_back(TPair(tokens[1], value));
            }
        }
    } else if (tokens.size() == 3 && NStr::EqualNocase(tokens[0], "special")) {
        pos  = tokens[1].find_first_of(kDigits);
        pos2 = tokens[1].find('-', pos);
        TFormatCode fmt
            = s_Key(pos, ((pos2 == NPOS) ? tokens[1].size() : pos2) - pos);
        TAccInfoMap::const_iterator it = sc_AccInfoMap.find(tokens[2].c_str());
        if (it == sc_AccInfoMap.end()) {
            string   key_used;
            TAccInfo old = Find(fmt, tokens[1], &key_used);
            if (old) {
                if ( !key_used.empty() ) {
                    key_used = " (per " + key_used + ')';
                }
                ERR_POST_X(4, Warning << "SAccGuide::AddRule: " << count
                           << ": unrecognized accession type " << tokens[2]
                           << " for special case " << tokens[1]
                           << "; falling back to " << old << key_used);
            } else {
                ERR_POST_X(9, Warning << "SAccGuide::AddRule: " << count
                           << ": unrecognized accession type " << tokens[2]
                           << " for stray(!) special case " << tokens[1]);
            }
        } else {
            TAccInfo value = it->second;
            if (pos2 == NPOS) {
                rules[fmt].specials[tokens[1]] = TPair(tokens[1], value);
            } else {
                // _VERIFY(NStr::SplitInTwo(tokens[1], "-", tmp1, tmp2));
                tmp1.assign(tokens[1], 0, pos2);
                tmp2.assign(tokens[1], pos2 + 1, NPOS);
                rules[fmt].specials[tmp2] = TPair(tmp1, value);
            }
        }
    } else if (tokens.size() == 3 && NStr::EqualNocase(tokens[0], "gnl")) {
        NStr::ToUpper(tokens[1]);
        TAccInfoMap::const_iterator it = sc_AccInfoMap.find(tokens[2].c_str());
        if (it == sc_AccInfoMap.end()) {
            TPrefixes::const_iterator it2 = general.find(tokens[1]);
            if (it2 == general.end()) {
                ERR_POST_X(3, "SAccGuide::AddRule: " << count
                           << ": unrecognized accession type " << tokens[2]
                           << " for " << tokens[1]);
            } else {
                ERR_POST_X(8, Warning << "SAccGuide::AddRule: " << count
                           << ": ignoring refinement of " << tokens[1]
                           << " from 0x" << hex << it2->second
                           << " to unrecognized accession type " << tokens[2]);
            }
        } else {
            general[tokens[1]] = it->second;
        }
    } else {
        ERR_POST_X(5, Warning << "SAccGuide::AddRule: " << count
                      << ": ignoring invalid line: " << rule);
    }
}

SAccGuide::TAccInfo SAccGuide::Find(TFormatCode fmt, const string& acc_or_pfx,
                                    string* key_used)
{
    TMainMap::const_iterator it = rules.find(fmt);
    if (it == rules.end()) {
        return CSeq_id::eAcc_unknown;
    }

    const SSubMap&            submap = it->second;
    TAccInfo                  result = CSeq_id::eAcc_unknown;
    string                    pfx     (acc_or_pfx, 0, fmt >> 16);
    TPrefixes::const_iterator pit    = submap.prefixes.find(pfx);
    if (pit != submap.prefixes.end()) {
        result = pit->second;
    } else {
        ITERATE (TPairs, wit, submap.wildcards) {
            if (NStr::MatchesMask(pfx, wit->first)) {
                if (key_used  &&  acc_or_pfx != wit->first) {
                    *key_used = wit->first;
                }
                result = wit->second;
                break;
            }
        }
    }
    if (acc_or_pfx != pfx  &&  result & CSeq_id::fAcc_specials) {
        TSpecialMap::const_iterator sit
            = submap.specials.lower_bound(acc_or_pfx);
        if (sit != submap.specials.end()  &&  sit->second.first <= acc_or_pfx) {
            if (key_used) {
                key_used->erase();
            }
            return sit->second.second;
        } else {
            if (key_used  &&  key_used->empty()) {
                *key_used = pfx;
            }
            return TAccInfo(result & ~CSeq_id::fAcc_specials);
        }
    } else /* if (result != CSeq_id::eAcc_unknown) */ {
        return result;
    }
}


SAccGuide s_Guide;

static void s_LoadGuide(void)
{
    DEFINE_STATIC_FAST_MUTEX(mutex);
    CFastMutexGuard guard(mutex);
    if (s_Guide.count) {
        return;
    }
    {{
        string file = g_FindDataFile("accguide.txt");
        if ( !file.empty() ) {
            try {
                CSeq_id::LoadAccessionGuide(file);
            } STD_CATCH_ALL_X(1, "CSeq_id::LoadAccessionGuide")
        }
    }}
    if ( !s_Guide.count ) {
        ERR_POST_X(6, Info << "CSeq_id::IdentifyAccession: " // minor lie
                              "falling back on built-in rules.");
        SAccGuide guide;
        static const unsigned int kNumBuiltInRules
            = sizeof(kBuiltInGuide) / sizeof(*kBuiltInGuide);
        for (unsigned int i = 0;  i < kNumBuiltInRules;  ++i) {
            guide.AddRule(kBuiltInGuide[i]);
        }
        swap(guide, s_Guide);
    }

    if (s_Guide.general.empty()) {
        // Populate with a hard-coded list by default; there are only
        // a few tags to worry about, but listing them in accguide.txt
        // right away would yield warnings from old Toolkit versions.
        static const char* const kNucDBs[] = {
            "SRA", "TI", "TR_ASSM_CH", "TRACE_ASSM", "TRACE_CHGR", NULL
        };
        for (const char* const* p = kNucDBs;  *p;  ++p) {
            s_Guide.general[*p] = CSeq_id::eAcc_general_nuc;
        }
    }
}

CSeq_id::EAccessionInfo CSeq_id::IdentifyAccession(const string& acc)
{
    SIZE_TYPE main_size = acc.find('.');
    if (main_size == NPOS) {
        main_size = acc.size();
    } else if (main_size >= acc.size() - 1
               ||  acc.find_first_not_of(kDigits, main_size + 1) != NPOS) {
        return eAcc_unknown; // non-numeric "version"
    }
    SIZE_TYPE digit_pos = acc.find_first_of(kDigits);
    string main_acc = acc.substr(0, main_size);
    NStr::ToUpper(main_acc);
    if (digit_pos == NPOS) {
        return eAcc_unknown;
    } else {
        SIZE_TYPE non_dig_pos = acc.find_first_not_of(kDigits, digit_pos);
        const unsigned char* ucdata = (const unsigned char*)acc.data();
        if (non_dig_pos < main_size  &&  non_dig_pos != NPOS) {
            if (digit_pos == 0  &&  main_size >= 4  &&  main_size <= 7
                &&  main_size == acc.size()  &&  isalnum(ucdata[1])
                &&  isalnum(ucdata[2])  &&  isalnum(ucdata[3])) {
                // Possible PDB (always unversioned); examine further
                // to avoid false positives.
                switch (main_size) {
                case 7:
                    if ((main_acc[5] != main_acc[6]
                         &&  (main_acc[5] != 'V' || main_acc[6] != 'B'))
                        ||  !isalpha(ucdata[5])) {
                        break;
                    } // else fall through
                case 6:
                    // Be extra strict when the potential molecule ID
                    // could simply be a year.  (NB: *insisting* on a
                    // non-digit would rule out 1914|A, gi 157829621.)
                    if ((non_dig_pos < 4  &&  ispunct(ucdata[4]))
                        ||  strchr("|-_", main_acc[4])) {
                        return eAcc_pdb;
                    }
                    break;
                case 5: case 4:
                    return eAcc_pdb;
                }
            }
            if (digit_pos == 1  &&  main_size == 6
                &&  (main_acc[0] == 'O'  ||  main_acc[0] == 'P'
                     ||  main_acc[0] == 'Q' ||  isalpha(ucdata[2]))
                &&  isdigit(ucdata[1])  &&  isalnum(ucdata[2])
                &&  isalnum(ucdata[3])  &&  isalnum(ucdata[4])
                &&  isdigit(ucdata[5])) {
                return eAcc_swissprot;
            } else if (digit_pos == 0  &&  main_size == acc.size()
                       &&  (non_dig_pos == 6  ||  non_dig_pos == 7)
                       &&  (main_size == non_dig_pos + 1
                            ||  main_acc[non_dig_pos + 1] == ':'
                            ||  (isalpha(ucdata[non_dig_pos + 1])
                                 &&  (main_size == non_dig_pos + 2
                                      ||  main_acc[non_dig_pos + 2] == ':')))) {
                // A formal spec appears to be elusive, but all examples in ID
                // contain six or seven digits followed by one or two letters,
                // followed in some rare cases by a tag such as :PDB=...
                return eAcc_prf;
            } else {
                return eAcc_unknown;
            }
        }
    }

    if (digit_pos == 0) {
        if (acc.find_first_not_of(kDigits) == NPOS) { // just digits
            return eAcc_gi;
        } else {
            return eAcc_unknown; // PDB already handled
        }
    }

    if ( !s_Guide.count ) {
        s_LoadGuide();
    }

    EAccessionInfo ai = s_Guide.Find
        (SAccGuide::s_Key(digit_pos, main_size - digit_pos), main_acc);
    switch (ai & eAcc_division_mask) {
    case eAcc_wgs:
    case eAcc_wgs_intermed:
        if (main_acc.find_first_not_of("0", digit_pos + 2) == NPOS) {
            return EAccessionInfo(ai | fAcc_master);
        }
    default:
        break;
    }
    return ai;
}


CSeq_id::EAccessionInfo CSeq_id::IdentifyAccession(void) const
{
    EAccessionInfo type = (EAccessionInfo)Which();
    switch (type) {
    case e_Pir: case e_Swissprot: case e_Prf: // but *NOT* e_Pdb
        return (EAccessionInfo)(type | fAcc_prot); // always just protein

    case e_Genbank: case e_Embl:  case e_Ddbj:
    case e_Tpg:     case e_Tpe:   case e_Tpd:
    case e_Other:   case e_Gpipe: case e_Named_annot_track:
    {
        const CTextseq_id* tsid = GetTextseq_Id();
        if (tsid->IsSetAccession()) {
            EAccessionInfo ai = IdentifyAccession(tsid->GetAccession());
            if ((ai & eAcc_type_mask) == e_not_set) {
                // We *know* what the type should be....
                return (EAccessionInfo)((ai & eAcc_flag_mask) | type);
            } else if ((ai & eAcc_type_mask) == type) {
                return ai;
            } else { // misidentified or mislabeled; assume the former
                return type;
            }
        } else {
            return type;
        }
    }

    case e_General:
    {
        string db = GetGeneral().GetDb();
        NStr::ToUpper(db);
        SAccGuide::TPrefixes::const_iterator it = s_Guide.general.find(db);
        return it == s_Guide.general.end() ? eAcc_general : it->second;
    }

    default:
        return type;
    }
}


void CSeq_id::LoadAccessionGuide(const string& filename)
{
    CRef<ILineReader> lr(ILineReader::New(filename));
    LoadAccessionGuide(*lr);
}

void CSeq_id::LoadAccessionGuide(ILineReader& in)
{
    SAccGuide guide;
    do {
        guide.AddRule(*++in);
    } while ( !in.AtEOF() );
    swap(s_Guide, guide);
}


static inline
void x_GetLabel_Type(const CSeq_id& id, string* label,
                     CSeq_id::TLabelFlags flags)
{
    unsigned choice = id.Which();
    _ASSERT(choice < CSeq_id::e_MaxChoice);
    if (choice >= CSeq_id::e_MaxChoice) {
        return;
    }

    switch (choice) {
    case CSeq_id::e_General:
        // we may encode 'gnl' or the database name as requested
        if (flags & CSeq_id::fLabel_GeneralDbIsContent) {
            *label += id.GetGeneral().GetDb();
        } else {
            *label += "gnl";
        }
        break;

    case CSeq_id::e_Patent:
        *label += id.GetPatent().GetCit().GetId().IsNumber() ? "pat" : "pgp";
        break;

    default:
        *label += s_TextId[choice];
        break;
    }

    // no extra flag interpretation currently
}


static inline
void x_GetLabel_Content(const CSeq_id& id, string* label,
                        CSeq_id::TLabelFlags flags)
{
    const CTextseq_id* tsid = id.GetTextseq_Id();

    //text id
    if (tsid) {
        string str;
        if (tsid->IsSetAccession()) {
            str = tsid->GetAccession();
            NStr::ToUpper(str);
        } else if (tsid->IsSetName()) {
            str = tsid->GetName();
        }

        if ( !str.empty() ) {
            if ( (flags & CSeq_id::fLabel_Version)  &&  tsid->IsSetVersion()) {
                str += "." + NStr::IntToString(tsid->GetVersion());
            }
        }
        *label += str;

    } else { //non-text id
        switch (id.Which()) {
        case CSeq_id::e_not_set:
            break;

        case CSeq_id::e_Local:
            {{
                const CObject_id& oid = id.GetLocal();
                if (oid.IsId()) {
                    *label += NStr::IntToString(oid.GetId());
                } else if (oid.IsStr()) {
                    *label += oid.GetStr();
                }
            }}
            break;

        case CSeq_id::e_Gibbsq:
            *label += NStr::IntToString(id.GetGibbsq());
            break;

        case CSeq_id::e_Gibbmt:
            *label += NStr::IntToString(id.GetGibbmt());
            break;

        case CSeq_id::e_Giim:
            *label += NStr::IntToString(id.GetGiim().GetId());
            break;

        case CSeq_id::e_General:
            {{
                const CDbtag& dbt = id.GetGeneral();
                if ((flags & CSeq_id::fLabel_GeneralDbIsContent) == 0) {
                    *label += dbt.GetDb() + ':';
                }
                if (dbt.GetTag().IsId()) {
                    *label += NStr::IntToString(dbt.GetTag().GetId());
                } else if (dbt.GetTag().IsStr()) {
                    *label += dbt.GetTag().GetStr();
                }
            }}
            break;

        case CSeq_id::e_Patent:
            {{
                const CId_pat& idp = id.GetPatent().GetCit();
                *label += idp.GetCountry();
                // *label += '|';
                *label += (idp.GetId().IsNumber() ?
                           idp.GetId().GetNumber() :
                           idp.GetId().GetApp_number());
                *label += '_'; // |
                *label += NStr::IntToString(id.GetPatent().GetSeqid());
            }}
            break;

        case CSeq_id::e_Gi:
            *label += NStr::IntToString(id.GetGi());
            break;

        case CSeq_id::e_Pdb:
            {{
                const CPDB_seq_id& pid = id.GetPdb();
                *label += pid.GetMol().Get();
                unsigned char chain = static_cast<unsigned char>(pid.GetChain());
                if (chain > ' ') {
                    *label += '_';
                    if (islower(chain)) {
                        *label += string(SIZE_TYPE(2),
                                         static_cast<char>(toupper(chain)));
                    } else {
                        *label += static_cast<char>(chain);
                    }
                }
            }}
            break;

        default:
            break;
        }
    }
}


void CSeq_id::GetLabel(string* label, ELabelType type, TLabelFlags flags) const
{
    if ( !label ) {
        return;
    }

    switch (type) {
    case eFasta:
        *label = AsFastaString();
        break;

    case eBoth:
        x_GetLabel_Type(*this, label, flags);
        *label += "|";
        x_GetLabel_Content(*this, label, flags);
        break;

    case eType:
        x_GetLabel_Type(*this, label, flags);
        break;

    case eContent:
        x_GetLabel_Content(*this, label, flags);
        break;
    }
}



/*Return seqid string with optional version for text seqid type
(default no version).*/
string CSeq_id::GetSeqIdString(bool with_version) const
{
    string label;
    TLabelFlags flags = 0;
    if (with_version) {
        flags |= fLabel_Version;
    }
    GetLabel(&label, eContent, flags);
    return label;
}


void CSeq_id::WriteAsFasta(ostream& out)
    const
{
    unsigned the_type = Which();
    if (the_type >= e_MaxChoice)  // New SeqId type
        the_type = e_not_set;

    if (IsPatent()  &&  !GetPatent().GetCit().GetId().IsNumber() ) {
        out << "pgp|";
    } else if (IsSwissprot()  &&  GetSwissprot().IsSetRelease()
               &&  GetSwissprot().GetRelease() == "unreviewed") {
        out << "tr|";
    } else {
        out << s_TextId[the_type] << '|';
    }

    switch (the_type) {
    case e_not_set:
        break;
    case e_Local:
        GetLocal().AsString(out);
        break;
    case e_Gibbsq:
        out << GetGibbsq();
        break;
    case e_Gibbmt:
        out << GetGibbmt();
        break;
    case e_Giim:
        out << (GetGiim().GetId());
        break;
    case e_Genbank:
        GetGenbank().AsFastaString(out);
        break;
    case e_Embl:
        GetEmbl().AsFastaString(out);
        break;
    case e_Pir:
        GetPir().AsFastaString(out);
        break;
    case e_Swissprot:
        GetSwissprot().AsFastaString(out);
        break;
    case e_Patent:
        GetPatent().AsFastaString(out);
        break;
    case e_Other:
        GetOther().AsFastaString(out);
        break;
    case e_General:
        {
            const CDbtag& dbt = GetGeneral();
            out << (dbt.GetDb()) << '|';  // no Upcase per Ostell - Karl 7/2001
            dbt.GetTag().AsString(out);
        }
        break;
    case e_Gi:
        out << GetGi();
        break;
    case e_Ddbj:
        GetDdbj().AsFastaString(out);
        break;
    case e_Prf:
        GetPrf().AsFastaString(out);
        break;
    case e_Pdb:
        GetPdb().AsFastaString(out);
        break;
    case e_Tpg:
        GetTpg().AsFastaString(out);
        break;
    case e_Tpe:
        GetTpe().AsFastaString(out);
        break;
    case e_Tpd:
        GetTpd().AsFastaString(out);
        break;
    case e_Gpipe:
        // don't suppress version after all
        GetGpipe().AsFastaString(out /*, false */);
        break;
    case e_Named_annot_track:
        GetNamed_annot_track().AsFastaString(out);
        break;
    default:
        out << "[UnknownSeqIdType]";
        break;
    }
}


const string CSeq_id::AsFastaString(void) const
{
    CNcbiOstrstream str;
    WriteAsFasta(str);
    return CNcbiOstrstreamToString(str);
}


//
// GetStringDescr()
// Given a bioseq, return the best possible ID description, in a number of
// appealing formats.  This function can produce FastA-formatted titles or a
// number of sub-titles (GI only, Best Accession with or without version).
//
string CSeq_id::GetStringDescr(const CBioseq& bioseq, EStringFormat fmt)
{
    if (fmt == eFormat_FastA) {
        CNcbiOstrstream ostr;
        WriteAsFasta(ostr, bioseq);
        return CNcbiOstrstreamToString(ostr);
    }

    bool is_na            = bioseq.GetInst().GetMol() != CSeq_inst::eMol_aa;
    CRef<CSeq_id> best_id = FindBestChoice(bioseq.GetId(),
                                           is_na ? CSeq_id::FastaNARank
                                           : CSeq_id::FastaAARank);
    switch (fmt) {
    case eFormat_ForceGI:
        // eForceGI produces a string containing only the GI in FastA format
        // so we have:
        //    gi|####
        ITERATE (CBioseq::TId, iter, bioseq.GetId()) {
            if ( (*iter)->IsGi() ) {
                CNcbiOstrstream out_str;
                (*iter)->WriteAsFasta(out_str);

                return CNcbiOstrstreamToString(out_str);
            }
        }
        break;

    case eFormat_BestWithVersion:
        // eBestWithVersion produces only the 'best' accession name, with
        // its version indicator
        if (best_id.NotEmpty()) {
            string label;
            best_id->GetLabel(&label, eDefault, fLabel_Version);
            return label;
        }
        break;

    case eFormat_BestWithoutVersion:
        // eBestWithoutVersion produces only the 'best' accession name,
        // without its version indicator
        if (best_id.NotEmpty()) {
            string label;
            best_id->GetLabel(&label, eDefault, 0);
            return label;
        }
        break;

    default:
        break;
    }

    // catch-all for unusual events
    return "";
}

CNcbiOstream& CSeq_id::WriteAsFasta(CNcbiOstream& ostr, const CBioseq& bioseq)
{
    bool is_na            = bioseq.GetInst().GetMol() != CSeq_inst::eMol_aa;
    CRef<CSeq_id> best_id = FindBestChoice(bioseq.GetId(),
                                           is_na ? CSeq_id::FastaNARank
                                           : CSeq_id::FastaAARank);

    // FastA format
    // Here we have something like:
    //      gi|###|SOME_ACCESSION|title
    bool found_gi = false;

    ITERATE (CBioseq::TId, id, bioseq.GetId()) {
        if ((*id)->IsGi()) {
            (*id)->WriteAsFasta(ostr);
            found_gi = true;
            break;
        }
    }

    if (best_id.NotEmpty()  &&  !best_id->IsGi() ) {
        if (found_gi) {
            ostr << '|';
        }

        best_id->WriteAsFasta(ostr);
    }

    return ostr;
}


CSeq_id::CSeq_id(const CDbtag& dbtag, bool set_as_general)
{
    Set(dbtag, set_as_general);
}

CSeq_id& CSeq_id::Set(const CDbtag& dbtag, bool set_as_general)
{
    int version = -1;
    string acc, accver;

    switch (dbtag.GetTag().Which()) {
    case CObject_id::e_Str:
        accver = dbtag.GetTag().GetStr();
        s_SplitVersion(accver, acc, version);
        break;
    case CObject_id::e_Id:
        acc = accver = NStr::IntToString(dbtag.GetTag().GetId());
        break;
    default:
        NCBI_THROW(CSeqIdException, eFormat,
                   "Bad CDbtag tag type "
                   + CObject_id::SelectionName(dbtag.GetTag().Which()));
        break;
    }

    CDbtag::EDbtagType type = dbtag.GetType();
    if (type == CDbtag::eDbtagType_bad  &&  dbtag.GetDb() == "GenBank") {
        type = CDbtag::eDbtagType_GenBank;
    }
    switch (type) {
    case CDbtag::eDbtagType_GenBank:
        try {
            int gi = NStr::StringToInt(acc);
            SetGi(gi);
        }
        catch (...) {
            SetGenbank().Set(accver);
        }
        break;

    case CDbtag::eDbtagType_EMBL:
        SetEmbl().Set(accver);
        break;

    case CDbtag::eDbtagType_DDBJ:
        SetDdbj().Set(accver);
        break;

    case CDbtag::eDbtagType_GI:
        if (dbtag.GetTag().IsStr()) {
            Set(e_Gi, dbtag.GetTag().GetStr());
        } else {
            SetGi(dbtag.GetTag().GetId());
        }
        break;

    case CDbtag::eDbtagType_bad:
    default:
        // not understood as a sequence id
        if (set_as_general) {
            SetGeneral().Assign(dbtag);
        } else {
            NCBI_THROW(CSeqIdException, eFormat,
                       "Unrecognized Dbtag DB " + dbtag.GetDb());
        }
        break;
    }

    return *this;
}


//SeqIdFastAConstructors
CSeq_id::CSeq_id( const string& the_id )
{
    Set(the_id);
}

CSeq_id& CSeq_id::Set(const string& the_id_in)
{
    string the_id = NStr::TruncateSpaces(the_id_in, NStr::eTrunc_Both);
    if (the_id.empty()) {
        NCBI_THROW(CSeqIdException, eFormat, "Empty bare accession supplied");
    } else if (the_id.find('|') == NPOS
               ||  isdigit((unsigned char)the_id[0])) {
        // If no vertical bar, tries to interpret the string as a pure
        // accession, inferring the type from the initial letter(s).
        EAccessionInfo info = IdentifyAccession(the_id);
        E_Choice       type = GetAccType(info);
        switch (type) {
        case e_not_set:
            NCBI_THROW(CSeqIdException, eFormat, "Malformatted ID " + the_id);
        case e_Prf:
            // technically a name/locus, not an accession!
            return Set(type, kEmptyStr, the_id);
        case e_Pdb:
        {
            string mol(the_id, 0, 4), chain;
            // NStr::SplitInTwo(the_id, "|", mol, chain);
            if (the_id.size() > 5) {
                chain = the_id.substr(5);
            } else if (the_id.size() == 5  &&  the_id[4] != '|') {
                chain = the_id[4];
            }
            return Set(type, mol, chain);
        }
        default:
        {
            string acc;
            int    ver;
            s_SplitVersion(the_id, acc, ver);
            return Set(type, acc, kEmptyStr, ver);
        }
        }
    } else {
        list<CTempString> fasta_pieces;
        NStr::Split(the_id, "|", fasta_pieces, NStr::eNoMergeDelims);
        x_Init(fasta_pieces);
        if ( !fasta_pieces.empty() ) {
            // tolerate trailing parts if they're all empty.
            ITERATE(list<CTempString>, it, fasta_pieces) {
                if ( !it->empty() ) {
                    NCBI_THROW(CSeqIdException, eFormat,
                               "FASTA-style ID " + the_id
                               + " has too many parts.");
                }
            }
        }
        return *this;
    }
}


bool CSeq_id::IsValidLocalID(const CTempString& s)
{
    static const char* const kLegal =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.:*#";
    return (!s.empty()  &&  s.find_first_not_of(kLegal) == NPOS);
}

SIZE_TYPE CSeq_id::ParseFastaIds(CBioseq::TId& ids, const string& s,
                                 bool allow_partial_failure)
{
    TParseFlags flags = fParse_RawText | fParse_AnyLocal;
    if (allow_partial_failure) {
        flags |= fParse_PartialOK;
    }
    return ParseIDs(ids, s, flags);
}

SIZE_TYPE CSeq_id::ParseIDs(CBioseq::TId& ids, const CTempString& s,
                            TParseFlags flags)
{
    CTempString ss = NStr::TruncateSpaces(s, NStr::eTrunc_Both);
    if (ss.empty()) {
        return 0;
    }
    list<CTempString> fasta_pieces;
    NStr::Split(ss, "|", fasta_pieces, NStr::eNoMergeDelims);
    if ((fasta_pieces.size() < 2  ||  isdigit((unsigned char)ss[0]))) {
        CRef<CSeq_id> id(new CSeq_id);
        EParseFlags raw_flag = ((ss.find_first_not_of(kDigits) == NPOS)
                                ? fParse_RawGI : fParse_RawText);

        if (((flags & fParse_ValidLocal) != 0)
            &&  ((flags & fParse_AnyLocal) == fParse_AnyLocal
                 ||  IsValidLocalID(ss))) {
            if ((flags & raw_flag) != 0) {
                try {
                    id->Set(ss);
                } catch (CSeqIdException&) {
                    id->Set(e_Local, ss);
                }
            } else {
                id->Set(e_Local, ss);
            }
        } else if ((flags & raw_flag) != 0) {
            id->Set(ss);
        }
        if (id->Which() != e_not_set) {
            ids.push_back(id);
            return 1;
        }
        return 0;
    }
    SIZE_TYPE count = 0;
    while ( !fasta_pieces.empty() ) {
        try {
            CRef<CSeq_id> id(new CSeq_id);
            id->x_Init(fasta_pieces);
            ids.push_back(id);
            ++count;
        } catch (std::exception& e) {
            if ((flags & fParse_PartialOK) != 0) {
                ERR_POST_X(7, Warning << e.what());
            } else {
                throw;
            }
        }
    }
    return count;
}


void CSeq_id::x_Init(list<CTempString>& fasta_pieces)
{
    _ASSERT(!fasta_pieces.empty());
    string typestr = fasta_pieces.front();
    fasta_pieces.pop_front();
    NStr::TruncateSpacesInPlace(typestr, NStr::eTrunc_Both);
    E_Choice type = WhichInverseSeqId(typestr.c_str());
    if (type == e_not_set  ||  typestr.size() > 3) {
        NCBI_THROW(CSeqIdException, eFormat, "Unsupported ID type " + typestr);
    }

    CTempString fields[3];
    SIZE_TYPE   min_fields, max_fields;
    switch (type) {
    case e_Local:
    case e_Gibbsq:
    case e_Gibbmt:
    case e_Giim:
    case e_Gi:
        min_fields = max_fields = 1;
        break;
    case e_Patent:
        min_fields = max_fields = 3;
        break;
    case e_General:
        min_fields = max_fields = 2;
        break;
#if 0 // release no longer used
    case e_Other:
        min_fields = 1;
        max_fields = 3;
        break;
#endif
    default: // text seqid: accession and optional name
        min_fields = 1;
        max_fields = 2;
        break;
    }

    for (SIZE_TYPE i = 0;  i < max_fields;  ++i) {
        if (fasta_pieces.empty()) {
            if (i >= min_fields) {
                break;
            } else {
                NCBI_THROW(CSeqIdException, eFormat,
                           "Not enough fields for ID of type " + typestr);
            }
        } else {
            if (i >= min_fields  &&  fasta_pieces.size() > 1
                &&  (WhichInverseSeqId(string(fasta_pieces.front()).c_str())
                     != e_not_set)) {
                // Likely mid-string optional-field omission;
                // conservatively treat as such only if unable to
                // parse the following piece as an ID type, though.
                list<CTempString>::iterator it = fasta_pieces.begin();
                ++it;
                _ASSERT(it != fasta_pieces.end());
                if (WhichInverseSeqId(string(*it).c_str()) == e_not_set) {
                    break;
                }
            }
            fields[i] = fasta_pieces.front();
            fasta_pieces.pop_front();
        }
    }

    // Special case -- dbSNP IDs have historically contained internal
    // vertical bars, so we have to parse them greedily.
    string snp_name; // must survive until the end of the function
    if (type == e_General  &&  NStr::EqualNocase(fields[0], "dbSNP")
        &&  !fasta_pieces.empty() ) {
        snp_name = string(fields[1]) + '|' + NStr::Join(fasta_pieces, "|");
        fields[1] = snp_name;
        fasta_pieces.clear();
    }

    // Clear out extra empty pieces
    while ( !fasta_pieces.empty()  &&  fasta_pieces.front().empty() ) {
        fasta_pieces.pop_front();
    }

    int ver = 0;
    switch (type) {
    case e_Swissprot:
        if (NStr::EqualNocase(typestr, "tr")) {
            fields[2] = "unreviewed";
        } else {
            _ASSERT(NStr::EqualNocase(typestr, "sp"));
            fields[2] = "reviewed";
        }
        break;

    case e_Patent:
        // "version" actually sequence number within patent, but whatever...
        ver = NStr::StringToNumeric(fields[2]);
        if (ver <= 0) {
            NCBI_THROW(CSeqIdException, eFormat,
                       "Bad sequence number " + string(fields[2]) + " for "
                       + string(fields[0]) + " patent " + string(fields[1]));
        }
        // to distinguish applications from granted patents; the numeric
        // content has already made its way into ver.
        fields[2] = typestr;
        break;

    case e_Pdb:
        if (fields[0].size() > 4  &&  fields[1].empty()) { // misdelimited
            if (fields[0].size() > 5) {
                fields[1] = fields[0].substr(5);
            } else {
                _ASSERT(fields[0][4] != '|');
                fields[1] = fields[0].substr(4);
            }
            fields[0] = fields[0].substr(0, 4);
        }
        break;

    default:
        break; // avoid compiler warnings
    }

    Set(type, fields[0] /* acc */, fields[1] /* name */, ver,
        fields[2] /* rel */);
}


CSeq_id::CSeq_id(E_Choice the_type, int the_id)
{
    Set(the_type, the_id);
}

CSeq_id& CSeq_id::Set(E_Choice the_type, int the_id)
{
    if (the_id <= 0) {
        NCBI_THROW(CSeqIdException, eFormat,
                   "Non-positive numeric ID " + NStr::IntToString(the_id));
    }

    switch (the_type) {
    case e_Local:
        SetLocal().SetId(the_id);
        break;
    case e_Gibbsq:
        SetGibbsq(the_id);
        break;
    case e_Gibbmt:
        SetGibbmt(the_id);
        break;
    case e_Giim:
    {
        CGiimport_id& giim = SetGiim();
        giim.SetId(the_id);
        giim.ResetDb();
        giim.ResetRelease();
        break;
    }
    case e_Gi:
        SetGi(the_id);
        break;
    default:
        NCBI_THROW(CSeqIdException, eFormat,
                   "Invalid numeric ID type" + SelectionName(the_type));
    }
    return *this;
}


CSeq_id::CSeq_id(E_Choice      the_type,
                 const string& acc_in,
                 const string& name_in,
                 int           version,
                 const string& release_in)
{
    Set(the_type, acc_in, name_in, version, release_in);
}

// Karl Sirotkin 7/2001

CSeq_id& CSeq_id::Set(E_Choice      the_type,
                      const string& acc_in,
                      const string& name_in,
                      int           version,
                      const string& release_in)
{
    string acc     = NStr::TruncateSpaces(acc_in,     NStr::eTrunc_Both);
    string name    = NStr::TruncateSpaces(name_in,    NStr::eTrunc_Both);
    string release = NStr::TruncateSpaces(release_in, NStr::eTrunc_Both);

    int          the_id;
    CTextseq_id* tsid      = 0;
    bool         allow_dot = true;

    switch (the_type) {
    case e_not_set: // Will cause unspecified SeqId to be returned.
        break;

    case e_Local:
        {
            string::const_iterator it = acc.begin();

            if ( (the_id = NStr::StringToNumeric(acc)) >= 0 && *it != '0' ) {
                SetLocal().SetId(the_id);
            } else { // to cover case where embedded vertical bar in
                // string, could add code here, to concat a
                // '|' and name string, if not null/empty
                SetLocal().SetStr(acc);
            }
            break;
        }

        // numeric IDs
    case e_Gibbsq:
    case e_Gibbmt:
    case e_Giim:
    case e_Gi:
        if ( (the_id = NStr::StringToNumeric (acc)) >= 0 ) {
            return Set(the_type, the_id);
        } else {
            NCBI_THROW(CSeqIdException, eFormat,
                       "Negative, excessively large, or non-numeric "
                       + SelectionName(the_type)
                       + " ID " + acc);
        }
        break;

        // text IDs
    case e_Genbank:    tsid = &SetGenbank();    break;
    case e_Embl:       tsid = &SetEmbl();       break;
    case e_Pir:        tsid = &SetPir();        allow_dot = false;  break;
    case e_Swissprot:  tsid = &SetSwissprot();  break;
    case e_Other:      tsid = &SetOther();      break;
    case e_Ddbj:       tsid = &SetDdbj();       break;
    case e_Prf:        tsid = &SetPrf();        allow_dot = false;  break;
    case e_Tpg:        tsid = &SetTpg();        break;
    case e_Tpe:        tsid = &SetTpe();        break;
    case e_Tpd:        tsid = &SetTpd();        break;
    case e_Gpipe:      tsid = &SetGpipe();      break;
    case e_Named_annot_track:  tsid = &SetNamed_annot_track();  break;

    case e_Patent:
        {
            CPatent_seq_id&  pat    = SetPatent();
            CId_pat&         id_pat = pat.SetCit();
            CId_pat::C_Id&   id_pat_id = id_pat.SetId();
            id_pat.SetCountry(acc);

            if (NStr::EqualNocase(release, "pgp")) {
                id_pat_id.SetApp_number(name);
            } else {
                id_pat_id.SetNumber(name);
            }
            id_pat.ResetDoc_type();
            pat.SetSeqid(version);
            break;
        }

    case e_General:
        {
            CDbtag& dbt = SetGeneral();
            dbt.SetDb(acc);
            CObject_id& oid = dbt.SetTag();
            the_id = NStr::StringToNumeric(name);
            if (the_id >= 0  &&  (name.size() == 1 || name[0] != '0')) {
                oid.SetId(the_id);
            } else {
                oid.SetStr(name);
            }
            break;
        }

    case e_Pdb:
        {
            CPDB_seq_id& pdb = SetPdb();
            pdb.SetMol().Set(acc);

            // Consult name_in in addition to name as whitespace
            // stripping can lose relevant information here.
            if (name_in.empty()) {
                pdb.ResetChain();
            } else if (name.empty()) {
                pdb.SetChain(' ');
            } else if (name.size() == 1) { // force upper case?
                pdb.SetChain(static_cast<unsigned char>(name[0]));
            } else if (NStr::EqualNocase(name, "VB")) {
                pdb.SetChain('|');
            } else if (name.size() == 2  &&  name[0] == name[1]) {
                pdb.SetChain(tolower(static_cast<unsigned char>(name[0])));
            } else {
                NCBI_THROW(CSeqIdException, eFormat,
                           "Unexpected PDB chain id " + name + " for " + acc);
            }
            pdb.ResetRel();
            break;
        }

    default:
        NCBI_THROW(CSeqIdException, eFormat,
                   "Unsupported Seq-id type " + SelectionName(the_type));
    }

    if (tsid) {
        tsid->Set(acc, name, version, release, allow_dot);
    }

    return *this;
}


SSeqIdRange::SSeqIdRange(const CTempString& s, TFlags flags)
    : start(0), stop(0), digits(0), acc_info(CSeq_id::eAcc_unknown)
{
    size_t pos = 0, n = s.size();
    while (pos < n
           &&  (isalpha((unsigned char) s[pos])
                ||  (((flags & fAllowUnderscores) != 0)  &&  s[pos] == '_'))) {
        prefix += s[pos++];
    }
    while (pos < n  &&  isdigit((unsigned char) s[pos])) {
        start = start * 10 + s[pos++] - '0';
        ++digits;
    }
    if (pos == n) {
        stop = start;
        return;
    } else if (s[pos++] != '-') {
        NCBI_THROW(CSeqIdException, eFormat,
                   "Expected hyphen in range " + string(s));
    }

    {{
        string pfx2;
        while (pos < n
               && (isalpha((unsigned char) s[pos])
                   || (((flags & fAllowUnderscores) != 0) && s[pos] == '_'))) {
            pfx2 += s[pos++];
        }
        if ( !pfx2.empty()  &&  pfx2 != prefix) {
            NCBI_THROW(CSeqIdException, eFormat,
                       "Mismatched prefixes in range " + string(s));
        }
    }}
    if (pos + digits != n) {
        NCBI_THROW(CSeqIdException, eFormat,
                   "Mismatched digit counts in range " + string(s));
    }
    while (pos < n  &&  isdigit((unsigned char) s[pos])) {
        stop = stop * 10 + s[pos++] - '0';
    }    
}


CRef<CSeq_id> SSeqIdRange::const_iterator::GetID(void) const
{
    CRef<CSeq_id> ret;

    if (m_Range->acc_info == CSeq_id::eAcc_unknown) {
        m_Range->acc_info = CSeq_id::IdentifyAccession(**this);
        if (m_Range->size() > 1  &&  m_Range->digits == 5) {
            // account for possible non-uniformity
            switch (m_Range->prefix[0]) {
            case 'C': case 'D': case 'c': case 'd':
                if (m_Range->prefix.size() == 3) {
                    m_Range->acc_info = CSeq_id::eAcc_unreserved_prot;
                }
            case 'N': case 'n':
                if (m_Range->prefix.size() == 1) {
                    m_Range->acc_info = CSeq_id::eAcc_unreserved_nuc;
                }
            }
        }
    }

    CSeq_id::E_Choice type = CSeq_id::GetAccType(m_Range->acc_info);
    if (type == CSeq_id::e_not_set) {
        ret = new CSeq_id(**this);
    } else {
        ret = new CSeq_id(type, **this);
    }

    return ret;
}


const string& SSeqIdRange::const_iterator::x_SetAccession(void) const
{
    CNcbiOstrstream oss;
    oss << m_Range->prefix << setw(m_Range->digits) << setfill('0') << m_Number;
    m_Accession = CNcbiOstrstreamToString(oss);
    return m_Accession;
}


END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE

#undef NCBI_USE_ERRCODE_X
