/* $Id: remap_client.cpp 124555 2008-04-15 15:59:05Z jcherry $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'remap.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/remap/remap_client.hpp>

// additional includes
#include <objects/remap/Remap_query.hpp>
#include <objects/remap/Remap_result.hpp>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

const string CRemapClient::kDefaultUrl =
    "http://intrawebdev.be-md.ncbi.nlm.nih.gov:6224/"
    "staff/jcherry/remap/remap_server.cgi";


// destructor
CRemapClient::~CRemapClient(void)
{
}


// For development, use an experimental server that is not
// set up as a named service.
void CRemapClient::x_Connect()
{
    x_ConnectURL(m_Url);
}


// Some convenience functions so callers don't need to build queries

/// Remap a single Seq-loc
CRef<CSeq_loc> CRemapClient::Remap(const CSeq_loc& loc,
                                   const string& from_build,
                                   const string& to_build)
{
    vector<CRef<CSeq_loc> > locs;
    CRef<CSeq_loc> cref_loc(new CSeq_loc);
    cref_loc->Assign(loc);
    locs.push_back(cref_loc);
    vector<CRef<CSeq_loc> > result;
    Remap(locs, from_build, to_build, result);
    if (result.size() != 1) {
        throw runtime_error("Remap produced "
                            + NStr::IntToString(result.size())
                            + " result locations for a single query");
    }
    return result[0];
}


/// Remap multiple Seq-locs
void CRemapClient::Remap(const vector<CRef<CSeq_loc> >& locs,
                         const string& from_build, const string& to_build,
                         vector<CRef<CSeq_loc> >& result)
{
    CRemap_query query;
    query.SetFrom_build(from_build);
    query.SetTo_build(to_build);
    ITERATE (vector<CRef<CSeq_loc> >, loc, locs) {
        query.SetLocs().push_back(*loc);
    }
    CRef<CRemap_result> remap_result = AskRemap(query);
    result.clear();
    result.reserve(locs.size());
    ITERATE (CRemap_result::Tdata, loc, remap_result->Get()) {
        result.push_back(*loc);
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1871, CRC32: d108ad95 */
