## <img src="logos/nats-server.png" width="300">

[NATS](https://nats.io) is a simple, secure and performant communications system for digital systems, services and devices. NATS is part of the Cloud Native Computing Foundation ([CNCF](https://cncf.io)). NATS has over [40 client language implementations](https://nats.io/download/), and its server can run on-premise, in the cloud, at the edge, and even on a Raspberry Pi. NATS can secure and simplify design and operation of modern distributed systems.

[![License][License-Image]][License-Url] [![Build][Build-Status-Image]][Build-Status-Url] [![Release][Release-Image]][Release-Url] [![Slack][Slack-Image]][Slack-Url] [![Coverage][Coverage-Image]][Coverage-Url] [![Docker Downloads][Docker-Image]][Docker-Url] [![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/1895/badge)](https://bestpractices.coreinfrastructure.org/projects/1895)

## Documentation

* [Official documentation](https://docs.nats.io)
* [FAQ](https://docs.nats.io/reference/faq)
* Watch [a video overview of NATS](https://www.youtube.com/watch?v=sm63oAVPqAM) to learn more about its origin story and design philosophy.

## Contact

* [Twitter](https://twitter.com/nats_io): Follow us on Twitter!
* [Google Groups](https://groups.google.com/forum/#!forum/natsio): Where you can ask questions
* [Slack](https://natsio.slack.com): Click [here](https://slack.nats.io) to join. You can ask question to our maintainers and to the rich and active community.

## Contributing

If you are interested in contributing to NATS, read about our...

* [Contributing guide](https://nats.io/community/#contribute)
* [Report issues or propose Pull Requests](https://github.com/nats-io)

[License-Url]: https://www.apache.org/licenses/LICENSE-2.0
[License-Image]: https://img.shields.io/badge/License-Apache2-blue.svg
[Docker-Image]: https://img.shields.io/docker/pulls/_/nats.svg
[Docker-Url]: https://hub.docker.com/_/nats
[Slack-Image]: https://img.shields.io/badge/chat-on%20slack-green
[Slack-Url]: https://join.slack.com/t/natsio/shared_invite/zt-41e6tnmb-qCt63606MKR1YxIHZf4ICA
[Fossa-Url]: https://app.fossa.io/projects/git%2Bgithub.com%2Fnats-io%2Fnats-server?ref=badge_shield
[Fossa-Image]: https://app.fossa.io/api/projects/git%2Bgithub.com%2Fnats-io%2Fnats-server.svg?type=shield
[Build-Status-Url]: https://travis-ci.com/github/nats-io/nats-server
[Build-Status-Image]: https://travis-ci.com/nats-io/nats-server.svg?branch=main
[Release-Url]: https://github.com/nats-io/nats-server/releases/tag/v2.8.0
[Release-image]: https://img.shields.io/badge/release-v2.8.0-1eb0fc.svg
[Coverage-Url]: https://coveralls.io/r/nats-io/nats-server?branch=main
[Coverage-image]: https://coveralls.io/repos/github/nats-io/nats-server/badge.svg?branch=main
[ReportCard-Url]: https://goreportcard.com/report/nats-io/nats-server
[ReportCard-Image]: https://goreportcard.com/badge/github.com/nats-io/nats-server
[github-release]: https://github.com/nats-io/nats-server/releases/

## Roadmap

The NATS product roadmap can be found [here](https://nats.io/about/#roadmap).

## Security

### Security Audit

A third party security audit was performed by Cure53, you can see the full report [here](https://github.com/nats-io/nats-general/blob/master/reports/Cure53_NATS_Audit.pdf).

### Reporting Security Vulnerabilities

If you've found a vulnerability or a potential vulnerability in the NATS server, please let us know at
[nats-security](mailto:security@nats.io).

## License

Unless otherwise noted, the NATS source files are distributed
under the Apache Version 2.0 license found in the LICENSE file.
