# FindArts.cmake
# This module finds aRts (the sound system for KDE 3) on your system.
#
# This module defines the following variables:
# ARTS_FOUND               - TRUE when aRts is found, FALSE otherwise.
# ARTS_INCLUDE_DIRS        - path to aRts header files
# KDE3_ARTSC_LIBRARY       - path to aRts library
#
# Author: Park "segfault" Joon-Kyu <mastermind@planetmono.org>

find_package(KDE3 REQUIRED)

set(_ARTS_LIBRARY_SEARCH_PATH
	${KDE3_LIB_DIR}
	/usr/lib
	/usr/local/lib
)

find_library(KDE3_ARTSC_LIBRARY NAMES artsc PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_ARTSCBACKEND_LIBRARY NAMES artscbackend PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_ARTSDSP_LIBRARY NAMES artsdsp PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_ARTSFLOW_LIBRARY NAMES artsflow PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_ARTSKDE_LIBRARY NAMES artskde PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_GMCOP_LIBRARY NAMES gmcop PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_KMEDIA2_LIBRARY NAMES kmedia2 PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_MCOP_LIBRARY NAMES mcop PATHS ${_ARTS_LIBRARY_SEARCH_PATH})
find_library(KDE3_QTMCOP_LIBRARY NAMES qtmcop PATHS ${_ARTS_LIBRARY_SEARCH_PATH})

find_path(ARTSC_INCLUDE_DIR artsc.h
	${KDE3_INCLUDE_DIRS}
	${KDE3_INCLUDE_DIRS}/artsc
	/usr/include
	/usr/include/artsc
	/usr/local/include
	/usr/local/include/artsc
)

find_path(ARTS_INCLUDE_DIR soundserver.h
	${KDE3_INCLUDE_DIRS}
	${KDE3_INCLUDE_DIRS}/arts
	/usr/include
	/usr/include/arts
	/usr/local/include
	/usr/local/include/arts
)

if(ARTSC_INCLUDE_DIR AND ARTS_INCLUDE_DIR)
	set(ARTS_INCLUDE_DIRS ${ARTSC_INCLUDE_DIR} ${ARTS_INCLUDE_DIR})
endif(ARTSC_INCLUDE_DIR AND ARTS_INCLUDE_DIR)

if(ARTS_INCLUDE_DIRS AND KDE3_ARTSC_LIBRARY)
	set(ARTS_FOUND TRUE)
	message(STATUS "Found aRts: ${KDE3_ARTSC_LIBRARY}")
else(ARTS_INCLUDE_DIRS AND KDE3_ARTSC_LIBRARY)
	set(ARTS_FOUND FALSE)
endif(ARTS_INCLUDE_DIRS AND KDE3_ARTSC_LIBRARY)

