/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2013 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _POSIX_C_SOURCE	200809L

#include "internal.h"

#include <langinfo.h>

_NACORE_DEF nacore_locale
nacore_locale_new(int category_mask, const char *locale, nacore_locale base)
{
	return newlocale(category_mask, locale, base);
}

_NACORE_DEF void
nacore_locale_free(nacore_locale locale)
{
	freelocale(locale);
}

_NACORE_DEF nacore_locale
nacore_locale_use(nacore_locale locale)
{
	return uselocale(locale);
}

_NACORE_DEF nacore_locale
nacore_locale_dup(nacore_locale locale)
{
	return duplocale(locale);
}

NACORE_PRIVATE size_t
_nacore_locale_dec_sep_len()
{
	locale_t cur;
	char *ret;

	cur = uselocale((locale_t)0);
	if (cur == LC_GLOBAL_LOCALE)
		ret = nl_langinfo(RADIXCHAR);
	else
		ret = nl_langinfo_l(RADIXCHAR, cur);

	return (*ret == '\0') ? 1 : strlen(ret);
}

NACORE_PRIVATE void
_nacore_locale_dec_sep_get(char *buf)
{
	locale_t cur;
	char *sep;

	cur = uselocale((locale_t)0);
	if (cur == LC_GLOBAL_LOCALE)
		sep = nl_langinfo(RADIXCHAR);
	else
		sep = nl_langinfo_l(RADIXCHAR, cur);

	if (*sep == '\0')
		sep = ".";

	strcpy(buf, sep);
}
