/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2009 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NACORE_LV2API_H
#define _NACORE_LV2API_H

#include <lv2.h>

#include <NASPRO/core/bridge.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Convenience function to fill a LV2 plugin descriptor with data found in a
 * NASPRO core plugin descriptor (URI and function pointers).
 *
 * lv2_desc is a pointer to the LV2 plugin descriptor to be filled
 * n_desc is a pointer to the NASPRO core plugin descriptor
 */
void nacore_lv2api_fill_desc(LV2_Descriptor *lv2_desc,
			     struct nacore_descriptor *n_desc);

#ifdef __cplusplus
}
#endif

#endif /* !_NACORE_LV2API_H */
