<?php
/**
 * $Horde: nag/view.php,v 1.14.2.4 2002/12/19 13:02:53 jan Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* If we aren't provided with a task, redirect to the task list. */
$task_id = Horde::getFormData('task');
if (!isset($task_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Nag storage instance. */
$storage = &Nag_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Get the current task list. */
$tasks = Nag::listTasks($storage);

/* Set the page title to the current task's name, if it exists. */
$title = (!empty($tasks[$task_id])) ? $tasks[$task_id]['name'] : _("Task Details");

$js_onLoad = null;
require NAG_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    include_once $registry->getParam('templates') . '/javascript/print.js';
} else {
    $print_link = Nag::addParameter('view.php', 'task=' . $task_id);
    $print_link = Nag::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        include_once $registry->getParam('templates') . '/javascript/open_print_win.js';
    }

    require NAG_BASE . '/menu.php';
    $notification->notify();
}

/* If the requested task doesn't exist, display an error message. */
if (!isset($tasks[$task_id])) {
    include NAG_TEMPLATES . '/view/no-task.inc';
} else {
    include NAG_TEMPLATES . '/view/headers.inc';
    include NAG_TEMPLATES . '/view/description.inc';
    if (!$print_view) {
        include NAG_TEMPLATES . '/view/navbar.inc';
    }
}

require NAG_TEMPLATES . '/common-footer.inc';
