# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's lisence.
#
#
# This bot is created by
#   akira yamada <akira at arika.org>
#
# $Id$
#

=begin

== Abstract

Auto away if no action

== Configuration

BotConfig = [
{
  :name      => :AutoAwayBot,
  :threshold => 15*60,        # sec
  :message   => 'Away',
}
]

=end

class AutoAwayBot < Nadoka::NDK_Bot
  def bot_initialize
    @threshold = @bot_config.fetch(:threshold, 15*60).to_i
    @message   = @bot_config.fetch(:message, 'Away')
    @lastseen  = Time.now
    @in_away   = false
  end

  def on_client_privmsg client, ch, msg
    if @threshold > 0
      @lastseen = Time.now
    end
    if @in_away
      @manager.send_to_server Nadoka::Cmd.away()
    end
  end

  def on_timer time
    if @threshold > 0 && Time.now - @lastseen > @threshold && !@in_away
      @manager.send_to_server Nadoka::Cmd.away(@message)
    end
  end

  def on_rpl_unaway *arg
    @in_away = false
  end

  def on_rpl_nowaway *arg
    @in_away = true
  end
end


