/*
**  RegEx.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _RegEx_H_
#define _RegEx_H_

#include <Foundation/Foundation.h>
#include <regex.h>

@interface RangeObject: NSObject
{
  @private
  unsigned int _location;
  unsigned int _length;
}

- (unsigned int) location;
- (void) setLocation: (unsigned int) location;
- (unsigned int) length;
- (void) setLength: (unsigned int) length;
- (NSRange) range;
- (void) setRange: (NSRange) range;
@end

@interface RegExPattern : NSObject
{
  @private
  regex_t *preg;
  /* Mask could be regex options. For example: REG_ICASE, REG_NEWLINE*/
  unsigned int _mask;
}

+ (RegExPattern *) regexPattern: (NSString *) pattern;

- (id) initWithPattern: (NSString *) pattern options: (unsigned int) mask;
- (regex_t *) pattern;

@end

@interface RegExParser: NSObject
{
  @private
  RegExPattern *_pattern;
  NSString *_string;
  NSRange _range; // The working range, changing all the time
  NSRange _originalRange; // Backup original range
  NSRange _lastMatch; // The last matched range
}

/* The return range is related to the whole string.
 * Not related to the given range.
 * Remember to use NSAutoreleasePool when call it in loop.
 */
+ (NSRange) rangeOfString:(NSString *) pattern
                 inString: (NSString *) string;

+ (NSRange) rangeOfPattern: (RegExPattern *) pattern
                  inString: (NSString *) string;

+ (NSRange) rangeOfString: (NSString *) pattern
                 inString: (NSString *) string
                    range: (NSRange) range;

+ (NSRange) rangeOfPattern: (RegExPattern *) pattern
                  inString: (NSString *) string
                     range: (NSRange) range;

- (id) initWithPattern: (NSString *) string options: (unsigned int)mask;
- (id) initWithPattern: (RegExPattern *) pattern;
- (RegExPattern *) pattern;
- (void) setString: (NSString *) string;
- (void) setString: (NSString *) string range: (NSRange) aRange;
- (NSString *) string;
- (NSRange) range;
/* Reset to setString:range: */
- (void) reset;

@end

#endif /* _RegEx_H_ */
