// Modified by Yen-Ju Chen <yjchenx at hotmail dot com>
/*
    This file is part of HelpViewer (http://www.roard.com/helpviewer)
    Copyright (C) 2003 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __NOTE_CELL_H__
#define __NOTE_CELL_H__

#include <AppKit/AppKit.h>

@interface NoteCell : NSTextAttachmentCell
{
    NSImage* _image;
    NSMutableAttributedString* _note;
    NSSize _size, sizeOfNote;
    NSColor* _color;
    float imageWidth, imageHeight;
    float border;
}

- (NSSize) cellSize;
- (void) setImage: (NSImage*) img;
- (void) setColor: (NSColor*) color;
- (void) setText: (NSAttributedString*) text;
- (void) drawWithFrame: (NSRect) cellFrame
                inView: (NSView*) controlView;
@end

#endif
