#!/usr/bin/perl -w
use DBI;
use DBD::mysql;
use MythTV;
use XML::RSS;
use CGI qw(:standard);
use HTTP::Date;
use strict;

# create an RSS 2.0 file
my $rss = new XML::RSS (version => '2.0');

# Set default values
my $exportdir = '/home/mythtv/';

my $connect = undef;
my $debug = 0;

my $myth = new MythTV();
# connect to database
$connect = $myth->{'dbh'};
my $ip = $ENV{'HTTP_HOST'};

my $podcast_name = param("podcastName");
my $title = "MythCast";
my ($query, $query_handle);
if ($podcast_name ne ""){
    $title .= " [$podcast_name]";
	$query = "select file, title, subtitle, description, pubDate, airDate from mythexport where podcastName like ? order by pubDate desc";
	$query_handle = $connect->prepare($query);
	$query_handle->execute($podcast_name) || die "Unable to get exported recordings from database.";
}
else{
	$query = "select file, title, subtitle, description, pubDate, airDate from mythexport order by pubDate desc";
	$query_handle = $connect->prepare($query);
	$query_handle->execute() || die "Unable to get exported recordings from database.";
}

$rss->channel(title          => "$title",
               link           => "http://$ip/mythexport/video/",
               language       => 'en',
               description    => 'Exported MythTV Recordings',
               rating         => '(PICS-1.1 "http://www.classify.org/safesurf/" 1 r (SS~~000 1))',
               #copyright      => 'Copyright 1999, Freshmeat.net',
               pubDate        => 'Thu, 23 Aug 1999 07:00:00 GMT',
               lastBuildDate  => 'Thu, 23 Aug 1999 16:20:26 GMT',
               #docs           => 'http://www.blahblah.org/fm.cdf',
               #managingEditor => 'scoop@freshmeat.net',
               #webMaster      => 'scoop@freshmeat.net'
               );

# Get all exports
#$query_handle->execute($podcast_name) || die "Unable to get exported recordings from database.";

while (my @data = $query_handle->fetchrow_array()) {
	#print "LOOP!";
	my $rss_file=$data[0];
	my $rss_title=$data[1];
	my $rss_subtitle=$data[2];
	my $rss_desc=$data[3];
	my $rss_pubDate = $data[4];
    my $rss_airDate = $data[5];
	my $title = "$rss_title - $rss_subtitle";
	if ($rss_subtitle eq ""){
        my $temp_date = $rss_airDate;
        $temp_date =~ s/\-/\//g;
        $temp_date =~ s/\s00\:00\:00//;
        $title .= $temp_date;
    }
    my $temp_pubDate = str2time($rss_pubDate);
    $temp_pubDate = time2str($temp_pubDate);
	$rss->add_item(title => "$title",
        # creates a guid field with permaLink=true
        # alternately creates a guid field with permaLink=false
        # guid     => "gtkeyboard-0.85"
        enclosure   => { url=>"http://$ip/mythexport/video/$rss_file", type=>"video/mpeg" },
        description => "$rss_desc",
		pubDate 	=> "$temp_pubDate"
		);
}

print "Content-Type: text/plain\n\n", $rss->as_string;
exit(0);
