## -*- coding: utf-8 -*-
#
# «mythbuntu_log_grabber» - Utility to grab diagnostic logs and data for user support
#
# Copyright (C) 2009, Nick Fox, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import gtk
import os
import subprocess
import urllib
import socket
import threading

class LogGrabberPostThread(threading.Thread):
    def __init__(self, data_input):
        self.data_input = data_input
        threading.Thread.__init__(self)
    def run(self):
        return post_data(self.data_input)

def post_data(data_in):
    """ Post data to Mythbutnu Pastebin """
    try:
        params={}
        params['code2'] = data_in
        params['paste'] = "Send" 
        params['remember'] = "0" #Do you want a cookie ?
        params = urllib.urlencode(params)
        page = urllib.urlopen("http://mythbuntu.pastebin.com/", params)
        paste_url = page.url
    except:
        paste_url = "Timeout/Error occured while uploading data. Local Data: /tmp/mythbuntu.diag"
    return paste_url

class LogGrabberPlugin(MCCPlugin):
    """An Example Plugin for showing how to use MCC as a developer"""
    #
    #Load GUI & Calculate Changes
    #

    def __init__(self):
        import os
        #Initialize parent class
        information = {}
        information["name"] = "Log Grabber"
        information["icon"] = "gtk-find"
        information["ui"] = "tab_log_grabber"
        """Remove Any Old Logs"""
        if os.path.exists('/tmp/mythbuntu.diag'):
            os.remove('/tmp/mythbuntu.diag')
        socket.setdefaulttimeout(45)
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        self.changes = {}
        self.changes['syslog'] = os.path.exists('/var/log/syslog')
        self.changes['backend'] = os.path.exists('/var/log/mythtv/mythbackend.log')
        self.changes['frontend'] = os.path.exists('/var/log/mythtv/mythfrontend.log')
        self.changes['xorg'] = os.path.exists('/var/log/Xorg.0.log')
        self.changes['xsession'] = os.path.exists(os.environ['HOME'] + '/.xsession-errors')
        self.changes['disk'] = True
        self.changes['version'] = True
        self.changes['hardware'] = True
    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        if not self.changes['syslog']:
            self.sys_log_check.set_sensitive(False)
        if not self.changes['backend']:
            self.backend_check.set_sensitive(False)
        if not self.changes['frontend']:
            self.frontend_check.set_sensitive(False)
        if not self.changes['xorg']:
            self.xorg_check.set_sensitive(False)
        if not self.changes['xsession']:
            self.xsession_check.set_sensitive(False)
        # MCC Will Try to upload logs if This is enabled by default
        self.enable_all_checkbox.set_active(False)
        
    def compareState(self):
        """Determines what items have been modified on this plugin"""
        MCCPlugin.clearParentState(self)
        if self.sys_log_check.get_active():
            self._markReconfigureUser('syslog', self.sys_log_check.get_active())
        if self.backend_check.get_active():
            self._markReconfigureUser('backend', self.backend_check.get_active())
        if self.frontend_check.get_active():
            self._markReconfigureUser('frontend', self.frontend_check.get_active())
        if self.xorg_check.get_active():
            self._markReconfigureUser('xorg', self.xorg_check.get_active())
        if self.xsession_check.get_active():
            self._markReconfigureUser('xsession', self.xsession_check.get_active())
        if self.hardware_check.get_active():
            self._markReconfigureUser('hardware', self.hardware_check.get_active())
        if self.version_check.get_active():
            self._markReconfigureUser('version', self.version_check.get_active())
        if self.disk_space_check.get_active():
            self._markReconfigureUser('disk', self.disk_space_check.get_active())
            
            
    #
    # Callbacks
    #
    def on_enable_all_checkbox_toggled(self,widget,data=None):
        """Enable/Disable all Options in GUI"""
        check_changed = self.enable_all_checkbox.get_active()
        if check_changed:
            if self.sys_log_check.props.sensitive:
                self.sys_log_check.set_active(True)
            if self.backend_check.props.sensitive:
                self.backend_check.set_active(True)
            if self.frontend_check.props.sensitive:
                self.frontend_check.set_active(True)
            if self.xorg_check.props.sensitive:
                self.xorg_check.set_active(True)
            if self.xsession_check.props.sensitive:
                self.xsession_check.set_active(True)
            if self.hardware_check.props.sensitive:
                self.hardware_check.set_active(True)
            if self.version_check.props.sensitive:
                self.version_check.set_active(True)
            if self.disk_space_check.props.sensitive:
                self.disk_space_check.set_active(True)
        else:
            if self.sys_log_check.props.sensitive:
                self.sys_log_check.set_active(False)
            if self.backend_check.props.sensitive:
                self.backend_check.set_active(False)
            if self.frontend_check.props.sensitive:
                self.frontend_check.set_active(False)
            if self.xorg_check.props.sensitive:
                self.xorg_check.set_active(False)
            if self.xsession_check.props.sensitive:
                self.xsession_check.set_active(False)
            if self.hardware_check.props.sensitive:
                self.hardware_check.set_active(False)
            if self.version_check.props.sensitive:
                self.version_check.set_active(False)
            if self.disk_space_check.props.sensitive:
                self.disk_space_check.set_active(False)
    #
    # Process selected activities
    #
    def user_scripted_changes(self, reconfigure):
        for item in reconfigure:
            if item == "syslog":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Syslog...", 20)
                    self.syslog()
            elif item == "backend":
                if reconfigure[item]:
                    self.emit_progress("Gathering the MythTV Backend log...", 30)
                    self.mythbackend()
            elif item == "frontend":
                if reconfigure[item]:
                    self.emit_progress("Gathering the MythTV Frontend Log...", 40)
                    self.mythfrontend()
            elif item == "xorg":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Xorg Log...", 50)
                    self.xorg_log()
            elif item == "xsession":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Xsession Log...", 60)
                    self.xsession_errors()
            elif item == "hardware":
                if reconfigure[item]:
                    self.emit_progress("Gathering System hardware Info...", 70)
                    self.installed_hardware()
            elif item == "version":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Mythbuntu Version Info...", 80)
                    self.mythbuntu_version()
            elif item == "disk":
                if reconfigure[item]:
                    self.emit_progress("Gathering the Hard disk info...", 90)
                    self.disk_space()
        if os.path.exists('/tmp/mythbuntu.diag'):            
            if len(reconfigure) >= 1:
                with open('/tmp/mythbuntu.diag') as file:
                    self.emit_progress("Posting the diagnostic data...", 95)
                    paste_data = file.read()
                    get_url = LogGrabberPostThread(paste_data)
                    paste_url = get_url.run()
                    while get_url.isAlive():
                        """ Just keep passing until the thread goes away """
                        pass
                    self.pastebin_output.set_text(paste_url)
                    file.close()
        else:
            print "Diagnostic data file not found!"

    def write_log(self, section_name, data_in):
        """Builds the Actual Log File on the Local Machine"""
        if not os.path.exists('/tmp/mythbuntu.diag'):
            log = open('/tmp/mythbuntu.diag', 'w')
            log.write('=== ' + section_name + ' ===\n')
            log.write(data_in)
            log.write('\n')
            log.close()
        else:
            """Append"""
            log = open('/tmp/mythbuntu.diag', 'a')
            log.write('=== ' + section_name + ' ===\n')
            log.write(data_in)
            log.write('\n')
            log.close()

    def installed_hardware(self):
        """Gather all Hardware Information"""
        data_in = subprocess.Popen(["/usr/bin/lspci"], stdout=subprocess.PIPE).communicate()[0]
        data_in += subprocess.Popen(["/usr/bin/lsusb"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Installed Hardware",data_in)

    def xorg_log(self):
        """Read in the Xorg.0.log"""
        f = open('/var/log/Xorg.0.log')
        data_in = f.read()
        f.close()
        self.write_log("Xorg Log",data_in)

    def xsession_errors(self):
        """Get the Xsession Errors"""
        session_log = os.environ['HOME'] + '/.xsession-errors'
        f = open(session_log)
        data_in = f.read()
        f.close()
        self.write_log("Xsession Errors",data_in)

    def syslog(self):
        """Read in the Syslog"""
        f = open('/var/log/syslog')
        data_in = f.read()
        f.close()
        self.write_log("Syslog",data_in)

    def mythfrontend(self):
        """Read in the Frontend Log"""
        f = open('/var/log/mythtv/mythfrontend.log')
        data_in = f.read()
        f.close()
        self.write_log("MythtV Frontend Log",data_in)

    def mythbackend(self):
        """Read in the Backend Log"""
        f = open('/var/log/mythtv/mythbackend.log')
        data_in = f.read()
        f.close()
        self.write_log("MythtV Backend Log",data_in)

    def disk_space(self):
        """Gather all Disk Information"""
        data_in = subprocess.Popen(["/bin/df", "-h"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Disk Space",data_in)

    def mythbuntu_version(self):
        """Gather Mythbuntu Version"""
        data_in = subprocess.Popen(["/usr/bin/lsb_release", "-a"], stdout=subprocess.PIPE).communicate()[0]
        self.write_log("Mythbuntu Version",data_in)
