#!/usr/bin/python
# Mythbuntu-Log-Grabber core.py
# Copyright (C) 2008, Nick Fox <nfox@foxmediasystems.com>
# This provides all the core features of Mythbuntu-Log-Grabber
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import sys
import subprocess

try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)

class MythbuntuLogGrabber:

	loglocation = os.path.join(os.getenv("HOME"), '.mythtv/errorlogs.log')
	if os.path.exists(loglocation):
		os.remove(loglocation)
	SUBMITTED = False
	GATHERED = False

	def __init__(self):

		
		#Initialize GUI & Terminal
		self.gladefile = "/usr/share/mythbuntu-log-grabber/SubmitWindow.glade"
		self.wTree = gtk.glade.XML(self.gladefile, "MainWindow")
		for widget in self.wTree.get_widget_prefix(""):
			setattr(self, widget.get_name(), widget)
			if isinstance(widget, gtk.Label):
				widget.set_property('can-focus', False)
		self.wTree.signal_autoconnect(self)
	
		#Get the Main Window, and connect the "destroy" event
		self.window = self.wTree.get_widget("MainWindow")
		if (self.window):
			self.window.connect("destroy", gtk.main_quit)

		#Create our dictionary and connect it
		dic = { "on_btnyes_clicked" : self.yes_button_clicked,
			"on_btnview_clicked" : self.on_btnview_clicked,
			"on_btnlogs_clicked" : self.gather_logs_button_clicked,
			"on_MainWindow_destroy" : gtk.main_quit }
		self.wTree.signal_autoconnect(dic)

		if not self.GATHERED:
			self.btnyes.set_sensitive(False)
			self.btnview.set_sensitive(False)

	def gather_logs_button_clicked(self, widget):
		## Gather all the logs and ready them for submitting

		self.SUBMITTED = False
		self.GATHERED = True
	
		os.system("tail -n 100 /var/log/mythtv/*.log /var/log/syslog /var/log/Xorg.0.log ~/.xsession-errors > "+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> df -h <==" >> '+self.loglocation)
		os.system('df -h >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> uname -a <==" >> '+self.loglocation)
		os.system('uname -a >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lspci <==" >> '+self.loglocation)
		os.system('lspci >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lsusb <==" >> '+self.loglocation)
		os.system('lsusb >> '+self.loglocation)

		if os.path.exists("/proc/driver/nvidia/"):
			os.system('tail -n 100 /proc/driver/nvidia/* >> '+self.loglocation)
			os.system('tail -n 100 /proc/driver/nvidia/cards/* >> '+self.loglocation)

		os.system('echo "" >> '+self.loglocation)
		os.system('echo "==> lshw <==" >> '+self.loglocation)
		os.system('lshw -sanitize >> '+self.loglocation)

		if self.GATHERED:
			self.btnyes.set_sensitive(True)
			self.btnview.set_sensitive(True)

	def yes_button_clicked(self, widget):
		if self.GATHERED == True:
			if self.SUBMITTED == False:
				pastebinlocation = subprocess.Popen(["pastebinit", "-b", "http://mythbuntu.pastebin.com", "-i", self.loglocation],stdout=subprocess.PIPE).communicate()[0]
				self.Entry.set_text(pastebinlocation.strip())
				self.SUBMITTED = True
		else:
			self.Entry.set_text("Logs not gathered.  Please gather your logs.")

	def on_btnview_clicked(self, widget):
		if os.path.exists('/usr/bin/mousepad'):
			subprocess.Popen(["mousepad", self.loglocation])
		elif os.path.exists('/usr/bin/gedit'):
			subprocess.Popen(["gedit", self.loglocation])
		elif os.path.exists('/usr/bin/kate'):
			subprocess.Popen(["kate", self.loglocation])
		else:
			subprocess.Popen(["nano", self.loglocation])

	def run(self):
		self.MainWindow.show()
		gtk.main()
