# -*- coding: utf-8 -*-
#
# «changer» - Mythbuntu Control Centre class for making change
#
# This script:
# Copyright (C) 2007, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

#Package install support
import warnings
warnings.filterwarnings("ignore", "apt API not stable yet", FutureWarning)
import apt
import apt_pkg

#GUI support
import pygtk
pygtk.require('2.0')
import gtk

#Terminal Widget support
import vte

#File, String, & Process manipulation
import os
import shutil
import re
import string
import subprocess
import time
import sys

#Package reloading support
import thread

#Add support for our LIRC Generation suite
from MythbuntuLircGenerator.mythtvhandler import MythTVHandler
from MythbuntuLircGenerator.mplayerhandler import MPlayerHandler
from MythbuntuLircGenerator.xinehandler import XineHandler
from MythbuntuLircGenerator.vlchandler import VLCHandler

#Add support for VNC Generation suite
from MythbuntuControlCentre.vnc import VNCHandler

#Borrow GDebi's install methods
from GDebi.GDebi import GDebi

#Glade directory
GLADEDIR = '/usr/share/mythbuntu-control-centre/glade'

#Script Directory
SCRIPTDIR = '/usr/share/mythbuntu-control-centre/scripts'

#Translation Support
from gettext import gettext as _

# debconf support
from debconftalk import debconftalk

def utf8(str):
  return unicode(str, 'latin1').encode('utf-8')


class Applicator():
    def __init__(self,to_install,to_remove,to_reconfigure):
        """Takes input from core and passes it on to Applicator"""
        #Initialize GUI & Terminal
        self.glade = gtk.glade.XML(GLADEDIR + '/' + 'progress_dialogs.glade')
        for widget in self.glade.get_widget_prefix(""):
            setattr(self, widget.get_name(), widget)
            if isinstance(widget, gtk.Label):
                widget.set_property('can-focus', False)
        self.glade.signal_autoconnect(self)
        self._term = vte.Terminal()
        self._term.show()
        self._term.set_font_from_string("monospace 10")
        self.expander_install.add(self._term)
        self.progress_dialog.show()

        #Don't show anything during package installs
        os.putenv('DEBIAN_FRONTEND','noninteractive')

        #Apt Cache
        apt_pkg.Config.Set("APT::Install-Recommends","0")
        self.cache=apt.Cache()

        #Other Changes
        self.to_reconfigure=to_reconfigure

        #Packages to install/remove
        try:
            self._init_error=False
            self.package_changes=False
            for pkg in to_install:
                self.cache[pkg].markInstall()
                self.package_changes=True
            for pkg in to_remove:
                self.cache[pkg].markDelete()
                self.package_changes=True
        except KeyError, msg:
            self._init_error = True
            header = _("Could not mark all packages")
            body = _("Check your repository lists for universe,  "
                    "multiverse, and main.  Perform a package"
                    "list update as well.")
            self.show_alert(gtk.MESSAGE_ERROR, header, body, msg,
                parent=self.progress_dialog)
            self.progress_dialog.hide()
        except SystemError, msg:
            self._init_error = True
            header = _("Broken apt package cache")
            body = _("Check your repository lists for universe,  "
                    "multiverse, and main.  Perform a package"
                    "list update as well.")
            self.show_alert(gtk.MESSAGE_ERROR, header, body, msg,
                parent=self.progress_dialog)
            self.progress_dialog.hide()

        while gtk.events_pending():
            gtk.main_iteration()

    def get_init_error(self):
        return self._init_error

    def show_alert(self, type, header, body=None, details=None, parent=None):
        if parent is not None:
             self.dialog_hig.set_transient_for(parent)
        else:
             self.dialog_hig.set_transient_for(self.progress_dialog)

        message = "<b><big>%s</big></b>" % header
        if not body == None:
             message = "%s\n\n%s" % (message, body)
        self.label_hig.set_markup(message)

        if not details == None:
             buffer = self.textview_hig.get_buffer()
             buffer.set_text(str(details))
             self.expander_hig.set_expanded(False)
             self.expander_hig.show()

        if type == gtk.MESSAGE_ERROR:
             self.image_hig.set_property("stock", "gtk-dialog-error")
        elif type == gtk.MESSAGE_WARNING:
             self.image_hig.set_property("stock", "gtk-dialog-warning")
        elif type == gtk.MESSAGE_INFO:
             self.image_hig.set_property("stock", "gtk-dialog-info")

        res = self.dialog_hig.run()
        self.dialog_hig.hide()
        if res == gtk.RESPONSE_CLOSE:
            return True
        return False

    def acquire_lock(self):
        " lock the pkgsystem for install "

        # check if we can lock the apt database
        try:
            apt_pkg.PkgSystemLock()
        except SystemError:
            self.error_header = _("Only one software management tool is allowed to"
                                  " run at the same time")
            self.error_body = _("Please close the other application e.g. 'Update "
                                "Manager', 'aptitude' or 'Synaptic' first.")
            return False
        return True

    def release_lock(self):
        " release the pkgsystem lock "
        apt_pkg.PkgSystemLock()
        return True

    def commit_changes(self):
        """Called to launch things"""
        if self.package_changes:
            if not self.acquire_lock():
                  self.show_alert(gtk.MESSAGE_ERROR, self.error_header, self.error_body)
                  return False

            self.fprogress = GDebi.FetchProgressAdapter(self.progressbar,
                                                  self.action,
                                                  self)
            self.iprogress = self.MythbuntuInstallProgressAdapter(self.progressbar,
                                                    self._term,
                                                    self.action,
                                                    self.expander_install)
            errMsg = None
            try:

                res = self.cache.commit(self.fprogress,self.iprogress)
            except IOError, msg:
                res = False
                errMsg = "%s" % msg
                header = _("Could not download all required files")
                body = _("Please check your internet connection or "
                        "installation medium.")
            except SystemError, msg:
                res = False
                header = _("Could not install all dependencies"),
                body = _("Usually this is related to an error of the "
                        "software distributor. See the terminal window for "
                        "more details.")
            if not res:
                self.show_alert(gtk.MESSAGE_ERROR, header, body, msg,
                                parent=self.progress_dialog)
                self.progress_dialog.hide()
                return

        self.prepare_configuration(self.progressbar,self.expander_install)
        self.process_configuration()
        self.progress_dialog.hide()

#Overrideen GDebi Methods
    class MythbuntuInstallProgressAdapter(GDebi.InstallProgressAdapter):
        def startUpdate(self):
            #print "startUpdate"
            apt_pkg.PkgSystemUnLock()
            self.term_expander.show()
            self.action.set_markup("<i>"+_("Installing and Removing packages...")+"</i>")
            self.progress.set_fraction(0.0)
            self.progress.set_text("")

    def prepare_configuration(self,progressbar,expander):
        """Prepares the GUI for the post install steps"""
        expander.hide()
        progressbar.set_text("")
        self.update_gui(0.0,"Post-install Mythbuntu Configuration")
        while gtk.events_pending():
            gtk.main_iteration()

    def update_gui(self,progress,new_text=None):
        """Updates the GUI to show what we are working on"""
        self.progressbar.set_fraction(progress)
        if new_text != None:
            self.action.set_markup("<i>"+_(new_text)+"</i>")
        time.sleep(0.5)
        while gtk.events_pending():
            gtk.main_iteration()

#Action Functions
    def process_configuration(self):
        """Interprets the to_reconfigure variable and does everything described"""

        mythtv_mysql_pass = None
        mythtv_mysql_user = None
        mythtv_mysql_database = None
        mythtv_mysql_server = None
        mplayer = None
        xine_ui = None
        vlc = None
        mythtv_backend = None
        mythtv_frontend = None
        mythvideo = None
        mythgallery = None
        mythmusic = None
        autologin = None
        autologin_user = None
        samba = None
        nfs_kernel_server = None
        vnc4server = None
        vnc_password = None
        mysql_server = None
        remote = None
        modules = None
        driver = None
        lircd = None
        lircrc = None
        mythweb_auth_activated = None
        mythweb_auth_username = None
        mythweb_auth_password = None
        mysql_tweaks_enabled = None
        enable_nightly_defrag = None
        new_mysql_repair = None
        medibuntu_change = None


        for item in self.to_reconfigure:
            #Mysql.txt
            if item == "mythtv_mysql_pass":
                mythtv_mysql_pass = self.to_reconfigure[item]
            elif item == "mythtv_mysql_user":
                mythtv_mysql_user = self.to_reconfigure[item]
            elif item == "mythtv_mysql_database":
                mythtv_mysql_database = self.to_reconfigure[item]
            elif item == "mythtv_mysql_server":
                mythtv_mysql_server = self.to_reconfigure[item]
            #Media apps
            elif item == "mplayer":
                mplayer = self.to_reconfigure[item]
            elif item == "xine-ui":
                xine_ui = self.to_reconfigure[item]
            elif item == "vlc":
                vlc = self.to_reconfigure[item]
            #frontend and backend
            elif item == "mythtv-backend":
                mythtv_backend = self.to_reconfigure[item]
            elif item == "mythtv-frontend":
                mythtv_frontend = self.to_reconfigure[item]
            #Plugins
            elif item == "mythvideo":
                mythvideo = self.to_reconfigure[item]
            elif item == "mythgallery":
                mythgallery = self.to_reconfigure[item]
            elif item == "mythmusic":
                mythmusic = self.to_reconfigure[item]
            #Autologin
            elif item == "autologin":
                autologin = self.to_reconfigure[item]
            elif item == "autologin_user":
                autologin_user = self.to_reconfigure[item]
            #Services
            elif item == "samba":
                samba = self.to_reconfigure[item]
            elif item == "nfs-kernel-server":
                nfs_kernel_server = self.to_reconfigure[item]
            elif item == "vnc4server":
                vnc4server = self.to_reconfigure[item]
            elif item == "vnc_password":
                vnc_password = self.to_reconfigure[item]
            elif item == "mysql-server":
                mysql_server = self.to_reconfigure[item]
            #Remotes
            elif item == "remote":
                remote = self.to_reconfigure[item]
            elif item == "modules":
                modules = self.to_reconfigure[item]
            elif item == "driver":
                driver = self.to_reconfigure[item]
            elif item == "lircd":
                lircd = self.to_reconfigure[item]
            elif item == "lircrc":
                lircrc = self.to_reconfigure[item]
            elif item == "mythweb_auth_activated":
                 mythweb_auth_activated = self.to_reconfigure[item]
            elif item == "mythweb_auth_username":
                mythweb_auth_username = self.to_reconfigure[item]
            elif item == "mythweb_auth_password":
                mythweb_auth_password = self.to_reconfigure[item]
            elif item == "mysql_tweaks_enabled":
                mysql_tweaks_enabled = self.to_reconfigure[item]
            elif item == "enable_nightly_defrag":
                enable_nightly_defrag = self.to_reconfigure[item]
            elif item == "new_mysql_repair":
                new_mysql_repair = self.to_reconfigure[item]
            #Extra Repos
            elif item == "medibuntu":
                medibuntu_change = self.to_reconfigure[item]

        #Services
        if samba is not None and samba:
            self.update_gui(.125,"Configuring Samba Service")
            self.configure_samba(mythtv_backend,mythvideo,mythmusic,mythgallery)
        else:
            self.update_gui(.125)
        if nfs_kernel_server is not None and nfs_kernel_server:
            self.update_gui(.250,"Configuring NFS Service")
            self.configure_nfs(mythtv_backend,mythvideo,mythmusic,mythgallery)
        else:
            self.update_gui(.250)
        if vnc4server is not None:
            self.update_gui(.375,"Configuring VNC Service")
            self.configure_vnc(vnc4server,vnc_password)
        else:
            self.update_gui(.375)
        if mysql_server is not None:
            self.update_gui(.500,"Configuring MySQL Service")
            self.configure_mysql(mysql_server)
        else:
            self.update_gui(.500)
        #Mysql.txt
        # FIXME: what happens if we just want to change the user name? --laga
        # OTOH, the mysql pass is the only thing which might be empty
        if mythtv_mysql_pass is not None:
            self.update_gui(.600,"Configuring Remote MythTV Connection Information...")
            self.write_mysql_txt(mythtv_mysql_user,mythtv_mysql_pass,mythtv_mysql_database,mythtv_mysql_server)
        else:
            self.update_gui(.600)
        # mysqld tweaks
        if mysql_tweaks_enabled is not None:
            self.update_gui(.650,"Configuring MySQL tweaks")
            self.mysql_tweaks(mysql_tweaks_enabled)
        else:
            self.update_gui(.650)
        if new_mysql_repair is not None:
            self.update_gui(.675,"Configuring MySQL optimization/repair cron job")
            self.mysql_repair(new_mysql_repair)
        else:
            self.update_gui(.675)
        #Extra Repos
        if medibuntu_change is not None:
            self.update_gui(.700,"Configuring Medibuntu Repository")
            self.update_medibuntu()
            self.update_gui(.740,"Updating Package Lists")
            self.update_package_lists()
        else:
            self.update_gui(.725)

        #Autologin
        if autologin is not None:
            self.update_gui(.750,"Configuring Automatic Login...")
            self.configure_autologin(autologin,autologin_user)
        else:
            self.update_gui(.750)
        # xfs defrag
        if enable_nightly_defrag is not None:
            self.update_gui(.825,"Configuring daily XFS defragmentation")
            self.xfs_defrag(enable_nightly_defrag)
        else:
            self.update_gui(.825)

        #Remote
        if remote is not None:
            self.update_gui(.900,"Configuring Remote Control...")
            self.write_hardware_conf(remote,driver,modules,lircd)
            self.create_lircd_conf(lircd)
            self.restart_lirc()
            #self.debconf_lirc(remote,driver,modules,lircd)
        else:
            self.update_gui(.900)
        # mythweb auth
        if mythweb_auth_activated is not None or mythweb_auth_username is not None or mythweb_auth_password is not None:
            self.update_gui(.950,"Setting up MythWeb authentication")
            self.config_mythweb_auth(mythweb_auth_activated,mythweb_auth_username,mythweb_auth_password)
        else:
            self.update_gui(.950)
        #Lircrc
        if lircrc is not None and lircrc:
            self.update_gui(1.00,"Configuring Application Specific Remote Buttons...")
            self.create_lircrc(mythtv_frontend,mplayer,xine_ui,vlc)
        else:
            self.update_gui(1.00)


    def write_mysql_txt(self,user,password,database,server):
        """Writes out a mysql.txt in /etc/mythtv"""
        if os.path.exists("/etc/mythtv/mysql.txt"):
            print "Moving /etc/mythtv/mysql.txt to /etc/mythtv/mysql.txt.mythbuntu-old"
            shutil.move("/etc/mythtv/mysql.txt", "/etc/mythtv/mysql.txt.mythbuntu-old")
        out_f = open("/etc/mythtv/mysql.txt", "w")
        out_f.write("DBHostName=" + server + "\n")
        out_f.write("DBUserName=" + user + "\n")
        out_f.write("DBName=" + database + "\n")
        out_f.write("DBPassword=" + password + "\n")
        out_f.close()

    def mysql_tweaks(self,mysql_tweaks):
        # string comparison. No, it's not a boolean variable
        if mysql_tweaks == "True":
            out_mt = open("/etc/mysql/conf.d/mythtv-tweaks.cnf", "w")
            # some of these seem to be in gutsy proper already
            out_mt.write("[mysqld]\n")
            out_mt.write("# The following values were partly taken from:\n")
            out_mt.write("# http://www.gossamer-threads.com/lists/mythtv/users/90942#90942\n")
            # out_mt.write("key_buffer = 48M\n")
            # out_mt.write("max_allowed_packet = 8M\n")
            out_mt.write("table_cache = 128\n")
            out_mt.write("sort_buffer_size = 48M\n")
            out_mt.write("net_buffer_length = 8M\n")
            # out_mt.write("thread_cache_size = 4\n")
            out_mt.write("query_cache_type = 1\n")
            out_mt.write("query_cache_size = 32M\n")
            out_mt.write("# don't do binary logs for mythconverg\n")
            out_mt.write("binlog_ignore_db = mythconverg\n")
            out_mt.close()
        elif mysql_tweaks == "False":
            os.remove("/etc/mysql/conf.d/mythtv-tweaks.cnf")

    def debconf_lirc(self,remote,driver,modules,lircd):
        debconftalk("set","lirc/driver "+driver)
        debconftalk("set","lirc/modules "+modules)
        debconftalk("set","lirc/remote "+remote)
        debconftalk("set","lirc/lircd_conf "+lircd)
        os.system('dpkg-reconfigure -fnoninteractive lirc')

    def write_hardware_conf(self,remote,driver,modules,lircd):
        """Writes out a hardware.conf in /etc/lirc"""
        #Only load driver for non kernel module items
        p1 = subprocess.Popen(["lircd","-H","help"], stderr=subprocess.PIPE)
        p2 = subprocess.Popen(["awk", "$0!~/^S|^D/{print $1}"], stdin=p1.stderr, stdout=subprocess.PIPE)
        p3 = subprocess.Popen(["tr", "'\\n'", "'\ '"],stdin=p2.stdout, stdout=subprocess.PIPE)
        supporteddrivers=p3.communicate()[0]
        pattern=re.compile(driver)
        if pattern.search(supporteddrivers) is None:
            driver=""

        patternline="^REMOTE"
        patternline+="|^MODULES"
        patternline+="|^DRIVER"
        patternline+="|^LIRCD_CONF"
        pattern=re.compile(patternline)
        found_remote=False
        found_modules=False
        found_driver=False
        found_lircd_conf=False
        lines = None
        try:
            in_f = open("/etc/lirc/hardware.conf")
            lines = in_f.readlines()
            in_f.close()
        except IOError:
            print "Unable to find /etc/lirc/hardware.conf"
        out_f = open("/etc/lirc/hardware.conf", 'w')
        for line in lines:
            if pattern.search(line) is None:
                out_f.write(line)
            else:
                if not found_remote and re.compile("^REMOTE").search(line):
                    out_f.write("REMOTE=\"" + remote + "\"\n")
                    found_remote = True
                elif not found_modules and re.compile("^MODULES").search(line):
                    out_f.write("MODULES=\"" + modules + "\"\n")
                    found_modules = True
                elif not found_driver and re.compile("^DRIVER").search(line):
                    out_f.write("DRIVER=\"" + driver + "\"\n")
                    found_driver = True
                elif not found_lircd_conf and re.compile("^LIRCD_CONF").search(line):
                    out_f.write("LIRCD_CONF=\"" + lircd + "\"\n")
                    found_lircd_conf = True
        if not found_remote:
            out_f.write("REMOTE=\"" + remote + "\"\n")
        if not found_modules:
            out_f.write("MODULES=\"" + modules + "\"\n")
        if not found_driver:
            out_f.write("DRIVER=\"" + driver + "\"\n")
        if not found_lircd_conf:
            out_f.write("LIRCD_CONF=\"" + lircd + "\"\n")
        out_f.close()

    def create_lircd_conf(self,lircd):
        """Copies the appropriate lircd.conf for a remote"""
        if lircd != "":
            if os.path.exists("/etc/lirc/lircd.conf"):
                print "Moving /etc/lirc/lircd.conf to /etc/lirc/lircd.conf.mythbuntu-old"
                shutil.move("/etc/lirc/lircd.conf", "/etc/lirc/lircd.conf.mythbuntu-old")
            shutil.copy('/usr/share/lirc/remotes/' + lircd, '/etc/lirc/lircd.conf')

    def create_lircrc(self,mythtv,mplayer,xine,vlc):
        """Generates lircrc files for all possible applications"""
        home = os.getenv('HOME')
        uid = int(os.getenv('SUDO_GID'))
        gid = int(os.getenv('SUDO_UID'))
        lircd = '/etc/lirc/lircd.conf'
        lircrc = home + '/.lircrc'
        #Check for existing
        if os.path.exists(lircrc):
            print "Moving existing " + lircrc + " to " + lircrc + ".mythbuntu-old"
            shutil.move(lircrc,lircrc + '.mythbuntu-old')
        #MythTV lircrc
        if mythtv:
            generation_station = MythTVHandler(lircd,lircrc,"0","0")
            generation_station.generate()

            if os.path.exists(home + '/.mythtv/lircrc'):
                print "Moving existing " + home  + "/.mythtv/lircrc to " + home + '/.mythtv/lircrc.mythbuntu-old'
                shutil.move(home + '/.mythtv/lircrc', home + '/.mythtv/lircrc.mythbuntu-old')
            elif not os.path.exists(home + '/.mythtv'):
                os.mkdir(home + '/.mythtv')
            shutil.copy(lircrc, home + '/.mythtv/lircrc')
            if uid != None and gid != None:
                os.chown(lircrc,uid,gid)
                os.chown(home + '/.mythtv',uid,gid)
                os.chown(home + '/.mythtv/lircrc',uid,gid)
        #Media apps
        if mplayer:
            generation_station = MPlayerHandler(lircd,lircrc,"0","0")
            generation_station.generate()
        if xine:
            generation_station = XineHandler(lircd,lircrc,"0","0")
            generation_station.generate()
        if vlc:
            generation_station = VLCHandler(lircd,lircrc,"0","0")
            generation_station.generate()

    def restart_lirc(self):
        """Restarts LIRC"""
        start_lirc = subprocess.Popen(["invoke-rc.d", "lirc", "restart"],stdout=subprocess.PIPE).communicate()[0]
        print start_lirc

    def configure_vnc(self,enable,passwd):
        if not os.path.exists("/root/.vnc"):
            os.mkdir("/root/.vnc")
        elif os.path.exists("/root/.vnc/vncpasswd"):
            print "Copying /root/.vnc/vncpasswd to /root/.vnc/vncpasswd.mythbuntu-old"
            shutil.copy("/root/.vnc/vncpasswd","/root/.vnc/vncpasswd.mythbuntu-old")
        if enable:
            #Create password using expect
            os.system(SCRIPTDIR + "/create_vnc_passwd " + passwd)
        #Xorg.conf
        xorg_handler=VNCHandler()
        xorg_handler.run(enable)

    def configure_autologin(self,enable,user):
        """Configures autologin for user if enable is True"""
        #Login Session Option
        home = ''
        uid = ''
        gid = ''
        in_f=open("/etc/passwd")
        for line in in_f:
            fields =  string.split(line,":")
            id=int(fields[2])
            if fields[0] == user:
                uid = int(fields[2])
                gid = int(fields[3])
                home = fields[5]
                break
        if enable:
            #dmrc, used to define which session is autologin
            if os.path.exists(home + '/.dmrc') and not os.path.exists(home + '/.dmrc.mythbuntu-old'):
                shutil.move(home + '/.dmrc', home + '/.dmrc.mythbuntu-old')
            shutil.copy('/etc/skel/.dmrc', home + '/.dmrc')
            #start myth frontend automatically
            if not os.path.exists(home + '/.config/autostart'):
                os.makedirs(home + '/.config/autostart')
            if not os.path.exists(home + '/.config/autostart/mythtv.desktop'):
                try:
                    os.symlink('/usr/share/applications/mythtv.desktop',home + '/.config/autostart/mythtv.desktop')
                except OSError:
                    os.unlink(home + '/.config/autostart/mythtv.desktop')
                    os.symlink('/usr/share/applications/mythtv.desktop',home + '/.config/autostart/mythtv.desktop')
            if uid != '' and gid != '':
                os.chown(home + '/.dmrc',uid,gid)
                os.chown(home + '/.config',uid,gid)
                os.chown(home + '/.config/autostart',uid,gid)
        else:
            if os.path.exists(home + '/.dmrc'):
                os.remove(home + '/.dmrc')
            if os.path.exists(home + '/.dmrc.mythbuntu-old'):
                shutil.move(home + '/.dmrc.mythbuntu-old', home + '/.dmrc')
            if os.path.exists(home + '/.config/autostart/mythtv.desktop'):
                os.remove(home + '/.config/autostart/mythtv.desktop')
        #GDM Configuration
        if os.path.exists("/etc/gdm/gdm-cdd.conf"):
            shutil.copy("/etc/gdm/gdm-cdd.conf","/etc/gdm/gdm-cdd.conf.mythbuntu-old")
            print "Copying /etc/gdm/gdm-cdd.conf to /etc/gdm/gdm-cdd.conf.mythbuntu-old"
            in_f=open("/etc/gdm/gdm-cdd.conf.mythbuntu-old")
            out_f=open("/etc/gdm/gdm-cdd.conf","w")
            pattern=re.compile("^AutomaticLoginEnable=|^AutomaticLogin=|^TimedLoginEnable=|^TimedLogin=")
            for line in in_f:
                if re.compile("^AutomaticLoginEnable=").search(line) is not None:
                    if enable:
                        out_f.write("AutomaticLoginEnable=true\n")
                    else:
                        out_f.write("AutomaticLoginEnable=false\n")
                elif re.compile("^AutomaticLogin=").search(line):
                    if enable:
                        out_f.write("AutomaticLogin=" + user + "\n")
                    else:
                        out_f.write(line)
                elif re.compile("^TimedLoginEnable=").search(line) is not None:
                    if enable:
                        out_f.write("TimedLoginEnable=true\n")
                    else:
                        out_f.write("TimedLoginEnable=false\n")
                elif re.compile("^TimedLogin=").search(line):
                    if enable:
                        out_f.write("TimedLogin=" + user + "\n")
                    else:
                        out_f.write(line)
                else:
                    out_f.write(line)
            out_f.close()

    def configure_samba(self,mythtv,videos,music,pictures):
        """Writes a sane default samba configuration"""
        if os.path.exists("/etc/samba/smb.conf"):
            print "Copying existing /etc/samba/smb.conf to /etc/samba/smb.conf.mythbuntu-old"
            shutil.copy("/etc/samba/smb.conf","/etc/samba/smb.conf.mythbuntu-old")
        out_f=open("/etc/samba/smb.conf","w")
        out_f.write("[global]\n")
        out_f.write("workgroup = MSHOME\n")
        out_f.write("server string = %h server (Samba, Mythbuntu)\n")
        out_f.write("log file = /var/log/samba/log.%m\n")
        out_f.write("max log size = 1000\n")
        out_f.write("syslog = 0\n")
        out_f.write("panic action = /usr/share/samba/panic-action %d\n")
        out_f.write("dns proxy = no\n")
        out_f.write("security = share\n")
        out_f.write("\n")
        if mythtv:
            out_f.write("[recordings]\n")
            out_f.write("comment = TV Recordings\n")
 # FIXME: this value should be pulled from the mysql DB, IMHO
 # Note: it'd be host-specific.
 # Current code also doesn't account for storage groups. --laga
            out_f.write("path = /var/lib/mythtv/recordings\n")
            out_f.write("public = yes\n")
            out_f.write("writable = no\n")
            out_f.write("create mask = 0777\n")
            out_f.write("directory mask = 0777\n")
            out_f.write("force user = nobody\n")
            out_f.write("force group = nogroup\n")
            out_f.write("\n")
        if videos:
            out_f.write("[videos]\n")
            out_f.write("comment = Videos\n")
            out_f.write("path = /var/lib/mythtv/videos\n")
            out_f.write("public = yes\n")
            out_f.write("writable = yes\n")
            out_f.write("create mask = 0660\n")
            out_f.write("directory mask = 0770\n")
            out_f.write("force user = mythtv\n")
            out_f.write("force group = mythtv\n")
            out_f.write("\n")
        if music:
            out_f.write("[music]\n")
            out_f.write("comment = Music\n")
            out_f.write("path = /var/lib/mythtv/music\n")
            out_f.write("public = yes\n")
            out_f.write("writable = yes\n")
            out_f.write("create mask = 0660\n")
            out_f.write("directory mask = 0770\n")
            out_f.write("force user = mythtv\n")
            out_f.write("force group = mythtv\n")
            out_f.write("\n")
        if pictures:
            out_f.write("[pictures]\n")
            out_f.write("comment = Pictures\n")
            out_f.write("path = /var/lib/mythtv/pictures\n")
            out_f.write("public = yes\n")
            out_f.write("writable = yes\n")
            out_f.write("create mask = 0660\n")
            out_f.write("directory mask = 0770\n")
            out_f.write("force user = mythtv\n")
            out_f.write("force group = mythtv\n")
            out_f.write("\n")
        out_f.close()

    def configure_nfs(self,mythtv,videos,music,pictures):
        if os.path.exists("/etc/exports"):
            print "Copying /etc/exports to /etc/exports.mythbuntu-old"
            shutil.copy("/etc/exports","/etc/exports.mythbuntu-old")
        out_f=open("/etc/exports","w")
        if mythtv:
            out_f.write("/var/lib/mythtv/recordings    *(ro,async,no_root_squash,no_subtree_check)\n")
        if videos:
            out_f.write("/var/lib/mythtv/videos    *(ro,async,no_root_squash,no_subtree_check)\n")
        if music:
            out_f.write("/var/lib/mythtv/music    *(ro,async,no_root_squash,no_subtree_check)\n")
        if pictures:
            out_f.write("/var/lib/mythtv/pictures    *(ro,async,no_root_squash,no_subtree_check)\n")
        out_f.close()

    def configure_mysql(self,enable):
        if not os.path.exists("/etc/mysql/conf.d"):
            os.mkdir("/etc/mysql/conf.d")
        lines = None
        out_f = None
        found = False
        pattern = re.compile("^bind-address|^#bind-address")
        try:
            in_f = open("/etc/mysql/conf.d/mythtv.cnf")
            lines = in_f.readlines()
            in_f.close()
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            for line in lines:
                if pattern.search(line) is None:
                    out_f.write(line)
                elif not found:
                    if enable:
                        out_f.write("bind-address=0.0.0.0\n")
                    else:
                        out_f.write("#bind-address=0.0.0.0\n")
                    found = True
            if not found:
                if enable:
                    out_f.write("bind-address=0.0.0.0\n")
                else:
                    out_f.write("#bind-address=0.0.0.0\n")
        except IOError:
            print "/etc/mysql/conf.d/mythtv.cnf not found"
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            out_f.write("[mysqld]\n")
            if enable:
                out_f.write("bind-address=0.0.0.0\n")
            else:
                out_f.write("#bind-address=0.0.0.0\n")
        out_f.close()

    def config_mythweb_auth(self,mythweb_auth_activated,mythweb_auth_username,mythweb_auth_password):

        # python does not want to mix boolean and strings, that's why we convert
        # mythweb_auth_activated here
        if mythweb_auth_activated == True:
            debconftalk('set', 'mythweb/enable true')
            # that extra whitespace in there is probably a good idea
            debconftalk('set', 'mythweb/username ' + mythweb_auth_username)
            debconftalk('set', 'mythweb/password ' + mythweb_auth_password)
        elif mythweb_auth_activated == False:
            debconftalk('set', 'mythweb/enable false')

        # this should be made more robust
        # eg check for errors and print a nice warning message
        subprocess.call(["dpkg-reconfigure", "-fnoninteractive", "mythweb"])

    def update_medibuntu(self):
        #toggles medibuntu
        medibuntuDeb = 'deb http://packages.medibuntu.org/ gutsy free non-free'
        #find it
        in_f=open("/etc/apt/sources.list")
        pattern=re.compile("^deb http://packages.medibuntu.org/ gutsy free non-free")
        medibuntu_exists=False
        for line in in_f:
            if pattern.search(line
            ):
                medibuntu_exists=True
        if not medibuntu_exists and os.path.exists("/etc/apt/sources.list.d/medibuntu.list"):
            medibuntu_exists=True
        #act
        if medibuntu_exists == False and self.check_medibuntu_key() == False:
            os.system("wget -q http://packages.medibuntu.org/medibuntu-key.gpg -O- | apt-key add -")
        self.update_source(medibuntuDeb, medibuntu_exists)

    def update_source(self, line, remove):
        from aptsources import distro
        from aptsources.sourceslist import SourcesList, SourceEntry
        from softwareproperties.SoftwareProperties import SoftwareProperties
        SoftwareProperties = SoftwareProperties()
        if remove == False:
            SoftwareProperties.sourceslist.list.append(SourceEntry(line))
        else:
            SoftwareProperties.sourceslist.list.remove(SourceEntry(line))
        SoftwareProperties.save_sourceslist()
        SoftwareProperties.reload_sourceslist()


    def xfs_defrag(self,enable_nightly_defrag):
        # string comparison. No, it's not a boolean variable
        if enable_nightly_defrag == "True":
            out_defrag = open("/etc/cron.daily/mythtv-xfs-defrag", "w")
            # the cron entry could handle failures more gracefully, but I don't see why currently
            out_defrag.write("#!/bin/sh\n")
            out_defrag.write("/usr/bin/ionice -c3 /usr/sbin/xfs_fsr\n")
            out_defrag.close()
            os.chmod("/etc/cron.daily/mythtv-xfs-defrag",0755)
        elif enable_nightly_defrag == "False":
            os.remove("/etc/cron.daily/mythtv-xfs-defrag")

    def mysql_repair(self,enable_mysql_repair):
        if enable_mysql_repair == "True":
            shutil.copy("/usr/share/doc/mythtv-backend/contrib/optimize_mythdb.pl", "/etc/cron.daily/optimize_mythdb.pl")
            os.chmod("/etc/cron.daily/optimize_mythdb.pl",0755)
        elif enable_mysql_repair == "False":
            os.remove("/etc/cron.daily/optimize_mythdb.pl")

    def update_package_lists(self):
        lock = thread.allocate_lock()
        lock.acquire()
        t = thread.start_new_thread(self.update_cache,
                                   (self.progress_dialog.window.xid, lock))
        while lock.locked():
            while gtk.events_pending():
                gtk.main_iteration()
                time.sleep(0.05)

    def check_medibuntu_key(self):
        #Checks if the medibuntu key is installed
        import gettext
        from subprocess import PIPE
        gpg = ["/usr/bin/gpg"]
        base_opt = gpg + ["--no-options", "--no-default-keyring",
                                    "--secret-keyring", "/etc/apt/secring.gpg",
                                    "--trustdb-name", "/etc/apt/trustdb.gpg",
                                    "--keyring", "/etc/apt/trusted.gpg"]
        list_opt = base_opt + ["--with-colons", "--batch",
                               "--list-keys"]
        p = subprocess.Popen(list_opt,stdout=PIPE).stdout
        for line in p.readlines():
            fields = line.split(":")
            if fields[4][-8:] == "0C5A2783":
                return True
        return False

    def update_cache(self, window_id, lock):
        """start synaptic to update the package cache"""
        try:
            apt_pkg.PkgSystemUnLock()
        except SystemError:
            pass
        cmd = ["/usr/sbin/synaptic", "--hide-main-window",
               "--non-interactive",
               "--parent-window-id", "%s" % (window_id),
               "--update-at-startup"]
        subprocess.call(cmd)
        lock.release()
